﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- Removes the port number from the URL, if it is the default number for the protocol -->
<xsl:template name="canonical-url">
<xsl:param name="url" />
  <xsl:choose>
    <xsl:when test="matches($url, '^http://[^:/]+:80/')">
      <xsl:value-of select="replace($url,':80/', '/')" />
    </xsl:when>
    <xsl:when test="matches($url, '^https://[^:/]+:443/')">
      <xsl:value-of select="replace($url,':443/', '/')" />
    </xsl:when>
    <xsl:otherwise>
       <xsl:value-of select="$url" />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

  <xsl:template match="/">
    <magictree class="MtBranchObject" xmlns:mt="http://www.gremwell.com/magictree">
      <testdata class="MtBranchObject">
 	<xsl:for-each select="ScanGroup/Scan">
          <webapp>
           <xsl:variable name="starturl">
             <xsl:call-template name="canonical-url">
                <xsl:with-param name="url" select="StartURL" />
             </xsl:call-template>
           </xsl:variable>
        <xsl:value-of select="$starturl" />
        <banner><xsl:value-of select="Banner" /></banner>
        <xsl:for-each select="ReportItems/ReportItem">
            <xsl:variable name="affects">
                <xsl:choose>
                    <xsl:when test="Affects='Web Server' or Affects='Server'">
                        <xsl:value-of select="$starturl"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <!--  <Affects> element in Acunetix looks like this: 
                            /phpmyadmin/db_create.php (351f37c83014add6589c6e411eb420bc) 
                            The part in brackets is generated by Acunetix.
                            We strip everyting after the space and strip the initial 
                            slash from relative url and concat with start url-->
                        <xsl:choose>
                            <xsl:when test="contains(Afects, ' ')">
                                <xsl:value-of select="concat($starturl,substring-before(substring(Affects,2),' '))"/>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:value-of select="concat($starturl,substring(Affects,2))"/>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
          <url><xsl:value-of select="$affects"/>
           <finding class="MtTextObject" status="new">
                <xsl:attribute name="title">
                    <xsl:value-of select="Name" />
                </xsl:attribute>
            <xsl:attribute name="mergeID" >
                <xsl:value-of select="@id" />
            </xsl:attribute>
            <xsl:value-of select="Description" />
            <source>acunetix</source>
            <affects><xsl:value-of select="$affects" /></affects>
            <falsepositive><xsl:value-of select="IsFalsePositive" /></falsepositive>
            <source-severity>
                <xsl:value-of select="Severity" />
                <numeric>
                <xsl:choose>
                    <xsl:when test="Severity='high'">3</xsl:when>
                    <xsl:when test="Severity='medium'">2</xsl:when>
                    <xsl:when test="Severity='low'">1</xsl:when>
                    <xsl:when test="Severity='info'">0</xsl:when>
                    <xsl:otherwise>-1</xsl:otherwise>
                </xsl:choose>
                </numeric>
            </source-severity>
            <impact class="MtTextObject" title="Impact">
                <xsl:value-of select="Impact" />
            </impact>
            <solution class="MtTextObject" title="Recommendation">
                <xsl:value-of select="Recommendation" />
            </solution>
            <output class="MtTextObject" title="Details">
                <xsl:value-of select="Details" />
            </output>
            <xsl:for-each select="References/Reference">
                <reference><xsl:value-of select="Database" /> 
                    <url><xsl:value-of select="URL" /></url>
                </reference>
            </xsl:for-each>
            <requestresponse>
                <xsl:number value="position()" format="1"/>
                <request class="MtTextObject" title="Request">
                    <xsl:value-of select="TechnicalDetails/Request" />
                </request>
                <response class="MtTextObject" title="Response">
                    <xsl:value-of select="TechnicalDetails/Response" />
                </response>
            </requestresponse>
            </finding>
          </url>
        </xsl:for-each>
        </webapp>
	</xsl:for-each>
      </testdata>
    </magictree>
  </xsl:template>
</xsl:stylesheet>
