if [ -z "$id" ] ; then
	echo "UUID environment variable '\$id' is empty" >&2
	exit 1
fi

if [ -z "$prefix" ] ; then
	echo "Spool files environment variable '\$prefix' is empty" >&2
	exit 1
fi

if [ ! -r "$prefix..SCRIPT" ] ; then
	echo "User script file '$prefix..SCRIPT' does not exist" >&2
	exit 1
fi

for f in "$prefix..SCREENRC" "$prefix..LOG" "$prefix..SH" "$prefix..EXITCODE" ; do
	if [ -f "$f" ] ; then
		echo "File '$f' exists. UUID collision?" >&2
		exit 2
	fi
done

## --- Build screenrc
##	set log file name
##	enable log file flushing every second
cat > "$prefix..SCREENRC" <<END
logfile "$prefix..LOG"
logfile flush 1
END

## --- Create slave starter script
cat > "$prefix..SH"<<END
## Prepare the environment variables
export out="$prefix"

## Trap on normal exit, HUP, INTR, QUIT, and TERM signals
## Create a exitcode file (using atomic filesystem operations)
trap 'echo \$? > "$prefix..EXITCODE.\$\$" ; mv "$prefix..EXITCODE.\$\$" "$prefix..EXITCODE"' 0 1 2 3 15

## Create a pidfile (using atomic filesystem operations)
echo \$\$ > "$prefix..SH.PID.\$\$"
mv "$prefix..SH.PID.\$\$" "$prefix..SH.PID"

## Execute user's script
"$SHELL" "$prefix..SCRIPT"
END

## --- Run screen
##	quiet
##	enable logging
##	specify config file
##	specify session id
##	detached, background
##	specify the command to execute
exec screen -q -L -c "$prefix..SCREENRC" -S "S$id" -d -m "$SHELL" "$prefix..SH"

