/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.reflection.emit;

import com.strobel.core.StringUtilities;
import com.strobel.reflection.FieldInfo;
import com.strobel.reflection.ICapturedType;
import com.strobel.reflection.LocalVariableInfo;
import com.strobel.reflection.MemberInfo;
import com.strobel.reflection.MethodBase;
import com.strobel.reflection.MethodInfo;
import com.strobel.reflection.ParameterInfo;
import com.strobel.reflection.SimpleVisitor;
import com.strobel.reflection.Type;
import com.strobel.reflection.TypeList;
import com.strobel.reflection.Types;
import com.strobel.reflection.emit.ConstructorBuilder;
import com.strobel.reflection.emit.FieldBuilder;
import com.strobel.reflection.emit.LocalBuilder;
import com.strobel.reflection.emit.MethodBuilder;
import com.strobel.reflection.emit.TypeBuilder;
import com.strobel.reflection.emit.VerificationException;
import com.strobel.util.ContractUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;

final class Verifier {
    private static final String VERIFY_LOCAL_VARIABLE_TYPES = "com.strobel.reflection.emit.Verifier.VerifyLocalVariableTypes";
    private static final GenericParameterResolver GENERIC_PARAMETER_RESOLVER = new GenericParameterResolver();

    private Verifier() {
    }

    public static void verify(MethodBase method, MethodBuilder scope) {
        GenericParameterScopeVerifier methodLevelVerifier = new GenericParameterScopeVerifier();
        methodLevelVerifier.visit(method, (MemberInfo)scope);
    }

    public static void verify(FieldInfo field, MethodBuilder scope) {
        GenericParameterScopeVerifier methodLevelVerifier = new GenericParameterScopeVerifier();
        methodLevelVerifier.visit(field, (MemberInfo)scope);
    }

    public static void verify(TypeBuilder<?> type) {
        GenericParameterScopeVerifier methodLevelVerifier;
        GenericParameterScopeVerifier typeLevelVerifier = new GenericParameterScopeVerifier();
        typeLevelVerifier._frames.push(new VerifierFrame(FrameType.TYPE_SIGNATURE, type));
        typeLevelVerifier._frames.push(new VerifierFrame(FrameType.SUPER_CLASS, type));
        Type<?> baseType = type.getBaseType();
        if (baseType != null) {
            typeLevelVerifier.visit(baseType, type);
        }
        typeLevelVerifier._frames.pop();
        typeLevelVerifier.visit(type.getExplicitInterfaces(), type, FrameType.SUPER_INTERFACE);
        if (type.isGenericTypeDefinition()) {
            typeLevelVerifier.visit(type.getGenericTypeParameters(), type, FrameType.TYPE_VARIABLE);
        } else if (type.isGenericType()) {
            typeLevelVerifier.visit(type.getTypeArguments(), type, FrameType.TYPE_ARGUMENT);
        }
        for (FieldBuilder field : type.fieldBuilders) {
            typeLevelVerifier.visit(field, type);
        }
        for (ConstructorBuilder ctor : type.constructorBuilders) {
            methodLevelVerifier = new GenericParameterScopeVerifier();
            methodLevelVerifier._frames.addAll(typeLevelVerifier._frames);
            methodLevelVerifier._visitedTypes.addAll(typeLevelVerifier._visitedTypes);
            methodLevelVerifier.visit(ctor.getMethodBuilder(), (MemberInfo)ctor.getMethodBuilder());
        }
        for (MethodBuilder method : type.methodBuilders) {
            methodLevelVerifier = new GenericParameterScopeVerifier();
            methodLevelVerifier._frames.addAll(typeLevelVerifier._frames);
            methodLevelVerifier._visitedTypes.addAll(typeLevelVerifier._visitedTypes);
            methodLevelVerifier.visit(method, (MemberInfo)method);
        }
        typeLevelVerifier._frames.pop();
    }

    static String typeVariableOutOfScopeError(Type<?> typeParameter, MemberInfo scope) {
        MethodBase declaringMethod = typeParameter.getDeclaringMethod();
        Type declaringType = declaringMethod != null ? declaringMethod.getDeclaringType() : typeParameter.getDeclaringType();
        String owner = declaringMethod != null ? String.format("method '%s' on type '%s'", declaringMethod.getSimpleDescription(), declaringType.getSimpleDescription()) : "type '" + declaringType.getSimpleDescription() + "'";
        String site = scope instanceof MethodBase ? String.format("method '%s' on type '%s'", scope.getSimpleDescription(), scope.getDeclaringType().getSimpleDescription()) : "type '" + scope.getSimpleDescription() + "'";
        return String.format("Type variable '%s' cannot be resolved in %s (variable owned by %s).", typeParameter.getName(), site, owner);
    }

    static final class VerifierFrame {
        private final FrameType _frameType;
        private final MemberInfo _member;
        private final Object _location;

        public VerifierFrame(FrameType frameType, MemberInfo member) {
            this(frameType, member, null);
        }

        public VerifierFrame(FrameType frameType, MemberInfo member, Object location) {
            this._frameType = frameType;
            this._member = member;
            this._location = location;
        }

        public String toString() {
            switch (this._frameType) {
                case FIELD_SIGNATURE: {
                    return "field: " + this._member.getDescription();
                }
                case METHOD_SIGNATURE: {
                    return "method: " + this._member.getDescription();
                }
                case METHOD_RETURN_TYPE: {
                    return "return type: " + this._member.getBriefDescription();
                }
                case METHOD_THROWS_LIST: {
                    return "throws list: " + this._member.getBriefDescription();
                }
                case METHOD_PARAMETER: {
                    if (this._location instanceof ParameterInfo) {
                        ParameterInfo p = (ParameterInfo)this._location;
                        if (StringUtilities.isNullOrEmpty(p.getName())) {
                            return "parameter #" + p.getPosition() + ": " + this._member.getSignature();
                        }
                        return "parameter #" + p.getPosition() + " (" + p.getName() + "): " + this._member.getSignature();
                    }
                    return "parameter: " + this._member.getSignature();
                }
                case METHOD_ARGUMENT: {
                    if (this._location instanceof ParameterInfo) {
                        ParameterInfo p = (ParameterInfo)this._location;
                        if (StringUtilities.isNullOrEmpty(p.getName())) {
                            return "argument #" + p.getPosition() + ": " + this._member.getBriefDescription();
                        }
                        return "argument #" + p.getPosition() + " (" + p.getName() + "): " + this._member.getBriefDescription();
                    }
                    return "argument: " + this._member.getBriefDescription();
                }
                case TYPE_SIGNATURE: {
                    return "type: " + this._member.getDescription();
                }
                case TYPE_VARIABLE: {
                    return "type variable: " + this._member.getDescription();
                }
                case TYPE_BOUND: {
                    return "type bound: " + this._member.getDescription();
                }
                case SUPER_CLASS: {
                    return "super class: " + this._member.getDescription();
                }
                case SUPER_INTERFACE: {
                    return "super interface: " + this._member.getDescription();
                }
                case TYPE_ARGUMENT: {
                    if (this._location instanceof Type && ((Type)this._location).isGenericParameter()) {
                        Type gp = (Type)this._location;
                        return "type argument #" + gp.getGenericParameterPosition() + " (" + gp.getName() + "): " + this._member.getBriefDescription();
                    }
                    return "type argument: " + this._member.getBriefDescription();
                }
                case LOCAL_VARIABLE: {
                    if (this._location instanceof LocalVariableInfo) {
                        LocalVariableInfo local = (LocalVariableInfo)this._location;
                        if (local instanceof LocalBuilder) {
                            return "local variable #" + local.getLocalIndex() + " (" + ((LocalBuilder)local).getName() + "): " + local.getLocalType().getBriefDescription();
                        }
                        return "local variable #" + local.getLocalIndex() + ": " + local.getLocalType().getBriefDescription();
                    }
                    return "local variable in method " + this._member.getName();
                }
            }
            throw ContractUtils.unreachable();
        }
    }

    static enum FrameType {
        FIELD_SIGNATURE,
        METHOD_SIGNATURE,
        METHOD_RETURN_TYPE,
        METHOD_PARAMETER,
        METHOD_THROWS_LIST,
        METHOD_ARGUMENT,
        TYPE_SIGNATURE,
        TYPE_VARIABLE,
        LOCAL_VARIABLE,
        TYPE_ARGUMENT,
        TYPE_BOUND,
        SUPER_CLASS,
        SUPER_INTERFACE;

    }

    private static final class GenericParameterResolver
    extends SimpleVisitor<Type<?>, Boolean> {
        private GenericParameterResolver() {
        }

        public Boolean visitScope(MemberInfo scope, Type<?> s) {
            if (scope instanceof MethodBase) {
                MethodBase method = (MethodBase)scope;
                if (method.containsGenericParameter(s)) {
                    return Boolean.TRUE;
                }
                Type declaringType = method.getDeclaringType();
                if (declaringType != null && !declaringType.isStatic()) {
                    return (Boolean)declaringType.accept(this, s);
                }
                return Boolean.FALSE;
            }
            if (scope instanceof Type) {
                Type type = (Type)scope;
                if (type.containsGenericParameter(s)) {
                    return Boolean.TRUE;
                }
                if (!type.isStatic()) {
                    Type declaringType = type.getDeclaringType();
                    if (declaringType != null) {
                        return (Boolean)declaringType.accept(this, s);
                    }
                    return Boolean.FALSE;
                }
            }
            return Boolean.FALSE;
        }

        public Boolean visitTypes(TypeList types, Type<?> s) {
            for (Type type : types) {
                if (this.visit(type, s) != Boolean.TRUE) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitCapturedType(Type<?> t, Type<?> s) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitClassType(Type<?> type, Type<?> s) {
            if (type.containsGenericParameter(s)) {
                return Boolean.TRUE;
            }
            MethodBase declaringMethod = type.getDeclaringMethod();
            if (declaringMethod != null) {
                return this.visitScope(declaringMethod, s);
            }
            if (type.isStatic()) {
                return Boolean.FALSE;
            }
            Type declaringType = type.getDeclaringType();
            if (declaringType != null && declaringType != Type.NullType) {
                return (Boolean)this.visit(declaringType, s);
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitPrimitiveType(Type<?> type, Type<?> s) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitTypeParameter(Type<?> type, Type<?> s) {
            if (type.isEquivalentTo(s)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitWildcardType(Type<?> type, Type<?> s) {
            return Boolean.FALSE;
        }

        @Override
        public Boolean visitArrayType(Type<?> type, Type<?> s) {
            return Boolean.FALSE;
        }
    }

    private static final class GenericParameterScopeVerifier
    extends SimpleVisitor<MemberInfo, Void> {
        private final Stack<VerifierFrame> _frames = new Stack();
        private final Set<Type<?>> _visitedTypes = new LinkedHashSet();

        private GenericParameterScopeVerifier() {
        }

        public Void visit(FieldInfo field, MemberInfo scope) {
            this._frames.push(new VerifierFrame(FrameType.FIELD_SIGNATURE, field));
            field.getFieldType().accept(this, scope);
            this._frames.pop();
            return null;
        }

        public Void visit(MethodBase method, MemberInfo scope) {
            MethodBuilder mb;
            this._frames.push(new VerifierFrame(FrameType.METHOD_SIGNATURE, method));
            if (method instanceof MethodInfo) {
                MethodInfo m = (MethodInfo)method;
                this._frames.push(new VerifierFrame(FrameType.METHOD_RETURN_TYPE, method));
                m.getReturnType().accept(this, scope);
                this._frames.pop();
                if (m.isGenericMethodDefinition()) {
                    this.visit(m.getGenericMethodParameters(), scope, FrameType.TYPE_VARIABLE);
                } else if (m.isGenericMethod()) {
                    this.visit(m.getTypeArguments(), scope, FrameType.TYPE_ARGUMENT);
                }
            }
            this.visit(method.getParameters().getParameterTypes(), scope, FrameType.METHOD_PARAMETER);
            this.visit(method.getThrownTypes(), scope, FrameType.METHOD_THROWS_LIST);
            if (StringUtilities.isTrue(System.getProperty(Verifier.VERIFY_LOCAL_VARIABLE_TYPES)) && (mb = method instanceof MethodBuilder ? (MethodBuilder)method : (method instanceof ConstructorBuilder ? ((ConstructorBuilder)method).getMethodBuilder() : null)) != null && mb.generator != null) {
                for (int i = 0; i < mb.generator.localCount; ++i) {
                    LocalBuilder local = mb.generator.locals[i];
                    this._frames.push(new VerifierFrame(FrameType.LOCAL_VARIABLE, local.getLocalType(), local));
                    local.getLocalType().accept(this, scope);
                    this._frames.pop();
                }
            }
            this._frames.pop();
            return null;
        }

        @Override
        public Void visitTypeParameter(Type<?> type, MemberInfo scope) {
            super.visitTypeParameter(type, scope);
            if (type.hasSuperBound()) {
                this._frames.push(new VerifierFrame(FrameType.TYPE_BOUND, type.getSuperBound()));
                this.visit(type.getSuperBound(), scope);
                this._frames.pop();
            } else if (type.hasExtendsBound() && !Types.Object.isEquivalentTo(type.getExtendsBound())) {
                this._frames.push(new VerifierFrame(FrameType.TYPE_BOUND, type.getExtendsBound()));
                this.visit(type.getExtendsBound(), scope);
                this._frames.pop();
            }
            if (!type.isGenericParameter() || !this._visitedTypes.add(type)) {
                return null;
            }
            if (GENERIC_PARAMETER_RESOLVER.visitScope(scope, type) != Boolean.TRUE) {
                ArrayList<VerifierFrame> frames = new ArrayList<VerifierFrame>(this._frames);
                Collections.reverse(frames);
                throw new VerificationException(Verifier.typeVariableOutOfScopeError(type, scope), frames.toArray(new VerifierFrame[frames.size()]));
            }
            return null;
        }

        public Void visit(TypeList types, MemberInfo scope, FrameType frameType) {
            for (Type type : types) {
                this._frames.push(new VerifierFrame(frameType, type));
                type.accept(this, scope);
                this._frames.pop();
            }
            return null;
        }

        @Override
        public Void visitArrayType(Type<?> type, MemberInfo scope) {
            super.visitArrayType(type, scope);
            this._frames.push(new VerifierFrame(FrameType.TYPE_SIGNATURE, type));
            type.getElementType().accept(this, scope);
            this._frames.pop();
            return null;
        }

        @Override
        public Void visitClassType(Type<?> type, MemberInfo scope) {
            super.visitClassType(type, scope);
            this._frames.push(new VerifierFrame(FrameType.TYPE_SIGNATURE, type));
            if (type.isGenericTypeDefinition()) {
                this.visit(type.getGenericTypeParameters(), scope, FrameType.TYPE_VARIABLE);
            } else if (type.isGenericType()) {
                this.visit(type.getTypeArguments(), scope, FrameType.TYPE_ARGUMENT);
            }
            this._frames.pop();
            return null;
        }

        @Override
        public Void visitPrimitiveType(Type<?> type, MemberInfo scope) {
            return null;
        }

        @Override
        public Void visitWildcardType(Type<?> type, MemberInfo scope) {
            super.visitWildcardType(type, scope);
            if (type.isUnbounded()) {
                return null;
            }
            if (type.hasSuperBound()) {
                this._frames.push(new VerifierFrame(FrameType.TYPE_BOUND, type.getSuperBound()));
                this.visit(type.getSuperBound(), scope);
                this._frames.pop();
            } else {
                this._frames.push(new VerifierFrame(FrameType.TYPE_BOUND, type.getExtendsBound()));
                this.visit(type.getExtendsBound(), scope);
                this._frames.pop();
            }
            return null;
        }

        @Override
        public Void visitCapturedType(Type<?> type, MemberInfo scope) {
            super.visitCapturedType(type, scope);
            if (type instanceof ICapturedType) {
                this.visit(((ICapturedType)((Object)type)).getWildcard(), scope);
            }
            return null;
        }
    }
}

