/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.expressions;

import com.strobel.core.VerifyArgument;
import com.strobel.expressions.Expression;
import com.strobel.expressions.ExpressionList;
import com.strobel.expressions.ExpressionStringBuilder;

public final class SwitchCase {
    private final ExpressionList<? extends Expression> _testValues;
    private final Expression _body;

    SwitchCase(Expression body, ExpressionList<? extends Expression> testValues) {
        this._body = VerifyArgument.notNull(body, "body");
        this._testValues = VerifyArgument.notNull(testValues, "testValues");
    }

    public final ExpressionList<? extends Expression> getTestValues() {
        return this._testValues;
    }

    public final Expression getBody() {
        return this._body;
    }

    public final String toString() {
        return ExpressionStringBuilder.switchCaseToString(this);
    }

    public final SwitchCase update(ExpressionList<? extends Expression> testValues, Expression body) {
        if (testValues == this._testValues && body == this._body) {
            return this;
        }
        return Expression.switchCase(body, testValues);
    }
}

