"use strict";
var chalk = require('chalk');
var _ = require('underscore');
var ChromeClient = require('../../../src/back-end/tester/chrome-tester-client');
var u = require('../../test-utils');
var chromeClient = new ChromeClient({
    hostname: 'localhost',
    port: 4004
});
u.desc('    Testing ' + chalk.bgWhite.black('executeFunctionWithDebugger'), function () {
    var functionsToTest = [
        {
            'functioName': 'f_6',
            'parameters': '5, 2',
            'scope': [
                {},
                {}
            ],
            'function': {
                'name': 'f_6'
            },
            'cfgStatements': ['2', '3']
        }
    ];
    testFunction(0, functionsToTest, function (err) {
        if (!err) {
            u.printSuccess('All tests passed');
        }
    });
});
function testFunction(index, functionsToTest, cb) {
    if (index < functionsToTest.length) {
        var f = functionsToTest[index];
        var fName = f.functioName;
        var parameters = f.parameters;
        u.desc('        Testing ' + chalk.bgWhite.black(fName), function () {
            chromeClient.executeFunctionWithDebugger(fName, parameters, function (err, res) {
                if (err) {
                    u.printError('Unable to run \'executeFunctionWithDebugger\' on function "' + fName + '"');
                    cb(true);
                }
                else {
                    var branches = res.function.branches;
                    var b;
                    for (var k = 0; k < branches.length; k++) {
                        b = branches[k];
                        console.log('key : ' + b.key);
                        console.log('n exec : ' + b.nExecutions);
                        console.log('n value conditions : ' + b.valuesCondition.length);
                        for (var j = 0; j < b.valuesCondition.length; j++) {
                            console.log('  ' + b.valuesCondition[j]);
                        }
                        console.log();
                    }
                    u.assert(res.hasOwnProperty('function'), 'res must have property "function"');
                    u.assert(res.function.name === fName, 'res.function.name !== functionsToTest.fName');
                    u.assert(res.hasOwnProperty('scope'), 'res must have property "scope"');
                    u.assert(_.isArray(res.scope), '"res.scope" must be an array');
                    u.assert(res.scope.length === f.scope.length, 'res.scope.length must be equal to "' + f.scope.length +
                        '" instead of ' + res.scope.length);
                    u.assert(res.cfgStatements.length === f.cfgStatements.length, 'res.cfgStatements.length must be equal to "' + f.cfgStatements.length +
                        '" instead of ' + res.cfgStatements.length);
                    u.assert(_.isEqual(res.cfgStatements, f.cfgStatements), 'res.cfgStatements must be equal to "' + f.cfgStatements.join(', ') +
                        '" instead of ' + res.cfgStatements.join(', '));
                    u.assert(res.hasOwnProperty('result'), 'res must have property "result"');
                    if (index !== (functionsToTest.length - 1)) {
                        testFunction(++index, functionsToTest, cb);
                    }
                    else {
                        cb(false);
                    }
                }
            });
        });
    }
}
