"use strict";
var net = require('net');
var ChromeTesterClient = (function () {
    function ChromeTesterClient(params) {
        this.hostname = params.hostname;
        this.port = params.port;
    }
    ChromeTesterClient.prototype.callChromeServer = function (method, data, cb) {
        var client = new net.Socket();
        var response;
        if (typeof cb !== 'function') {
            cb = function () { };
        }
        client.connect(this.port, this.hostname, function () {
            var objToWrite = {
                method: method,
                parameters: data
            };
            client.write(JSON.stringify(objToWrite));
        });
        client.on('data', function (data) {
            response = JSON.parse(data);
            client.destroy();
        });
        client.on('close', function () {
            var err = response.error
                ? response.value
                : null;
            var res = response.error
                ? null
                : response.value;
            cb(err, res);
        });
        client.on('error', function (err) {
            cb(err, null);
        });
    };
    ChromeTesterClient.prototype.getConfiguration = function (cb) {
        this.callChromeServer('getConfiguration', {}, function (err, res) {
            cb(err, res);
        });
    };
    ChromeTesterClient.prototype.getCoverageObject = function (coverageObject, cb) {
        this.callChromeServer('getCoverageObject', coverageObject, function (err, res) {
            cb(err, res);
        });
    };
    ChromeTesterClient.prototype.getFunctionInstance = function (functionName, cb) {
        this.callChromeServer('getFunctionInstance', functionName, function (err, res) {
            cb(err, res);
        });
    };
    ChromeTesterClient.prototype.getSourceFunction = function (functionName, cb) {
        this.callChromeServer('getSourceFunction', functionName, function (err, res) {
            cb(err, res);
        });
    };
    ChromeTesterClient.prototype.executeFunction = function (functionName, params, cb) {
        this.callChromeServer('executeFunction', [functionName, params], function (err, res) {
            cb(err, res);
        });
    };
    ChromeTesterClient.prototype.executeFunctionWithDebugger = function (functionName, params, cb) {
        this.callChromeServer('executeFunctionWithDebugger', [functionName, params], function (err, res) {
            cb(err, res);
        });
    };
    ChromeTesterClient.prototype.reloadPage = function (cb) {
        this.callChromeServer('reloadPage', {}, function (err, res) {
            cb(err, res);
        });
    };
    ChromeTesterClient.prototype.setUrl = function (url, cb) {
        this.callChromeServer('setUrl', url, function (err, res) {
            cb(err, res);
        });
    };
    return ChromeTesterClient;
}());
module.exports = ChromeTesterClient;
