"use strict";
var MODProperty;
(function (MODProperty) {
    MODProperty[MODProperty["V"] = 0] = "V";
    MODProperty[MODProperty["V_S"] = 1] = "V_S";
})(MODProperty || (MODProperty = {}));
var MOD = (function () {
    function MOD() {
        this.entries = [];
    }
    MOD.prototype.addEntry = function (property, M, S) {
        var modEntry;
        var concreteEntry;
        var symbolicEntry;
        modEntry = {};
        concreteEntry = M.hasProperty(property);
        symbolicEntry = S.hasProperty(property);
        if (!concreteEntry.hasProperty) {
            throw new Error(MOD.ERROR_PREFIX + 'unable to find property "' + property + '" in the concrete memory');
        }
        if (!symbolicEntry.hasProperty) {
            throw new Error(MOD.ERROR_PREFIX + 'unable to find property "' + property + '" in the symbolic memory');
        }
        modEntry.name = property;
        modEntry.attr = {};
        modEntry.attr.V = concreteEntry.content;
        modEntry.attr.V_S = symbolicEntry.content;
        this.entries.push(modEntry);
    };
    MOD.prototype.hasProperty = function (property) {
        for (var k = 0; k < this.entries.length; k++) {
            if (this.entries[k].name === property) {
                return true;
            }
        }
        return false;
    };
    MOD.prototype.toString = function () {
        var modToS = '';
        return modToS;
    };
    MOD.ERROR_PREFIX = '[MOD] Exception. Reason: ';
    return MOD;
}());
module.exports = MOD;
