// -*- c-basic-offset: 4; c-backslash-column: 79; indent-tabs-mode: nil -*-
// vim:sw=4 ts=4 sts=4 expandtab
#ifndef CIFS_H_101221
#define CIFS_H_101221
#include <junkie/proto/proto.h>

/** @file
 * @brief CIFS informations
 */

#define CIFS_SMB_HEADER 0xff534d42
#define CIFS_SMB2_HEADER 0xfe534d42

extern struct proto *proto_cifs;

enum smb_status {
    SMB_STATUS_OK                                         = 0x00000000,
    SMB_STATUS_ACCESS_DENIED                              = 0xC0000022,
    SMB_STATUS_NETWORK_ACCESS_DENIED                      = 0xC00000CA,
    SMB_STATUS_ACCOUNT_DISABLED                           = 0xC0000072,
    SMB_STATUS_ACCOUNT_EXPIRED                            = 0xC0000193,
    SMB_STATUS_ALREADY_COMMITTED                          = 0xC0000021,
    SMB_STATUS_BAD_DEVICE_TYPE                            = 0xC00000CB,
    SMB_STATUS_BAD_NETWORK_NAME                           = 0xC00000CC,
    SMB_STATUS_BUFFER_OVERFLOW                            = 0x80000005,
    SMB_STATUS_CANNOT_DELETE                              = 0xC0000121,
    SMB_STATUS_CRC_ERROR                                  = 0xC000003F,
    SMB_STATUS_DATA_ERROR                                 = 0xC000003E,
    SMB_STATUS_DATA_ERROR_UNUSED                          = 0xC000009C,
    SMB_STATUS_DELETE_PENDING                             = 0xC0000056,
    SMB_STATUS_DEVICE_PAPER_EMPTY                         = 0x8000000E,
    SMB_STATUS_DFS_EXIT_PATH_FOUND                        = 0xC000009B,
    SMB_STATUS_DIRECTORY_NOT_EMPTY                        = 0xC0000101,
    SMB_STATUS_DISK_CORRUPT_ERROR                         = 0xC0000032,
    SMB_STATUS_DISK_FULL                                  = 0xC000007F,
    SMB_STATUS_EAS_NOT_SUPPORTED                          = 0xC000004F,
    SMB_STATUS_EA_TOO_LARGE                               = 0xC0000050,
    SMB_STATUS_END_OF_FILE                                = 0xC0000011,
    SMB_STATUS_FILE_CLOSED                                = 0xC0000128,
    SMB_STATUS_FILE_DELETED                               = 0xC0000123,
    SMB_STATUS_FILE_IS_A_DIRECTORY                        = 0xC00000BA,
    SMB_STATUS_FILE_LOCK_CONFLICT                         = 0xC0000054,
    SMB_STATUS_FILE_RENAMED                               = 0xC00000D5,
    SMB_STATUS_HANDLE_NOT_CLOSABLE                        = 0xC0000235,
    SMB_STATUS_ILLEGAL_FUNCTION                           = 0xC00000AF,
    SMB_STATUS_INSTANCE_NOT_AVAILABLE                     = 0xC00000AB,
    SMB_STATUS_INSUFF_SERVER_RESOURCES                    = 0xC0000205,
    SMB_STATUS_INVALID_DEVICE_REQUEST                     = 0xC0000010,
    SMB_STATUS_INVALID_DEVICE_STATE                       = 0xC0000184,
    SMB_STATUS_INVALID_HANDLE                             = 0xC0000008,
    SMB_STATUS_INVALID_INFO_CLASS                         = 0xC0000003,
    SMB_STATUS_INVALID_LOCK_SEQUENCE                      = 0xC000001E,
    SMB_STATUS_INVALID_LOGON_HOURS                        = 0xC000006F,
    SMB_STATUS_INVALID_PARAMETER                          = 0xC000000D,
    SMB_STATUS_INVALID_PIPE_STATE                         = 0xC00000AD,
    SMB_STATUS_INVALID_PORT_HANDLE                        = 0xC0000042,
    SMB_STATUS_INVALID_READ_MODE                          = 0xC00000B4,
    SMB_STATUS_INVALID_SMB                                = 0x00010002,
    SMB_STATUS_INVALID_VIEW_SIZE                          = 0xC000001F,
    SMB_STATUS_INVALID_WORKSTATION                        = 0xC0000070,
    SMB_STATUS_IO_TIMEOUT                                 = 0xC00000B5,
    SMB_STATUS_LOCK_NOT_GRANTED                           = 0xC0000055,
    SMB_STATUS_LOGON_FAILURE                              = 0xC000006D,
    SMB_STATUS_MEDIA_WRITE_PROTECTED                      = 0xC00000A2,
    SMB_STATUS_MORE_PROCESSING_REQUIRED                   = 0xC0000016,
    SMB_STATUS_NETWORK_NAME_DELETED                       = 0xC00000C9,
    SMB_STATUS_NO_MEDIA_IN_DEVICE                         = 0xC0000013,
    SMB_STATUS_NO_MORE_FILES                              = 0x80000006,
    SMB_STATUS_NONEXISTENT_SECTOR                         = 0xC0000015,
    SMB_STATUS_NO_SPOOL_SPACE                             = 0xC00000C7,
    SMB_STATUS_NO_SUCH_DEVICE                             = 0xC000000E,
    SMB_STATUS_NO_SUCH_FILE                               = 0xC000000F,
    SMB_STATUS_NOTIFY_ENUM_DIR                            = 0x0000010C,
    SMB_STATUS_NOT_IMPLEMENTED                            = 0xC0000002,
    SMB_STATUS_NOT_SAME_DEVICE                            = 0xC00000D4,
    SMB_STATUS_NOT_SUPPORTED                              = 0XC00000BB,
    SMB_STATUS_OBJECT_NAME_COLLISION                      = 0xC0000035,
    SMB_STATUS_OBJECT_NAME_NOT_FOUND                      = 0xC0000034,
    SMB_STATUS_OBJECT_PATH_INVALID                        = 0xC0000039,
    SMB_STATUS_OBJECT_PATH_NOT_FOUND                      = 0xC000003A,
    SMB_STATUS_OBJECT_PATH_SYNTAX_BAD                     = 0xC000003B,
    SMB_STATUS_OBJECT_TYPE_MISMATCH                       = 0xC0000024,
    SMB_STATUS_OS2_ATOMIC_LOCKS_NOT_SUPPORTED             = 0x00AE0001,
    SMB_STATUS_OS2_CANCEL_VIOLATION                       = 0x00AD0001,
    SMB_STATUS_OS2_CANNOT_COPY                            = 0x010A0001,
    SMB_STATUS_OS2_EA_ACCESS_DENIED                       = 0x03E20001,
    SMB_STATUS_OS2_EAS_DIDNT_FIT                          = 0x01130001,
    SMB_STATUS_OS2_INVALID_ACCESS                         = 0x000C0001,
    SMB_STATUS_OS2_INVALID_LEVEL                          = 0x007C0001,
    SMB_STATUS_OS2_NEGATIVE_SEEK                          = 0x00830001,
    SMB_STATUS_OS2_NO_MORE_SIDS                           = 0x00710001,
    SMB_STATUS_PASSWORD_EXPIRED                           = 0xC0000071,
    SMB_STATUS_PASSWORD_MUST_CHANGE                       = 0xC0000224,
    SMB_STATUS_PATH_NOT_COVERED                           = 0xC0000257,
    SMB_STATUS_PIPE_BUSY                                  = 0xC00000AE,
    SMB_STATUS_PIPE_CLOSING                               = 0xC00000B1,
    SMB_STATUS_PIPE_DISCONNECTED                          = 0xC00000B0,
    SMB_STATUS_PIPE_EMPTY                                 = 0xC00000D9,
    SMB_STATUS_PIPE_NOT_AVAILABLE                         = 0xC00000AC,
    SMB_STATUS_PORT_CONNECTION_REFUSED                    = 0xC0000041,
    SMB_STATUS_PORT_DISCONNECTED                          = 0xC0000037,
    SMB_STATUS_PRINT_CANCELLED                            = 0xC00000C8,
    SMB_STATUS_PRINT_QUEUE_FULL                           = 0xC00000C6,
    SMB_STATUS_PRIVILEGE_NOT_HELD                         = 0xC0000061,
    SMB_STATUS_PROCESS_IS_TERMINATING                     = 0xC000010A,
    SMB_STATUS_RANGE_NOT_LOCKED                           = 0xC000007E,
    SMB_STATUS_REDIRECTOR_NOT_STARTED                     = 0xC00000FB,
    SMB_STATUS_REQUEST_NOT_ACCEPTED                       = 0xC00000D0,
    SMB_STATUS_SECTION_TOO_BIG                            = 0xC0000040,
    SMB_STATUS_SHARING_VIOLATION                          = 0xC0000043,
    SMB_STATUS_SMB_BAD_COMMAND                            = 0x00160002,
    SMB_STATUS_SMB_BAD_FID                                = 0x00060001,
    SMB_STATUS_SMB_BAD_TID                                = 0x00050002,
    SMB_STATUS_SMB_BAD_UID                                = 0x005B0002,
    SMB_STATUS_SMB_CONTINUE_MPX                           = 0x00FC0002,
    SMB_STATUS_SMB_NO_SUPPORT                             = 0XFFFF0002,
    SMB_STATUS_SMB_USE_MPX                                = 0x00FA0002,
    SMB_STATUS_SMB_USE_STANDARD                           = 0x00FB0002,
    SMB_STATUS_THREAD_IS_TERMINATING                      = 0xC000004B,
    SMB_STATUS_TOO_MANY_OPENED_FILES                      = 0xC000011F,
    SMB_STATUS_TOO_MANY_PAGING_FILES                      = 0xC0000097,
    SMB_STATUS_TOO_MANY_SESSIONS                          = 0xC00000CE,
    SMB_STATUS_UNEXPECTED_NETWORK_ERROR                   = 0xC00000C4,
    SMB_STATUS_UNSUCCESSFUL                               = 0xC0000001,
    SMB_STATUS_WRONG_PASSWORD                             = 0xC000006A,
    SMB_STATUS_WRONG_VOLUME                               = 0xC0000012,

    NT_STATUS_ABANDONED                                   = 0x00000080,
    NT_STATUS_USER_APC                                    = 0x000000C0,
    NT_STATUS_KERNEL_APC                                  = 0x00000100,
    NT_STATUS_ALERTED                                     = 0x00000101,
    NT_STATUS_TIMEOUT                                     = 0x00000102,
    NT_STATUS_PENDING                                     = 0x00000103,
    NT_STATUS_REPARSE                                     = 0x00000104,
    NT_STATUS_MORE_ENTRIES                                = 0x00000105,
    NT_STATUS_NOT_ALL_ASSIGNED                            = 0x00000106,
    NT_STATUS_SOME_NOT_MAPPED                             = 0x00000107,
    NT_STATUS_OPLOCK_BREAK_IN_PROGRESS                    = 0x00000108,
    NT_STATUS_VOLUME_MOUNTED                              = 0x00000109,
    NT_STATUS_RXACT_COMMITTED                             = 0x0000010A,
    NT_STATUS_NOTIFY_CLEANUP                              = 0x0000010B,
    NT_STATUS_NO_QUOTAS_FOR_ACCOUNT                       = 0x0000010D,
    NT_STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED            = 0x0000010E,
    NT_STATUS_PAGE_FAULT_TRANSITION                       = 0x00000110,
    NT_STATUS_PAGE_FAULT_DEMAND_ZERO                      = 0x00000111,
    NT_STATUS_PAGE_FAULT_COPY_ON_WRITE                    = 0x00000112,
    NT_STATUS_PAGE_FAULT_GUARD_PAGE                       = 0x00000113,
    NT_STATUS_PAGE_FAULT_PAGING_FILE                      = 0x00000114,
    NT_STATUS_CACHE_PAGE_LOCKED                           = 0x00000115,
    NT_STATUS_CRASH_DUMP                                  = 0x00000116,
    NT_STATUS_BUFFER_ALL_ZEROS                            = 0x00000117,
    NT_STATUS_REPARSE_OBJECT                              = 0x00000118,
    NT_STATUS_RESOURCE_REQUIREMENTS_CHANGED               = 0x00000119,
    NT_STATUS_TRANSLATION_COMPLETE                        = 0x00000120,
    NT_STATUS_DS_MEMBERSHIP_EVALUATED_LOCALLY             = 0x00000121,
    NT_STATUS_NOTHING_TO_TERMINATE                        = 0x00000122,
    NT_STATUS_PROCESS_NOT_IN_JOB                          = 0x00000123,
    NT_STATUS_PROCESS_IN_JOB                              = 0x00000124,
    NT_STATUS_OBJECT_NAME_EXISTS                          = 0x40000000,
    NT_STATUS_THREAD_WAS_SUSPENDED                        = 0x40000001,
    NT_STATUS_WORKING_SET_LIMIT_RANGE                     = 0x40000002,
    NT_STATUS_IMAGE_NOT_AT_BASE                           = 0x40000003,
    NT_STATUS_RXACT_STATE_CREATED                         = 0x40000004,
    NT_STATUS_SEGMENT_NOTIFICATION                        = 0x40000005,
    NT_STATUS_LOCAL_USER_SESSION_KEY                      = 0x40000006,
    NT_STATUS_BAD_CURRENT_DIRECTORY                       = 0x40000007,
    NT_STATUS_SERIAL_MORE_WRITES                          = 0x40000008,
    NT_STATUS_REGISTRY_RECOVERED                          = 0x40000009,
    NT_STATUS_FT_READ_RECOVERY_FROM_BACKUP                = 0x4000000A,
    NT_STATUS_FT_WRITE_RECOVERY                           = 0x4000000B,
    NT_STATUS_SERIAL_COUNTER_TIMEOUT                      = 0x4000000C,
    NT_STATUS_NULL_LM_PASSWORD                            = 0x4000000D,
    NT_STATUS_IMAGE_MACHINE_TYPE_MISMATCH                 = 0x4000000E,
    NT_STATUS_RECEIVE_PARTIAL                             = 0x4000000F,
    NT_STATUS_RECEIVE_EXPEDITED                           = 0x40000010,
    NT_STATUS_RECEIVE_PARTIAL_EXPEDITED                   = 0x40000011,
    NT_STATUS_EVENT_DONE                                  = 0x40000012,
    NT_STATUS_EVENT_PENDING                               = 0x40000013,
    NT_STATUS_CHECKING_FILE_SYSTEM                        = 0x40000014,
    NT_STATUS_FATAL_APP_EXIT                              = 0x40000015,
    NT_STATUS_PREDEFINED_HANDLE                           = 0x40000016,
    NT_STATUS_WAS_UNLOCKED                                = 0x40000017,
    NT_STATUS_SERVICE_NOTIFICATION                        = 0x40000018,
    NT_STATUS_WAS_LOCKED                                  = 0x40000019,
    NT_STATUS_LOG_HARD_ERROR                              = 0x4000001A,
    NT_STATUS_ALREADY_WIN32                               = 0x4000001B,
    NT_STATUS_WX86_UNSIMULATE                             = 0x4000001C,
    NT_STATUS_WX86_CONTINUE                               = 0x4000001D,
    NT_STATUS_WX86_SINGLE_STEP                            = 0x4000001E,
    NT_STATUS_WX86_BREAKPOINT                             = 0x4000001F,
    NT_STATUS_WX86_EXCEPTION_CONTINUE                     = 0x40000020,
    NT_STATUS_WX86_EXCEPTION_LASTCHANCE                   = 0x40000021,
    NT_STATUS_WX86_EXCEPTION_CHAIN                        = 0x40000022,
    NT_STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE             = 0x40000023,
    NT_STATUS_NO_YIELD_PERFORMED                          = 0x40000024,
    NT_STATUS_TIMER_RESUME_IGNORED                        = 0x40000025,
    NT_STATUS_ARBITRATION_UNHANDLED                       = 0x40000026,
    NT_STATUS_CARDBUS_NOT_SUPPORTED                       = 0x40000027,
    NT_STATUS_WX86_CREATEWX86TIB                          = 0x40000028,
    NT_STATUS_MP_PROCESSOR_MISMATCH                       = 0x40000029,
    NT_STATUS_HIBERNATED                                  = 0x4000002A,
    NT_STATUS_RESUME_HIBERNATION                          = 0x4000002B,
    NT_STATUS_GUARD_PAGE_VIOLATION                        = 0x80000001,
    NT_STATUS_DATATYPE_MISALIGNMENT                       = 0x80000002,
    NT_STATUS_BREAKPOINT                                  = 0x80000003,
    NT_STATUS_SINGLE_STEP                                 = 0x80000004,
    NT_STATUS_WAKE_SYSTEM_DEBUGGER                        = 0x80000007,
    NT_STATUS_HANDLES_CLOSED                              = 0x8000000A,
    NT_STATUS_NO_INHERITANCE                              = 0x8000000B,
    NT_STATUS_GUID_SUBSTITUTION_MADE                      = 0x8000000C,
    NT_STATUS_PARTIAL_COPY                                = 0x8000000D,
    NT_STATUS_DEVICE_POWERED_OFF                          = 0x8000000F,
    NT_STATUS_DEVICE_OFF_LINE                             = 0x80000010,
    NT_STATUS_DEVICE_BUSY                                 = 0x80000011,
    NT_STATUS_NO_MORE_EAS                                 = 0x80000012,
    NT_STATUS_INVALID_EA_NAME                             = 0x80000013,
    NT_STATUS_EA_LIST_INCONSISTENT                        = 0x80000014,
    NT_STATUS_INVALID_EA_FLAG                             = 0x80000015,
    NT_STATUS_VERIFY_REQUIRED                             = 0x80000016,
    NT_STATUS_EXTRANEOUS_INFORMATION                      = 0x80000017,
    NT_STATUS_RXACT_COMMIT_NECESSARY                      = 0x80000018,
    NT_STATUS_NO_MORE_ENTRIES                             = 0x8000001A,
    NT_STATUS_FILEMARK_DETECTED                           = 0x8000001B,
    NT_STATUS_MEDIA_CHANGED                               = 0x8000001C,
    NT_STATUS_BUS_RESET                                   = 0x8000001D,
    NT_STATUS_END_OF_MEDIA                                = 0x8000001E,
    NT_STATUS_BEGINNING_OF_MEDIA                          = 0x8000001F,
    NT_STATUS_MEDIA_CHECK                                 = 0x80000020,
    NT_STATUS_SETMARK_DETECTED                            = 0x80000021,
    NT_STATUS_NO_DATA_DETECTED                            = 0x80000022,
    NT_STATUS_REDIRECTOR_HAS_OPEN_HANDLES                 = 0x80000023,
    NT_STATUS_SERVER_HAS_OPEN_HANDLES                     = 0x80000024,
    NT_STATUS_ALREADY_DISCONNECTED                        = 0x80000025,
    NT_STATUS_LONGJUMP                                    = 0x80000026,
    NT_STATUS_CLEANER_CARTRIDGE_INSTALLED                 = 0x80000027,
    NT_STATUS_PLUGPLAY_QUERY_VETOED                       = 0x80000028,
    NT_STATUS_UNWIND_CONSOLIDATE                          = 0x80000029,
    NT_STATUS_INFO_LENGTH_MISMATCH                        = 0xC0000004,
    NT_STATUS_ACCESS_VIOLATION                            = 0xC0000005,
    NT_STATUS_IN_PAGE_ERROR                               = 0xC0000006,
    NT_STATUS_PAGEFILE_QUOTA                              = 0xC0000007,
    NT_STATUS_BAD_INITIAL_STACK                           = 0xC0000009,
    NT_STATUS_BAD_INITIAL_PC                              = 0xC000000A,
    NT_STATUS_INVALID_CID                                 = 0xC000000B,
    NT_STATUS_TIMER_NOT_CANCELED                          = 0xC000000C,
    NT_STATUS_UNRECOGNIZED_MEDIA                          = 0xC0000014,
    NT_STATUS_NO_MEMORY                                   = 0xC0000017,
    NT_STATUS_CONFLICTING_ADDRESSES                       = 0xC0000018,
    NT_STATUS_NOT_MAPPED_VIEW                             = 0xC0000019,
    NT_STATUS_UNABLE_TO_FREE_VM                           = 0xC000001A,
    NT_STATUS_UNABLE_TO_DELETE_SECTION                    = 0xC000001B,
    NT_STATUS_INVALID_SYSTEM_SERVICE                      = 0xC000001C,
    NT_STATUS_ILLEGAL_INSTRUCTION                         = 0xC000001D,
    NT_STATUS_INVALID_FILE_FOR_SECTION                    = 0xC0000020,
    NT_STATUS_BUFFER_TOO_SMALL                            = 0xC0000023,
    NT_STATUS_NONCONTINUABLE_EXCEPTION                    = 0xC0000025,
    NT_STATUS_INVALID_DISPOSITION                         = 0xC0000026,
    NT_STATUS_UNWIND                                      = 0xC0000027,
    NT_STATUS_BAD_STACK                                   = 0xC0000028,
    NT_STATUS_INVALID_UNWIND_TARGET                       = 0xC0000029,
    NT_STATUS_NOT_LOCKED                                  = 0xC000002A,
    NT_STATUS_PARITY_ERROR                                = 0xC000002B,
    NT_STATUS_UNABLE_TO_DECOMMIT_VM                       = 0xC000002C,
    NT_STATUS_NOT_COMMITTED                               = 0xC000002D,
    NT_STATUS_INVALID_PORT_ATTRIBUTES                     = 0xC000002E,
    NT_STATUS_PORT_MESSAGE_TOO_LONG                       = 0xC000002F,
    NT_STATUS_INVALID_PARAMETER_MIX                       = 0xC0000030,
    NT_STATUS_INVALID_QUOTA_LOWER                         = 0xC0000031,
    NT_STATUS_OBJECT_NAME_INVALID                         = 0xC0000033,
    NT_STATUS_DEVICE_ALREADY_ATTACHED                     = 0xC0000038,
    NT_STATUS_DATA_OVERRUN                                = 0xC000003C,
    NT_STATUS_DATA_LATE_ERROR                             = 0xC000003D,
    NT_STATUS_QUOTA_EXCEEDED                              = 0xC0000044,
    NT_STATUS_INVALID_PAGE_PROTECTION                     = 0xC0000045,
    NT_STATUS_MUTANT_NOT_OWNED                            = 0xC0000046,
    NT_STATUS_SEMAPHORE_LIMIT_EXCEEDED                    = 0xC0000047,
    NT_STATUS_PORT_ALREADY_SET                            = 0xC0000048,
    NT_STATUS_SECTION_NOT_IMAGE                           = 0xC0000049,
    NT_STATUS_SUSPEND_COUNT_EXCEEDED                      = 0xC000004A,
    NT_STATUS_BAD_WORKING_SET_LIMIT                       = 0xC000004C,
    NT_STATUS_INCOMPATIBLE_FILE_MAP                       = 0xC000004D,
    NT_STATUS_SECTION_PROTECTION                          = 0xC000004E,
    NT_STATUS_NONEXISTENT_EA_ENTRY                        = 0xC0000051,
    NT_STATUS_NO_EAS_ON_FILE                              = 0xC0000052,
    NT_STATUS_EA_CORRUPT_ERROR                            = 0xC0000053,
    NT_STATUS_CTL_FILE_NOT_SUPPORTED                      = 0xC0000057,
    NT_STATUS_UNKNOWN_REVISION                            = 0xC0000058,
    NT_STATUS_REVISION_MISMATCH                           = 0xC0000059,
    NT_STATUS_INVALID_OWNER                               = 0xC000005A,
    NT_STATUS_INVALID_PRIMARY_GROUP                       = 0xC000005B,
    NT_STATUS_NO_IMPERSONATION_TOKEN                      = 0xC000005C,
    NT_STATUS_CANT_DISABLE_MANDATORY                      = 0xC000005D,
    NT_STATUS_NO_LOGON_SERVERS                            = 0xC000005E,
    NT_STATUS_NO_SUCH_LOGON_SESSION                       = 0xC000005F,
    NT_STATUS_NO_SUCH_PRIVILEGE                           = 0xC0000060,
    NT_STATUS_INVALID_ACCOUNT_NAME                        = 0xC0000062,
    NT_STATUS_USER_EXISTS                                 = 0xC0000063,
    NT_STATUS_NO_SUCH_USER                                = 0xC0000064,
    NT_STATUS_GROUP_EXISTS                                = 0xC0000065,
    NT_STATUS_NO_SUCH_GROUP                               = 0xC0000066,
    NT_STATUS_MEMBER_IN_GROUP                             = 0xC0000067,
    NT_STATUS_MEMBER_NOT_IN_GROUP                         = 0xC0000068,
    NT_STATUS_LAST_ADMIN                                  = 0xC0000069,
    NT_STATUS_ILL_FORMED_PASSWORD                         = 0xC000006B,
    NT_STATUS_PASSWORD_RESTRICTION                        = 0xC000006C,
    NT_STATUS_ACCOUNT_RESTRICTION                         = 0xC000006E,
    NT_STATUS_TOO_MANY_LUIDS_REQUESTED                    = 0xC0000074,
    NT_STATUS_LUIDS_EXHAUSTED                             = 0xC0000075,
    NT_STATUS_INVALID_SUB_AUTHORITY                       = 0xC0000076,
    NT_STATUS_INVALID_ACL                                 = 0xC0000077,
    NT_STATUS_INVALID_SID                                 = 0xC0000078,
    NT_STATUS_INVALID_SECURITY_DESCR                      = 0xC0000079,
    NT_STATUS_PROCEDURE_NOT_FOUND                         = 0xC000007A,
    NT_STATUS_INVALID_IMAGE_FORMAT                        = 0xC000007B,
    NT_STATUS_NO_TOKEN                                    = 0xC000007C,
    NT_STATUS_BAD_INHERITANCE_ACL                         = 0xC000007D,
    NT_STATUS_SERVER_DISABLED                             = 0xC0000080,
    NT_STATUS_SERVER_NOT_DISABLED                         = 0xC0000081,
    NT_STATUS_TOO_MANY_GUIDS_REQUESTED                    = 0xC0000082,
    NT_STATUS_GUIDS_EXHAUSTED                             = 0xC0000083,
    NT_STATUS_INVALID_ID_AUTHORITY                        = 0xC0000084,
    NT_STATUS_AGENTS_EXHAUSTED                            = 0xC0000085,
    NT_STATUS_INVALID_VOLUME_LABEL                        = 0xC0000086,
    NT_STATUS_SECTION_NOT_EXTENDED                        = 0xC0000087,
    NT_STATUS_NOT_MAPPED_DATA                             = 0xC0000088,
    NT_STATUS_RESOURCE_DATA_NOT_FOUND                     = 0xC0000089,
    NT_STATUS_RESOURCE_TYPE_NOT_FOUND                     = 0xC000008A,
    NT_STATUS_RESOURCE_NAME_NOT_FOUND                     = 0xC000008B,
    NT_STATUS_ARRAY_BOUNDS_EXCEEDED                       = 0xC000008C,
    NT_STATUS_FLOAT_DENORMAL_OPERAND                      = 0xC000008D,
    NT_STATUS_FLOAT_DIVIDE_BY_ZERO                        = 0xC000008E,
    NT_STATUS_FLOAT_INEXACT_RESULT                        = 0xC000008F,
    NT_STATUS_FLOAT_INVALID_OPERATION                     = 0xC0000090,
    NT_STATUS_FLOAT_OVERFLOW                              = 0xC0000091,
    NT_STATUS_FLOAT_STACK_CHECK                           = 0xC0000092,
    NT_STATUS_FLOAT_UNDERFLOW                             = 0xC0000093,
    NT_STATUS_INTEGER_DIVIDE_BY_ZERO                      = 0xC0000094,
    NT_STATUS_INTEGER_OVERFLOW                            = 0xC0000095,
    NT_STATUS_PRIVILEGED_INSTRUCTION                      = 0xC0000096,
    NT_STATUS_FILE_INVALID                                = 0xC0000098,
    NT_STATUS_ALLOTTED_SPACE_EXCEEDED                     = 0xC0000099,
    NT_STATUS_INSUFFICIENT_RESOURCES                      = 0xC000009A,
    NT_STATUS_DEVICE_NOT_CONNECTED                        = 0xC000009D,
    NT_STATUS_DEVICE_POWER_FAILURE                        = 0xC000009E,
    NT_STATUS_FREE_VM_NOT_AT_BASE                         = 0xC000009F,
    NT_STATUS_MEMORY_NOT_ALLOCATED                        = 0xC00000A0,
    NT_STATUS_WORKING_SET_QUOTA                           = 0xC00000A1,
    NT_STATUS_DEVICE_NOT_READY                            = 0xC00000A3,
    NT_STATUS_INVALID_GROUP_ATTRIBUTES                    = 0xC00000A4,
    NT_STATUS_BAD_IMPERSONATION_LEVEL                     = 0xC00000A5,
    NT_STATUS_CANT_OPEN_ANONYMOUS                         = 0xC00000A6,
    NT_STATUS_BAD_VALIDATION_CLASS                        = 0xC00000A7,
    NT_STATUS_BAD_TOKEN_TYPE                              = 0xC00000A8,
    NT_STATUS_BAD_MASTER_BOOT_RECORD                      = 0xC00000A9,
    NT_STATUS_INSTRUCTION_MISALIGNMENT                    = 0xC00000AA,
    NT_STATUS_PIPE_CONNECTED                              = 0xC00000B2,
    NT_STATUS_PIPE_LISTENING                              = 0xC00000B3,
    NT_STATUS_FILE_FORCED_CLOSED                          = 0xC00000B6,
    NT_STATUS_PROFILING_NOT_STARTED                       = 0xC00000B7,
    NT_STATUS_PROFILING_NOT_STOPPED                       = 0xC00000B8,
    NT_STATUS_COULD_NOT_INTERPRET                         = 0xC00000B9,
    NT_STATUS_REMOTE_NOT_LISTENING                        = 0xC00000BC,
    NT_STATUS_DUPLICATE_NAME                              = 0xC00000BD,
    NT_STATUS_BAD_NETWORK_PATH                            = 0xC00000BE,
    NT_STATUS_NETWORK_BUSY                                = 0xC00000BF,
    NT_STATUS_DEVICE_DOES_NOT_EXIST                       = 0xC00000C0,
    NT_STATUS_TOO_MANY_COMMANDS                           = 0xC00000C1,
    NT_STATUS_ADAPTER_HARDWARE_ERROR                      = 0xC00000C2,
    NT_STATUS_INVALID_NETWORK_RESPONSE                    = 0xC00000C3,
    NT_STATUS_BAD_REMOTE_ADAPTER                          = 0xC00000C5,
    NT_STATUS_TOO_MANY_NAMES                              = 0xC00000CD,
    NT_STATUS_SHARING_PAUSED                              = 0xC00000CF,
    NT_STATUS_REDIRECTOR_PAUSED                           = 0xC00000D1,
    NT_STATUS_NET_WRITE_FAULT                             = 0xC00000D2,
    NT_STATUS_PROFILING_AT_LIMIT                          = 0xC00000D3,
    NT_STATUS_VIRTUAL_CIRCUIT_CLOSED                      = 0xC00000D6,
    NT_STATUS_NO_SECURITY_ON_OBJECT                       = 0xC00000D7,
    NT_STATUS_CANT_WAIT                                   = 0xC00000D8,
    NT_STATUS_CANT_ACCESS_DOMAIN_INFO                     = 0xC00000DA,
    NT_STATUS_CANT_TERMINATE_SELF                         = 0xC00000DB,
    NT_STATUS_INVALID_SERVER_STATE                        = 0xC00000DC,
    NT_STATUS_INVALID_DOMAIN_STATE                        = 0xC00000DD,
    NT_STATUS_INVALID_DOMAIN_ROLE                         = 0xC00000DE,
    NT_STATUS_NO_SUCH_DOMAIN                              = 0xC00000DF,
    NT_STATUS_DOMAIN_EXISTS                               = 0xC00000E0,
    NT_STATUS_DOMAIN_LIMIT_EXCEEDED                       = 0xC00000E1,
    NT_STATUS_OPLOCK_NOT_GRANTED                          = 0xC00000E2,
    NT_STATUS_INVALID_OPLOCK_PROTOCOL                     = 0xC00000E3,
    NT_STATUS_INTERNAL_DB_CORRUPTION                      = 0xC00000E4,
    NT_STATUS_INTERNAL_ERROR                              = 0xC00000E5,
    NT_STATUS_GENERIC_NOT_MAPPED                          = 0xC00000E6,
    NT_STATUS_BAD_DESCRIPTOR_FORMAT                       = 0xC00000E7,
    NT_STATUS_INVALID_USER_BUFFER                         = 0xC00000E8,
    NT_STATUS_UNEXPECTED_IO_ERROR                         = 0xC00000E9,
    NT_STATUS_UNEXPECTED_MM_CREATE_ERR                    = 0xC00000EA,
    NT_STATUS_UNEXPECTED_MM_MAP_ERROR                     = 0xC00000EB,
    NT_STATUS_UNEXPECTED_MM_EXTEND_ERR                    = 0xC00000EC,
    NT_STATUS_NOT_LOGON_PROCESS                           = 0xC00000ED,
    NT_STATUS_LOGON_SESSION_EXISTS                        = 0xC00000EE,
    NT_STATUS_INVALID_PARAMETER_1                         = 0xC00000EF,
    NT_STATUS_INVALID_PARAMETER_2                         = 0xC00000F0,
    NT_STATUS_INVALID_PARAMETER_3                         = 0xC00000F1,
    NT_STATUS_INVALID_PARAMETER_4                         = 0xC00000F2,
    NT_STATUS_INVALID_PARAMETER_5                         = 0xC00000F3,
    NT_STATUS_INVALID_PARAMETER_6                         = 0xC00000F4,
    NT_STATUS_INVALID_PARAMETER_7                         = 0xC00000F5,
    NT_STATUS_INVALID_PARAMETER_8                         = 0xC00000F6,
    NT_STATUS_INVALID_PARAMETER_9                         = 0xC00000F7,
    NT_STATUS_INVALID_PARAMETER_10                        = 0xC00000F8,
    NT_STATUS_INVALID_PARAMETER_11                        = 0xC00000F9,
    NT_STATUS_INVALID_PARAMETER_12                        = 0xC00000FA,
    NT_STATUS_REDIRECTOR_STARTED                          = 0xC00000FC,
    NT_STATUS_STACK_OVERFLOW                              = 0xC00000FD,
    NT_STATUS_NO_SUCH_PACKAGE                             = 0xC00000FE,
    NT_STATUS_BAD_FUNCTION_TABLE                          = 0xC00000FF,
    NT_STATUS_VARIABLE_NOT_FOUND                          = 0xC0000100,
    NT_STATUS_FILE_CORRUPT_ERROR                          = 0xC0000102,
    NT_STATUS_NOT_A_DIRECTORY                             = 0xC0000103,
    NT_STATUS_BAD_LOGON_SESSION_STATE                     = 0xC0000104,
    NT_STATUS_LOGON_SESSION_COLLISION                     = 0xC0000105,
    NT_STATUS_NAME_TOO_LONG                               = 0xC0000106,
    NT_STATUS_FILES_OPEN                                  = 0xC0000107,
    NT_STATUS_CONNECTION_IN_USE                           = 0xC0000108,
    NT_STATUS_MESSAGE_NOT_FOUND                           = 0xC0000109,
    NT_STATUS_INVALID_LOGON_TYPE                          = 0xC000010B,
    NT_STATUS_NO_GUID_TRANSLATION                         = 0xC000010C,
    NT_STATUS_CANNOT_IMPERSONATE                          = 0xC000010D,
    NT_STATUS_IMAGE_ALREADY_LOADED                        = 0xC000010E,
    NT_STATUS_ABIOS_NOT_PRESENT                           = 0xC000010F,
    NT_STATUS_ABIOS_LID_NOT_EXIST                         = 0xC0000110,
    NT_STATUS_ABIOS_LID_ALREADY_OWNED                     = 0xC0000111,
    NT_STATUS_ABIOS_NOT_LID_OWNER                         = 0xC0000112,
    NT_STATUS_ABIOS_INVALID_COMMAND                       = 0xC0000113,
    NT_STATUS_ABIOS_INVALID_LID                           = 0xC0000114,
    NT_STATUS_ABIOS_SELECTOR_NOT_AVAILABLE                = 0xC0000115,
    NT_STATUS_ABIOS_INVALID_SELECTOR                      = 0xC0000116,
    NT_STATUS_NO_LDT                                      = 0xC0000117,
    NT_STATUS_INVALID_LDT_SIZE                            = 0xC0000118,
    NT_STATUS_INVALID_LDT_OFFSET                          = 0xC0000119,
    NT_STATUS_INVALID_LDT_DESCRIPTOR                      = 0xC000011A,
    NT_STATUS_INVALID_IMAGE_NE_FORMAT                     = 0xC000011B,
    NT_STATUS_RXACT_INVALID_STATE                         = 0xC000011C,
    NT_STATUS_RXACT_COMMIT_FAILURE                        = 0xC000011D,
    NT_STATUS_MAPPED_FILE_SIZE_ZERO                       = 0xC000011E,
    NT_STATUS_CANCELLED                                   = 0xC0000120,
    NT_STATUS_INVALID_COMPUTER_NAME                       = 0xC0000122,
    NT_STATUS_SPECIAL_ACCOUNT                             = 0xC0000124,
    NT_STATUS_SPECIAL_GROUP                               = 0xC0000125,
    NT_STATUS_SPECIAL_USER                                = 0xC0000126,
    NT_STATUS_MEMBERS_PRIMARY_GROUP                       = 0xC0000127,
    NT_STATUS_TOO_MANY_THREADS                            = 0xC0000129,
    NT_STATUS_THREAD_NOT_IN_PROCESS                       = 0xC000012A,
    NT_STATUS_TOKEN_ALREADY_IN_USE                        = 0xC000012B,
    NT_STATUS_PAGEFILE_QUOTA_EXCEEDED                     = 0xC000012C,
    NT_STATUS_COMMITMENT_LIMIT                            = 0xC000012D,
    NT_STATUS_INVALID_IMAGE_LE_FORMAT                     = 0xC000012E,
    NT_STATUS_INVALID_IMAGE_NOT_MZ                        = 0xC000012F,
    NT_STATUS_INVALID_IMAGE_PROTECT                       = 0xC0000130,
    NT_STATUS_INVALID_IMAGE_WIN_16                        = 0xC0000131,
    NT_STATUS_LOGON_SERVER_CONFLICT                       = 0xC0000132,
    NT_STATUS_TIME_DIFFERENCE_AT_DC                       = 0xC0000133,
    NT_STATUS_SYNCHRONIZATION_REQUIRED                    = 0xC0000134,
    NT_STATUS_DLL_NOT_FOUND                               = 0xC0000135,
    NT_STATUS_OPEN_FAILED                                 = 0xC0000136,
    NT_STATUS_IO_PRIVILEGE_FAILED                         = 0xC0000137,
    NT_STATUS_ORDINAL_NOT_FOUND                           = 0xC0000138,
    NT_STATUS_ENTRYPOINT_NOT_FOUND                        = 0xC0000139,
    NT_STATUS_CONTROL_C_EXIT                              = 0xC000013A,
    NT_STATUS_LOCAL_DISCONNECT                            = 0xC000013B,
    NT_STATUS_REMOTE_DISCONNECT                           = 0xC000013C,
    NT_STATUS_REMOTE_RESOURCES                            = 0xC000013D,
    NT_STATUS_LINK_FAILED                                 = 0xC000013E,
    NT_STATUS_LINK_TIMEOUT                                = 0xC000013F,
    NT_STATUS_INVALID_CONNECTION                          = 0xC0000140,
    NT_STATUS_INVALID_ADDRESS                             = 0xC0000141,
    NT_STATUS_DLL_INIT_FAILED                             = 0xC0000142,
    NT_STATUS_MISSING_SYSTEMFILE                          = 0xC0000143,
    NT_STATUS_UNHANDLED_EXCEPTION                         = 0xC0000144,
    NT_STATUS_APP_INIT_FAILURE                            = 0xC0000145,
    NT_STATUS_PAGEFILE_CREATE_FAILED                      = 0xC0000146,
    NT_STATUS_NO_PAGEFILE                                 = 0xC0000147,
    NT_STATUS_INVALID_LEVEL                               = 0xC0000148,
    NT_STATUS_WRONG_PASSWORD_CORE                         = 0xC0000149,
    NT_STATUS_ILLEGAL_FLOAT_CONTEXT                       = 0xC000014A,
    NT_STATUS_PIPE_BROKEN                                 = 0xC000014B,
    NT_STATUS_REGISTRY_CORRUPT                            = 0xC000014C,
    NT_STATUS_REGISTRY_IO_FAILED                          = 0xC000014D,
    NT_STATUS_NO_EVENT_PAIR                               = 0xC000014E,
    NT_STATUS_UNRECOGNIZED_VOLUME                         = 0xC000014F,
    NT_STATUS_SERIAL_NO_DEVICE_INITED                     = 0xC0000150,
    NT_STATUS_NO_SUCH_ALIAS                               = 0xC0000151,
    NT_STATUS_MEMBER_NOT_IN_ALIAS                         = 0xC0000152,
    NT_STATUS_MEMBER_IN_ALIAS                             = 0xC0000153,
    NT_STATUS_ALIAS_EXISTS                                = 0xC0000154,
    NT_STATUS_LOGON_NOT_GRANTED                           = 0xC0000155,
    NT_STATUS_TOO_MANY_SECRETS                            = 0xC0000156,
    NT_STATUS_SECRET_TOO_LONG                             = 0xC0000157,
    NT_STATUS_INTERNAL_DB_ERROR                           = 0xC0000158,
    NT_STATUS_FULLSCREEN_MODE                             = 0xC0000159,
    NT_STATUS_TOO_MANY_CONTEXT_IDS                        = 0xC000015A,
    NT_STATUS_LOGON_TYPE_NOT_GRANTED                      = 0xC000015B,
    NT_STATUS_NOT_REGISTRY_FILE                           = 0xC000015C,
    NT_STATUS_NT_CROSS_ENCRYPTION_REQUIRED                = 0xC000015D,
    NT_STATUS_DOMAIN_CTRLR_CONFIG_ERROR                   = 0xC000015E,
    NT_STATUS_FT_MISSING_MEMBER                           = 0xC000015F,
    NT_STATUS_ILL_FORMED_SERVICE_ENTRY                    = 0xC0000160,
    NT_STATUS_ILLEGAL_CHARACTER                           = 0xC0000161,
    NT_STATUS_UNMAPPABLE_CHARACTER                        = 0xC0000162,
    NT_STATUS_UNDEFINED_CHARACTER                         = 0xC0000163,
    NT_STATUS_FLOPPY_VOLUME                               = 0xC0000164,
    NT_STATUS_FLOPPY_ID_MARK_NOT_FOUND                    = 0xC0000165,
    NT_STATUS_FLOPPY_WRONG_CYLINDER                       = 0xC0000166,
    NT_STATUS_FLOPPY_UNKNOWN_ERROR                        = 0xC0000167,
    NT_STATUS_FLOPPY_BAD_REGISTERS                        = 0xC0000168,
    NT_STATUS_DISK_RECALIBRATE_FAILED                     = 0xC0000169,
    NT_STATUS_DISK_OPERATION_FAILED                       = 0xC000016A,
    NT_STATUS_DISK_RESET_FAILED                           = 0xC000016B,
    NT_STATUS_SHARED_IRQ_BUSY                             = 0xC000016C,
    NT_STATUS_FT_ORPHANING                                = 0xC000016D,
    NT_STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT            = 0xC000016E,
    NT_STATUS_PARTITION_FAILURE                           = 0xC0000172,
    NT_STATUS_INVALID_BLOCK_LENGTH                        = 0xC0000173,
    NT_STATUS_DEVICE_NOT_PARTITIONED                      = 0xC0000174,
    NT_STATUS_UNABLE_TO_LOCK_MEDIA                        = 0xC0000175,
    NT_STATUS_UNABLE_TO_UNLOAD_MEDIA                      = 0xC0000176,
    NT_STATUS_EOM_OVERFLOW                                = 0xC0000177,
    NT_STATUS_NO_MEDIA                                    = 0xC0000178,
    NT_STATUS_NO_SUCH_MEMBER                              = 0xC000017A,
    NT_STATUS_INVALID_MEMBER                              = 0xC000017B,
    NT_STATUS_KEY_DELETED                                 = 0xC000017C,
    NT_STATUS_NO_LOG_SPACE                                = 0xC000017D,
    NT_STATUS_TOO_MANY_SIDS                               = 0xC000017E,
    NT_STATUS_LM_CROSS_ENCRYPTION_REQUIRED                = 0xC000017F,
    NT_STATUS_KEY_HAS_CHILDREN                            = 0xC0000180,
    NT_STATUS_CHILD_MUST_BE_VOLATILE                      = 0xC0000181,
    NT_STATUS_DEVICE_CONFIGURATION_ERROR                  = 0xC0000182,
    NT_STATUS_DRIVER_INTERNAL_ERROR                       = 0xC0000183,
    NT_STATUS_IO_DEVICE_ERROR                             = 0xC0000185,
    NT_STATUS_DEVICE_PROTOCOL_ERROR                       = 0xC0000186,
    NT_STATUS_BACKUP_CONTROLLER                           = 0xC0000187,
    NT_STATUS_LOG_FILE_FULL                               = 0xC0000188,
    NT_STATUS_TOO_LATE                                    = 0xC0000189,
    NT_STATUS_NO_TRUST_LSA_SECRET                         = 0xC000018A,
    NT_STATUS_NO_TRUST_SAM_ACCOUNT                        = 0xC000018B,
    NT_STATUS_TRUSTED_DOMAIN_FAILURE                      = 0xC000018C,
    NT_STATUS_TRUSTED_RELATIONSHIP_FAILURE                = 0xC000018D,
    NT_STATUS_EVENTLOG_FILE_CORRUPT                       = 0xC000018E,
    NT_STATUS_EVENTLOG_CANT_START                         = 0xC000018F,
    NT_STATUS_TRUST_FAILURE                               = 0xC0000190,
    NT_STATUS_MUTANT_LIMIT_EXCEEDED                       = 0xC0000191,
    NT_STATUS_NETLOGON_NOT_STARTED                        = 0xC0000192,
    NT_STATUS_POSSIBLE_DEADLOCK                           = 0xC0000194,
    NT_STATUS_NETWORK_CREDENTIAL_CONFLICT                 = 0xC0000195,
    NT_STATUS_REMOTE_SESSION_LIMIT                        = 0xC0000196,
    NT_STATUS_EVENTLOG_FILE_CHANGED                       = 0xC0000197,
    NT_STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT           = 0xC0000198,
    NT_STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT           = 0xC0000199,
    NT_STATUS_NOLOGON_SERVER_TRUST_ACCOUNT                = 0xC000019A,
    NT_STATUS_DOMAIN_TRUST_INCONSISTENT                   = 0xC000019B,
    NT_STATUS_FS_DRIVER_REQUIRED                          = 0xC000019C,
    NT_STATUS_NO_USER_SESSION_KEY                         = 0xC0000202,
    NT_STATUS_USER_SESSION_DELETED                        = 0xC0000203,
    NT_STATUS_RESOURCE_LANG_NOT_FOUND                     = 0xC0000204,
    NT_STATUS_INVALID_BUFFER_SIZE                         = 0xC0000206,
    NT_STATUS_INVALID_ADDRESS_COMPONENT                   = 0xC0000207,
    NT_STATUS_INVALID_ADDRESS_WILDCARD                    = 0xC0000208,
    NT_STATUS_TOO_MANY_ADDRESSES                          = 0xC0000209,
    NT_STATUS_ADDRESS_ALREADY_EXISTS                      = 0xC000020A,
    NT_STATUS_ADDRESS_CLOSED                              = 0xC000020B,
    NT_STATUS_CONNECTION_DISCONNECTED                     = 0xC000020C,
    NT_STATUS_CONNECTION_RESET                            = 0xC000020D,
    NT_STATUS_TOO_MANY_NODES                              = 0xC000020E,
    NT_STATUS_TRANSACTION_ABORTED                         = 0xC000020F,
    NT_STATUS_TRANSACTION_TIMED_OUT                       = 0xC0000210,
    NT_STATUS_TRANSACTION_NO_RELEASE                      = 0xC0000211,
    NT_STATUS_TRANSACTION_NO_MATCH                        = 0xC0000212,
    NT_STATUS_TRANSACTION_RESPONDED                       = 0xC0000213,
    NT_STATUS_TRANSACTION_INVALID_ID                      = 0xC0000214,
    NT_STATUS_TRANSACTION_INVALID_TYPE                    = 0xC0000215,
    NT_STATUS_NOT_SERVER_SESSION                          = 0xC0000216,
    NT_STATUS_NOT_CLIENT_SESSION                          = 0xC0000217,
    NT_STATUS_CANNOT_LOAD_REGISTRY_FILE                   = 0xC0000218,
    NT_STATUS_DEBUG_ATTACH_FAILED                         = 0xC0000219,
    NT_STATUS_SYSTEM_PROCESS_TERMINATED                   = 0xC000021A,
    NT_STATUS_DATA_NOT_ACCEPTED                           = 0xC000021B,
    NT_STATUS_NO_BROWSER_SERVERS_FOUND                    = 0xC000021C,
    NT_STATUS_VDM_HARD_ERROR                              = 0xC000021D,
    NT_STATUS_DRIVER_CANCEL_TIMEOUT                       = 0xC000021E,
    NT_STATUS_REPLY_MESSAGE_MISMATCH                      = 0xC000021F,
    NT_STATUS_MAPPED_ALIGNMENT                            = 0xC0000220,
    NT_STATUS_IMAGE_CHECKSUM_MISMATCH                     = 0xC0000221,
    NT_STATUS_LOST_WRITEBEHIND_DATA                       = 0xC0000222,
    NT_STATUS_CLIENT_SERVER_PARAMETERS_INVALID            = 0xC0000223,
    NT_STATUS_NOT_FOUND                                   = 0xC0000225,
    NT_STATUS_NOT_TINY_STREAM                             = 0xC0000226,
    NT_STATUS_RECOVERY_FAILURE                            = 0xC0000227,
    NT_STATUS_STACK_OVERFLOW_READ                         = 0xC0000228,
    NT_STATUS_FAIL_CHECK                                  = 0xC0000229,
    NT_STATUS_DUPLICATE_OBJECTID                          = 0xC000022A,
    NT_STATUS_OBJECTID_EXISTS                             = 0xC000022B,
    NT_STATUS_CONVERT_TO_LARGE                            = 0xC000022C,
    NT_STATUS_RETRY                                       = 0xC000022D,
    NT_STATUS_FOUND_OUT_OF_SCOPE                          = 0xC000022E,
    NT_STATUS_ALLOCATE_BUCKET                             = 0xC000022F,
    NT_STATUS_PROPSET_NOT_FOUND                           = 0xC0000230,
    NT_STATUS_MARSHALL_OVERFLOW                           = 0xC0000231,
    NT_STATUS_INVALID_VARIANT                             = 0xC0000232,
    NT_STATUS_DOMAIN_CONTROLLER_NOT_FOUND                 = 0xC0000233,
    NT_STATUS_ACCOUNT_LOCKED_OUT                          = 0xC0000234,
    NT_STATUS_CONNECTION_REFUSED                          = 0xC0000236,
    NT_STATUS_GRACEFUL_DISCONNECT                         = 0xC0000237,
    NT_STATUS_ADDRESS_ALREADY_ASSOCIATED                  = 0xC0000238,
    NT_STATUS_ADDRESS_NOT_ASSOCIATED                      = 0xC0000239,
    NT_STATUS_CONNECTION_INVALID                          = 0xC000023A,
    NT_STATUS_CONNECTION_ACTIVE                           = 0xC000023B,
    NT_STATUS_NETWORK_UNREACHABLE                         = 0xC000023C,
    NT_STATUS_HOST_UNREACHABLE                            = 0xC000023D,
    NT_STATUS_PROTOCOL_UNREACHABLE                        = 0xC000023E,
    NT_STATUS_PORT_UNREACHABLE                            = 0xC000023F,
    NT_STATUS_REQUEST_ABORTED                             = 0xC0000240,
    NT_STATUS_CONNECTION_ABORTED                          = 0xC0000241,
    NT_STATUS_BAD_COMPRESSION_BUFFER                      = 0xC0000242,
    NT_STATUS_USER_MAPPED_FILE                            = 0xC0000243,
    NT_STATUS_AUDIT_FAILED                                = 0xC0000244,
    NT_STATUS_TIMER_RESOLUTION_NOT_SET                    = 0xC0000245,
    NT_STATUS_CONNECTION_COUNT_LIMIT                      = 0xC0000246,
    NT_STATUS_LOGIN_TIME_RESTRICTION                      = 0xC0000247,
    NT_STATUS_LOGIN_WKSTA_RESTRICTION                     = 0xC0000248,
    NT_STATUS_IMAGE_MP_UP_MISMATCH                        = 0xC0000249,
    NT_STATUS_INSUFFICIENT_LOGON_INFO                     = 0xC0000250,
    NT_STATUS_BAD_DLL_ENTRYPOINT                          = 0xC0000251,
    NT_STATUS_BAD_SERVICE_ENTRYPOINT                      = 0xC0000252,
    NT_STATUS_LPC_REPLY_LOST                              = 0xC0000253,
    NT_STATUS_IP_ADDRESS_CONFLICT1                        = 0xC0000254,
    NT_STATUS_IP_ADDRESS_CONFLICT2                        = 0xC0000255,
    NT_STATUS_REGISTRY_QUOTA_LIMIT                        = 0xC0000256,
    NT_STATUS_NO_CALLBACK_ACTIVE                          = 0xC0000258,
    NT_STATUS_LICENSE_QUOTA_EXCEEDED                      = 0xC0000259,
    NT_STATUS_PWD_TOO_SHORT                               = 0xC000025A,
    NT_STATUS_PWD_TOO_RECENT                              = 0xC000025B,
    NT_STATUS_PWD_HISTORY_CONFLICT                        = 0xC000025C,
    NT_STATUS_PLUGPLAY_NO_DEVICE                          = 0xC000025E,
    NT_STATUS_UNSUPPORTED_COMPRESSION                     = 0xC000025F,
    NT_STATUS_INVALID_HW_PROFILE                          = 0xC0000260,
    NT_STATUS_INVALID_PLUGPLAY_DEVICE_PATH                = 0xC0000261,
    NT_STATUS_DRIVER_ORDINAL_NOT_FOUND                    = 0xC0000262,
    NT_STATUS_DRIVER_ENTRYPOINT_NOT_FOUND                 = 0xC0000263,
    NT_STATUS_RESOURCE_NOT_OWNED                          = 0xC0000264,
    NT_STATUS_TOO_MANY_LINKS                              = 0xC0000265,
    NT_STATUS_QUOTA_LIST_INCONSISTENT                     = 0xC0000266,
    NT_STATUS_FILE_IS_OFFLINE                             = 0xC0000267,
    NT_STATUS_EVALUATION_EXPIRATION                       = 0xC0000268,
    NT_STATUS_ILLEGAL_DLL_RELOCATION                      = 0xC0000269,
    NT_STATUS_LICENSE_VIOLATION                           = 0xC000026A,
    NT_STATUS_DLL_INIT_FAILED_LOGOFF                      = 0xC000026B,
    NT_STATUS_DRIVER_UNABLE_TO_LOAD                       = 0xC000026C,
    NT_STATUS_DFS_UNAVAILABLE                             = 0xC000026D,
    NT_STATUS_VOLUME_DISMOUNTED                           = 0xC000026E,
    NT_STATUS_WX86_INTERNAL_ERROR                         = 0xC000026F,
    NT_STATUS_WX86_FLOAT_STACK_CHECK                      = 0xC0000270,
    NT_STATUS_VALIDATE_CONTINUE                           = 0xC0000271,
    NT_STATUS_NO_MATCH                                    = 0xC0000272,
    NT_STATUS_NO_MORE_MATCHES                             = 0xC0000273,
    NT_STATUS_NOT_A_REPARSE_POINT                         = 0xC0000275,
    NT_STATUS_IO_REPARSE_TAG_INVALID                      = 0xC0000276,
    NT_STATUS_IO_REPARSE_TAG_MISMATCH                     = 0xC0000277,
    NT_STATUS_IO_REPARSE_DATA_INVALID                     = 0xC0000278,
    NT_STATUS_IO_REPARSE_TAG_NOT_HANDLED                  = 0xC0000279,
    NT_STATUS_REPARSE_POINT_NOT_RESOLVED                  = 0xC0000280,
    NT_STATUS_DIRECTORY_IS_A_REPARSE_POINT                = 0xC0000281,
    NT_STATUS_RANGE_LIST_CONFLICT                         = 0xC0000282,
    NT_STATUS_SOURCE_ELEMENT_EMPTY                        = 0xC0000283,
    NT_STATUS_DESTINATION_ELEMENT_FULL                    = 0xC0000284,
    NT_STATUS_ILLEGAL_ELEMENT_ADDRESS                     = 0xC0000285,
    NT_STATUS_MAGAZINE_NOT_PRESENT                        = 0xC0000286,
    NT_STATUS_REINITIALIZATION_NEEDED                     = 0xC0000287,
    NT_STATUS_DEVICE_REQUIRES_CLEANING                    = 0x80000288,
    NT_STATUS_DEVICE_DOOR_OPEN                            = 0x80000289,
    NT_STATUS_ENCRYPTION_FAILED                           = 0xC000028A,
    NT_STATUS_DECRYPTION_FAILED                           = 0xC000028B,
    NT_STATUS_RANGE_NOT_FOUND                             = 0xC000028C,
    NT_STATUS_NO_RECOVERY_POLICY                          = 0xC000028D,
    NT_STATUS_NO_EFS                                      = 0xC000028E,
    NT_STATUS_WRONG_EFS                                   = 0xC000028F,
    NT_STATUS_NO_USER_KEYS                                = 0xC0000290,
    NT_STATUS_FILE_NOT_ENCRYPTED                          = 0xC0000291,
    NT_STATUS_NOT_EXPORT_FORMAT                           = 0xC0000292,
    NT_STATUS_FILE_ENCRYPTED                              = 0xC0000293,
    NT_STATUS_WAKE_SYSTEM                                 = 0x40000294,
    NT_STATUS_WMI_GUID_NOT_FOUND                          = 0xC0000295,
    NT_STATUS_WMI_INSTANCE_NOT_FOUND                      = 0xC0000296,
    NT_STATUS_WMI_ITEMID_NOT_FOUND                        = 0xC0000297,
    NT_STATUS_WMI_TRY_AGAIN                               = 0xC0000298,
    NT_STATUS_SHARED_POLICY                               = 0xC0000299,
    NT_STATUS_POLICY_OBJECT_NOT_FOUND                     = 0xC000029A,
    NT_STATUS_POLICY_ONLY_IN_DS                           = 0xC000029B,
    NT_STATUS_VOLUME_NOT_UPGRADED                         = 0xC000029C,
    NT_STATUS_REMOTE_STORAGE_NOT_ACTIVE                   = 0xC000029D,
    NT_STATUS_REMOTE_STORAGE_MEDIA_ERROR                  = 0xC000029E,
    NT_STATUS_NO_TRACKING_SERVICE                         = 0xC000029F,
    NT_STATUS_SERVER_SID_MISMATCH                         = 0xC00002A0,
    NT_STATUS_DS_NO_ATTRIBUTE_OR_VALUE                    = 0xC00002A1,
    NT_STATUS_DS_INVALID_ATTRIBUTE_SYNTAX                 = 0xC00002A2,
    NT_STATUS_DS_ATTRIBUTE_TYPE_UNDEFINED                 = 0xC00002A3,
    NT_STATUS_DS_ATTRIBUTE_OR_VALUE_EXISTS                = 0xC00002A4,
    NT_STATUS_DS_BUSY                                     = 0xC00002A5,
    NT_STATUS_DS_UNAVAILABLE                              = 0xC00002A6,
    NT_STATUS_DS_NO_RIDS_ALLOCATED                        = 0xC00002A7,
    NT_STATUS_DS_NO_MORE_RIDS                             = 0xC00002A8,
    NT_STATUS_DS_INCORRECT_ROLE_OWNER                     = 0xC00002A9,
    NT_STATUS_DS_RIDMGR_INIT_ERROR                        = 0xC00002AA,
    NT_STATUS_DS_OBJ_CLASS_VIOLATION                      = 0xC00002AB,
    NT_STATUS_DS_CANT_ON_NON_LEAF                         = 0xC00002AC,
    NT_STATUS_DS_CANT_ON_RDN                              = 0xC00002AD,
    NT_STATUS_DS_CANT_MOD_OBJ_CLASS                       = 0xC00002AE,
    NT_STATUS_DS_CROSS_DOM_MOVE_FAILED                    = 0xC00002AF,
    NT_STATUS_DS_GC_NOT_AVAILABLE                         = 0xC00002B0,
    NT_STATUS_DIRECTORY_SERVICE_REQUIRED                  = 0xC00002B1,
    NT_STATUS_REPARSE_ATTRIBUTE_CONFLICT                  = 0xC00002B2,
    NT_STATUS_CANT_ENABLE_DENY_ONLY                       = 0xC00002B3,
    NT_STATUS_FLOAT_MULTIPLE_FAULTS                       = 0xC00002B4,
    NT_STATUS_FLOAT_MULTIPLE_TRAPS                        = 0xC00002B5,
    NT_STATUS_DEVICE_REMOVED                              = 0xC00002B6,
    NT_STATUS_JOURNAL_DELETE_IN_PROGRESS                  = 0xC00002B7,
    NT_STATUS_JOURNAL_NOT_ACTIVE                          = 0xC00002B8,
    NT_STATUS_NOINTERFACE                                 = 0xC00002B9,
    NT_STATUS_DS_ADMIN_LIMIT_EXCEEDED                     = 0xC00002C1,
    NT_STATUS_DRIVER_FAILED_SLEEP                         = 0xC00002C2,
    NT_STATUS_MUTUAL_AUTHENTICATION_FAILED                = 0xC00002C3,
    NT_STATUS_CORRUPT_SYSTEM_FILE                         = 0xC00002C4,
    NT_STATUS_DATATYPE_MISALIGNMENT_ERROR                 = 0xC00002C5,
    NT_STATUS_WMI_READ_ONLY                               = 0xC00002C6,
    NT_STATUS_WMI_SET_FAILURE                             = 0xC00002C7,
    NT_STATUS_COMMITMENT_MINIMUM                          = 0xC00002C8,
    NT_STATUS_REG_NAT_CONSUMPTION                         = 0xC00002C9,
    NT_STATUS_TRANSPORT_FULL                              = 0xC00002CA,
    NT_STATUS_DS_SAM_INIT_FAILURE                         = 0xC00002CB,
    NT_STATUS_ONLY_IF_CONNECTED                           = 0xC00002CC,
    NT_STATUS_DS_SENSITIVE_GROUP_VIOLATION                = 0xC00002CD,
    NT_STATUS_PNP_RESTART_ENUMERATION                     = 0xC00002CE,
    NT_STATUS_JOURNAL_ENTRY_DELETED                       = 0xC00002CF,
    NT_STATUS_DS_CANT_MOD_PRIMARYGROUPID                  = 0xC00002D0,
    NT_STATUS_SYSTEM_IMAGE_BAD_SIGNATURE                  = 0xC00002D1,
    NT_STATUS_PNP_REBOOT_REQUIRED                         = 0xC00002D2,
    NT_STATUS_POWER_STATE_INVALID                         = 0xC00002D3,
    NT_STATUS_DS_INVALID_GROUP_TYPE                       = 0xC00002D4,
    NT_STATUS_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN       = 0xC00002D5,
    NT_STATUS_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN        = 0xC00002D6,
    NT_STATUS_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER            = 0xC00002D7,
    NT_STATUS_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER        = 0xC00002D8,
    NT_STATUS_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER         = 0xC00002D9,
    NT_STATUS_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER      = 0xC00002DA,
    NT_STATUS_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER = 0xC00002DB,
    NT_STATUS_DS_HAVE_PRIMARY_MEMBERS                     = 0xC00002DC,
    NT_STATUS_WMI_NOT_SUPPORTED                           = 0xC00002DD,
    NT_STATUS_INSUFFICIENT_POWER                          = 0xC00002DE,
    NT_STATUS_SAM_NEED_BOOTKEY_PASSWORD                   = 0xC00002DF,
    NT_STATUS_SAM_NEED_BOOTKEY_FLOPPY                     = 0xC00002E0,
    NT_STATUS_DS_CANT_START                               = 0xC00002E1,
    NT_STATUS_DS_INIT_FAILURE                             = 0xC00002E2,
    NT_STATUS_SAM_INIT_FAILURE                            = 0xC00002E3,
    NT_STATUS_DS_GC_REQUIRED                              = 0xC00002E4,
    NT_STATUS_DS_LOCAL_MEMBER_OF_LOCAL_ONLY               = 0xC00002E5,
    NT_STATUS_DS_NO_FPO_IN_UNIVERSAL_GROUPS               = 0xC00002E6,
    NT_STATUS_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED           = 0xC00002E7,
    NT_STATUS_MULTIPLE_FAULT_VIOLATION                    = 0xC00002E8,
    NT_STATUS_CURRENT_DOMAIN_NOT_ALLOWED                  = 0xC00002E9,
    NT_STATUS_CANNOT_MAKE                                 = 0xC00002EA,
    NT_STATUS_SYSTEM_SHUTDOWN                             = 0xC00002EB,
    NT_STATUS_DS_INIT_FAILURE_CONSOLE                     = 0xC00002EC,
    NT_STATUS_DS_SAM_INIT_FAILURE_CONSOLE                 = 0xC00002ED,
    NT_STATUS_UNFINISHED_CONTEXT_DELETED                  = 0xC00002EE,
    NT_STATUS_NO_TGT_REPLY                                = 0xC00002EF,
    NT_STATUS_OBJECTID_NOT_FOUND                          = 0xC00002F0,
    NT_STATUS_NO_IP_ADDRESSES                             = 0xC00002F1,
    NT_STATUS_WRONG_CREDENTIAL_HANDLE                     = 0xC00002F2,
    NT_STATUS_CRYPTO_SYSTEM_INVALID                       = 0xC00002F3,
    NT_STATUS_MAX_REFERRALS_EXCEEDED                      = 0xC00002F4,
    NT_STATUS_MUST_BE_KDC                                 = 0xC00002F5,
    NT_STATUS_STRONG_CRYPTO_NOT_SUPPORTED                 = 0xC00002F6,
    NT_STATUS_TOO_MANY_PRINCIPALS                         = 0xC00002F7,
    NT_STATUS_NO_PA_DATA                                  = 0xC00002F8,
    NT_STATUS_PKINIT_NAME_MISMATCH                        = 0xC00002F9,
    NT_STATUS_SMARTCARD_LOGON_REQUIRED                    = 0xC00002FA,
    NT_STATUS_KDC_INVALID_REQUEST                         = 0xC00002FB,
    NT_STATUS_KDC_UNABLE_TO_REFER                         = 0xC00002FC,
    NT_STATUS_KDC_UNKNOWN_ETYPE                           = 0xC00002FD,
    NT_STATUS_SHUTDOWN_IN_PROGRESS                        = 0xC00002FE,
    NT_STATUS_SERVER_SHUTDOWN_IN_PROGRESS                 = 0xC00002FF,
    NT_STATUS_NOT_SUPPORTED_ON_SBS                        = 0xC0000300,
    NT_STATUS_WMI_GUID_DISCONNECTED                       = 0xC0000301,
    NT_STATUS_WMI_ALREADY_DISABLED                        = 0xC0000302,
    NT_STATUS_WMI_ALREADY_ENABLED                         = 0xC0000303,
    NT_STATUS_MFT_TOO_FRAGMENTED                          = 0xC0000304,
    NT_STATUS_COPY_PROTECTION_FAILURE                     = 0xC0000305,
    NT_STATUS_CSS_AUTHENTICATION_FAILURE                  = 0xC0000306,
    NT_STATUS_CSS_KEY_NOT_PRESENT                         = 0xC0000307,
    NT_STATUS_CSS_KEY_NOT_ESTABLISHED                     = 0xC0000308,
    NT_STATUS_CSS_SCRAMBLED_SECTOR                        = 0xC0000309,
    NT_STATUS_CSS_REGION_MISMATCH                         = 0xC000030A,
    NT_STATUS_CSS_RESETS_EXHAUSTED                        = 0xC000030B,
    NT_STATUS_PKINIT_FAILURE                              = 0xC0000320,
    NT_STATUS_SMARTCARD_SUBSYSTEM_FAILURE                 = 0xC0000321,
    NT_STATUS_NO_KERB_KEY                                 = 0xC0000322,
    NT_STATUS_HOST_DOWN                                   = 0xC0000350,
    NT_STATUS_UNSUPPORTED_PREAUTH                         = 0xC0000351,
    NT_STATUS_EFS_ALG_BLOB_TOO_BIG                        = 0xC0000352,
    NT_STATUS_PORT_NOT_SET                                = 0xC0000353,
    NT_STATUS_DEBUGGER_INACTIVE                           = 0xC0000354,
    NT_STATUS_DS_VERSION_CHECK_FAILURE                    = 0xC0000355,
    NT_STATUS_AUDITING_DISABLED                           = 0xC0000356,
    NT_STATUS_PRENT4_MACHINE_ACCOUNT                      = 0xC0000357,
    NT_STATUS_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER            = 0xC0000358,
    NT_STATUS_INVALID_IMAGE_WIN_32                        = 0xC0000359,
    NT_STATUS_INVALID_IMAGE_WIN_64                        = 0xC000035A,
    NT_STATUS_BAD_BINDINGS                                = 0xC000035B,
    NT_STATUS_NETWORK_SESSION_EXPIRED                     = 0xC000035C,
    NT_STATUS_APPHELP_BLOCK                               = 0xC000035D,
    NT_STATUS_ALL_SIDS_FILTERED                           = 0xC000035E,
    NT_STATUS_NOT_SAFE_MODE_DRIVER                        = 0xC000035F,
    NT_STATUS_ACCESS_DISABLED_BY_POLICY_DEFAULT           = 0xC0000361,
    NT_STATUS_ACCESS_DISABLED_BY_POLICY_PATH              = 0xC0000362,
    NT_STATUS_ACCESS_DISABLED_BY_POLICY_PUBLISHER         = 0xC0000363,
    NT_STATUS_ACCESS_DISABLED_BY_POLICY_OTHER             = 0xC0000364,
    NT_STATUS_FAILED_DRIVER_ENTRY                         = 0xC0000365,
    NT_STATUS_DEVICE_ENUMERATION_ERROR                    = 0xC0000366,
    NT_STATUS_WAIT_FOR_OPLOCK                             = 0x00000367,
    NT_STATUS_MOUNT_POINT_NOT_RESOLVED                    = 0xC0000368,
    NT_STATUS_INVALID_DEVICE_OBJECT_PARAMETER             = 0xC0000369,
    NT_STATUS_MCA_OCCURED                                 = 0xC000036A,
    NT_STATUS_DRIVER_BLOCKED_CRITICAL                     = 0xC000036B,
    NT_STATUS_DRIVER_BLOCKED                              = 0xC000036C,
    NT_STATUS_DRIVER_DATABASE_ERROR                       = 0xC000036D,
    NT_STATUS_SYSTEM_HIVE_TOO_LARGE                       = 0xC000036E,
    NT_STATUS_INVALID_IMPORT_OF_NON_DLL                   = 0xC000036F,
    NT_STATUS_DS_SHUTTING_DOWN                            = 0x40000370,
    NT_STATUS_SMARTCARD_WRONG_PIN                         = 0xC0000380,
    NT_STATUS_SMARTCARD_CARD_BLOCKED                      = 0xC0000381,
    NT_STATUS_SMARTCARD_CARD_NOT_AUTHENTICATED            = 0xC0000382,
    NT_STATUS_SMARTCARD_NO_CARD                           = 0xC0000383,
    NT_STATUS_SMARTCARD_NO_KEY_CONTAINER                  = 0xC0000384,
    NT_STATUS_SMARTCARD_NO_CERTIFICATE                    = 0xC0000385,
    NT_STATUS_SMARTCARD_NO_KEYSET                         = 0xC0000386,
    NT_STATUS_SMARTCARD_IO_ERROR                          = 0xC0000387,
    NT_STATUS_DOWNGRADE_DETECTED                          = 0xC0000388,
    NT_STATUS_SMARTCARD_CERT_REVOKED                      = 0xC0000389,
    NT_STATUS_ISSUING_CA_UNTRUSTED                        = 0xC000038A,
    NT_STATUS_REVOCATION_OFFLINE_C                        = 0xC000038B,
    NT_STATUS_PKINIT_CLIENT_FAILURE                       = 0xC000038C,
    NT_STATUS_SMARTCARD_CERT_EXPIRED                      = 0xC000038D,
    NT_STATUS_DRIVER_FAILED_PRIOR_UNLOAD                  = 0xC000038E,
    NT_STATUS_WOW_ASSERTION                               = 0xC0009898,
    RPC_NT_INVALID_STRING_BINDING                         = 0xC0020001,
    RPC_NT_WRONG_KIND_OF_BINDING                          = 0xC0020002,
    RPC_NT_INVALID_BINDING                                = 0xC0020003,
    RPC_NT_PROTSEQ_NOT_SUPPORTED                          = 0xC0020004,
    RPC_NT_INVALID_RPC_PROTSEQ                            = 0xC0020005,
    RPC_NT_INVALID_STRING_UUID                            = 0xC0020006,
    RPC_NT_INVALID_ENDPOINT_FORMAT                        = 0xC0020007,
    RPC_NT_INVALID_NET_ADDR                               = 0xC0020008,
    RPC_NT_NO_ENDPOINT_FOUND                              = 0xC0020009,
    RPC_NT_INVALID_TIMEOUT                                = 0xC002000A,
    RPC_NT_OBJECT_NOT_FOUND                               = 0xC002000B,
    RPC_NT_ALREADY_REGISTERED                             = 0xC002000C,
    RPC_NT_TYPE_ALREADY_REGISTERED                        = 0xC002000D,
    RPC_NT_ALREADY_LISTENING                              = 0xC002000E,
    RPC_NT_NO_PROTSEQS_REGISTERED                         = 0xC002000F,
    RPC_NT_NOT_LISTENING                                  = 0xC0020010,
    RPC_NT_UNKNOWN_MGR_TYPE                               = 0xC0020011,
    RPC_NT_UNKNOWN_IF                                     = 0xC0020012,
    RPC_NT_NO_BINDINGS                                    = 0xC0020013,
    RPC_NT_NO_PROTSEQS                                    = 0xC0020014,
    RPC_NT_CANT_CREATE_ENDPOINT                           = 0xC0020015,
    RPC_NT_OUT_OF_RESOURCES                               = 0xC0020016,
    RPC_NT_SERVER_UNAVAILABLE                             = 0xC0020017,
    RPC_NT_SERVER_TOO_BUSY                                = 0xC0020018,
    RPC_NT_INVALID_NETWORK_OPTIONS                        = 0xC0020019,
    RPC_NT_NO_CALL_ACTIVE                                 = 0xC002001A,
    RPC_NT_CALL_FAILED                                    = 0xC002001B,
    RPC_NT_CALL_FAILED_DNE                                = 0xC002001C,
    RPC_NT_PROTOCOL_ERROR                                 = 0xC002001D,
    RPC_NT_UNSUPPORTED_TRANS_SYN                          = 0xC002001F,
    RPC_NT_UNSUPPORTED_TYPE                               = 0xC0020021,
    RPC_NT_INVALID_TAG                                    = 0xC0020022,
    RPC_NT_INVALID_BOUND                                  = 0xC0020023,
    RPC_NT_NO_ENTRY_NAME                                  = 0xC0020024,
    RPC_NT_INVALID_NAME_SYNTAX                            = 0xC0020025,
    RPC_NT_UNSUPPORTED_NAME_SYNTAX                        = 0xC0020026,
    RPC_NT_UUID_NO_ADDRESS                                = 0xC0020028,
    RPC_NT_DUPLICATE_ENDPOINT                             = 0xC0020029,
    RPC_NT_UNKNOWN_AUTHN_TYPE                             = 0xC002002A,
    RPC_NT_MAX_CALLS_TOO_SMALL                            = 0xC002002B,
    RPC_NT_STRING_TOO_LONG                                = 0xC002002C,
    RPC_NT_PROTSEQ_NOT_FOUND                              = 0xC002002D,
    RPC_NT_PROCNUM_OUT_OF_RANGE                           = 0xC002002E,
    RPC_NT_BINDING_HAS_NO_AUTH                            = 0xC002002F,
    RPC_NT_UNKNOWN_AUTHN_SERVICE                          = 0xC0020030,
    RPC_NT_UNKNOWN_AUTHN_LEVEL                            = 0xC0020031,
    RPC_NT_INVALID_AUTH_IDENTITY                          = 0xC0020032,
    RPC_NT_UNKNOWN_AUTHZ_SERVICE                          = 0xC0020033,
    EPT_NT_INVALID_ENTRY                                  = 0xC0020034,
    EPT_NT_CANT_PERFORM_OP                                = 0xC0020035,
    EPT_NT_NOT_REGISTERED                                 = 0xC0020036,
    RPC_NT_NOTHING_TO_EXPORT                              = 0xC0020037,
    RPC_NT_INCOMPLETE_NAME                                = 0xC0020038,
    RPC_NT_INVALID_VERS_OPTION                            = 0xC0020039,
    RPC_NT_NO_MORE_MEMBERS                                = 0xC002003A,
    RPC_NT_NOT_ALL_OBJS_UNEXPORTED                        = 0xC002003B,
    RPC_NT_INTERFACE_NOT_FOUND                            = 0xC002003C,
    RPC_NT_ENTRY_ALREADY_EXISTS                           = 0xC002003D,
    RPC_NT_ENTRY_NOT_FOUND                                = 0xC002003E,
    RPC_NT_NAME_SERVICE_UNAVAILABLE                       = 0xC002003F,
    RPC_NT_INVALID_NAF_ID                                 = 0xC0020040,
    RPC_NT_CANNOT_SUPPORT                                 = 0xC0020041,
    RPC_NT_NO_CONTEXT_AVAILABLE                           = 0xC0020042,
    RPC_NT_INTERNAL_ERROR                                 = 0xC0020043,
    RPC_NT_ZERO_DIVIDE                                    = 0xC0020044,
    RPC_NT_ADDRESS_ERROR                                  = 0xC0020045,
    RPC_NT_FP_DIV_ZERO                                    = 0xC0020046,
    RPC_NT_FP_UNDERFLOW                                   = 0xC0020047,
    RPC_NT_FP_OVERFLOW                                    = 0xC0020048,
    RPC_NT_CALL_IN_PROGRESS                               = 0xC0020049,
    RPC_NT_NO_MORE_BINDINGS                               = 0xC002004A,
    RPC_NT_GROUP_MEMBER_NOT_FOUND                         = 0xC002004B,
    EPT_NT_CANT_CREATE                                    = 0xC002004C,
    RPC_NT_INVALID_OBJECT                                 = 0xC002004D,
    RPC_NT_NO_INTERFACES                                  = 0xC002004F,
    RPC_NT_CALL_CANCELLED                                 = 0xC0020050,
    RPC_NT_BINDING_INCOMPLETE                             = 0xC0020051,
    RPC_NT_COMM_FAILURE                                   = 0xC0020052,
    RPC_NT_UNSUPPORTED_AUTHN_LEVEL                        = 0xC0020053,
    RPC_NT_NO_PRINC_NAME                                  = 0xC0020054,
    RPC_NT_NOT_RPC_ERROR                                  = 0xC0020055,
    RPC_NT_UUID_LOCAL_ONLY                                = 0x40020056,
    RPC_NT_SEC_PKG_ERROR                                  = 0xC0020057,
    RPC_NT_NOT_CANCELLED                                  = 0xC0020058,
    RPC_NT_INVALID_ASYNC_HANDLE                           = 0xC0020062,
    RPC_NT_INVALID_ASYNC_CALL                             = 0xC0020063,
    RPC_NT_PROXY_ACCESS_DENIED                            = 0xC0020064,
    RPC_NT_SEND_INCOMPLETE                                = 0x400200AF,
    RPC_NT_NO_MORE_ENTRIES                                = 0xC0030001,
    RPC_NT_SS_CHAR_TRANS_OPEN_FAIL                        = 0xC0030002,
    RPC_NT_SS_CHAR_TRANS_SHORT_FILE                       = 0xC0030003,
    RPC_NT_SS_IN_NULL_CONTEXT                             = 0xC0030004,
    RPC_NT_SS_CONTEXT_MISMATCH                            = 0xC0030005,
    RPC_NT_SS_CONTEXT_DAMAGED                             = 0xC0030006,
    RPC_NT_SS_HANDLES_MISMATCH                            = 0xC0030007,
    RPC_NT_SS_CANNOT_GET_CALL_HANDLE                      = 0xC0030008,
    RPC_NT_NULL_REF_POINTER                               = 0xC0030009,
    RPC_NT_ENUM_VALUE_OUT_OF_RANGE                        = 0xC003000A,
    RPC_NT_BYTE_COUNT_TOO_SMALL                           = 0xC003000B,
    RPC_NT_BAD_STUB_DATA                                  = 0xC003000C,
    RPC_NT_INVALID_ES_ACTION                              = 0xC0030059,
    RPC_NT_WRONG_ES_VERSION                               = 0xC003005A,
    RPC_NT_WRONG_STUB_VERSION                             = 0xC003005B,
    RPC_NT_INVALID_PIPE_OBJECT                            = 0xC003005C,
    RPC_NT_INVALID_PIPE_OPERATION                         = 0xC003005D,
    RPC_NT_WRONG_PIPE_VERSION                             = 0xC003005E,
    RPC_NT_PIPE_CLOSED                                    = 0xC003005F,
    RPC_NT_PIPE_DISCIPLINE_ERROR                          = 0xC0030060,
    RPC_NT_PIPE_EMPTY                                     = 0xC0030061,
};

enum smb_trans2_subcommand {
    SMB_TRANS2_OPEN2                    = 0x0000,
    SMB_TRANS2_FIND_FIRST2              = 0x0001,
    SMB_TRANS2_FIND_NEXT2               = 0x0002,
    SMB_TRANS2_QUERY_FS_INFO            = 0x0003,
    SMB_TRANS2_SET_FS_INFORMATION       = 0x0004,
    SMB_TRANS2_QUERY_PATH_INFORMATION   = 0x0005,
    SMB_TRANS2_SET_PATH_INFORMATION     = 0x0006,
    SMB_TRANS2_QUERY_FILE_INFORMATION   = 0x0007,
    SMB_TRANS2_SET_FILE_INFORMATION     = 0x0008,
    SMB_TRANS2_FSCTL                    = 0x0009,
    SMB_TRANS2_IOCTL2                   = 0x000a,
    SMB_TRANS2_FIND_NOTIFY_FIRST        = 0x000b,
    SMB_TRANS2_FIND_NOTIFY_NEXT         = 0x000c,
    SMB_TRANS2_CREATE_DIRECTORY         = 0x000d,
    SMB_TRANS2_SESSION_SETUP            = 0x000e,
    SMB_TRANS2_GET_DFS_REFERRAL         = 0x0010,
    SMB_TRANS2_REPORT_DFS_INCONSISTENCY = 0x0011,
};

enum smb_transaction_subcommand {
    SMB_TRANS_CALL_NMPIPE                   = 0x0054,
    SMB_TRANS_PEEK_NMPIPE                   = 0x0023,
    SMB_TRANS_QUERY_NMPIPE_INFO             = 0x0022,
    SMB_TRANS_QUERY_NMPIPE_STATE            = 0x0021,
    SMB_TRANS_RAW_READ_NMPIPE               = 0x0011,
    SMB_TRANS_RAW_WRITE_NMPIPE              = 0x0031,
    SMB_TRANS_READ_NMPIPE                   = 0x0036,
    SMB_TRANS_SET_NMPIPE_STATE              = 0x0001,
    SMB_TRANS_TRANSACT_NMPIPE               = 0x0026,
    SMB_TRANS_WAIT_NMPIPE                   = 0x0053,
    SMB_TRANS_WRITE_NMPIPE                  = 0x0037,

    // !!! the following command uses the same code as SMB_TRANS_SET_NMPIPE_STATE
    // SMB_TRANS_MAILSLOT_WRITE                = 0x0001,
};

enum smb_nt_transact_subcommand {
    SMB_NT_TRANSACT_CREATE                  = 0x0001,
    SMB_NT_TRANSACT_IOCTL                   = 0x0002,
    SMB_NT_TRANSACT_SET_SECURITY_DESC       = 0x0003,
    SMB_NT_TRANSACT_NOTIFY_CHANGE           = 0x0004,
    SMB_NT_TRANSACT_RENAME                  = 0x0005,
    SMB_NT_TRANSACT_QUERY_SECURITY_DESC     = 0x0006,
};

enum smb_command {
    SMB_COM_CREATE_DIRECTORY        = 0x00,
    SMB_COM_DELETE_DIRECTORY,
    SMB_COM_OPEN,
    SMB_COM_CREATE,
    SMB_COM_CLOSE,
    SMB_COM_FLUSH,
    SMB_COM_DELETE,
    SMB_COM_RENAME,
    SMB_COM_QUERY_INFORMATION,
    SMB_COM_SET_INFORMATION,
    SMB_COM_READ,
    SMB_COM_WRITE,
    SMB_COM_LOCK_BYTE_RANGE,
    SMB_COM_UNLOCK_BYTE_RANGE,
    SMB_COM_CREATE_TEMPORARY,
    SMB_COM_CREATE_NEW,
    SMB_COM_CHECK_DIRECTORY,
    SMB_COM_PROCESS_EXIT,
    SMB_COM_SEEK,
    SMB_COM_LOCK_AND_READ,
    SMB_COM_WRITE_AND_UNLOCK,

    SMB_COM_READ_RAW                = 0x1a,
    SMB_COM_READ_MPX,
    SMB_COM_READ_MPX_SECONDARY,
    SMB_COM_WRITE_RAW,
    SMB_COM_WRITE_MPX,
    SMB_COM_WRITE_MPX_SECONDARY,
    SMB_COM_WRITE_COMPLETE,
    SMB_COM_QUERY_SERVER,
    SMB_COM_SET_INFORMATION2,
    SMB_COM_QUERY_INFORMATION2,
    SMB_COM_LOCKING_ANDX,
    SMB_COM_TRANSACTION,
    SMB_COM_TRANSACTION_SECONDARY,
    SMB_COM_IOCTL,
    SMB_COM_IOCTL_SECONDARY,
    SMB_COM_COPY,
    SMB_COM_MOVE,
    SMB_COM_ECHO,
    SMB_COM_WRITE_AND_CLOSE,
    SMB_COM_OPEN_ANDX,
    SMB_COM_READ_ANDX,
    SMB_COM_WRITE_ANDX,
    SMB_COM_NEW_FILE_SIZE,
    SMB_COM_CLOSE_AND_TREE_DISC,
    SMB_COM_TRANSACTION2,
    SMB_COM_TRANSACTION2_SECONDARY,
    SMB_COM_FIND_CLOSE2,
    SMB_COM_FIND_NOTIFY_CLOSE,

    SMB_COM_TREE_CONNECT            = 0x70,
    SMB_COM_TREE_DISCONNECT,
    SMB_COM_NEGOCIATE,
    SMB_COM_SESSION_SETUP_ANDX,
    SMB_COM_LOGOFF_ANDX,
    SMB_COM_TREE_CONNECT_ANDX       = 0x75,

    SMB_COM_SECURITY_PACKAGE_ANDX   = 0x7e,
    SMB_COM_QUERY_INFORMATION_DISK  = 0x80,
    SMB_COM_SEARCH,
    SMB_COM_FIND,
    SMB_COM_FIND_UNIQUE,
    SMB_COM_FIND_CLOSE              = 0x84,
    SMB_COM_NT_TRANSACT             = 0xa0,
    SMB_COM_NT_TRANSACT_SECONDARY,
    SMB_COM_NT_CREATE_ANDX,
    SMB_COM_NT_CANCEL               = 0xa4,
    SMB_COM_NT_RENAME,
    SMB_COM_OPEN_PRINT_FILE         = 0xc0,
    SMB_COM_WRITE_PRINT_FILE,
    SMB_COM_CLOSE_PRINT_FILE,
    SMB_COM_GET_PRINT_FILE,
    SMB_COM_READ_BULK               = 0xd8,
    SMB_COM_WRITE_BULK,
    SMB_COM_WRITE_BULK_DATA,
    SMB_COM_INVALID                 = 0xfe,
    SMB_COM_NO_ANDX_COMMAND
};

enum smb2_command {
    SMB2_COM_NEGOTIATE,
    SMB2_COM_SESSION_SETUP,
    SMB2_COM_LOGOFF,
    SMB2_COM_TREE_CONNECT,
    SMB2_COM_TREE_DISCONNECT,
    SMB2_COM_CREATE,
    SMB2_COM_CLOSE,
    SMB2_COM_FLUSH,
    SMB2_COM_READ,
    SMB2_COM_WRITE,
    SMB2_COM_LOCK,
    SMB2_COM_IOCTL,
    SMB2_COM_CANCEL,
    SMB2_COM_ECHO,
    SMB2_COM_QUERY_DIRECTORY,
    SMB2_COM_CHANGE_NOTIFY,
    SMB2_COM_QUERY_INFO,
    SMB2_COM_SET_INFO,
    SMB2_COM_OPLOCK_BREAK,
};

enum smb_file_info_levels {
    // Information levels for Trans2 QUERY_FILE_INFO
    SMB_INFO_STANDARD               = 0x0001,
    SMB_INFO_QUERY_EA_SIZE          = 0x0002,
    SMB_INFO_QUERY_EA_FROM_LIST     = 0x003,
    SMB_INFO_QUERY_ALL_EAS          = 0x0004,
    SMB_INFO_NAME_VALID             = 0x0006,
    SMB_QUERY_FILE_BASIC_INFO       = 0x0101,
    SMB_QUERY_FILE_STANDARD_INFO    = 0x0102,
    SMB_QUERY_FILE_EA_INFO          = 0x0103,
    SMB_QUERY_FILE_NAME_INFO        = 0x0104,
    SMB_QUERY_FILE_ALL_INFO         = 0x0107,
    SMB_QUERY_FILE_ALT_NAME_INFO    = 0x0108,
    SMB_QUERY_FILE_STREAM_INFO      = 0x0109,
    SMB_QUERY_FILE_COMPRESSION_INFO = 0x010b,

    QUERY_FILE_UNIX_BASIC     = 0x0200,
    QUERY_FILE_UNIX_LINK      = 0x0201,
    QUERY_POSIX_ACL           = 0x0204,
    QUERY_XATTR               = 0x0205,
    QUERY_ATTR_FLAGS          = 0x0206,
    QUERY_POSIX_PERMISSION    = 0x0207,
    QUERY_POSIX_LOCK          = 0x0208,
    SMB_POSIX_PATH_OPEN       = 0x0209,
    SMB_POSIX_PATH_UNLINK     = 0x020a,
    SMB_QUERY_FILE_UNIX_INFO2 = 0x020b,
};

#define PASS_THROUGH_LEVEL_OF_INTEREST 0x03e8
// classes for passthrough information level
enum smb_file_information_classes {
    FILE_DIRECTORY_INFORMATION              = 0x01,
    FILE_FULL_DIRECTORY_INFORMATION         = 0x02,
    FILE_BOTH_DIRECTORY_INFORMATION         = 0x03,
    FILE_BASIC_INFORMATION                  = 0x04,
    FILE_STANDARD_INFORMATION               = 0x05,
    FILE_INTERNAL_INFORMATION               = 0x06,
    FILE_EA_INFORMATION                     = 0x07,
    FILE_ACCESS_INFORMATION                 = 0x08,
    FILE_NAME_INFORMATION                   = 0x09,
    FILE_RENAME_INFORMATION                 = 0x0a,
    FILE_LINK_INFORMATION                   = 0x0b,
    FILE_NAMES_INFORMATION                  = 0x0c,
    FILE_DISPOSITION_INFORMATION            = 0x0d,
    FILE_POSITION_INFORMATION               = 0x0e,
    FILE_FULL_EA_INFORMATION                = 0x0f,
    FILE_MODE_INFORMATION                   = 0x10,
    FILE_ALIGNMENT_INFORMATION              = 0x11,
    FILE_ALL_INFORMATION                    = 0x12,
    FILE_ALLOCATION_INFORMATION             = 0x13,
    FILE_END_OF_FILE_INFORMATION            = 0x14,
    FILE_ALTERNATE_NAME_INFORMATION         = 0x15,
    FILE_STREAM_INFORMATION                 = 0x16,
    FILE_PIPE_INFORMATION                   = 0x17,
    FILE_PIPE_LOCAL_INFORMATION             = 0x18,
    FILE_PIPE_REMOTE_INFORMATION            = 0x19,
    FILE_MAILSLOT_QUERY_INFORMATION         = 0x1a,
    FILE_MAILSLOT_SET_INFORMATION           = 0x1b,
    FILE_COMPRESSION_INFORMATION            = 0x1c,
    FILE_OBJECT_ID_INFORMATION              = 0x1d,
    FILE_MOVE_CLUSTER_INFORMATION           = 0x1f,
    FILE_QUOTA_INFORMATION                  = 0x20,
    FILE_REPARSE_POINT_INFORMATION          = 0x21,
    FILE_NETWORK_OPEN_INFORMATION           = 0x22,
    FILE_ATTRIBUTE_TAG_INFORMATION          = 0x23,
    FILE_TRACKING_INFORMATION               = 0x24,
    FILE_ID_BOTH_DIRECTORY_INFORMATION      = 0x25,
    FILE_ID_FULL_DIRECTORY_INFORMATION      = 0x26,
    FILE_VALID_DATA_LENGTH_INFORMATION      = 0x27,
    FILE_SHORT_NAME_INFORMATION             = 0x28,
    FILE_SFIO_RESERVE_INFORMATION           = 0x2c,
    FILE_SFIO_VOLUME_INFORMATION            = 0x2d,
    FILE_HARD_LINK_INFORMATION              = 0x2e,
    FILE_NORMALIZED_NAME_INFORMATION        = 0x30,
    FILE_ID_GLOBAL_TX_DIRECTORY_INFORMATION = 0x32,
    FILE_STANDARD_LINK_INFORMATION          = 0x36,
};

enum ctl_code {
    // IOCTL/FSCTL Codes
    FSCTL_GET_REPARSE_POINT            = 0x000900a8,
    FSCTL_CREATE_OR_GET_OBJECT_ID      = 0x000900c0,

    // SMB2 specific IOCTL/FSCTL Codes
    FSCTL_DFS_GET_REFERRALS            = 0x00060194,
    FSCTL_PIPE_PEEK                    = 0x0011400C,
    FSCTL_PIPE_WAIT                    = 0x00110018,
    FSCTL_PIPE_TRANSCEIVE              = 0x0011C017,
    FSCTL_SRV_COPYCHUNK                = 0x001440F2,
    FSCTL_SRV_ENUMERATE_SNAPSHOTS      = 0x00144064,
    FSCTL_SRV_REQUEST_RESUME_KEY       = 0x00140078,
    FSCTL_SRV_READ_HASH                = 0x001441bb,
    FSCTL_SRV_COPYCHUNK_WRITE          = 0x001480F2,
    FSCTL_LMR_REQUEST_RESILIENCY       = 0x001401D4,
    FSCTL_QUERY_NETWORK_INTERFACE_INFO = 0x001401FC,
    FSCTL_SET_REPARSE_POINT            = 0x000900A4,
    FSCTL_DFS_GET_REFERRALS_EX         = 0x000601B0,
    FSCTL_FILE_LEVEL_TRIM              = 0x00098208,
    FSCTL_VALIDATE_NEGOTIATE_INFO      = 0x00140204,
};

enum smb_version {
    SMB_VERSION_1 = 0x1,
    SMB_VERSION_2 = 0x2,
    SMB_VERSION_3 = 0x3,
};

#define CIFS_DOMAIN_SIZE 256
#define CIFS_USER_SIZE 256
#define CIFS_PATH_SIZE 512
#define CIFS_TREE_SIZE 256
#define CIFS_HOSTNAME_SIZE 128
#define CIFS_DRIVER_SIZE 128
#define CIFS_OS_SIZE 128

struct cifs_proto_info {
    struct proto_info info;
    enum smb_version version;
    union {
        enum smb_command smb_command;
        enum smb2_command smb2_command;
    } command;
    enum smb_status status;
#define         CIFS_DOMAIN                            0x0001
#define         CIFS_USER                              0x0002
#define         CIFS_PATH                              0x0004
#define         CIFS_TRANS2_SUBCMD                     0x0008
#define         CIFS_FID                               0x0010
#define         CIFS_LEVEL_OF_INTEREST                 0x0020
#define         CIFS_TRANSACTION_SUBCMD                0x0040
#define         CIFS_NT_TRANSACT_SUBCMD                0x0080
#define         CIFS_TREE                              0x0100
#define         CIFS_OS                                0x0200
#define         CIFS_HOSTNAME                          0x0400
#define         CIFS_DRIVER                            0x0800
#define         CIFS_SERVER_OS                         0x1000
#define         CIFS_SERVER_HOSTNAME                   0x2000
#define         CIFS_SERVER_DRIVER                     0x4000
    unsigned set_values;
    union {
        char path[CIFS_PATH_SIZE];
        struct connection {
            char user[CIFS_USER_SIZE];
            char domain[CIFS_DOMAIN_SIZE];
            char os[CIFS_OS_SIZE];
            char hostname[CIFS_HOSTNAME_SIZE];
            char driver[CIFS_DRIVER_SIZE];
        } connection;
    } u;

    union smb_subcommand {
        enum smb_trans2_subcommand trans2_subcmd;
        enum smb_nt_transact_subcommand nt_transact_subcmd;
        enum smb_transaction_subcommand transaction_subcmd;
    } subcommand;

    enum smb_file_info_levels level_of_interest;
    uint64_t fid;
    uint32_t tree_id;

    union {
        uint16_t multiplex_id;    // SMB1
        uint64_t message_id; // SMB2
    } ids;

    unsigned query_write_bytes;
    unsigned response_read_bytes;
    unsigned response_write_bytes;
    unsigned meta_read_bytes;
    unsigned meta_write_bytes;

    union {
#define         CIFS_FILE_CREATE                         0x0001
#define         CIFS_FILE_DIRECTORY                      0x0002
#define         CIFS_FILE_UNLINK                         0x0004
        unsigned flag_file;
        uint8_t lock_type;
    } parameters;

    bool is_query;
    struct timeval first_packet_tv;
};

void cifs_init(void);
void cifs_fini(void);

static inline void cifs_set_fid(struct cifs_proto_info *info, uint64_t fid)
{
    info->fid = fid;
    SLOG(LOG_DEBUG, "Set fid to 0x%"PRIx64, info->fid);
    info->set_values |= CIFS_FID;
}
bool cifs_has_flag_file(struct cifs_proto_info const *info);

#endif
