/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.interaction;

import com.jsql.model.bean.util.Header;
import com.jsql.model.bean.util.HttpHeader;
import com.jsql.model.injection.strategy.blind.callable.AbstractCallableBit;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.interaction.InteractionCommand;
import com.jsql.view.swing.panel.consoles.NetworkTable;
import com.jsql.view.swing.util.MediatorHelper;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessageHeader
implements InteractionCommand {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final String url;
    private final String post;
    private final Map<String, String> header;
    private final Map<String, String> response;
    private final String source;
    private final String size;
    private final String metadataProcess;
    private final String metadataStrategy;
    private final AbstractCallableBit<?> metadataBoolean;

    public MessageHeader(Object[] interactionParams) {
        Map params = (Map)interactionParams[0];
        this.url = params.getOrDefault((Object)Header.URL, "");
        this.post = params.getOrDefault((Object)Header.POST, "");
        this.header = params.getOrDefault((Object)Header.HEADER, Collections.emptyMap());
        this.response = params.getOrDefault((Object)Header.RESPONSE, Collections.emptyMap());
        this.source = params.getOrDefault((Object)Header.SOURCE, "");
        this.size = params.getOrDefault((Object)Header.PAGE_SIZE, "");
        this.metadataProcess = params.getOrDefault((Object)Header.METADATA_PROCESS, "");
        this.metadataStrategy = params.getOrDefault((Object)Header.METADATA_STRATEGY, "");
        this.metadataBoolean = params.getOrDefault((Object)Header.METADATA_BOOLEAN, null);
    }

    @Override
    public void execute() {
        NetworkTable table = MediatorHelper.panelConsoles().getNetworkTable();
        table.addHeader(new HttpHeader(this.url, this.post, this.header, this.response, this.source));
        DefaultTableModel model = (DefaultTableModel)table.getModel();
        try {
            model.addRow(new Object[]{this.url, this.size, this.metadataStrategy, Arrays.asList(this.metadataProcess, this.metadataBoolean)});
            Rectangle rect = table.getCellRect(table.getRowCount() - 1, 0, true);
            table.scrollRectToVisible(rect);
            MediatorHelper.tabConsoles().setBold("Network");
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            LOGGER.log(LogLevelUtil.CONSOLE_JAVA, e, (Throwable)e);
        }
    }
}

