/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing;

import com.jsql.model.InjectionModel;
import com.jsql.util.GitUtil;
import com.jsql.util.I18nUtil;
import com.jsql.util.LogLevelUtil;
import com.jsql.view.interaction.SubscriberInteraction;
import com.jsql.view.swing.action.HotkeyUtil;
import com.jsql.view.swing.menubar.AppMenubar;
import com.jsql.view.swing.panel.PanelAddressBar;
import com.jsql.view.swing.panel.split.SplitNS;
import com.jsql.view.swing.tab.TabManagers;
import com.jsql.view.swing.terminal.AbstractExploit;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JFrameView
extends JFrame {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final Map<UUID, AbstractExploit> mapUuidShell = new HashMap<UUID, AbstractExploit>();
    private final transient SubscriberInteraction subscriber = new SubscriberInteraction("com.jsql.view.swing.interaction");
    private TabManagers tabManagers;
    private boolean isMaximized = false;
    private final InjectionModel injectionModel;
    private SplitNS splitNS;

    public JFrameView(InjectionModel injectionModel) {
        super("jSQL Injection");
        this.injectionModel = injectionModel;
        MediatorHelper.register(this);
        UiUtil.prepareGUI();
        this.initPaneComponents();
        this.initWindow();
        this.initShortcuts();
        this.displayVersion();
        I18nUtil.checkCurrentLanguage();
        this.check4K();
        SwingUtilities.invokeLater(() -> {
            AppMenubar.applyTheme(injectionModel.getMediatorUtils().getPreferencesUtil().getThemeFlatLafName());
            if (injectionModel.getMediatorUtils().getProxyUtil().isNotLive(GitUtil.ShowOnConsole.YES)) {
                return;
            }
            if (injectionModel.getMediatorUtils().getPreferencesUtil().isCheckingUpdate()) {
                injectionModel.getMediatorUtils().getGitUtil().checkUpdate(GitUtil.ShowOnConsole.NO);
            }
            injectionModel.getMediatorUtils().getGitUtil().showNews();
            this.setVisible(true);
            MediatorHelper.panelAddressBar().getTextFieldAddress().requestFocusInWindow();
        });
    }

    private void initPaneComponents() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        this.tabManagers = new TabManagers();
        this.add(this.tabManagers);
        AppMenubar menubar = new AppMenubar();
        this.setJMenuBar(menubar);
        MediatorHelper.register(menubar);
        PanelAddressBar panelAddressBar = new PanelAddressBar();
        MediatorHelper.register(panelAddressBar);
        this.add(panelAddressBar);
        JPanel mainPanel = new JPanel(new BorderLayout());
        this.splitNS = new SplitNS();
        mainPanel.add(this.splitNS);
        this.add(mainPanel);
        menubar.getMenuWindows().switchLocaleFromPreferences();
    }

    private void initWindow() {
        this.setIconImages(UiUtil.getIcons());
        final Preferences preferences = Preferences.userRoot().node(InjectionModel.class.getName());
        this.addWindowStateListener(e -> {
            this.isMaximized = (e.getNewState() & 6) == 6;
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent event) {
                double horizontalTopBottomSplitter;
                if (preferences.getBoolean("is_maximized", false)) {
                    JFrameView.this.setExtendedState(6);
                }
                if (!(0.0 <= (horizontalTopBottomSplitter = preferences.getDouble("horizontalSplitter", 0.75))) || !(horizontalTopBottomSplitter <= 1.0)) {
                    horizontalTopBottomSplitter = 0.75;
                }
                JFrameView.this.splitNS.setDividerLocation(horizontalTopBottomSplitter);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                preferences.putBoolean("is_maximized", JFrameView.this.isMaximized);
                preferences.putInt("verticalSplitter", JFrameView.this.splitNS.getSplitEW().getDividerLocation());
                BigDecimal percentTopBottom = BigDecimal.valueOf((double)JFrameView.this.splitNS.getDividerLocation() * 100.0 / (double)JFrameView.this.splitNS.getHeight() / 100.0);
                percentTopBottom = percentTopBottom.setScale(2, RoundingMode.HALF_UP);
                preferences.putDouble("horizontalSplitter", percentTopBottom.doubleValue() - 0.01);
                preferences.putBoolean("binary_visible", false);
                preferences.putBoolean("chunk_visible", false);
                preferences.putBoolean("header_visible", false);
                preferences.putBoolean("java_visible", false);
                for (int i = 0; i < MediatorHelper.tabConsoles().getTabCount(); ++i) {
                    if ("CONSOLE_BINARY_LABEL".equals(MediatorHelper.tabConsoles().getTabComponentAt(i).getName())) {
                        preferences.putBoolean("binary_visible", true);
                        continue;
                    }
                    if ("CONSOLE_CHUNK_LABEL".equals(MediatorHelper.tabConsoles().getTabComponentAt(i).getName())) {
                        preferences.putBoolean("chunk_visible", true);
                        continue;
                    }
                    if ("CONSOLE_NETWORK_LABEL".equals(MediatorHelper.tabConsoles().getTabComponentAt(i).getName())) {
                        preferences.putBoolean("header_visible", true);
                        continue;
                    }
                    if (!"CONSOLE_JAVA_LABEL".equals(MediatorHelper.tabConsoles().getTabComponentAt(i).getName())) continue;
                    preferences.putBoolean("java_visible", true);
                }
            }
        });
        this.setSize(1024, 768);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
    }

    private void initShortcuts() {
        HotkeyUtil.addShortcut(this.getRootPane(), MediatorHelper.tabResults());
        HotkeyUtil.addTextFieldShortcutSelectAll();
    }

    public void resetInterface() {
        this.mapUuidShell.clear();
        MediatorHelper.panelAddressBar().getPanelTrailingAddress().reset();
        MediatorHelper.panelConsoles().reset();
        MediatorHelper.treeDatabase().reset();
        for (int i = 0; i < MediatorHelper.tabConsoles().getTabCount(); ++i) {
            Component tabComponent = MediatorHelper.tabConsoles().getTabComponentAt(i);
            if (tabComponent == null) continue;
            tabComponent.setFont(tabComponent.getFont().deriveFont(0));
        }
        Stream.of(MediatorHelper.managerFile(), MediatorHelper.managerExploit()).forEach(managerList -> {
            managerList.setButtonEnable(false);
            managerList.changePrivilegeIcon(UiUtil.SQUARE.getIcon());
        });
    }

    private void displayVersion() {
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "{} v{} on Java {}-{}-{}", () -> "jSQL Injection", () -> this.injectionModel.getPropertiesUtil().getVersionJsql(), () -> SystemUtils.JAVA_VERSION, () -> SystemUtils.OS_ARCH, () -> SystemUtils.USER_LANGUAGE);
    }

    private void check4K() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (int)screenSize.getWidth();
        if (width >= 3840 && !this.injectionModel.getMediatorUtils().getPreferencesUtil().is4K()) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Screen compatible with resolution 4K, enable high-definition in Preferences");
        }
    }

    public final Map<UUID, AbstractExploit> getMapUuidShell() {
        return this.mapUuidShell;
    }

    public SubscriberInteraction getSubscriber() {
        return this.subscriber;
    }

    public SplitNS getSplitNS() {
        return this.splitNS;
    }

    public TabManagers getTabManagers() {
        return this.tabManagers;
    }
}

