/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.util;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Header;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.JSqlException;
import com.jsql.util.ConnectionUtil;
import com.jsql.util.LogLevelUtil;
import java.io.IOException;
import java.net.HttpCookie;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.AbstractMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HeaderUtil {
    private static final Logger LOGGER = LogManager.getRootLogger();
    public static final String CONTENT_TYPE_REQUEST = "Content-Type";
    public static final String WWW_AUTHENTICATE_RESPONSE = "www-authenticate";
    private static final String REGEX_HTTP_STATUS = "4\\d\\d";
    private static final String FOUND_STATUS_HTTP = "Found status HTTP";
    private final InjectionModel injectionModel;

    public HeaderUtil(InjectionModel injectionModel) {
        this.injectionModel = injectionModel;
    }

    public static void sanitizeHeaders(HttpRequest.Builder httpRequest, AbstractMap.SimpleEntry<String, String> header) throws JSqlException {
        String keyHeader = header.getKey().trim();
        String valueHeader = header.getValue().trim();
        if ("cookie".equalsIgnoreCase(keyHeader) && Pattern.compile(".+=.*").matcher(valueHeader).find()) {
            List cookies = Stream.of(valueHeader.split(";")).filter(value -> value != null && value.contains("=")).map(cookie -> cookie.split("=", 2)).map(arrayEntry -> arrayEntry[0].trim() + "=" + (arrayEntry[1] == null ? "" : URLEncoder.encode(arrayEntry[1].trim().replace("+", "%2B"), StandardCharsets.UTF_8))).collect(Collectors.toList());
            valueHeader = String.join((CharSequence)"; ", cookies);
        }
        try {
            httpRequest.setHeader(keyHeader, valueHeader.replaceAll("[^\\p{ASCII}]", ""));
        }
        catch (IllegalArgumentException e) {
            throw new JSqlException(e);
        }
    }

    public HttpResponse<String> checkResponseHeader(HttpRequest.Builder httpRequestBuilder, String body) throws IOException, InterruptedException {
        HttpRequest httpRequest = httpRequestBuilder.build();
        HttpResponse<String> httpResponse = this.injectionModel.getMediatorUtils().getConnectionUtil().getHttpClient().build().send(httpRequest, HttpResponse.BodyHandlers.ofString());
        String pageSource = httpResponse.body();
        List<HttpCookie> cookies = this.injectionModel.getMediatorUtils().getConnectionUtil().getCookieManager().getCookieStore().getCookies();
        if (!cookies.isEmpty()) {
            LOGGER.info("Cookies set by host: {}", (Object)cookies);
        }
        String responseCode = Integer.toString(httpResponse.statusCode());
        Map<String, String> mapResponseHeaders = ConnectionUtil.getHeadersMap(httpResponse);
        this.checkResponse(responseCode, mapResponseHeaders);
        this.checkStatus(httpResponse);
        this.injectionModel.getMediatorUtils().getFormUtil().parseForms(httpResponse.statusCode(), pageSource);
        this.injectionModel.getMediatorUtils().getCsrfUtil().parseForCsrfToken(pageSource, mapResponseHeaders);
        this.injectionModel.getMediatorUtils().getDigestUtil().parseWwwAuthenticate(mapResponseHeaders);
        EnumMap<Header, Object> msgHeader = new EnumMap<Header, Object>(Header.class);
        int sizeHeaders = mapResponseHeaders.keySet().stream().map(key -> ((String)mapResponseHeaders.get(key)).length() + key.length()).mapToInt(Integer::intValue).sum();
        float size = (float)(pageSource.length() + sizeHeaders) / 1024.0f;
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        msgHeader.put(Header.PAGE_SIZE, decimalFormat.format(size));
        msgHeader.put(Header.URL, httpRequest.uri().toURL().toString());
        msgHeader.put(Header.POST, body);
        msgHeader.put(Header.HEADER, ConnectionUtil.getHeadersMap(httpRequest.headers()));
        msgHeader.put(Header.RESPONSE, mapResponseHeaders);
        msgHeader.put(Header.SOURCE, pageSource);
        msgHeader.put(Header.METADATA_STRATEGY, "#none");
        msgHeader.put(Header.METADATA_PROCESS, "test#conn");
        Request request = new Request();
        request.setMessage(Interaction.MESSAGE_HEADER);
        request.setParameters(msgHeader);
        this.injectionModel.sendToViews(request);
        return httpResponse;
    }

    private void checkStatus(HttpResponse<String> response) {
        if (response.statusCode() >= 400) {
            if (this.injectionModel.getMediatorUtils().getPreferencesUtil().isNotTestingConnection()) {
                LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Connection test disabled, skipping error {}...", (Object)response.statusCode());
            } else {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Try with option 'Disable connection test' to skip HTTP error {}", (Object)response.statusCode());
            }
        }
    }

    private void checkResponse(String responseCode, Map<String, String> mapResponse) {
        if (this.isBasicAuth(responseCode, mapResponse)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Basic Authentication detected: set authentication in preferences, or add header 'Authorization: Basic b3N..3Jk', with b3N..3Jk as 'osUserName:osPassword' encoded in Base64 (use the Coder in jSQL to encode the string).");
        } else if (this.isNtlm(responseCode, mapResponse)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "NTLM Authentication detected: set authentication in preferences, or add username, password and domain information to the URL, e.g. http://domain\\user:password@127.0.0.1/[..]");
        } else if (this.isDigest(responseCode, mapResponse)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Digest Authentication detected: set authentication in preferences.");
        } else if (this.isNegotiate(responseCode, mapResponse)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "Negotiate Authentication detected: add username, password and domain information to the URL, e.g. http://domain\\user:password@127.0.0.1/[..]");
        } else if (Pattern.matches("1\\d\\d", responseCode)) {
            LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "{} {} Informational", (Object)FOUND_STATUS_HTTP, (Object)responseCode);
        } else if (Pattern.matches("2\\d\\d", responseCode)) {
            LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "{} {} Success", (Object)FOUND_STATUS_HTTP, (Object)responseCode);
        } else if (Pattern.matches("3\\d\\d", responseCode)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "{} {} Redirection", (Object)FOUND_STATUS_HTTP, (Object)responseCode);
            if (!this.injectionModel.getMediatorUtils().getPreferencesUtil().isFollowingRedirection()) {
                LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "If injection fails retry with option 'Follow HTTP redirection' activated");
            } else {
                LOGGER.log(LogLevelUtil.CONSOLE_INFORM, "Redirecting to the next page...");
            }
        } else if (Pattern.matches(REGEX_HTTP_STATUS, responseCode)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "{} {} Client Error", (Object)FOUND_STATUS_HTTP, (Object)responseCode);
        } else if (Pattern.matches("5\\d\\d", responseCode)) {
            LOGGER.log(LogLevelUtil.CONSOLE_ERROR, "{} {} Server Error", (Object)FOUND_STATUS_HTTP, (Object)responseCode);
        } else {
            LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "{} {} Unknown", (Object)FOUND_STATUS_HTTP, (Object)responseCode);
        }
    }

    private boolean isNegotiate(String responseCode, Map<String, String> mapResponse) {
        return Pattern.matches(REGEX_HTTP_STATUS, responseCode) && mapResponse.containsKey(WWW_AUTHENTICATE_RESPONSE) && "Negotiate".equals(mapResponse.get(WWW_AUTHENTICATE_RESPONSE));
    }

    private boolean isDigest(String responseCode, Map<String, String> mapResponse) {
        return Pattern.matches(REGEX_HTTP_STATUS, responseCode) && mapResponse.containsKey(WWW_AUTHENTICATE_RESPONSE) && mapResponse.get(WWW_AUTHENTICATE_RESPONSE) != null && mapResponse.get(WWW_AUTHENTICATE_RESPONSE).startsWith("Digest ");
    }

    private boolean isNtlm(String responseCode, Map<String, String> mapResponse) {
        return Pattern.matches(REGEX_HTTP_STATUS, responseCode) && mapResponse.containsKey(WWW_AUTHENTICATE_RESPONSE) && "NTLM".equals(mapResponse.get(WWW_AUTHENTICATE_RESPONSE));
    }

    private boolean isBasicAuth(String responseCode, Map<String, String> mapResponse) {
        return Pattern.matches(REGEX_HTTP_STATUS, responseCode) && mapResponse.containsKey(WWW_AUTHENTICATE_RESPONSE) && mapResponse.get(WWW_AUTHENTICATE_RESPONSE) != null && mapResponse.get(WWW_AUTHENTICATE_RESPONSE).startsWith("Basic ");
    }
}

