/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.graphs.graphviz.graph.operations.codestructure;

import com.jpexs.graphs.codestructure.BasicEditableNode;
import com.jpexs.graphs.codestructure.nodes.EditableNode;
import com.jpexs.graphs.codestructure.nodes.JoinedNode;
import com.jpexs.graphs.codestructure.nodes.Node;
import com.jpexs.graphs.codestructure.nodes.PrefixedNode;
import com.jpexs.graphs.graphviz.dot.parser.DotId;
import com.jpexs.graphs.graphviz.dot.parser.DotParseException;
import com.jpexs.graphs.graphviz.dot.parser.DotParser;
import com.jpexs.graphs.graphviz.graph.AttributesMap;
import com.jpexs.graphs.graphviz.graph.Edge;
import com.jpexs.graphs.graphviz.graph.Graph;
import com.jpexs.graphs.graphviz.graph.GraphBase;
import com.jpexs.graphs.graphviz.graph.NodeId;
import com.jpexs.graphs.graphviz.graph.NodeIdToAttributes;
import com.jpexs.graphs.graphviz.graph.SubGraph;
import com.jpexs.graphs.graphviz.graph.operations.codestructure.DecomposedGraph;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StructuredGraphFacade {
    public static final String IGNORE_ATTRIBUTE = "_ignore";
    public static final String IGNORE_ATTRIBUTES_ATTRIBUTE = "_ignoreattrib";

    public String recompose(String text) {
        Graph g = this.graphFromString(text);
        List<DecomposedGraph> graphs = this.decomposeGraph(g);
        String ret = this.graphToString(this.composeGraph(graphs));
        return ret;
    }

    public Graph graphFromString(String text) {
        try {
            DotParser parser = new DotParser();
            Graph ret = parser.parse(new StringReader(text));
            return ret;
        }
        catch (IOException ex) {
            return null;
        }
        catch (DotParseException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void populateEdges(EditableNode currentNode, Set<EditableNode> visited, Set<com.jpexs.graphs.codestructure.Edge<EditableNode>> orderedEdges) {
        if (visited.contains(currentNode)) {
            return;
        }
        visited.add(currentNode);
        for (EditableNode editableNode : currentNode.getNext()) {
            com.jpexs.graphs.codestructure.Edge<EditableNode> e = new com.jpexs.graphs.codestructure.Edge<EditableNode>(currentNode, editableNode);
            orderedEdges.add(e);
            this.populateEdges(editableNode, visited, orderedEdges);
        }
    }

    private DotId nodeToDotId(Node n) {
        try {
            if (n instanceof JoinedNode) {
                JoinedNode jn = (JoinedNode)n;
                ArrayList<DotId> snIds = new ArrayList<DotId>();
                for (Node sn : jn.getAllSubNodes()) {
                    snIds.add(this.nodeToDotId(sn));
                }
                return DotId.join(new DotId(jn.getIdDelimiter(), false), snIds);
            }
            if (n instanceof PrefixedNode) {
                PrefixedNode pn = (PrefixedNode)n;
                DotId prefix = new DotId(pn.getIdPrefix(), false);
                DotId original = this.nodeToDotId(pn.getOriginalNode());
                return DotId.join((CharSequence)"", prefix, original);
            }
            return DotId.fromString(n.getId());
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public Graph composeGraph(List<DecomposedGraph> gs) {
        DecomposedGraph mainGraph = gs.get(0);
        Graph ret = (Graph)this.composeOneGraph(false, mainGraph.getId(), mainGraph.graphAttributes, mainGraph.getNodes(), mainGraph.getNodeAttributesMap(), mainGraph.getEdgeAttributesMap(), mainGraph.getEdgeCompassesMap());
        for (int i = 1; i < gs.size(); ++i) {
            DecomposedGraph g = gs.get(i);
            SubGraph nextGraph = (SubGraph)this.composeOneGraph(true, g.getId(), g.graphAttributes, g.getNodes(), g.getNodeAttributesMap(), g.getEdgeAttributesMap(), g.getEdgeCompassesMap());
            ret.subgraphs.add(nextGraph);
        }
        return ret;
    }

    public GraphBase composeOneGraph(boolean isSubgraph, DotId id, AttributesMap graphAttributes, Set<EditableNode> nodes, Map<Node, AttributesMap> nodeAttributesMap, Map<com.jpexs.graphs.codestructure.Edge<EditableNode>, AttributesMap> edgeAttributesMap, Map<com.jpexs.graphs.codestructure.Edge<EditableNode>, String> edgeCompassesMap) {
        GraphBase ret = isSubgraph ? new SubGraph(true) : new Graph(false, true);
        ret.id = id;
        ret.graphAttributes = graphAttributes;
        Set<EditableNode> orderedNodes = nodes;
        LinkedHashSet<com.jpexs.graphs.codestructure.Edge<EditableNode>> orderedEdges = new LinkedHashSet<com.jpexs.graphs.codestructure.Edge<EditableNode>>();
        EditableNode startNode = orderedNodes.isEmpty() ? null : orderedNodes.iterator().next();
        LinkedHashSet<EditableNode> orderedNodes2 = new LinkedHashSet<EditableNode>();
        if (startNode != null) {
            this.populateEdges(startNode, orderedNodes2, orderedEdges);
        }
        ArrayList<NodeIdToAttributes> standaloneNodes = new ArrayList<NodeIdToAttributes>();
        LinkedHashSet<Node> processedNodes = new LinkedHashSet<Node>();
        for (Node node : orderedNodes2) {
            NodeId nodeId = new NodeId(this.nodeToDotId(node));
            if (!nodeAttributesMap.containsKey(node)) continue;
            AttributesMap attributesToSet = nodeAttributesMap.get(node);
            standaloneNodes.add(new NodeIdToAttributes(nodeId, attributesToSet.clone()));
            processedNodes.add(node);
        }
        ret.nodes = standaloneNodes;
        for (com.jpexs.graphs.codestructure.Edge edge : orderedEdges) {
            NodeId fromId = new NodeId(this.nodeToDotId((Node)edge.from));
            NodeId toId = new NodeId(this.nodeToDotId((Node)edge.to));
            Edge newEdge = new Edge(true, fromId, toId);
            if (edgeAttributesMap.containsKey(edge)) {
                newEdge.attributes = edgeAttributesMap.get(edge).clone();
            }
            if (edgeCompassesMap.containsKey(edge)) {
                String compasses = edgeCompassesMap.get(edge);
                String[] compassArr = compasses.split(":");
                if (compassArr.length > 0 && !compassArr[0].isEmpty()) {
                    fromId.compassPt = compassArr[0];
                }
                if (compassArr.length > 1 && !compassArr[1].isEmpty()) {
                    toId.compassPt = compassArr[1];
                }
            }
            processedNodes.add((Node)edge.from);
            processedNodes.add((Node)edge.to);
            ret.edges.add(newEdge);
        }
        if (startNode != null && !processedNodes.contains(startNode)) {
            standaloneNodes.add(new NodeIdToAttributes(new NodeId(this.nodeToDotId(startNode)), new AttributesMap()));
        }
        return ret;
    }

    public String graphToString(Graph g) {
        String ret = g.toString();
        return ret;
    }

    public List<DecomposedGraph> decomposeGraph(Graph fullGraph) {
        ArrayList<Graph> allGraphs = new ArrayList<Graph>();
        allGraphs.add(fullGraph);
        allGraphs.addAll(fullGraph.subgraphs);
        ArrayList<DecomposedGraph> ret = new ArrayList<DecomposedGraph>();
        for (GraphBase graphBase : allGraphs) {
            LinkedHashMap<Node, AttributesMap> nodeAttributesMap = new LinkedHashMap<Node, AttributesMap>();
            LinkedHashMap<com.jpexs.graphs.codestructure.Edge<EditableNode>, AttributesMap> edgeAttributesMap = new LinkedHashMap<com.jpexs.graphs.codestructure.Edge<EditableNode>, AttributesMap>();
            LinkedHashMap<com.jpexs.graphs.codestructure.Edge<EditableNode>, String> edgeCompassesMap = new LinkedHashMap<com.jpexs.graphs.codestructure.Edge<EditableNode>, String>();
            LinkedHashSet<EditableNode> orderedNodeSet = new LinkedHashSet<EditableNode>();
            LinkedHashMap<String, BasicEditableNode> nameToNodeMap = new LinkedHashMap<String, BasicEditableNode>();
            for (Edge srcEdge : graphBase.edges) {
                AttributesMap at;
                NodeId fromNodeId = null;
                if (srcEdge.from instanceof NodeId) {
                    fromNodeId = (NodeId)srcEdge.from;
                }
                NodeId toNodeId = null;
                if (srcEdge.to instanceof NodeId) {
                    toNodeId = (NodeId)srcEdge.to;
                }
                if (fromNodeId == null || toNodeId == null || (at = srcEdge.attributes.clone()).containsKey(IGNORE_ATTRIBUTE) && "true".equals(at.get(IGNORE_ATTRIBUTE))) continue;
                if (at.containsKey(IGNORE_ATTRIBUTES_ATTRIBUTE) && "true".equals(at.get(IGNORE_ATTRIBUTES_ATTRIBUTE))) {
                    at.clear();
                }
                String fromId = fromNodeId.getId().toString();
                String toId = toNodeId.getId().toString();
                if (!nameToNodeMap.containsKey(fromId)) {
                    nameToNodeMap.put(fromId, new BasicEditableNode(fromId));
                }
                if (!nameToNodeMap.containsKey(toId)) {
                    nameToNodeMap.put(toId, new BasicEditableNode(toId));
                }
                EditableNode fromNode = (EditableNode)nameToNodeMap.get(fromId);
                EditableNode toNode = (EditableNode)nameToNodeMap.get(toId);
                com.jpexs.graphs.codestructure.Edge<EditableNode> targetEdge = new com.jpexs.graphs.codestructure.Edge<EditableNode>(fromNode, toNode);
                edgeAttributesMap.put(targetEdge, at);
                String compassToSet = (fromNodeId.compassPt == null ? "" : fromNodeId.compassPt) + ":" + (toNodeId.compassPt == null ? "" : toNodeId.compassPt);
                if (!compassToSet.equals(":")) {
                    edgeCompassesMap.put(targetEdge, compassToSet);
                }
                fromNode.addNext(toNode);
                toNode.addPrev(fromNode);
                orderedNodeSet.add(fromNode);
                orderedNodeSet.add(toNode);
            }
            for (NodeIdToAttributes na : graphBase.nodes) {
                String id = na.nodeId.getId().toString();
                AttributesMap at = na.attributes.clone();
                if (at.containsKey(IGNORE_ATTRIBUTE) && "true".equals(at.get(IGNORE_ATTRIBUTE))) continue;
                if (at.containsKey(IGNORE_ATTRIBUTES_ATTRIBUTE) && "true".equals(at.get(IGNORE_ATTRIBUTES_ATTRIBUTE))) {
                    at.clear();
                }
                if (!nameToNodeMap.containsKey(id)) {
                    nameToNodeMap.put(id, new BasicEditableNode(id));
                }
                EditableNode node = (EditableNode)nameToNodeMap.get(id);
                nodeAttributesMap.put(node, at);
                orderedNodeSet.add(node);
            }
            ret.add(new DecomposedGraph(graphBase.getId(), graphBase.graphAttributes, orderedNodeSet, nodeAttributesMap, edgeAttributesMap, edgeCompassesMap));
        }
        return ret;
    }
}

