/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.graphs.graphviz.graph.operations.codestructure;

import com.jpexs.graphs.codestructure.Edge;
import com.jpexs.graphs.codestructure.nodes.EditableNode;
import com.jpexs.graphs.codestructure.nodes.Node;
import com.jpexs.graphs.graphviz.dot.parser.DotParseException;
import com.jpexs.graphs.graphviz.dot.parser.DotParser;
import com.jpexs.graphs.graphviz.graph.AttributesMap;
import com.jpexs.graphs.graphviz.graph.Graph;
import com.jpexs.graphs.graphviz.graph.operations.GraphOperation;
import com.jpexs.graphs.graphviz.graph.operations.StepHandler;
import com.jpexs.graphs.graphviz.graph.operations.StringOperation;
import com.jpexs.graphs.graphviz.graph.operations.codestructure.DecomposedGraph;
import com.jpexs.graphs.graphviz.graph.operations.codestructure.StructuredGraphFacade;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BasicDecomposedGraphOperation
implements StringOperation,
GraphOperation {
    protected StructuredGraphFacade facade = new StructuredGraphFacade();

    protected String nodesToString(String join, Collection<Node> nodes) {
        ArrayList<String> strs = new ArrayList<String>();
        for (Node n : nodes) {
            strs.add(n.toString());
        }
        return String.join((CharSequence)join, strs);
    }

    protected abstract void executeOnDecomposedGraph(List<DecomposedGraph> var1, StepHandler var2);

    protected void step(Graph g, StepHandler stepHandler) {
        if (stepHandler != null) {
            stepHandler.step(this.facade.graphToString(g));
        }
    }

    @Override
    public final String execute(String source, StepHandler stepHandler) {
        Graph parsedGraph;
        try {
            DotParser parser = new DotParser();
            parsedGraph = parser.parse(new StringReader(source));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (DotParseException ex) {
            ex.printStackTrace();
            return null;
        }
        return this.facade.graphToString(this.executeOnGraph(parsedGraph, stepHandler));
    }

    @Override
    public final Graph executeOnGraph(Graph graph, StepHandler stepHandler) {
        List<DecomposedGraph> decomposedGraphs = this.facade.decomposeGraph(graph);
        this.executeOnDecomposedGraph(decomposedGraphs, stepHandler);
        Graph ret = this.facade.composeGraph(decomposedGraphs);
        return ret;
    }

    protected Graph composeGraph(List<DecomposedGraph> decomposedGraphs) {
        StructuredGraphFacade f = new StructuredGraphFacade();
        return f.composeGraph(decomposedGraphs);
    }

    protected void markEdge(Map<Edge<EditableNode>, AttributesMap> edgeAttributesMap, Edge<EditableNode> edge, String color, String label) {
        if (!edgeAttributesMap.containsKey(edge)) {
            edgeAttributesMap.put(edge, new AttributesMap());
        }
        edgeAttributesMap.get(edge).put("color", color);
        if (label != null) {
            edgeAttributesMap.get(edge).put("label", label);
            edgeAttributesMap.get(edge).put("fontcolor", color);
        }
    }

    protected void markEdge(Map<Edge<EditableNode>, AttributesMap> edgeAttributesMap, EditableNode from, EditableNode to, String color, String label) {
        this.markEdge(edgeAttributesMap, new Edge<EditableNode>(from, to), color, label);
    }

    protected void markNode(Map<Node, AttributesMap> nodeAttributesMap, Node nodeName, String color) {
        if (!nodeAttributesMap.containsKey(nodeName)) {
            nodeAttributesMap.put(nodeName, new AttributesMap());
        }
        nodeAttributesMap.get(nodeName).put("color", color);
    }

    protected void hilightNoNode(Set<EditableNode> allNodes, Map<Node, AttributesMap> nodeAttributesMap) {
        for (Node node : allNodes) {
            if (!nodeAttributesMap.containsKey(node)) continue;
            nodeAttributesMap.get(node).remove("color");
        }
    }

    protected void hilightOneNode(Set<EditableNode> allNodes, Map<Node, AttributesMap> nodeAttributesMap, Node nodeName) {
        this.hilightNoNode(allNodes, nodeAttributesMap);
        this.markNode(nodeAttributesMap, nodeName, "red");
    }
}

