/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.graphs.graphviz.graph;

import com.jpexs.graphs.graphviz.dot.parser.DotId;
import com.jpexs.graphs.graphviz.graph.AttributesMap;
import com.jpexs.graphs.graphviz.graph.Edge;
import com.jpexs.graphs.graphviz.graph.IdAware;
import com.jpexs.graphs.graphviz.graph.NodeId;
import com.jpexs.graphs.graphviz.graph.NodeIdToAttributes;
import com.jpexs.graphs.graphviz.graph.SubGraph;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class GraphBase
implements IdAware {
    protected boolean directed;
    public DotId id = null;
    public AttributesMap graphAttributes = new AttributesMap();
    public AttributesMap nodeAttributes = new AttributesMap();
    public AttributesMap edgeAttributes = new AttributesMap();
    public List<NodeIdToAttributes> nodes = new ArrayList<NodeIdToAttributes>();
    public List<SubGraph> subgraphs = new ArrayList<SubGraph>();
    public List<Edge> edges = new ArrayList<Edge>();

    public GraphBase(boolean directed) {
        this.directed = directed;
    }

    @Override
    public DotId getId() {
        return this.id;
    }

    @Override
    public boolean hasId() {
        return this.id != null;
    }

    protected String bodyToString() {
        String NEWLINE = "\r\n";
        StringBuilder sb = new StringBuilder();
        if (this.hasId()) {
            sb.append(this.id.toString());
        }
        sb.append("{");
        for (DotId key : this.graphAttributes.keySet()) {
            sb.append(key.toString()).append("=").append(this.graphAttributes.get(key)).append(";");
        }
        StringBuilder esb = new StringBuilder();
        LinkedHashSet<NodeId> nodesInEdges = new LinkedHashSet<NodeId>();
        for (Edge edge : this.edges) {
            if (edge.from instanceof NodeId) {
                nodesInEdges.add((NodeId)edge.from);
            }
            if (edge.to instanceof NodeId) {
                nodesInEdges.add((NodeId)edge.to);
            }
            if (esb.length() > 0) {
                esb.append(";").append(NEWLINE);
            }
            esb.append(edge);
        }
        StringBuilder nsb = new StringBuilder();
        for (NodeIdToAttributes entry : this.nodes) {
            if (nsb.length() > 0) {
                nsb.append(";").append(NEWLINE);
            }
            nsb.append(entry.toString());
        }
        sb.append((CharSequence)nsb);
        if (esb.length() > 0) {
            if (nsb.length() > 0) {
                sb.append(";").append(NEWLINE);
            }
            sb.append((CharSequence)esb);
        }
        if (!this.subgraphs.isEmpty()) {
            sb.append(";");
        }
        for (SubGraph subgraph : this.subgraphs) {
            sb.append(subgraph.toString());
            sb.append(";").append(NEWLINE);
        }
        sb.append("}");
        return sb.toString();
    }
}

