/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.graphs.graphviz.dot.parser;

import com.jpexs.graphs.graphviz.dot.parser.DotId;
import com.jpexs.graphs.graphviz.dot.parser.DotLexer;
import com.jpexs.graphs.graphviz.dot.parser.DotParseException;
import com.jpexs.graphs.graphviz.dot.parser.DotParsedSymbol;
import com.jpexs.graphs.graphviz.graph.AttributesMap;
import com.jpexs.graphs.graphviz.graph.ConnectableObject;
import com.jpexs.graphs.graphviz.graph.Edge;
import com.jpexs.graphs.graphviz.graph.Graph;
import com.jpexs.graphs.graphviz.graph.NodeId;
import com.jpexs.graphs.graphviz.graph.NodeIdToAttributes;
import com.jpexs.graphs.graphviz.graph.SubGraph;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DotParser {
    private static final String[] VALID_COMPASS_VALUES = new String[]{"n", "ne", "e", "se", "s", "sw", "w", "nw", "c", "_"};

    public Graph parse(Reader in) throws DotParseException, IOException {
        DotLexer lexer = new DotLexer(in);
        return this.file(lexer);
    }

    public Graph file(DotLexer lexer) throws DotParseException, IOException {
        Graph ret = this.graph(lexer);
        this._expect(lexer, 18, "end of file");
        return ret;
    }

    public Graph graph(DotLexer lexer) throws IOException, DotParseException {
        boolean isStrict = false;
        boolean isDirectedGraph = false;
        DotParsedSymbol symbol = lexer.lex();
        if (symbol.type == 0) {
            symbol = lexer.lex();
            isStrict = true;
        }
        if (symbol.type != 1) {
            if (symbol.type == 2) {
                isDirectedGraph = true;
            } else {
                this._expected("draph or digraph keyword", symbol);
            }
        }
        symbol = lexer.lex();
        DotId id = null;
        if (symbol.type == 17) {
            id = symbol.getValueAsId();
        } else {
            lexer.pushback(symbol);
        }
        this._expect(lexer, 8, "{");
        ArrayList<Edge> edges = new ArrayList<Edge>();
        ArrayList<NodeIdToAttributes> standaloneNodes = new ArrayList<NodeIdToAttributes>();
        ArrayList<SubGraph> standaloneSubGraphs = new ArrayList<SubGraph>();
        AttributesMap graphAttributes = new AttributesMap();
        AttributesMap nodeAttributes = new AttributesMap();
        AttributesMap edgeAttributes = new AttributesMap();
        this.stmt_list(edges, standaloneSubGraphs, standaloneNodes, graphAttributes, nodeAttributes, edgeAttributes, isDirectedGraph, lexer);
        this._expect(lexer, 9, "}");
        Graph graph = new Graph(isStrict, isDirectedGraph);
        graph.edges = edges;
        graph.nodes = standaloneNodes;
        graph.subgraphs = standaloneSubGraphs;
        graph.id = id;
        graph.graphAttributes = graphAttributes;
        graph.nodeAttributes = nodeAttributes;
        graph.edgeAttributes = edgeAttributes;
        return graph;
    }

    public void stmt_list(List<Edge> edges, List<SubGraph> standaloneSubGraphs, List<NodeIdToAttributes> standaloneNodes, AttributesMap graphAttributes, AttributesMap nodeAttributes, AttributesMap edgeAttributes, boolean isDirectedGraph, DotLexer lexer) throws DotParseException, IOException {
        boolean empty = true;
        if (this.stmt(edges, standaloneSubGraphs, standaloneNodes, graphAttributes, nodeAttributes, edgeAttributes, isDirectedGraph, lexer)) {
            empty = false;
        }
        DotParsedSymbol symbol = lexer.lex();
        if (symbol.type == 6) {
            empty = false;
        } else {
            lexer.pushback(symbol);
        }
        if (!empty) {
            this.stmt_list(edges, standaloneSubGraphs, standaloneNodes, graphAttributes, nodeAttributes, edgeAttributes, isDirectedGraph, lexer);
        }
    }

    public boolean stmt(List<Edge> edges, List<SubGraph> standaloneSubGraphs, List<NodeIdToAttributes> standaloneNodes, AttributesMap graphAttributes, AttributesMap nodeAttributes, AttributesMap edgeAttributes, boolean isDirectedGraph, DotLexer lexer) throws DotParseException, IOException {
        DotParsedSymbol symbol = lexer.lex();
        if (symbol.type == 17) {
            DotParsedSymbol idSymbol = symbol;
            symbol = lexer.lex();
            if (symbol.type == 10) {
                DotId key = idSymbol.getValueAsId();
                symbol = lexer.lex();
                this._expect(17, "ID", symbol);
                DotId value = symbol.getValueAsId();
                graphAttributes.put(key, value);
                return true;
            }
            lexer.pushback(symbol);
            lexer.pushback(idSymbol);
            symbol = lexer.lex();
        }
        if (symbol.type == 1 || symbol.type == 3 || symbol.type == 4) {
            String attrKind;
            lexer.pushback(symbol);
            AttributesMap attributesBag = new AttributesMap();
            switch (attrKind = this.attr_stmt(lexer, attributesBag)) {
                case "graph": {
                    graphAttributes.putAll(attributesBag);
                    break;
                }
                case "node": {
                    nodeAttributes.putAll(attributesBag);
                    break;
                }
                case "edge": {
                    edgeAttributes.putAll(attributesBag);
                }
            }
            return true;
        }
        lexer.pushback(symbol);
        ConnectableObject from = this.node_id_or_subgraph(standaloneSubGraphs, standaloneNodes, isDirectedGraph, lexer);
        if (from != null) {
            symbol = lexer.lex();
            Object obj = from;
            if (symbol.type == 14 || symbol.type == 15) {
                lexer.pushback(symbol);
                obj = this.edge_rhs(from, standaloneSubGraphs, edges, isDirectedGraph, lexer);
                symbol = lexer.lex();
            }
            AttributesMap currentAttributes = new AttributesMap();
            if (symbol.type == 11 && (obj instanceof Edge || obj instanceof NodeId)) {
                lexer.pushback(symbol);
                if (obj instanceof Edge) {
                    currentAttributes = ((Edge)obj).attributes;
                }
                AttributesMap attributes = this.attr_list(lexer);
                currentAttributes.putAll(attributes);
            } else {
                lexer.pushback(symbol);
            }
            if (obj instanceof NodeId) {
                standaloneNodes.add(new NodeIdToAttributes((NodeId)obj, currentAttributes));
            }
            return true;
        }
        return false;
    }

    private ConnectableObject node_id_or_subgraph(List<SubGraph> standaloneSubgraphs, List<NodeIdToAttributes> standaloneNodes, boolean isDirectedGraph, DotLexer lexer) throws DotParseException, IOException {
        DotParsedSymbol symbol = lexer.lex();
        if (symbol.type == 5 || symbol.type == 8) {
            lexer.pushback(symbol);
            return this.subgraph(standaloneSubgraphs, isDirectedGraph, lexer);
        }
        if (symbol.type == 17) {
            lexer.pushback(symbol);
            return this.node_id(lexer);
        }
        lexer.pushback(symbol);
        return null;
    }

    public AttributesMap attr_list(DotLexer lexer) throws DotParseException, IOException {
        AttributesMap attributesBag = new AttributesMap();
        this._expect(lexer, 11, "[");
        DotParsedSymbol symbol = lexer.lex();
        if (symbol.type == 17) {
            lexer.pushback(symbol);
            this.a_list(attributesBag, lexer);
        } else {
            lexer.pushback(symbol);
        }
        this._expect(lexer, 12, "]");
        symbol = lexer.lex();
        if (symbol.type == 11) {
            lexer.pushback(symbol);
            AttributesMap nextAtributesBag = this.attr_list(lexer);
            attributesBag.putAll(nextAtributesBag);
        } else {
            lexer.pushback(symbol);
        }
        return attributesBag;
    }

    public String attr_stmt(DotLexer lexer, AttributesMap out) throws DotParseException, IOException {
        DotParsedSymbol symbol = lexer.lex();
        if (symbol.type != 1 && symbol.type != 3 && symbol.type != 4) {
            this._expected("graph or node or edge keyword", symbol);
        }
        out.putAll(this.attr_list(lexer));
        return symbol.getValueAsString();
    }

    public void a_list(AttributesMap attributesBag, DotLexer lexer) throws DotParseException, IOException {
        DotParsedSymbol symbol = lexer.lex();
        this._expect(17, "ID", symbol);
        DotId key = symbol.getValueAsId();
        this._expect(lexer, 10, "=");
        symbol = lexer.lex();
        DotId value = symbol.getValueAsId();
        attributesBag.put(key, value);
        symbol = lexer.lex();
        if (symbol.type == 6 || symbol.type == 7) {
            symbol = lexer.lex();
        }
        if (symbol.type == 17) {
            lexer.pushback(symbol);
            this.a_list(attributesBag, lexer);
        } else {
            lexer.pushback(symbol);
        }
    }

    public void node_stmt(List<NodeIdToAttributes> standaloneNodes, DotLexer lexer) throws DotParseException, IOException {
        NodeId node = this.node_id(lexer);
        DotParsedSymbol symbol = lexer.lex();
        if (symbol.type == 11) {
            lexer.pushback(symbol);
            AttributesMap attributes = this.attr_list(lexer);
            standaloneNodes.add(new NodeIdToAttributes(node, attributes));
        } else {
            lexer.pushback(symbol);
        }
    }

    public void edge_stmt(List<SubGraph> standaloneSubgraphs, List<Edge> edges, boolean isDirectedGraph, DotLexer lexer) throws DotParseException, IOException {
        ConnectableObject from;
        DotParsedSymbol symbol = lexer.lex();
        if (symbol.type == 17) {
            lexer.pushback(symbol);
            from = this.node_id(lexer);
        } else {
            this._expect(5, "subgraph", symbol);
            from = this.subgraph(standaloneSubgraphs, isDirectedGraph, lexer);
        }
        Edge edge = this.edge_rhs(from, standaloneSubgraphs, edges, isDirectedGraph, lexer);
        symbol = lexer.lex();
        if (symbol.type == 11) {
            lexer.pushback(symbol);
            AttributesMap attributes = this.attr_list(lexer);
            edge.attributes.putAll(attributes);
        } else {
            lexer.pushback(symbol);
        }
    }

    public NodeId node_id(DotLexer lexer) throws DotParseException, IOException {
        DotParsedSymbol symbol = lexer.lex();
        this._expect(17, "ID", symbol);
        DotId id = symbol.getValueAsId();
        symbol = lexer.lex();
        NodeId node = new NodeId(id);
        if (symbol.type == 13) {
            lexer.pushback(symbol);
            this.port(node, lexer);
        } else {
            lexer.pushback(symbol);
        }
        return node;
    }

    public void port(NodeId node, DotLexer lexer) throws DotParseException, IOException {
        this._expect(lexer, 13, "colon");
        DotParsedSymbol symbol = lexer.lex();
        if (symbol.idtype == 1 && Arrays.asList(VALID_COMPASS_VALUES).contains(symbol.getValueAsString())) {
            lexer.pushback(symbol);
            node.compassPt = this.compass_pt(lexer);
        } else if (symbol.type == 17) {
            node.portId = symbol.getValueAsString();
            symbol = lexer.lex();
            if (symbol.type == 13) {
                node.compassPt = this.compass_pt(lexer);
            } else {
                lexer.pushback(symbol);
            }
        } else {
            this._expected("ID or compass_pt", symbol);
        }
    }

    public String compass_pt(DotLexer lexer) throws DotParseException, IOException {
        DotParsedSymbol symbol = lexer.lex();
        if (symbol.idtype == 1) {
            String compassValue = symbol.getValueAsString();
            if (!Arrays.asList(VALID_COMPASS_VALUES).contains(compassValue)) {
                this._expected("compass value - one of " + String.join((CharSequence)",", VALID_COMPASS_VALUES), symbol);
            }
            return compassValue;
        }
        this._expected("compass value - one of " + String.join((CharSequence)",", VALID_COMPASS_VALUES), symbol);
        return null;
    }

    public Edge edge_rhs(ConnectableObject from, List<SubGraph> standaloneSubgraphs, List<Edge> edges, boolean isDirectedGraph, DotLexer lexer) throws DotParseException, IOException {
        DotParsedSymbol symbol = lexer.lex();
        if (symbol.type == 15) {
            if (!isDirectedGraph) {
                this._expected("--", symbol);
            }
        } else if (symbol.type == 14 && isDirectedGraph) {
            this._expected("->", symbol);
        }
        symbol = lexer.lex();
        ConnectableObject to = null;
        if (symbol.type == 17) {
            lexer.pushback(symbol);
            to = this.node_id(lexer);
        } else if (symbol.type == 5 || symbol.type == 8) {
            lexer.pushback(symbol);
            to = this.subgraph(standaloneSubgraphs, isDirectedGraph, lexer);
        }
        Edge edge = null;
        if (to != null) {
            edge = new Edge(isDirectedGraph, from, to);
            edges.add(edge);
        }
        symbol = lexer.lex();
        if (symbol.type == 15 || symbol.type == 14) {
            lexer.pushback(symbol);
            edge = this.edge_rhs(to, standaloneSubgraphs, edges, isDirectedGraph, lexer);
        } else {
            lexer.pushback(symbol);
        }
        return edge;
    }

    public SubGraph subgraph(List<SubGraph> standaloneSubgraphs, boolean isDirectedGraph, DotLexer lexer) throws DotParseException, IOException {
        DotParsedSymbol symbol = lexer.lex();
        DotId id = null;
        if (symbol.type == 5) {
            symbol = lexer.lex();
            if (symbol.type == 17) {
                id = symbol.getValueAsId();
                symbol = lexer.lex();
            }
        }
        this._expect(8, "{", symbol);
        ArrayList<Edge> edges = new ArrayList<Edge>();
        ArrayList<NodeIdToAttributes> standaloneNodes = new ArrayList<NodeIdToAttributes>();
        AttributesMap graphAttributes = new AttributesMap();
        AttributesMap nodeAttributes = new AttributesMap();
        AttributesMap edgeAttributes = new AttributesMap();
        this.stmt_list(edges, standaloneSubgraphs, standaloneNodes, graphAttributes, nodeAttributes, edgeAttributes, isDirectedGraph, lexer);
        this._expect(lexer, 9, "}");
        SubGraph graph = new SubGraph(isDirectedGraph);
        graph.edges = edges;
        graph.nodes = standaloneNodes;
        graph.id = id;
        graph.graphAttributes = graphAttributes;
        graph.nodeAttributes = nodeAttributes;
        graph.edgeAttributes = edgeAttributes;
        standaloneSubgraphs.add(graph);
        return graph;
    }

    private void _expect(DotLexer lexer, int symbolType, String expected) throws DotParseException, IOException {
        DotParsedSymbol found = lexer.lex();
        if (found.type != symbolType) {
            throw new DotParseException(found.line, "Expected " + expected + ", but " + found.getValueAsString() + " found");
        }
    }

    private void _expected(String expected, DotParsedSymbol found) throws DotParseException {
        throw new DotParseException(found.line, "Expected " + expected + ", but " + found.getValueAsString() + " found");
    }

    private void _expect(int symbolType, String typeString, DotParsedSymbol symbol) throws DotParseException {
        if (symbol.type != symbolType) {
            this._expected(typeString, symbol);
        }
    }
}

