/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.graphs.codestructure.operations;

import com.jpexs.graphs.codestructure.factories.BasicEditableJoinedNodeFactory;
import com.jpexs.graphs.codestructure.factories.EditableJoinedNodeFactory;
import com.jpexs.graphs.codestructure.nodes.EditableJoinedNode;
import com.jpexs.graphs.codestructure.nodes.EditableNode;
import com.jpexs.graphs.codestructure.nodes.Node;
import com.jpexs.graphs.codestructure.operations.NodeJoinerProgressListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class NodeJoiner {
    private EditableJoinedNodeFactory joinedNodeFactory = new BasicEditableJoinedNodeFactory();
    private List<NodeJoinerProgressListener> listeners = new ArrayList<NodeJoinerProgressListener>();

    public void setJoinedNodeFactory(EditableJoinedNodeFactory joinedNodeFactory) {
        this.joinedNodeFactory = joinedNodeFactory;
    }

    public EditableNode joinNodes(EditableNode head) {
        ArrayList<EditableNode> heads = new ArrayList<EditableNode>();
        heads.add(head);
        Collection<EditableNode> multiHeads = this.joinNodes(heads);
        return multiHeads.iterator().next();
    }

    public Collection<EditableNode> joinNodes(Collection<? extends EditableNode> heads) {
        ArrayList<EditableNode> ret = new ArrayList<EditableNode>();
        for (EditableNode editableNode : heads) {
            ret.add(this.joinNodes(editableNode, new LinkedHashSet<EditableNode>()));
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private EditableNode joinNodes(EditableNode node, Set<EditableNode> visited) {
        EditableNode result;
        EditableNode originalNode;
        if (visited.contains(node)) {
            return node;
        }
        EditableNode currentNode = originalNode = node;
        ArrayList<EditableNode> subNodesList = new ArrayList<EditableNode>();
        subNodesList.add(currentNode);
        visited.add(currentNode);
        while (currentNode.getNext().size() == 1 && currentNode.getNext().get(0).getPrev().size() == 1 && !visited.contains(currentNode.getNext().get(0))) {
            currentNode = currentNode.getNext().get(0);
            visited.add(currentNode);
            subNodesList.add(currentNode);
        }
        if (subNodesList.size() > 1) {
            void var11_17;
            void var11_15;
            EditableNode lastSubNode = (EditableNode)subNodesList.get(subNodesList.size() - 1);
            EditableNode editableNode = (EditableNode)subNodesList.get(0);
            ArrayList<String> subIds = new ArrayList<String>();
            for (Node node2 : subNodesList) {
                subIds.add(node2.getId());
            }
            EditableJoinedNode joinedNode = this.joinedNodeFactory.create(subIds);
            for (Node node3 : subNodesList) {
                joinedNode.addSubNode(node3);
            }
            boolean bl = false;
            while (var11_15 < lastSubNode.getNext().size()) {
                EditableNode editableNode2 = lastSubNode.getNext().get((int)var11_15);
                joinedNode.addNext(editableNode2);
                if (lastSubNode instanceof EditableNode) {
                    EditableNode lastSubNodeMutable = lastSubNode;
                    lastSubNodeMutable.removeNext(editableNode2);
                    --var11_15;
                }
                if (editableNode2 instanceof EditableNode) {
                    EditableNode nextMutable = editableNode2;
                    for (int j = 0; j < editableNode2.getPrev().size(); ++j) {
                        if (editableNode2.getPrev().get(j) != lastSubNode) continue;
                        nextMutable.setPrev(j, joinedNode);
                    }
                }
                ++var11_15;
            }
            boolean bl2 = false;
            while (var11_17 < editableNode.getPrev().size()) {
                EditableNode editableNode3 = editableNode.getPrev().get((int)var11_17);
                joinedNode.addPrev(editableNode3);
                EditableNode firstSubNodeMutable = editableNode;
                firstSubNodeMutable.removePrev(editableNode3);
                --var11_17;
                EditableNode prevMutable = editableNode3;
                for (int j = 0; j < editableNode3.getNext().size(); ++j) {
                    if (editableNode3.getNext().get(j) != editableNode) continue;
                    prevMutable.setNext(j, joinedNode);
                }
                ++var11_17;
            }
            this.fireNodesJoined(joinedNode);
            this.fireStep();
            result = joinedNode;
        } else {
            result = originalNode;
        }
        for (EditableNode editableNode : result.getNext()) {
            this.joinNodes(editableNode, visited);
        }
        return result;
    }

    public void addListener(NodeJoinerProgressListener l) {
        this.listeners.add(l);
    }

    public void removeListener(NodeJoinerProgressListener l) {
        this.listeners.remove(l);
    }

    private void fireNodesJoined(EditableJoinedNode node) {
        for (NodeJoinerProgressListener l : this.listeners) {
            l.nodesJoined(node);
        }
    }

    private void fireStep() {
        for (NodeJoinerProgressListener l : this.listeners) {
            l.step();
        }
    }
}

