/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.graphs.codestructure.operations;

import com.jpexs.graphs.codestructure.DecisionList;
import com.jpexs.graphs.codestructure.Edge;
import com.jpexs.graphs.codestructure.nodes.EditableNode;
import com.jpexs.graphs.codestructure.nodes.Node;
import com.jpexs.graphs.codestructure.operations.CodeStructureDetector;
import com.jpexs.graphs.codestructure.operations.CodeStructureDetectorProgressListener;
import com.jpexs.graphs.codestructure.operations.CodeStructureModifierProgressListener;
import com.jpexs.graphs.codestructure.operations.DetectedEdgeType;
import com.jpexs.graphs.codestructure.operations.EndIfNodeInjector;
import com.jpexs.graphs.codestructure.operations.NodeJoiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CodeStructureModifier {
    private List<CodeStructureModifierProgressListener> listeners = new ArrayList<CodeStructureModifierProgressListener>();

    public EditableNode execute(EditableNode head, List<Node> loopContinues, List<Edge<EditableNode>> gotoEdges, List<Edge<EditableNode>> backEdges, List<Edge<EditableNode>> exitIfEdges) {
        ArrayList<EditableNode> heads = new ArrayList<EditableNode>();
        heads.add(head);
        Collection<EditableNode> heads2 = this.execute(heads, loopContinues, gotoEdges, backEdges, exitIfEdges);
        return heads2.isEmpty() ? null : heads2.iterator().next();
    }

    public Collection<EditableNode> execute(Collection<? extends EditableNode> heads, List<Node> loopContinues, List<Edge<EditableNode>> gotoEdges, List<Edge<EditableNode>> backEdges, List<Edge<EditableNode>> exitIfEdges) {
        NodeJoiner multinodeJoiner = new NodeJoiner();
        for (CodeStructureModifierProgressListener l : this.listeners) {
            multinodeJoiner.addListener(l);
        }
        Collection<EditableNode> joinedHeads = multinodeJoiner.joinNodes(heads);
        CodeStructureDetector<EditableNode> det = new CodeStructureDetector<EditableNode>();
        final EndIfNodeInjector endifInjector = new EndIfNodeInjector();
        for (CodeStructureModifierProgressListener l : this.listeners) {
            endifInjector.addListener(l);
        }
        det.addListener(new CodeStructureDetectorProgressListener<EditableNode>(){

            @Override
            public EditableNode endIfDetected(EditableNode decisionNode, List<EditableNode> endBranchNodes, EditableNode afterNode) {
                EditableNode ret = afterNode;
                for (CodeStructureModifierProgressListener l : CodeStructureModifier.this.listeners) {
                    ret = l.endIfDetected(decisionNode, endBranchNodes, afterNode);
                }
                return endifInjector.injectEndIf(decisionNode, endBranchNodes, ret);
            }

            @Override
            public void step() {
                for (CodeStructureModifierProgressListener l : CodeStructureModifier.this.listeners) {
                    l.step();
                }
            }

            @Override
            public void edgeMarked(Edge<EditableNode> edge, DetectedEdgeType edgeType) {
                for (CodeStructureModifierProgressListener l : CodeStructureModifier.this.listeners) {
                    l.edgeMarked(edge, edgeType);
                }
            }

            @Override
            public void nodeSelected(EditableNode node) {
                for (CodeStructureModifierProgressListener l : CodeStructureModifier.this.listeners) {
                    l.nodeSelected(node);
                }
            }

            @Override
            public void updateDecisionLists(Map<Edge<EditableNode>, DecisionList<EditableNode>> decistionLists) {
                for (CodeStructureModifierProgressListener l : CodeStructureModifier.this.listeners) {
                    l.updateDecisionLists(decistionLists);
                }
            }

            @Override
            public void noNodeSelected() {
                for (CodeStructureModifierProgressListener l : CodeStructureModifier.this.listeners) {
                    l.noNodeSelected();
                }
            }
        });
        det.detect(joinedHeads, loopContinues, gotoEdges, backEdges, exitIfEdges);
        return joinedHeads;
    }

    public void addListener(CodeStructureModifierProgressListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CodeStructureModifierProgressListener listener) {
        this.listeners.remove(listener);
    }
}

