/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFAnnot;
import gnu.jpdf.PDFFont;
import gnu.jpdf.PDFGraphics;
import gnu.jpdf.PDFObject;
import gnu.jpdf.PDFOutline;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Vector;

public class PDFPage
extends PDFObject
implements Serializable {
    private static final PageFormat DEF_FORMAT = new PageFormat();
    protected PageFormat pageFormat;
    protected PDFObject pdfPageList;
    protected Vector<PDFObject> contents;
    protected PDFObject thumbnail = null;
    protected Vector<PDFObject> annotations;
    protected Vector<String> resources;
    protected Vector<String> imageResources;
    protected Vector<String> patternResources;
    protected Vector<String> shadingResources;
    protected Vector<String> extGStateResources;
    protected Vector<PDFFont> fonts;
    protected boolean hasImageB;
    protected boolean hasImageC;
    protected boolean hasImageI;
    protected procset procset = null;
    private Vector<String> xobjects = new Vector();

    public PDFPage() {
        super("/Page");
        this.pageFormat = DEF_FORMAT;
        this.contents = new Vector();
        this.annotations = new Vector();
        this.resources = new Vector();
        this.imageResources = new Vector();
        this.patternResources = new Vector();
        this.shadingResources = new Vector();
        this.extGStateResources = new Vector();
        this.fonts = new Vector();
    }

    public PDFPage(int orientation) {
        this();
        this.setOrientation(orientation);
    }

    public PDFPage(PageFormat pageFormat) {
        this();
        this.pageFormat = pageFormat;
    }

    public void addToProcset(String proc) {
        if (this.procset == null) {
            this.addProcset();
        }
        this.procset.add(proc);
    }

    public PDFGraphics getGraphics() {
        try {
            PDFGraphics g = new PDFGraphics();
            g.init(this);
            return g;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public PDFFont getFont(String type, String font, int style) {
        for (PDFFont ft : this.fonts) {
            if (!ft.equals(type, font, style)) continue;
            return ft;
        }
        if (this.fonts.size() == 0) {
            this.addProcset();
            this.procset.add("/Text");
        }
        PDFFont f = this.pdfDocument.getFont(type, font, style);
        this.fonts.addElement(f);
        return f;
    }

    public PDFFont getEmbeddedFont(String font, int style, File file) throws IOException {
        for (PDFFont ft : this.fonts) {
            if (!ft.equals("/TrueType", font, style)) continue;
            return ft;
        }
        if (this.fonts.size() == 0) {
            this.addProcset();
            this.procset.add("/Text");
        }
        PDFFont f = this.pdfDocument.getEmbeddedFont(font, style, file);
        this.fonts.addElement(f);
        return f;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public Dimension getDimension() {
        return new Dimension((int)this.pageFormat.getWidth(), (int)this.pageFormat.getHeight());
    }

    public Rectangle getImageableArea() {
        return new Rectangle((int)this.pageFormat.getImageableX(), (int)this.pageFormat.getImageableY(), (int)(this.pageFormat.getImageableX() + this.pageFormat.getImageableWidth()), (int)(this.pageFormat.getImageableY() + this.pageFormat.getImageableHeight()));
    }

    public void setOrientation(int orientation) {
        this.pageFormat.setOrientation(orientation);
    }

    public int getOrientation() {
        return this.pageFormat.getOrientation();
    }

    public void add(PDFObject ob) {
        this.contents.addElement(ob);
    }

    public void addAnnotation(PDFObject ob) {
        this.annotations.addElement(ob);
    }

    public PDFAnnot addNote(String note, int x, int y, int w, int h) {
        int[] xy1 = this.cxy(x, y + h);
        int[] xy2 = this.cxy(x + w, y);
        PDFAnnot ob = new PDFAnnot(xy1[0], xy1[1], xy2[0], xy2[1], note);
        this.pdfDocument.add(ob);
        this.annotations.addElement(ob);
        return ob;
    }

    public PDFAnnot addLink(int x, int y, int w, int h, PDFObject dest) {
        int[] xy1 = this.cxy(x, y + h);
        int[] xy2 = this.cxy(x + w, y);
        PDFAnnot ob = new PDFAnnot(xy1[0], xy1[1], xy2[0], xy2[1], dest);
        this.pdfDocument.add(ob);
        this.annotations.addElement(ob);
        return ob;
    }

    public PDFAnnot addLink(int x, int y, int w, int h, PDFObject dest, int vx, int vy, int vw, int vh) {
        int[] xy1 = this.cxy(x, y + h);
        int[] xy2 = this.cxy(x + w, y);
        int[] xy3 = this.cxy(vx, vy + vh);
        int[] xy4 = this.cxy(vx + vw, vy);
        PDFAnnot ob = new PDFAnnot(xy1[0], xy1[1], xy2[0], xy2[1], dest, xy3[0], xy3[1], xy4[0], xy4[1]);
        this.pdfDocument.add(ob);
        this.annotations.addElement(ob);
        return ob;
    }

    public void addXObject(String inxobject) {
        this.xobjects.addElement(inxobject);
    }

    public void addResource(String resource) {
        this.resources.addElement(resource);
    }

    public void addImageResource(String resource) {
        this.imageResources.addElement(resource);
    }

    public void addPatternResource(String resource) {
        this.patternResources.add(resource);
    }

    public void addShadingResource(String resource) {
        this.shadingResources.add(resource);
    }

    public void addExtGStateResource(String resource) {
        this.extGStateResources.add(resource);
    }

    public void setThumbnail(PDFObject thumbnail) {
        this.thumbnail = thumbnail;
    }

    public PDFOutline addOutline(String title) {
        PDFOutline outline = new PDFOutline(title, this);
        this.pdfDocument.add(outline);
        this.pdfDocument.getOutline().add(outline);
        return outline;
    }

    public PDFOutline addOutline(String title, int x, int y, int w, int h) {
        int[] xy1 = this.cxy(x, y + h);
        int[] xy2 = this.cxy(x + w, y);
        PDFOutline outline = new PDFOutline(title, this, xy1[0], xy1[1], xy2[0], xy2[1]);
        this.pdfDocument.add(outline);
        this.pdfDocument.getOutline().add(outline);
        return outline;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.writeStart(os);
        os.write("/Parent ".getBytes());
        os.write(this.pdfPageList.toString().getBytes());
        os.write("\n".getBytes());
        os.write("/MediaBox [".getBytes());
        os.write(Integer.toString(0).getBytes());
        os.write(" ".getBytes());
        os.write(Integer.toString(0).getBytes());
        os.write(" ".getBytes());
        os.write(Integer.toString((int)this.pageFormat.getWidth()).getBytes());
        os.write(" ".getBytes());
        os.write(Integer.toString((int)this.pageFormat.getHeight()).getBytes());
        os.write("]\n".getBytes());
        this.writeResources(os);
        if (this.thumbnail != null) {
            os.write("/Thumb ".getBytes());
            os.write(this.thumbnail.toString().getBytes());
            os.write("\n".getBytes());
        }
        if (this.contents.size() > 0) {
            if (this.contents.size() == 1) {
                PDFObject ob = this.contents.elementAt(0);
                os.write("/Contents ".getBytes());
                os.write(ob.toString().getBytes());
                os.write("\n".getBytes());
            } else {
                os.write("/Contents [".getBytes());
                os.write(PDFObject.toArray(this.contents).getBytes());
                os.write("\n".getBytes());
            }
        }
        if (this.annotations.size() > 0) {
            os.write("/Annots ".getBytes());
            os.write(PDFObject.toArray(this.annotations).getBytes());
            os.write("\n".getBytes());
        }
        this.writeEnd(os);
    }

    public void writeResources(OutputStream os) throws IOException {
        os.write("/Resources << ".getBytes());
        if (this.fonts.size() > 0) {
            os.write("\n/Font << ".getBytes());
            for (PDFFont font : this.fonts) {
                os.write(font.getName().getBytes());
                os.write(" ".getBytes());
                os.write(font.toString().getBytes());
                os.write(" ".getBytes());
            }
            os.write(">> ".getBytes());
        }
        if (this.xobjects.size() > 0) {
            os.write("\n/XObject << ".getBytes());
            for (String str : this.xobjects) {
                os.write(str.getBytes());
                os.write(" ".getBytes());
            }
            os.write(">> ".getBytes());
        }
        for (String str : this.resources) {
            os.write(str.getBytes());
            os.write(" ".getBytes());
        }
        if (this.imageResources.size() > 0) {
            os.write("/XObject << ".getBytes());
            for (String str : this.imageResources) {
                os.write(str.getBytes());
                os.write(" ".getBytes());
            }
            os.write(" >> ".getBytes());
        }
        if (this.patternResources.size() > 0) {
            os.write("/Pattern << ".getBytes());
            for (String str : this.patternResources) {
                os.write(str.getBytes());
                os.write(" ".getBytes());
            }
            os.write(" >> ".getBytes());
        }
        if (this.shadingResources.size() > 0) {
            os.write("/Shading << ".getBytes());
            for (String str : this.shadingResources) {
                os.write(str.getBytes());
                os.write(" ".getBytes());
            }
            os.write(" >> ".getBytes());
        }
        if (this.extGStateResources.size() > 0) {
            os.write("/ExtGState << ".getBytes());
            for (String str : this.extGStateResources) {
                os.write(str.getBytes());
                os.write(" ".getBytes());
            }
            os.write(" >> ".getBytes());
        }
        os.write(">>\n".getBytes());
    }

    private void addProcset() {
        if (this.procset == null) {
            this.procset = new procset();
            this.pdfDocument.add(this.procset);
            this.resources.addElement("/ProcSet " + this.procset);
        }
    }

    public int cy(int x, int y) {
        return this.cxy(x, y)[1];
    }

    public int cx(int x, int y) {
        return this.cxy(x, y)[0];
    }

    public int[] cxy(int x, int y) {
        int[] r = new int[]{x, (int)this.pageFormat.getHeight() - y};
        return r;
    }

    public class procset
    extends PDFObject {
        private Vector<String> set;

        public procset() {
            super(null);
            this.set = new Vector();
            this.set.addElement("/PDF");
        }

        public void add(String proc) {
            this.set.addElement(" " + proc);
        }

        @Override
        public void write(OutputStream os) throws IOException {
            os.write(Integer.toString(this.objser).getBytes());
            os.write(" 0 obj\n".getBytes());
            os.write("[".getBytes());
            for (String str : this.set) {
                os.write(str.getBytes());
            }
            os.write("]\n".getBytes());
            os.write("endobj\n".getBytes());
        }
    }
}

