/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFStream;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class PDFMask
extends PDFStream
implements ImageObserver {
    private final Image img;
    private int width;
    private int height;

    public PDFMask(Image img) {
        super("/XObject");
        this.img = img;
        this.width = img.getWidth(this);
        this.height = img.getHeight(this);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        if (infoflags == 1) {
            this.width = w;
        }
        if (infoflags == 2) {
            this.height = h;
        }
        return false;
    }

    @Override
    public void writeStream(OutputStream os) throws IOException {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream(b);
        int w = this.width;
        int h = this.height;
        int x = 0;
        int y = 0;
        int[] pixels = new int[w * h];
        PixelGrabber pg = new PixelGrabber(this.img, x, y, w, h, pixels, 0, w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                int p = pixels[j * w + i];
                int alpha = 255 - (p >> 24) & 0xFF;
                dos.write(alpha);
            }
        }
        dos.finish();
        dos.close();
        os.write("/Subtype /Image\n".getBytes());
        os.write(("/Width " + this.width + "\n").getBytes());
        os.write(("/Height " + this.height + "\n").getBytes());
        os.write("/BitsPerComponent 8\n".getBytes());
        os.write("/ColorSpace /DeviceGray\n".getBytes());
        os.write("/Decode [1 0]\n".getBytes());
        os.write("/Filter /FlateDecode\n".getBytes());
        os.write("/Length ".getBytes());
        os.write(Integer.toString(b.size() + 1).getBytes());
        os.write("\n>>\nstream\n".getBytes());
        b.writeTo(os);
        os.write("\n".getBytes());
        os.write("endstream\nendobj\n".getBytes());
    }
}

