/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFDocument;
import gnu.jpdf.PDFObject;
import gnu.jpdf.PDFOutline;
import gnu.jpdf.PDFPageList;
import java.io.IOException;
import java.io.OutputStream;

public class PDFCatalog
extends PDFObject {
    private PDFPageList pdfPageList;
    private PDFOutline outlines;
    private int pagemode;

    public PDFCatalog(PDFPageList pdfPageList, int pagemode) {
        super("/Catalog");
        this.pdfPageList = pdfPageList;
        this.pagemode = pagemode;
    }

    protected void setOutline(PDFOutline outline) {
        this.outlines = outline;
    }

    @Override
    public void write(OutputStream os) throws IOException {
        this.writeStart(os);
        os.write("/Version /1.7\n".getBytes());
        os.write("/Pages ".getBytes());
        os.write(this.pdfPageList.toString().getBytes());
        os.write("\n".getBytes());
        if (this.outlines != null) {
            os.write("/Outlines ".getBytes());
            os.write(this.outlines.toString().getBytes());
            os.write("\n".getBytes());
        }
        os.write("/PageMode ".getBytes());
        os.write(PDFDocument.PDF_PAGE_MODES[this.pagemode].getBytes());
        os.write("\n".getBytes());
        this.writeEnd(os);
    }
}

