/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane;

import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import jsyntaxpane.SyntaxDocument;

public class CompoundUndoMan
extends UndoManager {
    private final SyntaxDocument doc;
    private CompoundEdit compoundEdit;
    private boolean startCombine = false;
    private int lastLine = -1;

    public CompoundUndoMan(SyntaxDocument doc) {
        this.doc = doc;
        doc.addUndoableEditListener(this);
        this.lastLine = doc.getStartPosition().getOffset();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        if (this.compoundEdit == null) {
            this.compoundEdit = this.startCompoundEdit(e.getEdit());
            this.startCombine = false;
            this.updateDirty();
            return;
        }
        if (e.getEdit() instanceof AbstractDocument.DefaultDocumentEvent) {
            AbstractDocument.DefaultDocumentEvent docEvt = (AbstractDocument.DefaultDocumentEvent)e.getEdit();
            int editLine = this.doc.getLineNumberAt(docEvt.getOffset());
            if ((this.startCombine || Math.abs(docEvt.getLength()) == 1) && editLine == this.lastLine) {
                this.compoundEdit.addEdit(e.getEdit());
                this.startCombine = false;
                this.updateDirty();
                return;
            }
            this.lastLine = editLine;
        } else if (this.startCombine && !e.getEdit().isSignificant()) {
            this.compoundEdit.addEdit(e.getEdit());
            this.startCombine = false;
            this.updateDirty();
            return;
        }
        this.compoundEdit.end();
        this.compoundEdit = this.startCompoundEdit(e.getEdit());
        this.updateDirty();
    }

    private void updateDirty() {
        this.doc.setCanUndo(this.canUndo());
        this.doc.setCanRedo(this.canRedo());
    }

    @Override
    protected void undoTo(UndoableEdit edit) throws CannotUndoException {
        super.undoTo(edit);
        this.updateDirty();
    }

    @Override
    public synchronized void undo() throws CannotUndoException {
        super.undo();
        this.updateDirty();
    }

    @Override
    protected void redoTo(UndoableEdit edit) throws CannotRedoException {
        super.redoTo(edit);
        this.updateDirty();
    }

    @Override
    public synchronized void redo() throws CannotRedoException {
        super.redo();
        this.updateDirty();
    }

    @Override
    public synchronized void discardAllEdits() {
        super.discardAllEdits();
        this.updateDirty();
    }

    private CompoundEdit startCompoundEdit(UndoableEdit anEdit) {
        this.compoundEdit = new MyCompoundEdit();
        this.compoundEdit.addEdit(anEdit);
        this.addEdit(this.compoundEdit);
        return this.compoundEdit;
    }

    public void startCombine() {
        this.startCombine = true;
    }

    class MyCompoundEdit
    extends CompoundEdit {
        MyCompoundEdit() {
        }

        @Override
        public boolean isInProgress() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (CompoundUndoMan.this.compoundEdit != null) {
                CompoundUndoMan.this.compoundEdit.end();
            }
            super.undo();
            CompoundUndoMan.this.compoundEdit = null;
        }
    }
}

