/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.tools.conversion.eot;

import com.google.typography.font.sfntly.table.truetype.ControlValueTable;
import java.io.ByteArrayOutputStream;

public class CvtEncoder {
    private static final int CVT_POS8 = 255;
    private static final int CVT_POS1 = 248;
    private static final int CVT_NEG8 = 247;
    private static final int CVT_NEG1 = 240;
    private static final int CVT_NEG0 = 239;
    private static final int CVT_WORDCODE = 238;
    private static final int CVT_LOWESTCODE = 238;
    private ByteArrayOutputStream cvtStream = new ByteArrayOutputStream();

    public void encode(ControlValueTable controlValueTable) {
        int n = controlValueTable.fwordCount();
        this.cvtStream.write(n >> 8);
        this.cvtStream.write(n & 0xFF);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = controlValueTable.fword(i * 2);
            short s = (short)(n3 - n2);
            int n4 = Math.abs(s);
            int n5 = n4 / 238;
            if (n5 <= 8) {
                if (s < 0) {
                    this.cvtStream.write(239 + n5);
                    this.cvtStream.write(n4 - n5 * 238);
                } else {
                    if (n5 > 0) {
                        this.cvtStream.write(248 + n5 - 1);
                    }
                    this.cvtStream.write(n4 - n5 * 238);
                }
            } else {
                this.cvtStream.write(238);
                this.cvtStream.write(s >> 8);
                this.cvtStream.write(s & 0xFF);
            }
            n2 = n3;
        }
    }

    public byte[] toByteArray() {
        return this.cvtStream.toByteArray();
    }
}

