/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table.bitmap;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.bitmap.GlyphMetrics;

public class SmallGlyphMetrics
extends GlyphMetrics {
    private SmallGlyphMetrics(ReadableFontData readableFontData) {
        super(readableFontData);
    }

    public int height() {
        return this.data.readByte(Offset.height.offset);
    }

    public int width() {
        return this.data.readByte(Offset.width.offset);
    }

    public int bearingX() {
        return this.data.readChar(Offset.BearingX.offset);
    }

    public int bearingY() {
        return this.data.readChar(Offset.BearingY.offset);
    }

    public int advance() {
        return this.data.readByte(Offset.Advance.offset);
    }

    public static class Builder
    extends GlyphMetrics.Builder<SmallGlyphMetrics> {
        protected Builder(WritableFontData writableFontData) {
            super(writableFontData);
        }

        protected Builder(ReadableFontData readableFontData) {
            super(readableFontData);
        }

        public int height() {
            return this.internalReadData().readByte(Offset.height.offset);
        }

        public void setHeight(byte by) {
            this.internalWriteData().writeByte(Offset.height.offset, by);
        }

        public int width() {
            return this.internalReadData().readByte(Offset.width.offset);
        }

        public void setWidth(byte by) {
            this.internalWriteData().writeByte(Offset.width.offset, by);
        }

        public int bearingX() {
            return this.internalReadData().readChar(Offset.BearingX.offset);
        }

        public void setBearingX(byte by) {
            this.internalWriteData().writeChar(Offset.BearingX.offset, by);
        }

        public int bearingY() {
            return this.internalReadData().readChar(Offset.BearingY.offset);
        }

        public void setBearingY(byte by) {
            this.internalWriteData().writeChar(Offset.BearingY.offset, by);
        }

        public int advance() {
            return this.internalReadData().readByte(Offset.Advance.offset);
        }

        public void setAdvance(byte by) {
            this.internalWriteData().writeByte(Offset.Advance.offset, by);
        }

        @Override
        protected SmallGlyphMetrics subBuildTable(ReadableFontData readableFontData) {
            return new SmallGlyphMetrics(readableFontData);
        }

        @Override
        protected void subDataSet() {
        }

        @Override
        protected int subDataSizeToSerialize() {
            return 0;
        }

        @Override
        protected boolean subReadyToSerialize() {
            return false;
        }

        @Override
        protected int subSerialize(WritableFontData writableFontData) {
            return this.data().copyTo(writableFontData);
        }
    }

    static enum Offset {
        metricsLength(5),
        height(0),
        width(1),
        BearingX(2),
        BearingY(3),
        Advance(4);

        final int offset;

        private Offset(int n2) {
            this.offset = n2;
        }
    }
}

