/*
 * Decompiled with CFR 0.152.
 */
package com.google.typography.font.sfntly.table;

import com.google.typography.font.sfntly.data.ReadableFontData;
import com.google.typography.font.sfntly.data.WritableFontData;
import com.google.typography.font.sfntly.table.Header;
import com.google.typography.font.sfntly.table.Table;
import com.google.typography.font.sfntly.table.TableBasedTableBuilder;
import java.io.IOException;

public abstract class ByteArrayTableBuilder<T extends Table>
extends TableBasedTableBuilder<T> {
    protected ByteArrayTableBuilder(Header header, WritableFontData writableFontData) {
        super(header, writableFontData);
    }

    protected ByteArrayTableBuilder(Header header, ReadableFontData readableFontData) {
        super(header, readableFontData);
    }

    public int byteValue(int n) throws IOException {
        ReadableFontData readableFontData = this.internalReadData();
        if (readableFontData == null) {
            throw new IOException("No font data for the table.");
        }
        return readableFontData.readByte(n);
    }

    public void setByteValue(int n, byte by) throws IOException {
        WritableFontData writableFontData = this.internalWriteData();
        if (writableFontData == null) {
            throw new IOException("No font data for the table.");
        }
        writableFontData.writeByte(n, by);
    }

    public int byteCount() throws IOException {
        ReadableFontData readableFontData = this.internalReadData();
        if (readableFontData == null) {
            throw new IOException("No font data for the table.");
        }
        return readableFontData.length();
    }
}

