/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ImmediateFuture<V>
implements Future<V> {
    private final V value;
    private final Throwable throwable;
    private final boolean cancelled;

    public ImmediateFuture(V value) {
        this.value = value;
        this.throwable = null;
        this.cancelled = false;
    }

    public ImmediateFuture(V value, Throwable throwable, boolean cancelled) {
        this.value = value;
        this.throwable = throwable;
        this.cancelled = cancelled;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return true;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (this.cancelled) {
            throw new CancellationException();
        }
        if (this.throwable != null) {
            throw new ExecutionException(this.throwable);
        }
        return this.value;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get();
    }
}

