/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class TernarOpItem
extends GraphTargetItem {
    public GraphTargetItem expression;
    public GraphTargetItem onTrue;
    public GraphTargetItem onFalse;

    public TernarOpItem(GraphSourceItem src, GraphSourceItem lineStartIns, GraphTargetItem expression, GraphTargetItem onTrue, GraphTargetItem onFalse) {
        super(src, lineStartIns, 13);
        this.expression = expression;
        this.onTrue = onTrue;
        this.onFalse = onFalse;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.expression);
        visitor.visit(this.onTrue);
        visitor.visit(this.onFalse);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.expression.getPrecedence() >= this.precedence) {
            writer.append("(");
        }
        this.expression.toString(writer, localData);
        if (this.expression.getPrecedence() >= this.precedence) {
            writer.append(")");
        }
        writer.append(" ? ");
        if (this.onTrue.getPrecedence() >= this.precedence && this.onTrue.getPrecedence() != 16) {
            writer.append("(");
        }
        this.onTrue.toString(writer, localData);
        if (this.onTrue.getPrecedence() >= this.precedence && this.onTrue.getPrecedence() != 16) {
            writer.append(")");
        }
        writer.append(" : ");
        if (this.onFalse.getPrecedence() >= this.precedence && this.onFalse.getPrecedence() != 16) {
            writer.append("(");
        }
        this.onFalse.toString(writer, localData);
        if (this.onFalse.getPrecedence() >= this.precedence && this.onFalse.getPrecedence() != 16) {
            writer.append(")");
        }
        return writer;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return generator.generate(localData, this);
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public GraphTargetItem returnType() {
        return this.onTrue.returnType();
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + Objects.hashCode(this.expression);
        hash = 61 * hash + Objects.hashCode(this.onTrue);
        hash = 61 * hash + Objects.hashCode(this.onFalse);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TernarOpItem other = (TernarOpItem)obj;
        if (!Objects.equals(this.expression, other.expression)) {
            return false;
        }
        if (!Objects.equals(this.onTrue, other.onTrue)) {
            return false;
        }
        return Objects.equals(this.onFalse, other.onFalse);
    }
}

