/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.operations.Inverted;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.DuplicateItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.LogicalOpItem;
import com.jpexs.decompiler.graph.model.UnaryOpItem;
import java.util.List;
import java.util.Set;

public class NotItem
extends UnaryOpItem
implements LogicalOpItem,
Inverted {
    public NotItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem value) {
        super(instruction, lineStartIns, 2, value, "!", "Boolean");
    }

    @Override
    public Object getResult() {
        return this.value.getResultAsBoolean() == false;
    }

    public static Boolean getResult(Object obj) {
        boolean ret = EcmaScript.toBoolean(obj);
        if (ret) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        if (dependencies.contains(this.value)) {
            return false;
        }
        dependencies.add(this.value);
        return this.value.isCompileTime(dependencies);
    }

    public GraphTargetItem getOriginal() {
        return this.value;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return generator.generate(localData, this);
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.BOOLEAN;
    }

    @Override
    public GraphTextWriter toStringBoolean(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.value instanceof NotItem) {
            return this.value.value.toStringBoolean(writer, localData);
        }
        return super.toStringBoolean(writer, localData);
    }

    @Override
    public GraphTargetItem invert(GraphSourceItem src) {
        if (this.value instanceof NotItem) {
            return this.value;
        }
        if (!TypeItem.BOOLEAN.equals(this.value.returnType()) && !(this.value instanceof DuplicateItem)) {
            return new NotItem(null, null, this);
        }
        return this.value;
    }
}

