/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph.model;

import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.IntegerValueTypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.Set;

public class IntegerValueItem
extends GraphTargetItem
implements IntegerValueTypeItem {
    private final int intValue;

    public IntegerValueItem(GraphSourceItem src, GraphSourceItem lineStartIns, int value) {
        super(src, lineStartIns, 0);
        this.intValue = value;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) {
        return writer.append(this.intValue);
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        return true;
    }

    @Override
    public Object getResult() {
        return (long)this.intValue;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public int intValue() {
        return this.intValue;
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + this.intValue;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerValueItem other = (IntegerValueItem)obj;
        return this.intValue == other.intValue;
    }
}

