/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.graph.Graph;
import com.jpexs.decompiler.graph.GraphPath;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.decompiler.graph.Loop;
import com.jpexs.decompiler.graph.ThrowState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class GraphPart
implements Serializable {
    public static final int TYPE_NONE = 0;
    public static final int TYPE_LOOP_HEADER = 1;
    public static final int TYPE_PRELOOP = 3;
    public static final int TYPE_REENTRY = 2;
    public boolean traversed = false;
    public int DFSP_pos = 0;
    public GraphPart iloop_header;
    public int type = 0;
    public boolean irreducible = false;
    public int start = 0;
    public int end = 0;
    public int instanceCount = 0;
    public List<GraphPart> nextParts = new ArrayList<GraphPart>();
    public int posX = -1;
    public int posY = -1;
    public GraphPath path = new GraphPath();
    public List<GraphPart> refs = new ArrayList<GraphPart>();
    public boolean ignored = false;
    public List<Object> forContinues = new ArrayList<Object>();
    public int level;
    public int discoveredTime;
    public int finishedTime;
    public int order;

    public int setTime(int time, List<GraphPart> ordered, List<GraphPart> visited) {
        if (visited.contains(this)) {
            return time;
        }
        this.discoveredTime = time;
        visited.add(this);
        for (GraphPart next : this.nextParts) {
            if (visited.contains(next)) continue;
            time = next.setTime(time + 1, ordered, visited);
        }
        this.finishedTime = ++time;
        this.order = ordered.size();
        ordered.add(this);
        return time;
    }

    private boolean leadsTo(BaseLocalData localData, Graph gr, GraphSource code, GraphPart prev, GraphPart part, HashSet<GraphPart> visited, List<Loop> loops, List<ThrowState> throwStates, boolean useThrow) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        GraphPart tpart = gr.checkPart(null, localData, prev, this, null);
        if (tpart == null) {
            return false;
        }
        if (tpart != this) {
            return tpart.leadsTo(localData, gr, code, null, part, visited, loops, throwStates, useThrow);
        }
        Object currentLoop = null;
        for (Loop l : loops) {
            if (l.phase != 1) continue;
            if (l.loopContinue == this) {
                return false;
            }
            if (l.loopPreContinue == this) {
                return false;
            }
            if (l.loopBreak != this) continue;
        }
        if (visited.contains(this)) {
            return false;
        }
        visited.add(this);
        if (this.end < code.size() && code.get(this.end).isBranch() && code.get(this.end).ignoredLoops()) {
            return false;
        }
        for (GraphPart p : this.nextParts) {
            if (p == part) {
                return true;
            }
            if (!p.leadsTo(localData, gr, code, this, part, visited, loops, throwStates, useThrow)) continue;
            return true;
        }
        for (ThrowState ts : throwStates) {
            if (ts.state == 1 || !ts.throwingParts.contains(this)) continue;
            GraphPart p = ts.targetPart;
            if (p == part) {
                return true;
            }
            if (!p.leadsTo(localData, gr, code, this, part, visited, loops, throwStates, useThrow)) continue;
            return true;
        }
        return false;
    }

    public boolean leadsTo(BaseLocalData localData, Graph gr, GraphSource code, GraphPart part, List<Loop> loops, List<ThrowState> throwStates, boolean useThrow) throws InterruptedException {
        for (Loop l : loops) {
            l.leadsToMark = 0;
        }
        return this.leadsTo(localData, gr, code, null, part, new HashSet<GraphPart>(), loops, throwStates, useThrow);
    }

    public GraphPart(int start, int end) {
        this.start = start;
        this.end = end;
    }

    private GraphPart getNextPartPath(GraphPart original, GraphPath path, List<GraphPart> visited) {
        if (visited.contains(this) && this == original) {
            return null;
        }
        if (visited.contains(this) && this != original) {
            return null;
        }
        visited.add(this);
        for (GraphPart p : this.nextParts) {
            GraphPart gp;
            if (p == original) continue;
            if (p.path.equals(path)) {
                return p;
            }
            if (p.path.length() < path.length() || (gp = p.getNextPartPath(original, path, visited)) == null) continue;
            return gp;
        }
        return null;
    }

    public GraphPart getNextPartPath(List<GraphPart> ignored) {
        ArrayList<GraphPart> visited = new ArrayList<GraphPart>();
        visited.addAll(ignored);
        if (visited.contains(this)) {
            visited.remove(this);
        }
        return this.getNextPartPath(this, this.path, visited);
    }

    public GraphPart getNextSuperPartPath(List<GraphPart> ignored) {
        ArrayList<GraphPart> visited = new ArrayList<GraphPart>();
        visited.addAll(ignored);
        return this.getNextSuperPartPath(this, this.path, visited);
    }

    private GraphPart getNextSuperPartPath(GraphPart original, GraphPath path, List<GraphPart> visited) {
        if (visited.contains(this)) {
            return null;
        }
        visited.add(this);
        for (GraphPart p : this.nextParts) {
            if (p == original) continue;
            if (p.path.length() < path.length()) {
                return p;
            }
            GraphPart gp = p.getNextSuperPartPath(original, path, visited);
            if (gp == null) continue;
            return gp;
        }
        return null;
    }

    public String toString() {
        if (this.end < this.start) {
            return "<-> " + (this.start + 1) + "-" + (this.end + 1);
        }
        int printStart = this.start + 1;
        int printEnd = this.end + 1;
        return "" + (printStart < 0 ? "(" : "") + printStart + (printStart < 0 ? ")" : "") + "-" + (printEnd < 0 ? "(" : "") + printEnd + (printEnd < 0 ? ")" : "") + (this.instanceCount > 1 ? "(" + this.instanceCount + " links)" : "");
    }

    public boolean containsIP(int ip) {
        return ip >= this.start && ip <= this.end;
    }

    private boolean containsPart(GraphPart part, GraphPart what, List<GraphPart> used) {
        if (used.contains(part)) {
            return false;
        }
        used.add(part);
        for (GraphPart subpart : part.nextParts) {
            if (subpart == what) {
                return true;
            }
            if (!this.containsPart(subpart, what, used)) continue;
            return true;
        }
        return false;
    }

    public int getHeight() {
        return this.end - this.start + 1;
    }

    public int getPosAt(int offset) {
        return this.start + offset;
    }

    public boolean containsPart(GraphPart what) {
        return this.containsPart(this, what, new ArrayList<GraphPart>());
    }

    public List<GraphPart> getSubParts() {
        ArrayList<GraphPart> ret = new ArrayList<GraphPart>();
        ret.add(this);
        return ret;
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + this.start;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphPart)) {
            return false;
        }
        GraphPart other = (GraphPart)obj;
        if (this.start != other.start) {
            return false;
        }
        return this.end == other.end;
    }

    public static enum StopPartType {
        NONE,
        AND_OR,
        COMMONPART;

    }
}

