/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.FinalProcessLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.swf5.ActionDefineFunction;
import com.jpexs.decompiler.flash.action.swf7.ActionDefineFunction2;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.EqualsTypeItem;
import com.jpexs.decompiler.graph.GraphException;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphPartChangeException;
import com.jpexs.decompiler.graph.GraphPartEdge;
import com.jpexs.decompiler.graph.GraphPartMarkedArrayList;
import com.jpexs.decompiler.graph.GraphPartQueue;
import com.jpexs.decompiler.graph.GraphPath;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemContainer;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.Loop;
import com.jpexs.decompiler.graph.MarkItem;
import com.jpexs.decompiler.graph.SecondPassData;
import com.jpexs.decompiler.graph.SecondPassException;
import com.jpexs.decompiler.graph.StopPartKind;
import com.jpexs.decompiler.graph.ThrowState;
import com.jpexs.decompiler.graph.TranslateException;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.AndItem;
import com.jpexs.decompiler.graph.model.BranchStackResistant;
import com.jpexs.decompiler.graph.model.BreakItem;
import com.jpexs.decompiler.graph.model.CommaExpressionItem;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.DefaultItem;
import com.jpexs.decompiler.graph.model.DoWhileItem;
import com.jpexs.decompiler.graph.model.DuplicateItem;
import com.jpexs.decompiler.graph.model.ExitItem;
import com.jpexs.decompiler.graph.model.FalseItem;
import com.jpexs.decompiler.graph.model.ForItem;
import com.jpexs.decompiler.graph.model.GotoItem;
import com.jpexs.decompiler.graph.model.IfItem;
import com.jpexs.decompiler.graph.model.IntegerValueItem;
import com.jpexs.decompiler.graph.model.IntegerValueTypeItem;
import com.jpexs.decompiler.graph.model.LabelItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.LogicalOpItem;
import com.jpexs.decompiler.graph.model.LoopItem;
import com.jpexs.decompiler.graph.model.NotItem;
import com.jpexs.decompiler.graph.model.OrItem;
import com.jpexs.decompiler.graph.model.PopItem;
import com.jpexs.decompiler.graph.model.PushItem;
import com.jpexs.decompiler.graph.model.ScriptEndItem;
import com.jpexs.decompiler.graph.model.SwitchItem;
import com.jpexs.decompiler.graph.model.TernarOpItem;
import com.jpexs.decompiler.graph.model.TrueItem;
import com.jpexs.decompiler.graph.model.UniversalLoopItem;
import com.jpexs.decompiler.graph.model.WhileItem;
import com.jpexs.decompiler.graph.precontinues.GraphPrecontinueDetector;
import com.jpexs.helpers.Reference;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Graph {
    public List<GraphPart> heads;
    protected GraphSource code;
    private final List<GraphException> exceptions;
    public static final int SOP_USE_STATIC = 0;
    public static final int SOP_SKIP_STATIC = 1;
    public static final int SOP_REMOVE_STATIC = 2;
    private boolean debugPrintAllParts = false;
    private boolean debugPrintLoopList = false;
    private boolean debugGetLoops = false;
    private boolean debugPrintGraph = false;
    private static final Logger logger = Logger.getLogger(Graph.class.getName());
    public static final String INDENTOPEN = "INDENTOPEN";
    public static final String INDENTCLOSE = "INDENTCLOSE";

    public GraphSource getGraphCode() {
        return this.code;
    }

    public LinkedHashMap<String, Graph> getSubGraphs() {
        return new LinkedHashMap<String, Graph>();
    }

    public Graph(GraphSource code, List<GraphException> exceptions) {
        this.code = code;
        this.exceptions = exceptions;
    }

    public void init(BaseLocalData localData) throws InterruptedException {
        if (this.heads != null) {
            return;
        }
        this.heads = this.makeGraph(this.code, new ArrayList<GraphPart>(), this.exceptions);
        int time = 1;
        ArrayList<GraphPart> ordered = new ArrayList<GraphPart>();
        ArrayList<GraphPart> visited = new ArrayList<GraphPart>();
        for (GraphPart head : this.heads) {
            time = head.setTime(time, ordered, visited);
        }
    }

    public List<GraphException> getExceptions() {
        return this.exceptions;
    }

    protected static void populateParts(GraphPart part, Set<GraphPart> allParts) {
        if (allParts.contains(part)) {
            return;
        }
        allParts.add(part);
        for (GraphPart p : part.nextParts) {
            Graph.populateParts(p, allParts);
        }
    }

    public GraphPart deepCopy(GraphPart part) {
        return this.deepCopy(part, new HashMap<GraphPart, GraphPart>());
    }

    private GraphPart deepCopy(GraphPart part, Map<GraphPart, GraphPart> copies) {
        int i;
        GraphPart copy = copies.get(part);
        if (copy != null) {
            return copy;
        }
        copy = new GraphPart(part.start, part.end);
        copy.path = part.path;
        copies.put(part, copy);
        copy.nextParts = new ArrayList<GraphPart>();
        for (i = 0; i < part.nextParts.size(); ++i) {
            copy.nextParts.add(this.deepCopy(part.nextParts.get(i), copies));
        }
        for (i = 0; i < part.refs.size(); ++i) {
            copy.refs.add(this.deepCopy(part.refs.get(i), copies));
        }
        return copy;
    }

    public void resetGraph(GraphPart part, Set<GraphPart> visited) {
        if (visited.contains(part)) {
            return;
        }
        visited.add(part);
        int pos = 0;
        for (GraphPart p : part.nextParts) {
            if (!visited.contains(p)) {
                p.path = part.path.sub(pos, p.end);
            }
            this.resetGraph(p, visited);
            ++pos;
        }
    }

    protected void getReachableParts(BaseLocalData localData, GraphPart part, LinkedHashSet<GraphPart> ret, List<Loop> loops, List<ThrowState> throwStates) {
        this.getReachableParts(localData, part, ret, loops, throwStates, true);
    }

    private void getReachableParts(BaseLocalData localData, GraphPart part, LinkedHashSet<GraphPart> ret, List<Loop> loops, List<ThrowState> throwStates, boolean first) {
        Stack<GraphPartQueue> stack = new Stack<GraphPartQueue>();
        GraphPartQueue queue = new GraphPartQueue();
        queue.add(part);
        stack.add(queue);
        block0: while (!stack.isEmpty()) {
            queue = (GraphPartQueue)stack.peek();
            if (!queue.isEmpty()) {
                part = (GraphPart)queue.remove();
            } else if (queue.currentLoop != null) {
                Loop cLoop = queue.currentLoop;
                part = cLoop.loopBreak;
                queue.currentLoop = null;
                if (ret.contains(part)) continue;
                ret.add(part);
                cLoop.reachableMark = 2;
            } else {
                stack.pop();
                continue;
            }
            for (Loop loop : loops) {
                loop.reachableMark = 0;
            }
            Loop currentLoop = null;
            for (Loop l : loops) {
                if ((l.phase == 1 || l.reachableMark == 1) && (l.loopContinue == part || l.loopBreak == part || l.loopPreContinue == part)) continue block0;
                if (l.reachableMark != 0 || l.loopContinue != part) continue;
                l.reachableMark = 1;
                currentLoop = l;
            }
            GraphPartQueue graphPartQueue = new GraphPartQueue();
            ArrayList<GraphPart> nextParts = new ArrayList<GraphPart>(this.getNextParts(localData, part));
            for (ThrowState ts : throwStates) {
                if (ts.state == 1 || !ts.throwingParts.contains(part)) continue;
                graphPartQueue.add(ts.targetPart);
            }
            block4: for (GraphPart nextRaw : nextParts) {
                GraphPart next = this.checkPart(null, localData, part, nextRaw, null);
                if (next == null) continue;
                for (Loop l : loops) {
                    if (l.phase != 1 && l.reachableMark != 1 || l.loopContinue != next && l.loopBreak != next && l.loopPreContinue != next) continue;
                    continue block4;
                }
                if (ret.contains(next)) continue;
                graphPartQueue.add(next);
            }
            ret.addAll(graphPartQueue);
            if (currentLoop != null && currentLoop.loopBreak != null) {
                graphPartQueue.currentLoop = currentLoop;
            }
            if (graphPartQueue.isEmpty() && graphPartQueue.currentLoop == null) continue;
            stack.add(graphPartQueue);
        }
    }

    public GraphPart getNextCommonPart(BaseLocalData localData, GraphPart part, List<Loop> loops, List<ThrowState> throwStates) throws InterruptedException {
        return this.getCommonPart(localData, part, this.getNextParts(localData, part), loops, throwStates);
    }

    public GraphPart getCommonPart(BaseLocalData localData, GraphPart prev, List<GraphPart> parts, List<Loop> loops, List<ThrowState> throwStates) throws InterruptedException {
        Object p;
        if (parts.isEmpty()) {
            return null;
        }
        ArrayList<GraphPart> loopContinues = new ArrayList<GraphPart>();
        for (Loop l : loops) {
            if (l.phase != 1) continue;
            loopContinues.add(l.loopContinue);
            if (l.loopPreContinue == null) continue;
            loopContinues.add(l.loopPreContinue);
        }
        Iterator<Serializable> iterator = parts.iterator();
        while (iterator.hasNext() && !loopContinues.contains(p = (GraphPart)iterator.next())) {
            boolean common = true;
            for (GraphPart q : parts) {
                if (q == p || q.leadsTo(localData, this, this.code, (GraphPart)p, loops, throwStates, false)) continue;
                common = false;
                break;
            }
            if (!common) continue;
            return p;
        }
        ArrayList<LinkedHashSet<GraphPart>> reachable = new ArrayList<LinkedHashSet<GraphPart>>();
        for (GraphPart p2 : parts) {
            LinkedHashSet<GraphPart> r1 = new LinkedHashSet<GraphPart>();
            this.getReachableParts(localData, p2, r1, loops, throwStates);
            r1.add(p2);
            reachable.add(r1);
        }
        Set first = (Set)reachable.get(0);
        for (GraphPart p3 : first) {
            boolean common = true;
            for (Set set : reachable) {
                if (set.contains(p3)) continue;
                common = false;
                break;
            }
            if (!common) continue;
            if (loopContinues.contains(p3)) {
                return null;
            }
            return p3;
        }
        return null;
    }

    public GraphPart getMostCommonPart(BaseLocalData localData, List<GraphPart> parts, List<Loop> loops, List<ThrowState> throwStates) throws InterruptedException {
        if (parts.isEmpty()) {
            return null;
        }
        HashSet<GraphPart> s = new HashSet<GraphPart>(parts);
        parts = new ArrayList<GraphPart>(s);
        ArrayList<GraphPart> loopContinues = new ArrayList<GraphPart>();
        for (Loop l : loops) {
            if (l.phase != 1) continue;
            loopContinues.add(l.loopContinue);
            loopContinues.add(l.loopPreContinue);
        }
        ArrayList reachable = new ArrayList();
        LinkedHashSet<GraphPart> allReachable = new LinkedHashSet<GraphPart>();
        for (GraphPart p : parts) {
            LinkedHashSet<GraphPart> r1 = new LinkedHashSet<GraphPart>();
            this.getReachableParts(localData, p, r1, loops, throwStates);
            LinkedHashSet<GraphPart> r2 = new LinkedHashSet<GraphPart>();
            r2.add(p);
            r2.addAll(r1);
            reachable.add(r2);
            allReachable.add(p);
            allReachable.addAll(r1);
        }
        int maxCommonLevel = -1;
        GraphPart maxCommonPart = null;
        for (GraphPart r : allReachable) {
            if (loopContinues.contains(r)) continue;
            boolean common = true;
            int commonLevel = 0;
            for (GraphPart p : parts) {
                if (p == r) {
                    ++commonLevel;
                    continue;
                }
                if (!p.leadsTo(localData, this, this.code, r, loops, throwStates, false)) {
                    common = false;
                    continue;
                }
                ++commonLevel;
            }
            if (common) {
                Stack<GraphPart> toProcess = new Stack<GraphPart>();
                HashSet<GraphPart> visited = new HashSet<GraphPart>();
                toProcess.addAll(parts);
                block4: while (!toProcess.isEmpty()) {
                    GraphPart p = (GraphPart)toProcess.pop();
                    if (p == r || loopContinues.contains(p) || visited.contains(p)) continue;
                    visited.add(p);
                    for (GraphPart n : p.nextParts) {
                        if (n == r || loopContinues.contains(n) || visited.contains(n) || n.leadsTo(localData, this, this.code, r, loops, throwStates, false)) continue;
                        common = false;
                        break block4;
                    }
                    toProcess.addAll(p.nextParts);
                }
                if (common) {
                    return r;
                }
            }
            if (commonLevel <= maxCommonLevel) continue;
            maxCommonPart = r;
            maxCommonLevel = commonLevel;
        }
        if (maxCommonLevel <= 1) {
            return null;
        }
        return maxCommonPart;
    }

    public GraphPart getNextNoJump(GraphPart part, BaseLocalData localData) {
        while (this.code.get(part.start).isJump()) {
            part = part.getSubParts().get((int)0).nextParts.get(0);
        }
        return part;
    }

    public static List<GraphTargetItem> translateViaGraph(BaseLocalData localData, String path, GraphSource code, List<GraphException> exceptions, int staticOperation) throws InterruptedException {
        Graph g = new Graph(code, exceptions);
        g.init(localData);
        return g.translate(localData, staticOperation, path);
    }

    protected void afterPopupateAllParts(Set<GraphPart> allParts) {
    }

    protected List<ThrowState> getThrowStates(BaseLocalData localData, Set<GraphPart> allParts) {
        return new ArrayList<ThrowState>();
    }

    public List<GraphTargetItem> translate(BaseLocalData localData, int staticOperation, String path) throws InterruptedException {
        SecondPassData secondPassData;
        HashSet<GraphPart> allParts = new HashSet<GraphPart>();
        for (GraphPart head : this.heads) {
            Graph.populateParts(head, allParts);
        }
        this.afterPopupateAllParts(allParts);
        if (this.debugPrintAllParts) {
            System.err.println("parts:");
            for (GraphPart p : allParts) {
                System.err.print(p);
                if (!this.getNextParts(localData, p).isEmpty()) {
                    System.err.print(", next: ");
                }
                boolean first = true;
                for (GraphPart n : this.getNextParts(localData, p)) {
                    if (!first) {
                        System.err.print(",");
                    }
                    System.err.print(n);
                    first = false;
                }
                System.err.println("");
            }
            System.err.println("/parts");
        }
        TranslateStack stack = new TranslateStack(path);
        List<ThrowState> throwStates = this.getThrowStates(localData, allParts);
        this.beforeGetLoops(localData, path, allParts, throwStates);
        ArrayList<Loop> loops = new ArrayList<Loop>();
        this.getLoops(localData, this.heads.get(0), loops, throwStates, null);
        this.afterGetLoops(localData, path, allParts);
        if (this.debugPrintLoopList) {
            System.err.println("<loops>");
            for (Loop el : loops) {
                System.err.println(el);
            }
            System.err.println("</loops>");
        }
        this.getBackEdges(localData, loops, throwStates);
        new GraphPrecontinueDetector().detectPrecontinues(this.heads, allParts, loops, throwStates);
        ArrayList<GotoItem> gotos = new ArrayList<GotoItem>();
        List<GraphTargetItem> ret = this.printGraph(gotos, new HashMap<GraphPart, List<GraphTargetItem>>(), new HashMap<GraphPart, Integer>(), new HashSet<GraphPart>(), localData, stack, allParts, null, this.heads.get(0), null, null, loops, throwStates, staticOperation, path);
        if (localData.secondPassData == null && (secondPassData = this.prepareSecondPass(ret)) != null) {
            throw new SecondPassException(secondPassData);
        }
        this.processIfGotos2(new ArrayList<List<GraphTargetItem>>(), gotos, ret, ret);
        this.processIfGotos(gotos, ret, ret);
        HashMap<String, Integer> usages = new HashMap<String, Integer>();
        HashMap<String, GotoItem> lastUsage = new HashMap<String, GotoItem>();
        for (GotoItem gi : gotos) {
            if (!usages.containsKey(gi.labelName)) {
                usages.put(gi.labelName, 0);
            }
            usages.put(gi.labelName, (Integer)usages.get(gi.labelName) + 1);
            lastUsage.put(gi.labelName, gi);
        }
        for (String labelName : usages.keySet()) {
            logger.log(Level.FINE, "usage - {0}: {1}", new Object[]{labelName, usages.get(labelName)});
            if ((Integer)usages.get(labelName) != 1) continue;
            ((GotoItem)lastUsage.get((Object)labelName)).labelName = null;
        }
        this.expandGotos(ret);
        this.processIfs(ret);
        this.finalProcessStack(stack, ret, path);
        Graph.makeAllCommands(ret, stack);
        this.finalProcessAll(ret, 0, this.getFinalData(localData, loops, throwStates), path);
        return ret;
    }

    protected void processSwitches(List<GraphTargetItem> list) {
        this.processSwitches(list, -1L);
    }

    protected SecondPassData prepareSecondPass(List<GraphTargetItem> list) {
        return null;
    }

    protected void processSwitches(List<GraphTargetItem> list, long lastLoopId) {
        block0: for (int i = 0; i < list.size(); ++i) {
            List<GraphTargetItem> lastCommands;
            GraphTargetItem item = list.get(i);
            if (!(item instanceof SwitchItem)) continue;
            SwitchItem swi = (SwitchItem)item;
            Set<GraphTargetItem> allItems = swi.getAllSubItemsRecursively();
            int breakCount = 0;
            for (GraphTargetItem it : allItems) {
                if (!(it instanceof BreakItem)) continue;
                BreakItem br = (BreakItem)it;
                if (br.loopId != swi.loop.id || ++breakCount <= 1) continue;
                continue block0;
            }
            if (!swi.caseCommands.isEmpty() && ((lastCommands = swi.caseCommands.get(swi.caseCommands.size() - 1)).isEmpty() && breakCount == 1 || breakCount == 1 && !(lastCommands.get(lastCommands.size() - 1) instanceof ContinueItem) && !(lastCommands.get(lastCommands.size() - 1) instanceof ExitItem))) continue;
            int breakCaseIndex = -1;
            for (int c = 0; c < swi.caseCommands.size(); ++c) {
                List<GraphTargetItem> commands = swi.caseCommands.get(c);
                if (!commands.isEmpty() && commands.get(commands.size() - 1) instanceof BreakItem) {
                    BreakItem br = (BreakItem)commands.get(commands.size() - 1);
                    if (br.loopId == swi.loop.id) {
                        breakCaseIndex = c;
                        break;
                    }
                }
                if (c != swi.caseCommands.size() - 1) continue;
                if (commands.isEmpty()) {
                    breakCaseIndex = c;
                    break;
                }
                if (commands.get(commands.size() - 1) instanceof ContinueItem || commands.get(commands.size() - 1) instanceof ExitItem) continue;
                breakCaseIndex = c;
                break;
            }
            boolean hasContinues = false;
            for (int c = 0; c < swi.caseCommands.size(); ++c) {
                List<GraphTargetItem> commands = swi.caseCommands.get(c);
                if (commands.isEmpty() || !(commands.get(commands.size() - 1) instanceof ContinueItem)) continue;
                ContinueItem cnt = (ContinueItem)commands.get(commands.size() - 1);
                if (cnt.loopId != lastLoopId) continue;
                hasContinues = true;
                commands.set(commands.size() - 1, new BreakItem(null, null, swi.loop.id));
                if (c != swi.caseCommands.size() - 1 || commands.size() != 1) continue;
                commands.remove(0);
            }
            if (!hasContinues || breakCaseIndex <= -1 || i + 1 >= list.size() || !(list.get(list.size() - 1) instanceof ContinueItem)) continue;
            ArrayList<GraphTargetItem> toAdd = new ArrayList<GraphTargetItem>();
            for (int j = i + 1; j < list.size() - 1; ++j) {
                toAdd.add(list.remove(i + 1));
            }
            List<GraphTargetItem> targetCommands = swi.caseCommands.get(breakCaseIndex);
            if (!targetCommands.isEmpty() && targetCommands.get(targetCommands.size() - 1) instanceof BreakItem) {
                targetCommands.remove(targetCommands.size() - 1);
            }
            targetCommands.addAll(toAdd);
            targetCommands.add(new BreakItem(null, null, swi.loop.id));
        }
    }

    protected FinalProcessLocalData getFinalData(BaseLocalData localData, List<Loop> loops, List<ThrowState> throwStates) {
        return new FinalProcessLocalData(loops);
    }

    protected void beforeGetLoops(BaseLocalData localData, String path, Set<GraphPart> allParts, List<ThrowState> throwStates) throws InterruptedException {
    }

    protected void afterGetLoops(BaseLocalData localData, String path, Set<GraphPart> allParts) throws InterruptedException {
    }

    protected boolean isPartEmpty(GraphPart part) {
        return false;
    }

    private String pathToString(Collection<? extends Object> list) {
        ArrayList<String> strs = new ArrayList<String>();
        for (Object object : list) {
            strs.add(object.toString());
        }
        return "[" + String.join((CharSequence)", ", strs) + "]";
    }

    private List<GraphPart> getUnicatePartList(List<GraphPart> list) {
        ArrayList<GraphPart> result = new ArrayList<GraphPart>();
        for (GraphPart p : list) {
            if (result.contains(p)) continue;
            result.add(p);
        }
        return result;
    }

    private List<GraphPart> getUnicateRefsNoThrow(GraphPart part, Set<GraphPartEdge> throwEdges) {
        ArrayList<GraphPart> result = new ArrayList<GraphPart>();
        for (GraphPart r : part.refs) {
            GraphPartEdge edge = new GraphPartEdge(r, part);
            if (throwEdges.contains(edge)) continue;
            result.add(r);
        }
        return this.getUnicatePartList(result);
    }

    private List<GraphPart> getUsableRefs(GraphPart g, List<Loop> loops, List<ThrowState> throwStates) {
        List<GraphPart> ret = this.getUnicatePartList(g.refs);
        for (Loop el : loops) {
            for (GraphPart be : el.backEdges) {
                if (!ret.contains(be)) continue;
                ret.remove(be);
            }
        }
        return ret;
    }

    private void getBackEdges(BaseLocalData localData, List<Loop> loops, List<ThrowState> throwStates) throws InterruptedException {
        this.clearLoops(loops);
        for (Loop el : loops) {
            el.backEdges.clear();
            HashSet<GraphPart> uniqueRefs = new HashSet<GraphPart>(el.loopContinue.refs);
            for (GraphPart r : uniqueRefs) {
                if (!el.loopContinue.leadsTo(localData, this, this.code, r, loops, throwStates, true)) continue;
                el.backEdges.add(r);
            }
            el.phase = 1;
        }
        this.clearLoops(loops);
    }

    public void finalProcessStack(TranslateStack stack, List<GraphTargetItem> output, String path) {
    }

    private void finalProcessAll(List<GraphTargetItem> list, int level, FinalProcessLocalData localData, String path) throws InterruptedException {
        this.finalProcess(list, level, localData, path);
        for (GraphTargetItem item : list) {
            if (!(item instanceof Block)) continue;
            List<List<GraphTargetItem>> subs = ((Block)((Object)item)).getSubs();
            for (List<GraphTargetItem> sub : subs) {
                this.finalProcessAll(sub, level + 1, localData, path);
            }
        }
        this.finalProcessAfter(list, level, localData, path);
    }

    private boolean processSubBlk(Block b, GraphTargetItem replacement) {
        boolean allSubPush = true;
        boolean atleastOne = false;
        for (List<GraphTargetItem> sub : b.getSubs()) {
            if (sub.isEmpty()) continue;
            int lastPos = sub.size() - 1;
            GraphTargetItem last = sub.get(sub.size() - 1);
            GraphTargetItem br = null;
            if (last instanceof BreakItem && sub.size() >= 2) {
                br = last;
                last = sub.get(--lastPos);
            }
            if (last instanceof Block) {
                if (!this.processSubBlk((Block)((Object)last), replacement)) {
                    allSubPush = false;
                    continue;
                }
                atleastOne = true;
                continue;
            }
            if (last instanceof PushItem) {
                if (replacement != null) {
                    GraphTargetItem e2 = replacement.clone();
                    e2.value = last.value;
                    sub.set(lastPos, e2);
                    if (br != null) {
                        sub.remove(sub.size() - 1);
                    }
                }
                atleastOne = true;
                continue;
            }
            if (last instanceof ExitItem) continue;
            allSubPush = false;
        }
        return allSubPush && atleastOne;
    }

    protected void finalProcessAfter(List<GraphTargetItem> list, int level, FinalProcessLocalData localData, String path) {
        if (list.size() >= 2 && list.get(list.size() - 1) instanceof ExitItem) {
            Block b;
            ExitItem e = (ExitItem)((Object)list.get(list.size() - 1));
            if (list.get((int)(list.size() - 1)).value instanceof PopItem && list.get(list.size() - 2) instanceof Block && this.processSubBlk(b = (Block)((Object)list.get(list.size() - 2)), (GraphTargetItem)((Object)e))) {
                list.remove(list.size() - 1);
            }
        }
    }

    protected void finalProcess(List<GraphTargetItem> list, int level, FinalProcessLocalData localData, String path) throws InterruptedException {
        int i;
        boolean[] toDelete = new boolean[list.size()];
        for (i = 0; i < list.size(); ++i) {
            GraphTargetItem itemJ;
            int j;
            WhileItem whi;
            int whileExprLine;
            ArrayList<GraphTargetItem> forFirstCommands;
            ForItem fori;
            int exprLine;
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            GraphTargetItem itemI = list.get(i);
            if (itemI instanceof ForItem && (exprLine = (fori = (ForItem)itemI).getLine()) > 0) {
                forFirstCommands = new ArrayList<GraphTargetItem>();
                for (int j2 = i - 1; j2 >= 0 && list.get(j2).getLine() == exprLine && !(list.get(j2) instanceof LoopItem); --j2) {
                    forFirstCommands.add(0, list.get(j2));
                    toDelete[j2] = true;
                }
                fori.firstCommands.addAll(0, forFirstCommands);
            }
            if (!(itemI instanceof WhileItem) || (whileExprLine = (whi = (WhileItem)itemI).getLine()) <= 0) continue;
            forFirstCommands = new ArrayList();
            ArrayList<GraphTargetItem> forFinalCommands = new ArrayList<GraphTargetItem>();
            for (j = i - 1; j >= 0 && (itemJ = list.get(j)).getLine() == whileExprLine && !(itemJ instanceof LoopItem); --j) {
                forFirstCommands.add(0, itemJ);
                toDelete[j] = true;
            }
            for (j = whi.commands.size() - 1; j >= 0 && whi.commands.get(j).getLine() == whileExprLine && !(whi.commands.get(j) instanceof LoopItem); --j) {
                forFinalCommands.add(0, whi.commands.remove(j));
            }
            if (forFirstCommands.isEmpty() && forFinalCommands.isEmpty()) continue;
            if (forFirstCommands.size() > 2 || forFinalCommands.size() > 2) {
                for (int k = 0; k < forFirstCommands.size(); ++k) {
                    toDelete[i - 1 - k] = false;
                }
                whi.commands.addAll(forFinalCommands);
                continue;
            }
            if (whi.commands.isEmpty() && forFirstCommands.isEmpty()) {
                whi.commands.addAll(forFinalCommands);
                continue;
            }
            GraphTargetItem lastExpr = whi.expression.remove(whi.expression.size() - 1);
            forFirstCommands.addAll(whi.expression);
            list.set(i, new ForItem(whi.getSrc(), whi.getLineStartItem(), whi.loop, forFirstCommands, lastExpr, forFinalCommands, whi.commands));
        }
        for (i = toDelete.length - 1; i >= 0; --i) {
            if (!toDelete[i]) continue;
            list.remove(i);
        }
    }

    private void expandGotos(List<GraphTargetItem> list) {
        if (!list.isEmpty() && list.get(list.size() - 1) instanceof GotoItem) {
            GotoItem gi = (GotoItem)list.get(list.size() - 1);
            if (gi.targetCommands != null) {
                list.remove(gi);
                if (gi.labelName != null) {
                    list.add(new LabelItem(null, gi.lineStartItem, gi.labelName));
                }
                list.addAll(gi.targetCommands);
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            GraphTargetItem item = list.get(i);
            if (!(item instanceof Block)) continue;
            List<List<GraphTargetItem>> subs = ((Block)((Object)item)).getSubs();
            for (List<GraphTargetItem> sub : subs) {
                this.expandGotos(sub);
            }
        }
    }

    private void processIfGotos2(List<List<GraphTargetItem>> alreadyProcessedBlocks, List<GotoItem> allGotos, List<GraphTargetItem> list, List<GraphTargetItem> rootList) {
        block0: for (int i = 0; i < list.size(); ++i) {
            GraphTargetItem item = list.get(i);
            if (item instanceof Block) {
                List<List<GraphTargetItem>> subs = ((Block)((Object)item)).getSubs();
                for (List<GraphTargetItem> sub : subs) {
                    this.processIfGotos2(alreadyProcessedBlocks, allGotos, sub, rootList);
                }
            }
            if (!(item instanceof GotoItem)) continue;
            GotoItem gi = (GotoItem)item;
            for (List<GraphTargetItem> blk : alreadyProcessedBlocks) {
                for (int j = 0; j < blk.size(); ++j) {
                    GraphTargetItem ti = blk.get(j);
                    if (!(ti instanceof LabelItem)) continue;
                    LabelItem label = (LabelItem)ti;
                    if (!label.labelName.equals(gi.labelName)) continue;
                    if (!(blk.get(blk.size() - 1) instanceof ExitItem)) continue block0;
                    int siz = blk.size();
                    for (int k = 0; k < siz - j; ++k) {
                        list.add(i + 1 + k, blk.remove(j));
                    }
                    blk.add(j, list.remove(i));
                    continue block0;
                }
            }
        }
        alreadyProcessedBlocks.add(list);
    }

    private void processIfGotos(List<GotoItem> allGotos, List<GraphTargetItem> list, List<GraphTargetItem> rootList) {
        for (int i = 0; i < list.size(); ++i) {
            GraphTargetItem item = list.get(i);
            if (item instanceof Block) {
                List<List<GraphTargetItem>> subs = ((Block)((Object)item)).getSubs();
                for (List<GraphTargetItem> sub : subs) {
                    this.processIfGotos(allGotos, sub, rootList);
                }
            }
            if (!(item instanceof IfItem)) continue;
            IfItem ii = (IfItem)item;
            if (!ii.onTrue.isEmpty() && !ii.onFalse.isEmpty() && ii.onTrue.get(ii.onTrue.size() - 1) instanceof GotoItem && ii.onFalse.get(ii.onFalse.size() - 1) instanceof GotoItem) {
                for (int j = i + 1; j < list.size(); ++j) {
                    list.remove(i + 1);
                }
            }
            if (!ii.onTrue.isEmpty() && !ii.onFalse.isEmpty() && ii.onTrue.get(ii.onTrue.size() - 1) instanceof GotoItem && ii.onFalse.get(ii.onFalse.size() - 1) instanceof GotoItem) {
                GotoItem gotoOnTrue = (GotoItem)ii.onTrue.get(ii.onTrue.size() - 1);
                GotoItem gotoOnFalse = (GotoItem)ii.onFalse.get(ii.onFalse.size() - 1);
                if (gotoOnTrue.labelName.equals(gotoOnFalse.labelName)) {
                    String labelOnTrue = gotoOnTrue.labelName;
                    String labelOnFalse = gotoOnFalse.labelName;
                    if (labelOnTrue != null && labelOnFalse != null && labelOnTrue.equals(labelOnFalse)) {
                        GotoItem gotoRemoved;
                        GotoItem gotoMerged;
                        if (gotoOnTrue.targetCommands != null) {
                            gotoMerged = gotoOnTrue;
                            gotoRemoved = gotoOnFalse;
                        } else {
                            gotoMerged = gotoOnFalse;
                            gotoRemoved = gotoOnTrue;
                        }
                        ii.onTrue.remove(ii.onTrue.size() - 1);
                        ii.onFalse.remove(ii.onFalse.size() - 1);
                        list.add(i + 1, gotoMerged);
                        allGotos.remove(gotoRemoved);
                    }
                }
            }
            if (ii.onTrue.isEmpty() || !ii.onFalse.isEmpty() || !(ii.onTrue.get(ii.onTrue.size() - 1) instanceof GotoItem)) continue;
            GotoItem g1 = (GotoItem)ii.onTrue.get(ii.onTrue.size() - 1);
            if (i + 1 >= list.size() || !(list.get(i + 1) instanceof GotoItem)) continue;
            GotoItem g2 = (GotoItem)list.get(i + 1);
            if (!g1.labelName.equals(g2.labelName)) continue;
            ii.onTrue.remove(ii.onTrue.size() - 1);
        }
    }

    protected void processIfs(List<GraphTargetItem> list) {
        for (int i = 0; i < list.size(); ++i) {
            GraphTargetItem last;
            List<List<GraphTargetItem>> subs;
            GraphTargetItem item = list.get(i);
            if (item instanceof LoopItem && item instanceof Block) {
                subs = ((Block)((Object)item)).getSubs();
                for (List<GraphTargetItem> sub : subs) {
                    this.processIfs(sub);
                    this.checkContinueAtTheEnd(sub, ((LoopItem)item).loop);
                }
            } else if (item instanceof Block) {
                subs = ((Block)((Object)item)).getSubs();
                for (List<GraphTargetItem> sub : subs) {
                    this.processIfs(sub);
                }
            }
            if (!(item instanceof IfItem)) continue;
            IfItem ifi = (IfItem)item;
            List<GraphTargetItem> onTrue = ifi.onTrue;
            List<GraphTargetItem> onFalse = ifi.onFalse;
            if (!onTrue.isEmpty() && !onFalse.isEmpty() && onTrue.get(onTrue.size() - 1) instanceof ContinueItem && onFalse.get(onFalse.size() - 1) instanceof ContinueItem && ((ContinueItem)onTrue.get((int)(onTrue.size() - 1))).loopId == ((ContinueItem)onFalse.get((int)(onFalse.size() - 1))).loopId) {
                onTrue.remove(onTrue.size() - 1);
                list.add(i + 1, onFalse.remove(onFalse.size() - 1));
            }
            if (i < list.size() - 1 && list.get(i + 1) instanceof ContinueItem && !onTrue.isEmpty() && onFalse.isEmpty() && onTrue.get(onTrue.size() - 1) instanceof ContinueItem && ((ContinueItem)onTrue.get((int)(onTrue.size() - 1))).loopId == ((ContinueItem)list.get((int)(i + 1))).loopId) {
                onTrue.remove(onTrue.size() - 1);
            }
            if (!onTrue.isEmpty() && !onFalse.isEmpty() && ((last = onTrue.get(onTrue.size() - 1)) instanceof ExitItem || last instanceof ContinueItem || last instanceof BreakItem)) {
                list.addAll(i + 1, onFalse);
                onFalse.clear();
            }
            if (!onTrue.isEmpty() && !onFalse.isEmpty() && (onFalse.get(onFalse.size() - 1) instanceof ExitItem || onFalse.get(onFalse.size() - 1) instanceof BreakItem) && onTrue.get(onTrue.size() - 1) instanceof ContinueItem) {
                list.add(i + 1, onTrue.remove(onTrue.size() - 1));
            }
            if (!(onFalse.isEmpty() || !(onFalse.get(onFalse.size() - 1) instanceof BreakItem) && !(onFalse.get(onFalse.size() - 1) instanceof ExitItem) && !(onFalse.get(onFalse.size() - 1) instanceof ContinueItem) || onFalse.get(onFalse.size() - 1) instanceof ScriptEndItem || !onTrue.isEmpty() && (onTrue.get(onTrue.size() - 1) instanceof BreakItem || onTrue.get(onTrue.size() - 1) instanceof ExitItem || onTrue.get(onTrue.size() - 1) instanceof ContinueItem))) {
                ifi.expression = ifi.expression.invert(null);
                ifi.onTrue = onFalse;
                ifi.onFalse = new ArrayList<GraphTargetItem>();
                list.addAll(i + 1, onTrue);
                onFalse = ifi.onFalse;
                onTrue = ifi.onTrue;
            }
            if (i < list.size() - 1 && list.get(i + 1) instanceof BreakItem && onFalse.isEmpty() && !onTrue.isEmpty() && onTrue.get(onTrue.size() - 1) instanceof ContinueItem) {
                ifi.expression = ifi.expression.invert(null);
                list.addAll(i + 2, ifi.onTrue);
                ifi.onTrue.clear();
                ifi.onTrue.add(list.remove(i + 1));
            }
            if (i >= list.size() - 1 || !(list.get(list.size() - 1) instanceof ExitItem) && !(list.get(list.size() - 1) instanceof BreakItem) || !onFalse.isEmpty() || onTrue.isEmpty() || !(onTrue.get(onTrue.size() - 1) instanceof ContinueItem)) continue;
            ifi.expression = ifi.expression.invert(null);
            ArrayList<GraphTargetItem> onTrueItems = new ArrayList<GraphTargetItem>();
            for (int j = i; j < list.size(); ++j) {
                onTrueItems.add(list.remove(i + 1));
            }
            list.addAll(i + 1, ifi.onTrue);
            ifi.onTrue.clear();
            ifi.onTrue.addAll(onTrueItems);
        }
    }

    protected List<GraphPart> getLoopsContinuesPreAndBreaks(List<Loop> loops) {
        ArrayList<GraphPart> ret = new ArrayList<GraphPart>();
        for (Loop l : loops) {
            if (l.loopContinue != null) {
                ret.add(l.loopContinue);
            }
            if (l.loopPreContinue != null) {
                ret.add(l.loopPreContinue);
            }
            if (l.loopBreak == null) continue;
            ret.add(l.loopBreak);
        }
        return ret;
    }

    protected List<GraphPart> getLoopsContinuesAndPre(List<Loop> loops) {
        ArrayList<GraphPart> ret = new ArrayList<GraphPart>();
        for (Loop l : loops) {
            if (l.loopContinue != null) {
                ret.add(l.loopContinue);
            }
            if (l.loopPreContinue == null) continue;
            ret.add(l.loopPreContinue);
        }
        return ret;
    }

    protected List<GraphPart> getLoopsContinues(List<Loop> loops) {
        ArrayList<GraphPart> ret = new ArrayList<GraphPart>();
        for (Loop l : loops) {
            if (l.loopContinue == null) continue;
            ret.add(l.loopContinue);
        }
        return ret;
    }

    protected GraphTargetItem checkLoop(List<GraphTargetItem> output, GraphPart part, List<GraphPart> stopPart, List<Loop> loops, List<ThrowState> throwStates) {
        if (stopPart.contains(part)) {
            return null;
        }
        GraphSourceItem firstIns = null;
        if (part != null && part.start >= 0 && part.start < this.code.size()) {
            firstIns = this.code.get(part.start);
        }
        for (Loop l : loops) {
            if (l.phase == 2) continue;
            if (l.loopContinue == part) {
                return new ContinueItem(null, firstIns, l.id);
            }
            if (l.loopBreak != part) continue;
            return new BreakItem(null, firstIns, l.id);
        }
        return null;
    }

    private void checkContinueAtTheEnd(List<GraphTargetItem> commands, Loop loop) {
        if (!commands.isEmpty()) {
            int i;
            for (i = commands.size() - 1; i >= 0 && (commands.get(i) instanceof ContinueItem || commands.get(i) instanceof BreakItem); --i) {
            }
            if (i < commands.size() - 1) {
                for (int k = i + 2; k < commands.size(); ++k) {
                    commands.remove(k);
                }
            }
            if (commands.get(commands.size() - 1) instanceof ContinueItem && ((ContinueItem)commands.get((int)(commands.size() - 1))).loopId == loop.id) {
                commands.remove(commands.size() - 1);
            }
        }
    }

    protected boolean isEmpty(List<GraphTargetItem> output) {
        if (output.isEmpty()) {
            return true;
        }
        return output.size() == 1 && output.get(0) instanceof MarkItem;
    }

    protected List<GraphTargetItem> check(List<GraphTargetItem> currentRet, List<GotoItem> foundGotos, Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, Set<GraphPart> visited, GraphSource code, BaseLocalData localData, Set<GraphPart> allParts, TranslateStack stack, GraphPart parent, GraphPart part, List<GraphPart> stopPart, List<StopPartKind> stopPartKind, List<Loop> loops, List<ThrowState> throwStates, List<GraphTargetItem> output, Loop currentLoop, int staticOperation, String path) throws InterruptedException {
        return null;
    }

    protected GraphPart checkPartWithOutput(List<GraphTargetItem> output, TranslateStack stack, BaseLocalData localData, GraphPart prev, GraphPart part, Set<GraphPart> allParts) {
        return this.checkPart(stack, localData, prev, part, allParts);
    }

    protected GraphPart checkPart(TranslateStack stack, BaseLocalData localData, GraphPart prev, GraphPart part, Set<GraphPart> allParts) {
        return part;
    }

    protected GraphTargetItem translatePartGetStack(BaseLocalData localData, GraphPart part, TranslateStack stack, int staticOperation) throws InterruptedException, GraphPartChangeException {
        stack = (TranslateStack)stack.clone();
        this.translatePart(localData, part, stack, staticOperation, null);
        return stack.pop();
    }

    protected List<GraphTargetItem> translatePart(BaseLocalData localData, GraphPart part, TranslateStack stack, int staticOperation, String path) throws InterruptedException, GraphPartChangeException {
        List<GraphPart> sub = part.getSubParts();
        ArrayList<GraphTargetItem> ret = new ArrayList<GraphTargetItem>();
        for (GraphPart p : sub) {
            if (p.end == -1) {
                p.end = this.code.size() - 1;
            }
            if (p.start == this.code.size()) continue;
            if (p.end == this.code.size()) {
                // empty if block
            }
            int end = --p.end;
            int start = p.start;
            ret.addAll(this.code.translatePart(part, localData, stack, start, end, staticOperation, path));
        }
        return ret;
    }

    private void markBranchEnd(List<GraphTargetItem> items) {
        if (!items.isEmpty()) {
            if (items.get(items.size() - 1) instanceof BreakItem) {
                return;
            }
            if (items.get(items.size() - 1) instanceof ContinueItem) {
                return;
            }
            if (items.get(items.size() - 1) instanceof ExitItem) {
                return;
            }
        }
        items.add(new MarkItem("finish"));
    }

    private static GraphTargetItem getLastNoEnd(List<GraphTargetItem> list) {
        if (list.isEmpty()) {
            return null;
        }
        if (list.get(list.size() - 1) instanceof ScriptEndItem) {
            if (list.size() >= 2) {
                return list.get(list.size() - 2);
            }
            return list.get(list.size() - 1);
        }
        return list.get(list.size() - 1);
    }

    private static void removeLastNoEnd(List<GraphTargetItem> list) {
        if (list.isEmpty()) {
            return;
        }
        if (list.get(list.size() - 1) instanceof ScriptEndItem) {
            if (list.size() >= 2) {
                list.remove(list.size() - 2);
            }
            return;
        }
        list.remove(list.size() - 1);
    }

    protected List<GraphTargetItem> printGraph(List<GotoItem> foundGotos, Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, Set<GraphPart> visited, BaseLocalData localData, TranslateStack stack, Set<GraphPart> allParts, GraphPart parent, GraphPart part, List<GraphPart> stopPart, List<StopPartKind> stopPartKind, List<Loop> loops, List<ThrowState> throwStates, int staticOperation, String path) throws InterruptedException {
        return this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, parent, part, stopPart, stopPartKind, loops, throwStates, null, staticOperation, path, 0);
    }

    protected GraphTargetItem checkLoop(List<GraphTargetItem> output, LoopItem loopItem, BaseLocalData localData, List<Loop> loops, List<ThrowState> throwStates, TranslateStack stack) {
        return loopItem;
    }

    private void clearLoops(List<Loop> loops) {
        for (Loop l : loops) {
            l.phase = 0;
        }
    }

    private void clearThrowStates(List<ThrowState> throwStates) {
        for (ThrowState ts : throwStates) {
            ts.state = 0;
        }
    }

    private void getLoops(BaseLocalData localData, GraphPart part, List<Loop> loops, List<ThrowState> throwStates, List<GraphPart> stopPart) throws InterruptedException {
        this.clearLoops(loops);
        this.clearThrowStates(throwStates);
        this.getLoopsWalk(localData, part, loops, throwStates, stopPart, true, new ArrayList<GraphPart>(), 0);
        this.clearLoops(loops);
        this.clearThrowStates(throwStates);
    }

    protected boolean canBeBreakCandidate(BaseLocalData localData, GraphPart part, List<ThrowState> throwStates) {
        return true;
    }

    protected void checkGetLoopsPart(GraphPart part) {
    }

    private void findPartsOutsideTry(ThrowState ts, GraphPart part, List<GraphPart> ret, Set<GraphPart> visited) {
        if (visited.contains(part)) {
            return;
        }
        visited.add(part);
        if (!ts.throwingParts.contains(part)) {
            ret.add(part);
            return;
        }
        for (GraphPart n : part.nextParts) {
            this.findPartsOutsideTry(ts, n, ret, visited);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void getLoopsWalk(BaseLocalData localData, GraphPart part, List<Loop> loops, List<ThrowState> throwStates, List<GraphPart> stopPart, boolean first, List<GraphPart> visited, int level) throws InterruptedException {
        void var12_31;
        block66: {
            Loop lastP1;
            block67: {
                if (part == null) {
                    return;
                }
                if ((part = this.checkPart(null, localData, null, part, null)) == null) {
                    return;
                }
                if (!visited.contains(part)) {
                    visited.add(part);
                }
                this.checkGetLoopsPart(part);
                if (this.debugGetLoops) {
                    System.err.println("getloops: " + part);
                }
                lastP1 = null;
                for (Loop loop : loops) {
                    if (loop.phase != 1 || loop.loopBreak != null) continue;
                    if (loop.loopContinue != part) {
                        lastP1 = loop;
                        continue;
                    }
                    lastP1 = null;
                }
                boolean canBeCandidate = true;
                if (lastP1 != null) {
                    for (ThrowState throwState : throwStates) {
                        if (throwState.catchParts.contains(lastP1.loopContinue) || !throwState.catchParts.contains(part)) continue;
                        canBeCandidate = false;
                        break;
                    }
                }
                if (lastP1 == null || !canBeCandidate || !this.canBeBreakCandidate(localData, part, throwStates)) break block66;
                if (!lastP1.breakCandidates.contains(part)) break block67;
                lastP1.breakCandidates.add(part);
                lastP1.breakCandidatesLevels.add(level);
                for (ThrowState throwState : throwStates) {
                    if (!throwState.throwingParts.contains(part)) continue;
                    throwState.state = 1;
                }
                return;
            }
            try {
                ArrayList<Loop> arrayList = new ArrayList<Loop>(loops);
                arrayList.remove(lastP1);
                if (part.leadsTo(localData, this, this.code, lastP1.loopContinue, arrayList, throwStates, true) || lastP1.breakCandidatesLocked != 0) break block66;
                if (this.debugGetLoops) {
                    System.err.println("added breakCandidate " + part + " to " + lastP1);
                }
                lastP1.breakCandidates.add(part);
                lastP1.breakCandidatesLevels.add(level);
            }
            catch (Throwable throwable) {
                for (ThrowState ts : throwStates) {
                    if (!ts.throwingParts.contains(part)) continue;
                    ts.state = 1;
                }
                throw throwable;
            }
            for (ThrowState ts : throwStates) {
                if (!ts.throwingParts.contains(part)) continue;
                ts.state = 1;
            }
            return;
        }
        for (ThrowState throwState : throwStates) {
            if (!throwState.throwingParts.contains(part)) continue;
            throwState.state = 1;
        }
        for (Loop loop : loops) {
            if (loop.loopContinue != part) continue;
            return;
        }
        if (stopPart != null && stopPart.contains(part)) {
            return;
        }
        part.level = level;
        boolean bl = part.leadsTo(localData, this, this.code, part, loops, throwStates, true);
        Object var12_29 = null;
        if (bl) {
            Loop loop = new Loop(loops.size(), part, null);
            loop.phase = 1;
            loops.add(loop);
        }
        for (ThrowState ts : throwStates) {
            GraphPart graphPart;
            if (!ts.throwingParts.contains(part) || visited.contains(graphPart = ts.targetPart)) continue;
            this.getLoopsWalk(localData, graphPart, loops, throwStates, stopPart, false, visited, level);
        }
        if (part.nextParts.size() == 2 && !this.partIsSwitch(part)) {
            ArrayList<GraphPart> arrayList;
            List<GraphPart> nps = part.nextParts;
            GraphPart next = this.getCommonPart(localData, part, nps, loops, throwStates);
            ArrayList<GraphPart> arrayList2 = arrayList = stopPart == null ? new ArrayList<GraphPart>() : new ArrayList<GraphPart>(stopPart);
            if (next != null) {
                arrayList.add(next);
            }
            if (next != nps.get(0)) {
                this.getLoopsWalk(localData, nps.get(0), loops, throwStates, arrayList, false, visited, level + 1);
            }
            if (next != nps.get(1)) {
                this.getLoopsWalk(localData, nps.get(1), loops, throwStates, arrayList, false, visited, level + 1);
            }
            if (next != null) {
                this.getLoopsWalk(localData, next, loops, throwStates, stopPart, false, visited, level);
            }
        } else if (part.nextParts.size() > 2 || this.partIsSwitch(part)) {
            GraphPart next = this.getMostCommonPart(localData, part.nextParts, loops, throwStates);
            for (GraphPart graphPart : part.nextParts) {
                ArrayList<GraphPart> stopPart2;
                ArrayList<GraphPart> arrayList = stopPart2 = stopPart == null ? new ArrayList<GraphPart>() : new ArrayList<GraphPart>(stopPart);
                if (next != null) {
                    stopPart2.add(next);
                }
                for (GraphPart p2 : part.nextParts) {
                    if (p2 == graphPart || stopPart2.contains(p2)) continue;
                    stopPart2.add(p2);
                }
                if (next == graphPart) continue;
                this.getLoopsWalk(localData, graphPart, loops, throwStates, stopPart2, false, visited, level + 1);
            }
            if (next != null) {
                this.getLoopsWalk(localData, next, loops, throwStates, stopPart, false, visited, level);
            }
        } else if (part.nextParts.size() == 1) {
            this.getLoopsWalk(localData, part.nextParts.get(0), loops, throwStates, stopPart, false, visited, level);
        }
        if (bl && var12_31 != null) {
            GraphPart found;
            for (int i = 0; i < var12_31.breakCandidates.size(); ++i) {
                GraphPart graphPart = this.checkPart(null, localData, null, var12_31.breakCandidates.get(i), null);
                if (graphPart != null) continue;
                var12_31.breakCandidates.remove(i);
                var12_31.breakCandidatesLevels.remove(i);
                --i;
            }
            if (this.debugGetLoops) {
                System.err.println("loop " + var12_31 + " break candidates:");
                for (GraphPart graphPart : var12_31.breakCandidates) {
                    System.err.println("- " + graphPart);
                }
            }
            ArrayList<Integer> contThrowStates = new ArrayList<Integer>();
            for (ThrowState ts : throwStates) {
                if (!ts.throwingParts.contains(var12_31.loopContinue)) continue;
                contThrowStates.add(ts.exceptionId);
            }
            HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
            block16: for (int c = 0; c < var12_31.breakCandidates.size(); ++c) {
                GraphPart cand = var12_31.breakCandidates.get(c);
                ArrayList<Integer> candThrowStates = new ArrayList<Integer>();
                for (ThrowState ts : throwStates) {
                    if (!ts.throwingParts.contains(cand) || ts.startPart == cand) continue;
                    if (contThrowStates.equals(candThrowStates)) {
                        if (this.debugGetLoops) {
                            System.err.println("candidate " + cand + " is in inner try, getting outside parts");
                        }
                        ArrayList<GraphPart> outsideTry = new ArrayList<GraphPart>();
                        this.findPartsOutsideTry(ts, cand, outsideTry, new HashSet<GraphPart>());
                        for (int j = outsideTry.size() - 1; j >= 0; --j) {
                            if (this.canBeBreakCandidate(localData, (GraphPart)outsideTry.get(j), throwStates)) continue;
                            outsideTry.remove(j);
                        }
                        if (this.debugGetLoops) {
                            for (GraphPart op : outsideTry) {
                                System.err.println("- outsidepart " + op);
                            }
                        }
                        int bcLevel = var12_31.breakCandidatesLevels.get(c);
                        var12_31.breakCandidates.remove(c);
                        var12_31.breakCandidates.addAll(c, outsideTry);
                        var12_31.breakCandidatesLevels.remove(c);
                        hashMap.put(cand, bcLevel);
                        for (int j = 0; j < outsideTry.size(); ++j) {
                            var12_31.breakCandidatesLevels.add(c, bcLevel);
                        }
                        --c;
                        continue block16;
                    }
                    candThrowStates.add(ts.exceptionId);
                }
            }
            do {
                found = null;
                block22: for (int c1 = 0; c1 < var12_31.breakCandidates.size(); ++c1) {
                    GraphPart cand = var12_31.breakCandidates.get(c1);
                    for (int c2 = 0; c2 < var12_31.breakCandidates.size(); ++c2) {
                        int curLev;
                        Object other;
                        GraphPart cand2 = var12_31.breakCandidates.get(c2);
                        if (cand == cand2 || !cand.leadsTo(localData, this, this.code, cand2, loops, throwStates, true)) continue;
                        int curLevl = var12_31.breakCandidatesLevels.get(c1);
                        int curLev2 = var12_31.breakCandidatesLevels.get(c2);
                        int lev1 = Integer.MAX_VALUE;
                        int lev2 = Integer.MAX_VALUE;
                        for (int i = 0; i < var12_31.breakCandidates.size(); ++i) {
                            if (var12_31.breakCandidates.get(i) == cand && var12_31.breakCandidatesLevels.get(i) < lev1) {
                                lev1 = var12_31.breakCandidatesLevels.get(i);
                            }
                            if (var12_31.breakCandidates.get(i) != cand2 || var12_31.breakCandidatesLevels.get(i) >= lev2) continue;
                            lev2 = var12_31.breakCandidatesLevels.get(i);
                        }
                        if (lev1 <= lev2) {
                            found = cand2;
                            other = cand;
                            curLev = curLevl;
                        } else {
                            found = cand;
                            other = cand2;
                            curLev = curLev2;
                        }
                        var12_31.breakCandidates.add((GraphPart)other);
                        var12_31.breakCandidatesLevels.add(curLev);
                        break block22;
                    }
                }
                if (found == null) continue;
                int maxlevel = 0;
                while (var12_31.breakCandidates.contains(found)) {
                    int ind = var12_31.breakCandidates.indexOf(found);
                    var12_31.breakCandidates.remove(ind);
                    int lev = var12_31.breakCandidatesLevels.remove(ind);
                    if (lev <= maxlevel) continue;
                    maxlevel = lev;
                }
                if (hashMap.containsKey(found) && (Integer)hashMap.get(found) > maxlevel) {
                    maxlevel = (Integer)hashMap.get(found);
                }
                hashMap.put(found, maxlevel);
            } while (found != null && var12_31.breakCandidates.size() > 1);
            HashMap<GraphPart, Integer> count = new HashMap<GraphPart, Integer>();
            GraphPart winner = null;
            int winnerCount = 0;
            for (GraphPart cand : var12_31.breakCandidates) {
                if (!count.containsKey(cand)) {
                    count.put(cand, 0);
                }
                count.put(cand, (Integer)count.get(cand) + 1);
                boolean otherBreakCandidate = false;
                for (Loop el : loops) {
                    if (el == var12_31 || !el.breakCandidates.contains(cand)) continue;
                    otherBreakCandidate = true;
                    break;
                }
                if (otherBreakCandidate) continue;
                if ((Integer)count.get(cand) > winnerCount) {
                    winnerCount = (Integer)count.get(cand);
                    winner = cand;
                    continue;
                }
                if ((Integer)count.get(cand) != winnerCount || winner == null || cand.path.length() >= winner.path.length()) continue;
                winner = cand;
            }
            for (int i = 0; i < var12_31.breakCandidates.size(); ++i) {
                GraphPart cand = var12_31.breakCandidates.get(i);
                if (cand == winner) continue;
                int lev = var12_31.breakCandidatesLevels.get(i);
                if (hashMap.containsKey(cand) && (Integer)hashMap.get(cand) > lev) {
                    lev = (Integer)hashMap.get(cand);
                }
                hashMap.put(cand, lev);
            }
            var12_31.loopBreak = winner;
            var12_31.phase = 2;
            boolean start = false;
            for (int l = 0; l < loops.size(); ++l) {
                Loop el = loops.get(l);
                if (start) {
                    el.phase = 1;
                }
                if (el != var12_31) continue;
                start = true;
            }
            ArrayList<GraphPart> removedVisited = new ArrayList<GraphPart>();
            for (GraphPart r : hashMap.keySet()) {
                if (removedVisited.contains(r)) continue;
                this.getLoopsWalk(localData, r, loops, throwStates, stopPart, false, visited, (Integer)hashMap.get(r));
                removedVisited.add(r);
            }
            start = false;
            for (int l = 0; l < loops.size(); ++l) {
                Loop el = loops.get(l);
                if (el == var12_31) {
                    start = true;
                }
                if (!start) continue;
                el.phase = 2;
            }
            this.getLoopsWalk(localData, var12_31.loopBreak, loops, throwStates, stopPart, false, visited, level);
        }
    }

    private void getContinuesCommands(List<GraphTargetItem> commands, List<List<GraphTargetItem>> result, long loopId) {
        for (GraphTargetItem ti : commands) {
            if (ti instanceof ContinueItem) {
                ContinueItem ci = (ContinueItem)ti;
                if (ci.loopId == loopId) {
                    result.add(commands);
                }
            }
            if (!(ti instanceof Block)) continue;
            Block bl = (Block)((Object)ti);
            for (List<GraphTargetItem> subCommands : bl.getSubs()) {
                this.getContinuesCommands(subCommands, result, loopId);
            }
        }
    }

    protected List<GraphPart> getNextParts(BaseLocalData localData, GraphPart part) {
        return part.nextParts;
    }

    protected boolean checkPartOutput(List<GraphTargetItem> currentRet, List<GotoItem> foundGotos, Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, Set<GraphPart> visited, GraphSource code, BaseLocalData localData, Set<GraphPart> allParts, TranslateStack stack, GraphPart parent, GraphPart part, List<GraphPart> stopPart, List<StopPartKind> stopPartKind, List<Loop> loops, List<ThrowState> throwStates, Loop currentLoop, int staticOperation, String path, int recursionLevel) throws InterruptedException {
        return false;
    }

    protected boolean partIsLoopContBrePre(GraphPart part, List<Loop> loops, List<ThrowState> throwStates) {
        for (Loop el : loops) {
            if (el.phase != 1) continue;
            if (el.loopBreak == part) {
                return true;
            }
            if (el.loopContinue == part) {
                return true;
            }
            if (el.loopPreContinue != part) continue;
            return true;
        }
        return false;
    }

    protected boolean canHandleLoop(BaseLocalData localData, GraphPart part, List<Loop> loops, List<ThrowState> throwStates) {
        return true;
    }

    protected boolean canHandleVisited(BaseLocalData localData, GraphPart part) {
        return true;
    }

    protected boolean canBeCommaised(List<GraphTargetItem> list) {
        for (GraphTargetItem item : list) {
            if (!(item instanceof Block)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<GraphTargetItem> printGraph(List<GotoItem> foundGotos, Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, Set<GraphPart> visited, BaseLocalData localData, TranslateStack stack, Set<GraphPart> allParts, GraphPart parent, GraphPart part, List<GraphPart> stopPart, List<StopPartKind> stopPartKind, List<Loop> loops, List<ThrowState> throwStates, List<GraphTargetItem> ret, int staticOperation, String path, int recursionLevel) throws InterruptedException {
        TranslateStack sPreLoop;
        UniversalLoopItem loopItem;
        Loop currentLoop;
        boolean isLoop;
        block165: {
            GraphPart nextOnePart;
            List<GraphTargetItem> currentRet;
            block166: {
                ContinueItem addAfterIf;
                Object next;
                block168: {
                    boolean isIf;
                    List<GraphTargetItem> onFalse;
                    List<GraphTargetItem> onTrue;
                    List<GraphPart> nps;
                    GraphTargetItem expr;
                    block164: {
                        block169: {
                            GraphTargetItem prevExpr;
                            block173: {
                                boolean hideEmptyTrueFalse;
                                GraphTargetItem leftSide;
                                GraphTargetItem rightSide;
                                block172: {
                                    block171: {
                                        block170: {
                                            ArrayList<GraphTargetItem> filteredOnFalse;
                                            ArrayList<GraphTargetItem> filteredOnTrue;
                                            block167: {
                                                GraphTargetItem ternarOnFalse;
                                                GraphTargetItem ternarOnTrue;
                                                if (Thread.currentThread().isInterrupted()) {
                                                    throw new InterruptedException();
                                                }
                                                if (stopPart == null) {
                                                    stopPart = new ArrayList<GraphPart>();
                                                }
                                                if (stopPartKind == null) {
                                                    stopPartKind = new ArrayList<StopPartKind>();
                                                }
                                                if (recursionLevel > allParts.size() + 1) {
                                                    throw new TranslateException("printGraph max recursion level reached.");
                                                }
                                                if (ret == null) {
                                                    ret = new GraphPartMarkedArrayList();
                                                }
                                                if (this.debugPrintGraph) {
                                                    System.err.println("PART " + part + " nextsize:" + this.getNextParts(localData, part).size());
                                                }
                                                if (part == null) {
                                                    return ret;
                                                }
                                                if ((part = this.checkPartWithOutput(ret, stack, localData, parent, part, allParts)) == null) {
                                                    return ret;
                                                }
                                                if (part.ignored) {
                                                    return ret;
                                                }
                                                isLoop = false;
                                                currentLoop = null;
                                                boolean vCanHandleLoop = this.canHandleLoop(localData, part, loops, throwStates);
                                                Loop ignoredLoop = null;
                                                for (Loop el : loops) {
                                                    if (el.loopContinue != part || el.phase != 0) continue;
                                                    if (vCanHandleLoop) {
                                                        currentLoop = el;
                                                        currentLoop.phase = 1;
                                                        isLoop = true;
                                                        break;
                                                    }
                                                    ignoredLoop = el;
                                                    break;
                                                }
                                                if (isLoop) {
                                                    Graph.makeAllCommands(ret, stack);
                                                }
                                                if (this.debugPrintGraph) {
                                                    System.err.println("loopsize:" + loops.size());
                                                }
                                                for (int l = loops.size() - 1; l >= 0; --l) {
                                                    Loop el;
                                                    el = loops.get(l);
                                                    if (el == ignoredLoop) {
                                                        if (!this.debugPrintGraph) continue;
                                                        System.err.println("ignoring to be loop " + el);
                                                        continue;
                                                    }
                                                    if (el == currentLoop) {
                                                        if (!this.debugPrintGraph) continue;
                                                        System.err.println("ignoring current loop " + el);
                                                        continue;
                                                    }
                                                    if (el.phase != 1) {
                                                        if (!this.debugPrintGraph) continue;
                                                        System.err.println("ignoring loop " + el);
                                                        continue;
                                                    }
                                                    if (el.loopBreak == part) {
                                                        if (currentLoop != null) {
                                                            currentLoop.phase = 0;
                                                        }
                                                        if (this.debugPrintGraph) {
                                                            System.err.println("Adding break");
                                                        }
                                                        ret.add(new BreakItem(null, localData.lineStartInstruction, el.id));
                                                        return ret;
                                                    }
                                                    if (el.loopPreContinue == part) {
                                                        if (currentLoop != null) {
                                                            currentLoop.phase = 0;
                                                        }
                                                        if (this.debugPrintGraph) {
                                                            System.err.println("Adding precontinue");
                                                        }
                                                        ret.add(new ContinueItem(null, localData.lineStartInstruction, el.id));
                                                        return ret;
                                                    }
                                                    if (el.loopContinue != part) continue;
                                                    if (currentLoop != null) {
                                                        currentLoop.phase = 0;
                                                    }
                                                    if (this.debugPrintGraph) {
                                                        System.err.println("Adding continue");
                                                    }
                                                    ret.add(new ContinueItem(null, localData.lineStartInstruction, el.id));
                                                    return ret;
                                                }
                                                if (this.debugPrintGraph) {
                                                    System.err.println("stopParts: " + this.pathToString(stopPart));
                                                }
                                                if (stopPart.contains(part)) {
                                                    boolean hasBlockClosesAfter = false;
                                                    block4: for (int i = 0; i < stopPartKind.size(); ++i) {
                                                        if (stopPart.get(i) != part) continue;
                                                        for (int j = i + 1; j < stopPartKind.size(); ++j) {
                                                            if (stopPart.get(j) == part || stopPartKind.get(j) != StopPartKind.BLOCK_CLOSE) continue;
                                                            hasBlockClosesAfter = true;
                                                            break block4;
                                                        }
                                                    }
                                                    if (!hasBlockClosesAfter) {
                                                        if (currentLoop != null) {
                                                            currentLoop.phase = 0;
                                                        }
                                                        if (this.debugPrintGraph) {
                                                            System.err.println("Stopped on part " + part);
                                                        }
                                                        return ret;
                                                    }
                                                }
                                                if (this.code.size() <= part.start) {
                                                    ret.add(new ScriptEndItem());
                                                    return ret;
                                                }
                                                boolean vCanHandleVisited = this.canHandleVisited(localData, part);
                                                if (vCanHandleVisited) {
                                                    if (visited.contains(part)) {
                                                        String labelName = "addr" + part.start;
                                                        List<GraphTargetItem> firstCode = partCodes.get(part);
                                                        int firstCodePos = partCodePos.get(part);
                                                        if (firstCodePos > firstCode.size()) {
                                                            firstCodePos = firstCode.size();
                                                        }
                                                        if (firstCode instanceof GraphPartMarkedArrayList) {
                                                            GraphPartMarkedArrayList markedFirstCode = (GraphPartMarkedArrayList)firstCode;
                                                            firstCodePos = markedFirstCode.indexOfPart(part);
                                                            if (firstCodePos == -1) {
                                                                firstCodePos = firstCode.size();
                                                            }
                                                            ((GraphPartMarkedArrayList)firstCode).startPart(part);
                                                        }
                                                        if (firstCode.size() > firstCodePos && firstCode.get(firstCodePos) instanceof LabelItem) {
                                                            labelName = ((LabelItem)firstCode.get((int)firstCodePos)).labelName;
                                                        } else {
                                                            firstCode.add(firstCodePos, new LabelItem(null, localData.lineStartInstruction, labelName));
                                                        }
                                                        ret.add(new GotoItem(null, localData.lineStartInstruction, labelName));
                                                        return ret;
                                                    }
                                                    visited.add(part);
                                                    partCodes.put(part, ret);
                                                    partCodePos.put(part, ret.size());
                                                }
                                                currentRet = ret;
                                                loopItem = null;
                                                sPreLoop = stack;
                                                if (isLoop) {
                                                    GraphTargetItem topBsr = !(stack = (TranslateStack)stack.clone()).isEmpty() && stack.peek() instanceof BranchStackResistant ? stack.peek() : null;
                                                    stack.clear();
                                                    if (topBsr != null) {
                                                        stack.push(topBsr);
                                                    }
                                                    loopItem = new UniversalLoopItem(null, localData.lineStartInstruction, currentLoop, new ArrayList<GraphTargetItem>());
                                                    currentRet.add(loopItem);
                                                    currentRet = loopItem.commands;
                                                }
                                                boolean parseNext = true;
                                                if (stack.isEmpty() && currentRet instanceof GraphPartMarkedArrayList) {
                                                    ((GraphPartMarkedArrayList)currentRet).clearCurrentParts();
                                                }
                                                GraphPartMarkedArrayList<GraphTargetItem> output = new GraphPartMarkedArrayList<GraphTargetItem>();
                                                output.startPart(part);
                                                if (currentRet instanceof GraphPartMarkedArrayList) {
                                                    ((GraphPartMarkedArrayList)currentRet).startPart(part);
                                                }
                                                if (this.checkPartOutput(currentRet, foundGotos, partCodes, partCodePos, visited, this.code, localData, allParts, stack, parent, part, stopPart, stopPartKind, loops, throwStates, currentLoop, staticOperation, path, recursionLevel)) {
                                                    parseNext = false;
                                                } else {
                                                    boolean exHappened = false;
                                                    int ipStart = part.start;
                                                    block6: do {
                                                        exHappened = false;
                                                        try {
                                                            output.addAll(this.code.translatePart(part, localData, stack, ipStart, part.end, staticOperation, path));
                                                        }
                                                        catch (GraphPartChangeException ex) {
                                                            output.addAll(ex.getOutput());
                                                            for (GraphPart p : allParts) {
                                                                if (!p.containsIP(ex.getIp())) continue;
                                                                if (ex.getIp() == p.start) {
                                                                    currentRet.addAll(output);
                                                                    part = p;
                                                                    return this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, parent, part, stopPart, stopPartKind, loops, throwStates, ret, staticOperation, path, recursionLevel);
                                                                }
                                                                exHappened = true;
                                                                ipStart = ex.getIp();
                                                                part = p;
                                                                continue block6;
                                                            }
                                                        }
                                                    } while (exHappened);
                                                    if (part.end >= this.code.size() - 1 && this.getNextParts(localData, part).isEmpty()) {
                                                        output.add(new ScriptEndItem());
                                                    }
                                                }
                                                if (parseNext) {
                                                    List<GraphTargetItem> retCheck = this.check(currentRet, foundGotos, partCodes, partCodePos, visited, this.code, localData, allParts, stack, parent, part, stopPart, stopPartKind, loops, throwStates, output, currentLoop, staticOperation, path);
                                                    if (retCheck != null) {
                                                        if (!retCheck.isEmpty()) {
                                                            currentRet.addAll(retCheck);
                                                        }
                                                        parseNext = false;
                                                    } else {
                                                        currentRet.addAll(output);
                                                    }
                                                }
                                                if (!parseNext) break block165;
                                                if (this.getNextParts(localData, part).size() > 2 || this.partIsSwitch(part)) {
                                                    GraphTargetItem originalSwitchedItem = stack.pop();
                                                    Graph.makeAllCommands(currentRet, stack);
                                                    GraphTargetItem switchedItem = originalSwitchedItem;
                                                    if (switchedItem instanceof PopItem && !currentRet.isEmpty() && currentRet.get(currentRet.size() - 1) instanceof IfItem) {
                                                        switchedItem = currentRet.get(currentRet.size() - 1);
                                                    }
                                                    ArrayList<GraphTargetItem> caseValues = new ArrayList<GraphTargetItem>();
                                                    ArrayList caseCommands = new ArrayList();
                                                    ArrayList valueMappings = new ArrayList();
                                                    boolean first = false;
                                                    HashMap caseExpressions = new HashMap();
                                                    HashMap<Integer, GraphTargetItem> caseExpressionLeftSides = new HashMap<Integer, GraphTargetItem>();
                                                    HashMap<Integer, GraphTargetItem> caseExpressionRightSides = new HashMap<Integer, GraphTargetItem>();
                                                    GraphTargetItem it = switchedItem;
                                                    int defaultBranch = 0;
                                                    boolean hasExpr = false;
                                                    ArrayList<GraphTargetItem> commaCommands = new ArrayList<GraphTargetItem>();
                                                    HashMap<Integer, ArrayList<GraphTargetItem>> caseCommaCommands = new HashMap<Integer, ArrayList<GraphTargetItem>>();
                                                    while (it instanceof TernarOpItem || it instanceof IfItem) {
                                                        int cpos;
                                                        if (it instanceof IfItem) {
                                                            IfItem ii = (IfItem)it;
                                                            if (ii.expression instanceof EqualsTypeItem) {
                                                                if (ii.onFalse.isEmpty() || ii.onTrue.isEmpty() || !(ii.onTrue.get(ii.onTrue.size() - 1) instanceof PushItem) || !(ii.onTrue.get((int)(ii.onTrue.size() - 1)).value instanceof IntegerValueTypeItem)) break;
                                                                cpos = ((IntegerValueTypeItem)((Object)ii.onTrue.get((int)(ii.onTrue.size() - 1)).value)).intValue();
                                                                caseCommaCommands.put(cpos, commaCommands);
                                                                caseExpressionLeftSides.put(cpos, ((EqualsTypeItem)((Object)ii.expression)).getLeftSide());
                                                                caseExpressionRightSides.put(cpos, ((EqualsTypeItem)((Object)ii.expression)).getRightSide());
                                                                commaCommands = new ArrayList();
                                                                for (int f = 0; f < ii.onFalse.size() - 1; ++f) {
                                                                    commaCommands.add(ii.onFalse.get(f));
                                                                }
                                                                it = ii.onFalse.get(ii.onFalse.size() - 1);
                                                                if (!(it instanceof PushItem)) continue;
                                                                it = it.value;
                                                                continue;
                                                            }
                                                            if (ii.expression instanceof FalseItem && !ii.onFalse.isEmpty()) {
                                                                it = ii.onFalse.get(ii.onFalse.size() - 1);
                                                                continue;
                                                            }
                                                            if (!(ii.expression instanceof TrueItem) || ii.onTrue.isEmpty()) break;
                                                            it = ii.onTrue.get(ii.onTrue.size() - 1);
                                                            continue;
                                                        }
                                                        if (!(it instanceof TernarOpItem)) continue;
                                                        TernarOpItem to = (TernarOpItem)it;
                                                        if (to.expression instanceof EqualsTypeItem) {
                                                            if (!(to.onTrue instanceof IntegerValueTypeItem)) break;
                                                            cpos = ((IntegerValueTypeItem)((Object)to.onTrue)).intValue();
                                                            caseExpressionLeftSides.put(cpos, ((EqualsTypeItem)((Object)to.expression)).getLeftSide());
                                                            caseExpressionRightSides.put(cpos, ((EqualsTypeItem)((Object)to.expression)).getRightSide());
                                                            caseCommaCommands.put(cpos, commaCommands);
                                                            commaCommands = new ArrayList();
                                                            it = to.onFalse;
                                                            if (!(it instanceof CommaExpressionItem)) continue;
                                                            commaCommands = new ArrayList();
                                                            CommaExpressionItem ce = (CommaExpressionItem)it;
                                                            for (int f = 0; f < ce.commands.size() - 1; ++f) {
                                                                commaCommands.add(ce.commands.get(f));
                                                            }
                                                            it = ce.commands.get(ce.commands.size() - 1);
                                                            continue;
                                                        }
                                                        if (to.expression instanceof FalseItem) {
                                                            it = to.onFalse;
                                                            continue;
                                                        }
                                                        if (!(to.expression instanceof TrueItem)) break;
                                                        it = to.onTrue;
                                                    }
                                                    if (switchedItem != originalSwitchedItem && !caseExpressionRightSides.isEmpty()) {
                                                        currentRet.remove(currentRet.size() - 1);
                                                    } else {
                                                        switchedItem = originalSwitchedItem;
                                                    }
                                                    if (it instanceof IntegerValueTypeItem && !(switchedItem instanceof IntegerValueTypeItem)) {
                                                        defaultBranch = ((IntegerValueTypeItem)((Object)it)).intValue();
                                                    }
                                                    HashMap caseExpressionOtherSides = caseExpressions;
                                                    if (!caseExpressionRightSides.isEmpty()) {
                                                        GraphTargetItem firstItem = (GraphTargetItem)caseExpressionRightSides.values().toArray()[0];
                                                        boolean sameRight = true;
                                                        for (Object cit : caseExpressionRightSides.values()) {
                                                            if (cit.equals(firstItem)) continue;
                                                            sameRight = false;
                                                            break;
                                                        }
                                                        if (sameRight) {
                                                            caseExpressions = caseExpressionLeftSides;
                                                            caseExpressionOtherSides = caseExpressionRightSides;
                                                            switchedItem = firstItem;
                                                            hasExpr = true;
                                                        } else {
                                                            firstItem = (GraphTargetItem)caseExpressionLeftSides.values().toArray()[0];
                                                            boolean sameLeft = true;
                                                            for (GraphTargetItem cit : caseExpressionLeftSides.values()) {
                                                                if (cit.equals(firstItem)) continue;
                                                                sameLeft = false;
                                                                break;
                                                            }
                                                            if (sameLeft) {
                                                                caseExpressions = caseExpressionRightSides;
                                                                caseExpressionOtherSides = caseExpressionLeftSides;
                                                                switchedItem = firstItem;
                                                                hasExpr = true;
                                                            }
                                                        }
                                                    }
                                                    first = true;
                                                    int pos = 0;
                                                    GraphPart defaultPart = hasExpr ? this.getNextParts(localData, part).get(1 + defaultBranch) : this.getNextParts(localData, part).get(0);
                                                    ArrayList<GraphPart> caseBodyParts = new ArrayList<GraphPart>();
                                                    for (int i = 1; i < this.getNextParts(localData, part).size(); ++i) {
                                                        if (!hasExpr) {
                                                            if (this.getNextParts(localData, part).get(i) == defaultPart) {
                                                                ++pos;
                                                                continue;
                                                            }
                                                            caseValues.add(new IntegerValueItem(null, localData.lineStartInstruction, pos));
                                                        } else if (caseExpressions.containsKey(pos)) {
                                                            GraphTargetItem expr2 = (GraphTargetItem)caseExpressions.get(pos);
                                                            if (((List)caseCommaCommands.get(pos)).size() > 0) {
                                                                ArrayList<GraphTargetItem> exprCommaCommands = new ArrayList<GraphTargetItem>((Collection)caseCommaCommands.get(pos));
                                                                exprCommaCommands.add(expr2);
                                                                expr2 = new CommaExpressionItem(null, expr2.lineStartItem, exprCommaCommands);
                                                            }
                                                            caseValues.add(expr2);
                                                        } else {
                                                            ++pos;
                                                            continue;
                                                        }
                                                        caseBodyParts.add(this.getNextParts(localData, part).get(i));
                                                        ++pos;
                                                    }
                                                    Reference<Object> nextRef = new Reference<Object>(null);
                                                    Reference<Object> tiRef = new Reference<Object>(null);
                                                    SwitchItem sw = this.handleSwitch(switchedItem, originalSwitchedItem.getSrc(), foundGotos, partCodes, partCodePos, visited, allParts, stack, stopPart, stopPartKind, loops, throwStates, localData, staticOperation, path, caseValues, defaultPart, caseBodyParts, nextRef, tiRef);
                                                    GraphPart next2 = nextRef.getVal();
                                                    this.checkSwitch(localData, sw, caseExpressionOtherSides.values(), currentRet);
                                                    currentRet.add(sw);
                                                    if (next2 != null) {
                                                        if (tiRef.getVal() != null) {
                                                            ret.add(tiRef.getVal());
                                                        } else {
                                                            this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, part, next2, stopPart, stopPartKind, loops, throwStates, currentRet, staticOperation, path, recursionLevel + 1);
                                                        }
                                                    }
                                                    ++pos;
                                                }
                                                nextOnePart = null;
                                                if (this.getNextParts(localData, part).size() != 2 || this.partIsSwitch(part)) break block166;
                                                expr = stack.pop();
                                                if (nextOnePart != null) break block166;
                                                nps = this.getNextParts(localData, part);
                                                boolean isEmpty = nps.get(0) == nps.get(1);
                                                next = this.getCommonPart(localData, part, nps, loops, throwStates);
                                                TranslateStack trueStack = (TranslateStack)stack.clone();
                                                TranslateStack falseStack = (TranslateStack)stack.clone();
                                                GraphTargetItem topBsr = !stack.isEmpty() && stack.peek() instanceof BranchStackResistant ? stack.peek() : null;
                                                trueStack.clear();
                                                falseStack.clear();
                                                if (topBsr != null) {
                                                    trueStack.add(topBsr);
                                                    falseStack.add(topBsr);
                                                }
                                                if (isEmpty) {
                                                    next = nps.get(0);
                                                }
                                                boolean hasOntrue = nps.get(1) != next;
                                                boolean hasOnFalse = nps.get(0) != next;
                                                ArrayList<GraphPart> stopPart2 = new ArrayList<GraphPart>(stopPart);
                                                ArrayList<StopPartKind> stopPartKind2 = new ArrayList<StopPartKind>(stopPartKind);
                                                if (!isEmpty && next != null && !stopPart2.contains(next)) {
                                                    stopPart2.add((GraphPart)next);
                                                    stopPartKind2.add(StopPartKind.BLOCK_CLOSE);
                                                }
                                                onTrue = new ArrayList<GraphTargetItem>();
                                                if (!isEmpty && hasOntrue) {
                                                    onTrue = this.printGraph(foundGotos, partCodes, partCodePos, visited, this.prepareBranchLocalData(localData), trueStack, allParts, part, nps.get(1), stopPart2, stopPartKind2, loops, throwStates, null, staticOperation, path, recursionLevel + 1);
                                                }
                                                onFalse = new ArrayList<GraphTargetItem>();
                                                if (!isEmpty && hasOnFalse) {
                                                    onFalse = this.printGraph(foundGotos, partCodes, partCodePos, visited, this.prepareBranchLocalData(localData), falseStack, allParts, part, nps.get(0), stopPart2, stopPartKind2, loops, throwStates, null, staticOperation, path, recursionLevel + 1);
                                                }
                                                Graph.makeAllCommands(onTrue, trueStack);
                                                Graph.makeAllCommands(onFalse, falseStack);
                                                addAfterIf = null;
                                                if (!onTrue.isEmpty() && !onFalse.isEmpty() && onTrue.get(onTrue.size() - 1) instanceof ContinueItem && onFalse.get(onFalse.size() - 1) instanceof ContinueItem) {
                                                    ContinueItem contTrue = (ContinueItem)onTrue.get(onTrue.size() - 1);
                                                    ContinueItem contFalse = (ContinueItem)onFalse.get(onFalse.size() - 1);
                                                    if (contTrue.loopId == contFalse.loopId) {
                                                        onTrue.remove(onTrue.size() - 1);
                                                        onFalse.remove(onFalse.size() - 1);
                                                        addAfterIf = contTrue;
                                                    }
                                                }
                                                filteredOnTrue = onTrue;
                                                filteredOnFalse = onFalse;
                                                if (this.isEmpty(filteredOnTrue) || this.isEmpty(filteredOnFalse) || !(filteredOnTrue.get(filteredOnTrue.size() - 1) instanceof PushItem) || !(filteredOnFalse.get(filteredOnFalse.size() - 1) instanceof PushItem) || !this.canBeCommaised(filteredOnTrue) || !this.canBeCommaised(filteredOnFalse)) break block167;
                                                if (filteredOnTrue.size() > 1) {
                                                    filteredOnTrue.set(filteredOnTrue.size() - 1, ((GraphTargetItem)filteredOnTrue.get((int)(filteredOnTrue.size() - 1))).value);
                                                    ternarOnTrue = new CommaExpressionItem(null, null, filteredOnTrue);
                                                } else {
                                                    ternarOnTrue = ((GraphTargetItem)filteredOnTrue.get((int)0)).value;
                                                }
                                                if (filteredOnFalse.size() > 1) {
                                                    filteredOnFalse.set(filteredOnFalse.size() - 1, ((GraphTargetItem)filteredOnFalse.get((int)(filteredOnFalse.size() - 1))).value);
                                                    ternarOnFalse = new CommaExpressionItem(null, null, filteredOnFalse);
                                                } else {
                                                    ternarOnFalse = ((GraphTargetItem)filteredOnFalse.get((int)0)).value;
                                                }
                                                stack.push(new TernarOpItem(null, localData.lineStartInstruction, expr.invert(null), ternarOnTrue, ternarOnFalse));
                                                break block168;
                                            }
                                            isIf = true;
                                            if (filteredOnTrue.isEmpty() && !filteredOnFalse.isEmpty()) {
                                                expr = expr.invert(null);
                                                List<GraphTargetItem> tmp = onTrue;
                                                onTrue = onFalse;
                                                onFalse = tmp;
                                                filteredOnTrue = filteredOnFalse;
                                            }
                                            if (stack.isEmpty() || (filteredOnTrue.size() != 1 || !(filteredOnTrue.get(0) instanceof PopItem)) && (filteredOnTrue.size() < 2 || !(filteredOnTrue.get(0) instanceof PopItem) || !(filteredOnTrue.get(filteredOnTrue.size() - 1) instanceof PushItem))) break block164;
                                            if (filteredOnTrue.size() <= 1) break block169;
                                            rightSide = ((PushItem)filteredOnTrue.get((int)(filteredOnTrue.size() - 1))).value;
                                            prevExpr = stack.pop();
                                            leftSide = expr.getNotCoercedNoDup();
                                            hideEmptyTrueFalse = true;
                                            if (!(leftSide instanceof DuplicateItem)) break block170;
                                            isIf = false;
                                            if (hideEmptyTrueFalse && prevExpr.getNotCoercedNoDup() instanceof FalseItem) {
                                                stack.push(rightSide);
                                                break block164;
                                            } else if (hideEmptyTrueFalse && rightSide.getNotCoercedNoDup() instanceof FalseItem) {
                                                stack.push(prevExpr);
                                                break block164;
                                            } else {
                                                stack.push(new OrItem(null, localData.lineStartInstruction, prevExpr, rightSide));
                                            }
                                            break block164;
                                        }
                                        if (!(leftSide.invert(null).getNotCoercedNoDup() instanceof DuplicateItem)) break block171;
                                        isIf = false;
                                        if (hideEmptyTrueFalse && prevExpr.getNotCoercedNoDup() instanceof TrueItem) {
                                            stack.push(rightSide);
                                            break block164;
                                        } else if (hideEmptyTrueFalse && rightSide.getNotCoercedNoDup() instanceof TrueItem) {
                                            stack.push(prevExpr);
                                            break block164;
                                        } else {
                                            stack.push(new AndItem(null, localData.lineStartInstruction, prevExpr, rightSide));
                                        }
                                        break block164;
                                    }
                                    if (!(prevExpr instanceof FalseItem)) break block172;
                                    isIf = false;
                                    leftSide = leftSide.invert(null);
                                    if (hideEmptyTrueFalse && leftSide.getNotCoercedNoDup() instanceof TrueItem) {
                                        stack.push(rightSide);
                                        break block164;
                                    } else if (hideEmptyTrueFalse && rightSide.getNotCoercedNoDup() instanceof TrueItem) {
                                        stack.push(leftSide);
                                        break block164;
                                    } else {
                                        stack.push(new AndItem(null, localData.lineStartInstruction, leftSide, rightSide));
                                    }
                                    break block164;
                                }
                                if (!(prevExpr instanceof TrueItem)) break block173;
                                isIf = false;
                                if (hideEmptyTrueFalse && leftSide.getNotCoercedNoDup() instanceof FalseItem) {
                                    stack.push(rightSide);
                                    break block164;
                                } else if (hideEmptyTrueFalse && rightSide.getNotCoercedNoDup() instanceof FalseItem) {
                                    stack.push(leftSide);
                                    break block164;
                                } else {
                                    stack.push(new OrItem(null, localData.lineStartInstruction, leftSide, rightSide));
                                }
                                break block164;
                            }
                            stack.push(prevExpr);
                            break block164;
                        }
                        isIf = false;
                    }
                    if (isIf) {
                        Graph.makeAllCommands(currentRet, stack);
                        IfItem b = new IfItem(null, localData.lineStartInstruction, expr.invert(null), onTrue, onFalse);
                        b.decisionPart = part;
                        b.onTruePart = nps.get(0);
                        b.onFalsePart = nps.get(1);
                        currentRet.add(b);
                        if (this.processSubBlk(b, null)) {
                            stack.push(new PopItem(null, localData.lineStartInstruction));
                        }
                    }
                }
                if (addAfterIf != null) {
                    currentRet.add(addAfterIf);
                }
                if (next != null) {
                    this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, part, (GraphPart)next, stopPart, stopPartKind, loops, throwStates, currentRet, staticOperation, path, recursionLevel + 1);
                }
            }
            if (this.getNextParts(localData, part).size() == 1) {
                nextOnePart = this.getNextParts(localData, part).get(0);
            }
            if (this.getNextParts(localData, part).isEmpty()) {
                Graph.makeAllCommands(currentRet, stack);
            }
            if (nextOnePart != null) {
                this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, part, this.getNextParts(localData, part).get(0), stopPart, stopPartKind, loops, throwStates, currentRet, staticOperation, path, recursionLevel + 1);
            }
        }
        if (isLoop && loopItem != null && currentLoop != null) {
            IfItem ifi;
            LoopItem li = loopItem;
            boolean loopTypeFound = false;
            boolean hasContinue = false;
            this.processIfs(loopItem.commands);
            this.processSwitches(loopItem.commands, currentLoop.id);
            this.checkContinueAtTheEnd(loopItem.commands, currentLoop);
            List<ContinueItem> continues = loopItem.getContinues();
            for (ContinueItem c : continues) {
                if (c.loopId != currentLoop.id) continue;
                hasContinue = true;
                break;
            }
            if (!hasContinue && currentLoop.loopPreContinue != null) {
                ArrayList<GraphPart> stopContPart = new ArrayList<GraphPart>();
                stopContPart.add(currentLoop.loopContinue);
                ArrayList<StopPartKind> stopContPartKind = new ArrayList<StopPartKind>();
                stopContPartKind.add(StopPartKind.OTHER);
                GraphPart precoBackup = currentLoop.loopPreContinue;
                currentLoop.loopPreContinue = null;
                this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, null, precoBackup, stopContPart, stopContPartKind, loops, throwStates, loopItem.commands, staticOperation, path, recursionLevel + 1);
                this.checkContinueAtTheEnd(loopItem.commands, currentLoop);
            }
            if (!loopTypeFound && !loopItem.commands.isEmpty() && loopItem.commands.get(0) instanceof IfItem) {
                BreakItem bi;
                ifi = (IfItem)loopItem.commands.get(0);
                List<GraphTargetItem> bodyBranch = null;
                boolean inverted = false;
                boolean breakpos2 = false;
                BreakItem addBreakItem = null;
                if (ifi.onTrue.size() == 1 && ifi.onTrue.get(0) instanceof BreakItem) {
                    bi = (BreakItem)ifi.onTrue.get(0);
                    if (bi.loopId == currentLoop.id) {
                        bodyBranch = ifi.onFalse;
                        inverted = true;
                    }
                } else if (ifi.onFalse.size() == 1 && ifi.onFalse.get(0) instanceof BreakItem) {
                    bi = (BreakItem)ifi.onFalse.get(0);
                    if (bi.loopId == currentLoop.id) {
                        bodyBranch = ifi.onTrue;
                    }
                } else if (loopItem.commands.size() == 2 && loopItem.commands.get(1) instanceof BreakItem) {
                    bi = (BreakItem)loopItem.commands.get(1);
                    if (ifi.onTrue.isEmpty()) {
                        inverted = true;
                    }
                    bodyBranch = inverted ? ifi.onFalse : ifi.onTrue;
                    breakpos2 = true;
                    if (bi.loopId != currentLoop.id) {
                        addBreakItem = bi;
                    }
                }
                if (bodyBranch != null) {
                    int index = ret.indexOf(loopItem);
                    ret.remove(index);
                    ArrayList<GraphTargetItem> exprList = new ArrayList<GraphTargetItem>();
                    GraphTargetItem expr = ifi.expression;
                    if (inverted) {
                        expr = expr instanceof LogicalOpItem ? ((LogicalOpItem)((Object)expr)).invert(null) : new NotItem(null, expr.getLineStartItem(), expr);
                    }
                    exprList.add(expr);
                    ArrayList<GraphTargetItem> commands = new ArrayList<GraphTargetItem>();
                    commands.addAll(bodyBranch);
                    loopItem.commands.remove(0);
                    if (breakpos2) {
                        loopItem.commands.remove(0);
                    }
                    commands.addAll(loopItem.commands);
                    this.checkContinueAtTheEnd(commands, currentLoop);
                    ArrayList<GraphTargetItem> finalComm = new ArrayList<GraphTargetItem>();
                    if (currentLoop.loopPreContinue != null) {
                        GraphTargetItem lastItem;
                        GraphPart backup = currentLoop.loopPreContinue;
                        currentLoop.loopPreContinue = null;
                        ArrayList<GraphPart> stopPart2 = new ArrayList<GraphPart>(stopPart);
                        stopPart2.add(currentLoop.loopContinue);
                        ArrayList<StopPartKind> stopPartKind2 = new ArrayList<StopPartKind>(stopPartKind);
                        stopPartKind2.add(StopPartKind.OTHER);
                        List<GraphTargetItem> precoCommands = this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, new TranslateStack(path), allParts, null, backup, stopPart2, stopPartKind2, loops, throwStates, null, staticOperation, path, recursionLevel + 1);
                        currentLoop.loopPreContinue = backup;
                        this.checkContinueAtTheEnd(precoCommands, currentLoop);
                        ArrayList<List<GraphTargetItem>> continueCommands = new ArrayList<List<GraphTargetItem>>();
                        this.getContinuesCommands(commands, continueCommands, currentLoop.id);
                        if (continueCommands.isEmpty()) {
                            commands.addAll(precoCommands);
                            precoCommands = new ArrayList<GraphTargetItem>();
                        } else if (!commands.isEmpty() && continueCommands.size() == 1 && ((lastItem = (GraphTargetItem)commands.get(commands.size() - 1)) instanceof BreakItem || lastItem instanceof ContinueItem || lastItem instanceof ExitItem)) {
                            ((List)continueCommands.get(0)).addAll(((List)continueCommands.get(0)).size() - 1, precoCommands);
                            precoCommands = new ArrayList<GraphTargetItem>();
                        }
                        finalComm.addAll(precoCommands);
                    }
                    if (currentLoop.precontinueCommands != null) {
                        finalComm.addAll(currentLoop.precontinueCommands);
                    }
                    if (!finalComm.isEmpty()) {
                        li = new ForItem(expr.getSrc(), expr.getLineStartItem(), currentLoop, new ArrayList<GraphTargetItem>(), (GraphTargetItem)exprList.get(exprList.size() - 1), finalComm, commands);
                        ret.add(index, li);
                    } else {
                        li = new WhileItem(expr.getSrc(), expr.getLineStartItem(), currentLoop, exprList, commands);
                        ret.add(index, li);
                    }
                    if (addBreakItem != null) {
                        ret.add(index + 1, addBreakItem);
                    }
                    loopTypeFound = true;
                }
            }
            if (!loopTypeFound && !loopItem.commands.isEmpty() && loopItem.commands.get(loopItem.commands.size() - 1) instanceof IfItem) {
                ifi = (IfItem)loopItem.commands.get(loopItem.commands.size() - 1);
                List<GraphTargetItem> bodyBranch = null;
                boolean inverted = false;
                if (ifi.onTrue.size() == 1 && ifi.onTrue.get(0) instanceof BreakItem) {
                    BreakItem bi = (BreakItem)ifi.onTrue.get(0);
                    if (bi.loopId == currentLoop.id) {
                        bodyBranch = ifi.onFalse;
                        inverted = true;
                    }
                } else if (ifi.onFalse.size() == 1 && ifi.onFalse.get(0) instanceof BreakItem) {
                    BreakItem bi = (BreakItem)ifi.onFalse.get(0);
                    if (bi.loopId == currentLoop.id) {
                        bodyBranch = ifi.onTrue;
                    }
                }
                if (bodyBranch != null) {
                    int index = ret.indexOf(loopItem);
                    ret.remove(index);
                    ArrayList<GraphTargetItem> exprList = new ArrayList<GraphTargetItem>();
                    GraphTargetItem expr = ifi.expression;
                    if (inverted) {
                        expr = expr.invert(null);
                    }
                    this.checkContinueAtTheEnd(bodyBranch, currentLoop);
                    ArrayList<GraphTargetItem> commands = new ArrayList<GraphTargetItem>();
                    if (!bodyBranch.isEmpty()) {
                        ret.add(index, loopItem);
                    } else {
                        loopItem.commands.remove(loopItem.commands.size() - 1);
                        commands.addAll(loopItem.commands);
                        commands.addAll(bodyBranch);
                        exprList.add(expr);
                        this.checkContinueAtTheEnd(commands, currentLoop);
                        li = new DoWhileItem(null, ((GraphTargetItem)exprList.get(0)).getLineStartItem(), currentLoop, commands, exprList);
                        ret.add(index, li);
                    }
                    loopTypeFound = true;
                }
            }
            if (!loopTypeFound && currentLoop.loopPreContinue != null) {
                loopTypeFound = true;
                GraphPart backup = currentLoop.loopPreContinue;
                currentLoop.loopPreContinue = null;
                ArrayList<GraphPart> stopPart2 = new ArrayList<GraphPart>(stopPart);
                stopPart2.add(currentLoop.loopContinue);
                ArrayList<StopPartKind> stopPartKind2 = new ArrayList<StopPartKind>(stopPartKind);
                stopPartKind2.add(StopPartKind.OTHER);
                List<GraphTargetItem> finalComm = this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, new TranslateStack(path), allParts, null, backup, stopPart2, stopPartKind2, loops, throwStates, null, staticOperation, path, recursionLevel + 1);
                currentLoop.loopPreContinue = backup;
                this.checkContinueAtTheEnd(finalComm, currentLoop);
                if (!finalComm.isEmpty() && finalComm.get(finalComm.size() - 1) instanceof IfItem) {
                    IfItem ifi2 = (IfItem)finalComm.get(finalComm.size() - 1);
                    boolean ok = false;
                    boolean invert = false;
                    if (ifi2.onTrue.size() == 1 && ifi2.onTrue.get(0) instanceof BreakItem && ((BreakItem)ifi2.onTrue.get((int)0)).loopId == currentLoop.id && ifi2.onFalse.size() == 1 && ifi2.onFalse.get(0) instanceof ContinueItem && ((ContinueItem)ifi2.onFalse.get((int)0)).loopId == currentLoop.id) {
                        ok = true;
                        invert = true;
                    }
                    if (ifi2.onTrue.size() == 1 && ifi2.onTrue.get(0) instanceof ContinueItem && ((ContinueItem)ifi2.onTrue.get((int)0)).loopId == currentLoop.id && ifi2.onFalse.size() == 1 && ifi2.onFalse.get(0) instanceof BreakItem && ((BreakItem)ifi2.onFalse.get((int)0)).loopId == currentLoop.id) {
                        ok = true;
                    }
                    if (ok) {
                        finalComm.remove(finalComm.size() - 1);
                        int index = ret.indexOf(loopItem);
                        ret.remove(index);
                        ArrayList<GraphTargetItem> exprList = new ArrayList<GraphTargetItem>(finalComm);
                        GraphTargetItem expr = ifi2.expression;
                        if (invert) {
                            expr = expr.invert(null);
                        }
                        exprList.add(expr);
                        li = new DoWhileItem(null, expr.getLineStartItem(), currentLoop, loopItem.commands, exprList);
                        ret.add(index, li);
                    }
                }
            }
            if (!loopTypeFound) {
                this.checkContinueAtTheEnd(loopItem.commands, currentLoop);
            }
            currentLoop.phase = 2;
            GraphTargetItem replaced = this.checkLoop(ret, li, localData, loops, throwStates, sPreLoop);
            if (replaced != li) {
                int index = ret.indexOf(li);
                ret.remove(index);
                if (replaced != null) {
                    ret.add(index, replaced);
                }
            }
            if (currentLoop.loopBreak != null) {
                this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, sPreLoop, allParts, part, currentLoop.loopBreak, stopPart, stopPartKind, loops, throwStates, ret, staticOperation, path, recursionLevel + 1);
            }
        }
        return ret;
    }

    protected void checkSwitch(BaseLocalData localData, SwitchItem switchItem, Collection<? extends GraphTargetItem> otherSides, List<GraphTargetItem> output) {
    }

    protected void checkGraph(List<GraphPart> allBlocks) {
    }

    public List<GraphPart> makeGraph(GraphSource code, List<GraphPart> allBlocks, List<GraphException> exceptions) throws InterruptedException {
        ArrayList<Integer> alternateEntries = new ArrayList<Integer>();
        for (GraphException ex : exceptions) {
            alternateEntries.add(ex.start);
            alternateEntries.add(ex.target);
        }
        HashMap<Integer, List<Integer>> refs = code.visitCode(alternateEntries);
        ArrayList<GraphPart> ret = new ArrayList<GraphPart>();
        boolean[] visited = new boolean[code.size()];
        ret.add(this.makeGraph(null, new GraphPath(), code, 0, 0, allBlocks, refs, visited));
        Iterator iterator = alternateEntries.iterator();
        while (iterator.hasNext()) {
            int pos = (Integer)iterator.next();
            GraphPart e1 = new GraphPart(-1, -1);
            e1.path = new GraphPath("e");
            ret.add(this.makeGraph(e1, new GraphPath("e"), code, pos, pos, allBlocks, refs, visited));
        }
        this.checkGraph(allBlocks);
        return ret;
    }

    protected int checkIp(int ip) {
        return ip;
    }

    public GraphPart searchPart(int ip, Collection<? extends GraphPart> allParts) {
        if (ip < 0) {
            return null;
        }
        for (GraphPart graphPart : allParts) {
            if (ip < graphPart.start || ip > graphPart.end) continue;
            return graphPart;
        }
        return null;
    }

    private GraphPart makeGraph(GraphPart parent, GraphPath path, GraphSource code, int startip, int lastIp, List<GraphPart> allBlocks, HashMap<Integer, List<Integer>> refs, boolean[] visited) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        int ip = startip;
        GraphPart existingPart = this.searchPart(ip, allBlocks);
        if (existingPart != null) {
            if (parent != null) {
                existingPart.refs.add(parent);
                parent.nextParts.add(existingPart);
            }
            return existingPart;
        }
        GraphPart ret = new GraphPart(ip, -1);
        ret.path = path;
        GraphPart part = ret;
        if (parent != null) {
            ret.refs.add(parent);
            parent.nextParts.add(ret);
        }
        while (ip < code.size() && (ip = this.checkIp(ip)) < code.size()) {
            if (visited[ip] || ip != startip && refs.get(ip).size() > 1) {
                part.end = lastIp;
                GraphPart found = this.searchPart(ip, allBlocks);
                allBlocks.add(part);
                if (found != null) {
                    part.nextParts.add(found);
                    found.refs.add(part);
                    break;
                }
                GraphPart nextPart = new GraphPart(ip, -1);
                nextPart.path = path;
                part.nextParts.add(nextPart);
                nextPart.refs.add(part);
                part = nextPart;
            }
            visited[ip] = true;
            lastIp = ip;
            GraphSourceItem ins = code.get(ip);
            if (ins.isIgnored()) {
                ++ip;
                continue;
            }
            if (ins instanceof GraphSourceItemContainer) {
                GraphSourceItemContainer cnt = (GraphSourceItemContainer)((Object)ins);
                if (!(ins instanceof Action)) continue;
                long endAddr = ((Action)ins).getAddress() + cnt.getHeaderSize();
                for (long size : cnt.getContainerSizes()) {
                    endAddr += size;
                }
                ip = code.adr2pos(endAddr);
                if (!(ins instanceof ActionDefineFunction) && !(ins instanceof ActionDefineFunction2)) continue;
                part.end = lastIp;
                allBlocks.add(part);
                GraphPart nextGraphPart = new GraphPart(ip, -1);
                nextGraphPart.path = path;
                part.nextParts.add(nextGraphPart);
                nextGraphPart.refs.add(part);
                part = nextGraphPart;
                continue;
            }
            if (ins.isExit()) {
                part.end = ip;
                allBlocks.add(part);
                break;
            }
            if (ins.isJump()) {
                part.end = ip;
                allBlocks.add(part);
                ip = ins.getBranches(code).get(0);
                this.makeGraph(part, path, code, ip, lastIp, allBlocks, refs, visited);
                break;
            }
            if (ins.isBranch()) {
                part.end = ip;
                allBlocks.add(part);
                List<Integer> branches = ins.getBranches(code);
                for (int i = 0; i < branches.size(); ++i) {
                    this.makeGraph(part, path.sub(i, ip), code, branches.get(i), ip, allBlocks, refs, visited);
                }
                break;
            }
            ++ip;
        }
        if (part.end == -1 && ip >= code.size()) {
            if (part.start == code.size()) {
                part.end = code.size();
                allBlocks.add(part);
            } else {
                part.end = ip - 1;
                for (GraphPart p : allBlocks) {
                    if (p.start != ip) continue;
                    p.refs.add(part);
                    part.nextParts.add(p);
                    allBlocks.add(part);
                    return ret;
                }
                GraphPart gp = new GraphPart(ip, ip);
                allBlocks.add(gp);
                gp.refs.add(part);
                part.nextParts.add(gp);
                allBlocks.add(part);
            }
        }
        return ret;
    }

    public static GraphTextWriter graphToString(List<GraphTargetItem> tree, GraphTextWriter writer, LocalData localData) throws InterruptedException {
        for (GraphTargetItem ti : tree) {
            if (ti.isEmpty()) continue;
            ti.toStringSemicoloned(writer, localData);
            if (ti.handlesNewLine()) continue;
            writer.newLine();
        }
        return writer;
    }

    public BaseLocalData prepareBranchLocalData(BaseLocalData localData) {
        return localData;
    }

    protected List<GraphSourceItem> getPartItems(GraphPart part) {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        do {
            for (int i = 0; i < part.getHeight(); ++i) {
                GraphSourceItem s;
                if (part.getPosAt(i) >= this.code.size() || part.getPosAt(i) < 0 || (s = this.code.get(part.getPosAt(i))).isJump()) continue;
                ret.add(s);
            }
        } while ((part = part.nextParts.size() == 1 && part.nextParts.get((int)0).refs.size() == 1 ? part.nextParts.get(0) : null) != null);
        return ret;
    }

    protected static void makeAllStack(List<GraphTargetItem> commands, TranslateStack stack) {
        int i;
        int pcnt = 0;
        for (i = commands.size() - 1; i >= 0 && commands.get(i) instanceof PushItem; --i) {
            ++pcnt;
        }
        for (i = commands.size() - pcnt; i < commands.size(); ++i) {
            stack.push(commands.remove((int)i).value);
            --i;
        }
    }

    public static void makeAllCommands(List<GraphTargetItem> commands, TranslateStack stack) {
        int clen = commands.size();
        boolean isExit = false;
        if (clen > 0 && commands.get(clen - 1) instanceof ScriptEndItem) {
            --clen;
            isExit = true;
        }
        if (clen > 0 && commands.get(clen - 1) instanceof ExitItem) {
            isExit = true;
            --clen;
        }
        if (clen > 0 && commands.get(clen - 1) instanceof BreakItem) {
            --clen;
        }
        if (clen > 0 && commands.get(clen - 1) instanceof ContinueItem) {
            --clen;
        }
        for (int i = stack.size() - 1; i >= 0; --i) {
            GraphTargetItem p = stack.get(i);
            if (p instanceof BranchStackResistant) continue;
            stack.remove(i);
            if (p instanceof PopItem) continue;
            if (isExit) {
                commands.add(clen, p);
                continue;
            }
            commands.add(clen, new PushItem(p));
        }
    }

    protected SwitchItem handleSwitch(GraphTargetItem switchedObject, GraphSourceItem switchStartItem, List<GotoItem> foundGotos, Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, Set<GraphPart> visited, Set<GraphPart> allParts, TranslateStack stack, List<GraphPart> stopPart, List<StopPartKind> stopPartKind, List<Loop> loops, List<ThrowState> throwStates, BaseLocalData localData, int staticOperation, String path, List<GraphTargetItem> caseValuesMap, GraphPart defaultPart, List<GraphPart> caseBodyParts, Reference<GraphPart> nextRef, Reference<GraphTargetItem> tiRef) throws InterruptedException {
        List lastc;
        GraphPart cur;
        int i;
        DefaultItem di;
        int i2;
        boolean hasDefault = false;
        for (i2 = caseBodyParts.size() - 1; i2 >= 0; --i2) {
            if (caseBodyParts.get(i2) != defaultPart) continue;
            di = new DefaultItem();
            caseValuesMap.add(i2 + 1, di);
            caseBodyParts.add(i2 + 1, defaultPart);
            hasDefault = true;
            break;
        }
        if (!hasDefault) {
            for (i2 = caseBodyParts.size() - 1; i2 >= 0; --i2) {
                if (!caseBodyParts.get(i2).leadsTo(localData, this, this.code, defaultPart, loops, throwStates, false)) continue;
                di = new DefaultItem();
                caseValuesMap.add(i2 + 1, di);
                caseBodyParts.add(i2 + 1, defaultPart);
                hasDefault = true;
                break;
            }
        }
        if (!hasDefault) {
            for (i2 = 0; i2 < caseBodyParts.size(); ++i2) {
                if (!defaultPart.leadsTo(localData, this, this.code, caseBodyParts.get(i2), loops, throwStates, false)) continue;
                di = new DefaultItem();
                caseValuesMap.add(i2, di);
                caseBodyParts.add(i2, defaultPart);
                hasDefault = true;
                break;
            }
        }
        if (!hasDefault) {
            caseValuesMap.add(new DefaultItem());
            caseBodyParts.add(defaultPart);
        }
        GraphPart breakPart = this.getMostCommonPart(localData, caseBodyParts, loops, throwStates);
        ArrayList<List<GraphTargetItem>> caseCommands = new ArrayList<List<GraphTargetItem>>();
        GraphPart next = breakPart;
        Loop currentLoop = new Loop(loops.size(), null, next);
        currentLoop.phase = 1;
        loops.add(currentLoop);
        ArrayList<Integer> valuesMapping = new ArrayList<Integer>();
        ArrayList<GraphPart> caseBodies = new ArrayList<GraphPart>();
        for (i = 0; i < caseValuesMap.size(); ++i) {
            cur = caseBodyParts.get(i);
            if (caseBodies.contains(cur)) continue;
            caseBodies.add(cur);
        }
        block4: for (i = 0; i < caseBodies.size(); ++i) {
            GraphPart b = (GraphPart)caseBodies.get(i);
            for (int j = i + 1; j < caseBodies.size(); ++j) {
                GraphPart b2 = (GraphPart)caseBodies.get(j);
                if (b2.leadsTo(localData, this, this.code, b, loops, throwStates, false)) {
                    caseBodies.remove(j);
                    caseBodies.add(i, b2);
                    --i;
                    continue block4;
                }
                if (j <= i + 1 || !b.leadsTo(localData, this, this.code, b2, loops, throwStates, false)) continue;
                caseBodies.remove(j);
                caseBodies.add(i + 1, b2);
                continue block4;
            }
        }
        for (i = 0; i < caseValuesMap.size(); ++i) {
            cur = caseBodyParts.get(i);
            valuesMapping.add(caseBodies.indexOf(cur));
        }
        for (i = 0; i < caseBodies.size(); ++i) {
            GraphTargetItem last;
            List<Object> currentCaseCommands = new ArrayList();
            boolean willHaveBreak = false;
            if (i < caseBodies.size() - 1 && !((GraphPart)caseBodies.get(i)).leadsTo(localData, this, this.code, (GraphPart)caseBodies.get(i + 1), loops, throwStates, false)) {
                willHaveBreak = true;
            }
            ArrayList<GraphPart> stopPart2x = new ArrayList<GraphPart>(stopPart);
            ArrayList<StopPartKind> stopPartKind2x = new ArrayList<StopPartKind>(stopPartKind);
            for (GraphPart b : caseBodies) {
                if (b == caseBodies.get(i)) continue;
                stopPart2x.add(b);
                stopPartKind2x.add(StopPartKind.OTHER);
            }
            if (breakPart != null) {
                stopPart2x.add(breakPart);
                stopPartKind2x.add(StopPartKind.OTHER);
            }
            currentCaseCommands = this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, null, (GraphPart)caseBodies.get(i), stopPart2x, stopPartKind2x, loops, throwStates, staticOperation, path);
            if (!(!willHaveBreak || currentCaseCommands.isEmpty() || (last = (GraphTargetItem)currentCaseCommands.get(currentCaseCommands.size() - 1)) instanceof ContinueItem || last instanceof BreakItem || last instanceof GotoItem || last instanceof ExitItem || last instanceof ScriptEndItem)) {
                currentCaseCommands.add(new BreakItem(null, localData.lineStartInstruction, currentLoop.id));
            }
            caseCommands.add(currentCaseCommands);
        }
        if (!caseCommands.isEmpty()) {
            List lastc2 = (List)caseCommands.get(caseCommands.size() - 1);
            if (!lastc2.isEmpty() && lastc2.get(lastc2.size() - 1) instanceof BreakItem) {
                BreakItem bi = (BreakItem)lastc2.get(lastc2.size() - 1);
                lastc2.remove(lastc2.size() - 1);
            }
            if (lastc2.isEmpty()) {
                int cnt2 = 0;
                if (caseValuesMap.get(caseValuesMap.size() - 1) instanceof DefaultItem) {
                    for (int i3 = valuesMapping.size() - 1; i3 >= 0; --i3) {
                        if ((Integer)valuesMapping.get(i3) != caseCommands.size() - 1) continue;
                        ++cnt2;
                    }
                    caseValuesMap.remove(caseValuesMap.size() - 1);
                    valuesMapping.remove(valuesMapping.size() - 1);
                    if (cnt2 == 1) {
                        caseCommands.remove(lastc2);
                    }
                }
            }
        }
        if (!caseCommands.isEmpty() && !(lastc = (List)caseCommands.get(caseCommands.size() - 1)).isEmpty() && lastc.get(lastc.size() - 1) instanceof BreakItem) {
            BreakItem bi = (BreakItem)lastc.get(lastc.size() - 1);
            lastc.remove(lastc.size() - 1);
        }
        nextRef.setVal(next);
        currentLoop.phase = 2;
        GraphTargetItem ti = this.checkLoop(new ArrayList<GraphTargetItem>(), next, stopPart, loops, throwStates);
        tiRef.setVal(ti);
        return new SwitchItem(null, switchStartItem, currentLoop, switchedObject, caseValuesMap, caseCommands, valuesMapping);
    }

    protected boolean partIsSwitch(GraphPart part) {
        return false;
    }
}

