/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.timeline;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.treeitems.TreeItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AS2Package
implements TreeItem {
    private final SWF swf;
    private final String name;
    private final AS2Package parent;
    public Map<String, AS2Package> subPackages = new TreeMap<String, AS2Package>();
    public Map<String, ASMSource> scripts = new TreeMap<String, ASMSource>();

    public AS2Package(String name, AS2Package parent, SWF swf) {
        this.name = name;
        this.parent = parent;
        this.swf = swf;
    }

    @Override
    public SWF getSwf() {
        return this.swf;
    }

    public List<TreeItem> getAllChildren() {
        ArrayList<TreeItem> result = new ArrayList<TreeItem>(this.getChildCount());
        result.addAll(this.subPackages.values());
        result.addAll(this.scripts.values());
        return result;
    }

    public TreeItem getChild(int index) {
        if (index < this.subPackages.size()) {
            for (AS2Package subPackage : this.subPackages.values()) {
                if (index == 0) {
                    return subPackage;
                }
                --index;
            }
        }
        index -= this.subPackages.size();
        for (ASMSource pack : this.scripts.values()) {
            if (index == 0) {
                return pack;
            }
            --index;
        }
        return null;
    }

    public int getChildCount() {
        return this.subPackages.size() + this.scripts.size();
    }

    public int getIndexOfChild(TreeItem child) {
        int res = 0;
        if (child instanceof AS2Package) {
            for (AS2Package pkg : this.subPackages.values()) {
                if (pkg.equals(child)) break;
                ++res;
            }
            return res;
        }
        res = this.subPackages.size();
        for (ASMSource pack : this.scripts.values()) {
            if (pack.equals(child)) break;
            ++res;
        }
        return res;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isModified() {
        for (ASMSource s : this.scripts.values()) {
            if (!s.isModified()) continue;
            return true;
        }
        for (AS2Package p : this.subPackages.values()) {
            if (!p.isModified()) continue;
            return true;
        }
        return false;
    }
}

