/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags.gfx;

import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.annotations.HideInRawEdit;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.SerializableImage;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.npe.dds.DDSReader;

public class DefineExternalImage
extends ImageTag {
    public static final int ID = 1001;
    public static final String NAME = "DefineExternalImage";
    public int bitmapFormat;
    public int targetWidth;
    public int targetHeight;
    public String exportName;
    public String fileName;
    public static final int BITMAP_FORMAT_DEFAULT = 0;
    public static final int BITMAP_FORMAT_TGA = 1;
    public static final int BITMAP_FORMAT_DDS = 2;
    @HideInRawEdit
    private SerializableImage serImage;

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterID);
        sos.writeUI16(this.bitmapFormat);
        sos.writeUI16(this.targetWidth);
        sos.writeUI16(this.targetHeight);
        sos.writeNetString(this.exportName);
        sos.writeNetString(this.fileName);
    }

    public DefineExternalImage(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 1001, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.characterID = sis.readUI16("characterID");
        this.bitmapFormat = sis.readUI16("bitmapFormat");
        this.targetWidth = sis.readUI16("targetWidth");
        this.targetHeight = sis.readUI16("targetHeight");
        this.exportName = sis.readNetString("exportName");
        this.fileName = sis.readNetString("fileName");
        if (this.bitmapFormat == 1) {
            return;
        }
        Path imagePath = Paths.get(sis.getSwf().getFile(), new String[0]).getParent().resolve(Paths.get(this.fileName, new String[0]));
        byte[] imageData = Files.readAllBytes(imagePath);
        int[] pixels = DDSReader.read((byte[])imageData, (DDSReader.Order)DDSReader.ARGB, (int)0);
        BufferedImage bufImage = new BufferedImage(DDSReader.getWidth((byte[])imageData), DDSReader.getHeight((byte[])imageData), 2);
        bufImage.getRaster().setDataElements(0, 0, bufImage.getWidth(), bufImage.getHeight(), pixels);
        Image scaled = bufImage.getScaledInstance(this.targetWidth, this.targetHeight, 1);
        bufImage = new BufferedImage(this.targetWidth, this.targetHeight, 2);
        bufImage.getGraphics().drawImage(scaled, 0, 0, null);
        this.serImage = new SerializableImage(bufImage);
    }

    @Override
    public void setImage(byte[] data) throws IOException {
        this.serImage = new SerializableImage(ImageHelper.read(data));
        this.clearCache();
        this.setModified(true);
    }

    @Override
    public ImageFormat getImageFormat() {
        return ImageFormat.PNG;
    }

    @Override
    public ImageFormat getOriginalImageFormat() {
        return ImageFormat.PNG;
    }

    @Override
    public InputStream getOriginalImageData() {
        return null;
    }

    @Override
    protected SerializableImage getImage() {
        return this.serImage;
    }

    @Override
    public Dimension getImageDimension() {
        return new Dimension(this.serImage.getWidth(), this.serImage.getHeight());
    }
}

