/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.SoundStreamBlockTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.TagInfo;
import com.jpexs.decompiler.flash.tags.base.SoundStreamHeadTypeTag;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.flash.types.sound.SoundExportFormat;
import com.jpexs.decompiler.flash.types.sound.SoundFormat;
import com.jpexs.helpers.ByteArrayRange;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

@SWFVersion(from=3)
public class SoundStreamHead2Tag
extends Tag
implements SoundStreamHeadTypeTag {
    public static final int ID = 45;
    public static final String NAME = "SoundStreamHead2";
    @Reserved
    @SWFType(value=BasicType.UB, count=4)
    public int reserved;
    @SWFType(value=BasicType.UB, count=2)
    public int playBackSoundRate;
    public boolean playBackSoundSize;
    public boolean playBackSoundType;
    @SWFType(value=BasicType.UB, count=4)
    public int streamSoundCompression;
    @SWFType(value=BasicType.UB, count=2)
    public int streamSoundRate;
    public boolean streamSoundSize;
    public boolean streamSoundType;
    @SWFType(value=BasicType.UI16)
    public int streamSoundSampleCount;
    @SWFType(value=BasicType.SI16)
    @Conditional(value={"streamSoundCompression"}, options={2})
    public int latencySeek;
    @Internal
    private int virtualCharacterId = 0;

    public SoundStreamHead2Tag(SWF swf) {
        super(swf, 45, NAME, null);
    }

    public SoundStreamHead2Tag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 45, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.reserved = (int)sis.readUB(4, "reserved");
        this.playBackSoundRate = (int)sis.readUB(2, "playBackSoundRate");
        this.playBackSoundSize = sis.readUB(1, "playBackSoundSize") == 1L;
        this.playBackSoundType = sis.readUB(1, "playBackSoundType") == 1L;
        this.streamSoundCompression = (int)sis.readUB(4, "streamSoundCompression");
        this.streamSoundRate = (int)sis.readUB(2, "streamSoundRate");
        this.streamSoundSize = sis.readUB(1, "streamSoundSize") == 1L;
        this.streamSoundType = sis.readUB(1, "streamSoundType") == 1L;
        this.streamSoundSampleCount = sis.readUI16("streamSoundSampleCount");
        if (this.streamSoundCompression == 2) {
            this.latencySeek = sis.readSI16("latencySeek");
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUB(4, this.reserved);
        sos.writeUB(2, this.playBackSoundRate);
        sos.writeUB(1, this.playBackSoundSize ? 1L : 0L);
        sos.writeUB(1, this.playBackSoundType ? 1L : 0L);
        sos.writeUB(4, this.streamSoundCompression);
        sos.writeUB(2, this.streamSoundRate);
        sos.writeUB(1, this.streamSoundSize ? 1L : 0L);
        sos.writeUB(1, this.streamSoundType ? 1L : 0L);
        sos.writeUI16(this.streamSoundSampleCount);
        if (this.streamSoundCompression == 2) {
            sos.writeSI16(this.latencySeek);
        }
    }

    @Override
    public int getCharacterId() {
        return this.virtualCharacterId;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.virtualCharacterId = characterId;
    }

    @Override
    public SoundExportFormat getExportFormat() {
        if (this.streamSoundCompression == 2) {
            return SoundExportFormat.MP3;
        }
        if (this.streamSoundCompression == 1) {
            return SoundExportFormat.WAV;
        }
        if (this.streamSoundCompression == 3) {
            return SoundExportFormat.WAV;
        }
        if (this.streamSoundCompression == 0) {
            return SoundExportFormat.WAV;
        }
        if (this.streamSoundCompression == 6 || this.streamSoundCompression == 4 || this.streamSoundCompression == 5) {
            return SoundExportFormat.WAV;
        }
        return SoundExportFormat.FLV;
    }

    @Override
    public long getSoundSampleCount() {
        return this.streamSoundSampleCount;
    }

    @Override
    public void setVirtualCharacterId(int ch) {
        this.virtualCharacterId = ch;
    }

    @Override
    public int getSoundFormatId() {
        return this.streamSoundCompression;
    }

    @Override
    public int getSoundRate() {
        return this.streamSoundRate;
    }

    @Override
    public boolean getSoundSize() {
        return this.streamSoundSize;
    }

    @Override
    public boolean getSoundType() {
        return this.streamSoundType;
    }

    @Override
    public List<SoundStreamBlockTag> getBlocks() {
        Timeline timeline = this.swf.getTimeline();
        List<SoundStreamBlockTag> ret = timeline.getSoundStreamBlocks(this);
        return ret;
    }

    @Override
    public boolean importSupported() {
        return false;
    }

    @Override
    public boolean setSound(InputStream is, int newSoundFormat) {
        return false;
    }

    @Override
    public List<ByteArrayRange> getRawSoundData() {
        ArrayList<ByteArrayRange> ret = new ArrayList<ByteArrayRange>();
        List<SoundStreamBlockTag> blocks = this.getBlocks();
        if (blocks != null) {
            for (SoundStreamBlockTag block : blocks) {
                ByteArrayRange data = block.streamSoundData;
                if (this.streamSoundCompression == 2) {
                    ret.add(data.getSubRange(4, data.getLength() - 4));
                    continue;
                }
                ret.add(data);
            }
        }
        return ret;
    }

    @Override
    public long getTotalSoundSampleCount() {
        return this.getBlocks().size() * this.streamSoundSampleCount;
    }

    @Override
    public SoundFormat getSoundFormat() {
        int[] rateMap = new int[]{5512, 11025, 22050, 44100};
        return new SoundFormat(this.getSoundFormatId(), rateMap[this.getSoundRate()], this.getSoundType());
    }

    @Override
    public String getCharacterExportFileName() {
        String exportName = this.swf.getExportName(this.getCharacterId());
        return this.getCharacterId() + (exportName != null ? "_" + exportName : "");
    }

    @Override
    public void getTagInfo(TagInfo tagInfo) {
        super.getTagInfo(tagInfo);
        SoundFormat soundFormat = this.getSoundFormat();
        tagInfo.addInfo("general", "codecName", soundFormat.getFormatName());
        tagInfo.addInfo("general", "exportFormat", (Object)soundFormat.getNativeExportFormat());
        tagInfo.addInfo("general", "samplingRate", soundFormat.samplingRate);
        tagInfo.addInfo("general", "stereo", soundFormat.stereo);
        tagInfo.addInfo("general", "sampleCount", this.streamSoundSampleCount);
    }

    @Override
    public String toString() {
        return this.getName() + (this.virtualCharacterId > 0 ? " (" + this.virtualCharacterId + ")" : "");
    }
}

