/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ImportTag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.SWFArray;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.flash.types.annotations.Table;
import com.jpexs.helpers.ByteArrayRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SWFVersion(from=5, to=7)
public class ImportAssetsTag
extends Tag
implements ImportTag {
    public static final int ID = 57;
    public static final String NAME = "ImportAssets";
    public String url;
    @SWFType(value=BasicType.UI16)
    @SWFArray(value="tag", countField="count")
    @Table(value="assets", itemName="asset")
    public List<Integer> tags;
    @SWFArray(value="name", countField="count")
    @Table(value="assets", itemName="asset")
    public List<String> names;

    public ImportAssetsTag(SWF swf) {
        super(swf, 57, NAME, null);
        this.url = "";
        this.tags = new ArrayList<Integer>();
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
        this.setModified(true);
    }

    public ImportAssetsTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 57, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.tags = new ArrayList<Integer>();
        this.names = new ArrayList<String>();
        this.url = sis.readString("url");
        int count = sis.readUI16("count");
        for (int i = 0; i < count; ++i) {
            int charId = sis.readUI16("charId");
            String tagName = sis.readString("tagName");
            this.tags.add(charId);
            this.names.add(tagName);
        }
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeString(this.url);
        sos.writeUI16(this.tags.size());
        for (int i = 0; i < this.tags.size(); ++i) {
            sos.writeUI16(this.tags.get(i));
            sos.writeString(this.names.get(i));
        }
    }

    @Override
    public Map<Integer, String> getAssets() {
        HashMap<Integer, String> assets = new HashMap<Integer, String>();
        for (int i = 0; i < this.tags.size(); ++i) {
            assets.put(this.tags.get(i), this.names.get(i));
        }
        return assets;
    }

    @Override
    public String getUrl() {
        return this.url;
    }
}

