/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.SWFField;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Cache;
import com.jpexs.helpers.SerializableImage;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@SWFVersion(from=3)
public class DefineSpriteTag
extends DrawableTag
implements Timelined {
    public static final int ID = 39;
    public static final String NAME = "DefineSprite";
    @SWFType(value=BasicType.UI16)
    public int spriteId;
    @SWFType(value=BasicType.UI16)
    public int frameCount;
    @SWFField
    private List<Tag> subTags;
    @Internal
    public ReadOnlyTagList readOnlyTags;
    public boolean hasEndTag;
    private Timeline timeline;
    private boolean isSingleFrameInitialized;
    private boolean isSingleFrame;

    public DefineSpriteTag(SWF swf) {
        super(swf, 39, NAME, null);
        this.spriteId = swf.getNextCharacterId();
        this.subTags = new ArrayList<Tag>();
    }

    public DefineSpriteTag(SWFInputStream sis, int level, ByteArrayRange data, boolean parallel, boolean skipUnusualTags) throws IOException, InterruptedException {
        super(sis.getSwf(), 39, NAME, data);
        this.readData(sis, data, level, parallel, skipUnusualTags, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException, InterruptedException {
        this.spriteId = sis.readUI16("spriteId");
        this.frameCount = sis.readUI16("frameCount");
        List<Tag> subTags = sis.readTagList(this, level + 1, parallel, skipUnusualTags, true, lazy);
        if (subTags.size() > 0 && subTags.get(subTags.size() - 1).getId() == 0) {
            this.hasEndTag = true;
            subTags.remove(subTags.size() - 1);
        }
        this.subTags = subTags;
        this.readOnlyTags = null;
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.spriteId);
        sos.writeUI16(this.frameCount);
        sos.writeTags(this.getTags());
        if (this.hasEndTag) {
            sos.writeUI16(0);
        }
    }

    @Override
    public Timeline getTimeline() {
        if (this.timeline == null) {
            this.timeline = new Timeline(this.swf, this, this.spriteId, this.getRect());
        }
        return this.timeline;
    }

    @Override
    public void resetTimeline() {
        if (this.timeline != null) {
            this.timeline.reset(this.swf, this, this.spriteId, this.getRect());
        }
    }

    @Override
    public int getCharacterId() {
        return this.spriteId;
    }

    @Override
    public void setCharacterId(int characterId) {
        this.spriteId = characterId;
    }

    private RECT getCharacterBounds(Set<Integer> characters, Set<BoundedTag> added) {
        RECT ret = new RECT(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE);
        boolean foundSomething = false;
        for (int c : characters) {
            BoundedTag bt;
            CharacterTag t = this.swf.getCharacter(c);
            RECT r = null;
            if (t instanceof BoundedTag && !added.contains(bt = (BoundedTag)((Object)t))) {
                added.add(bt);
                r = bt.getRect(added);
                added.remove(bt);
            }
            if (r == null || r.Xmin >= r.Xmax || r.Ymin >= r.Ymax) continue;
            foundSomething = true;
            ret.Xmin = Math.min(r.Xmin, ret.Xmin);
            ret.Ymin = Math.min(r.Ymin, ret.Ymin);
            ret.Xmax = Math.max(r.Xmax, ret.Xmax);
            ret.Ymax = Math.max(r.Ymax, ret.Ymax);
        }
        if (!foundSomething) {
            return new RECT();
        }
        return ret;
    }

    @Override
    public RECT getRect() {
        return this.getRect(new HashSet<BoundedTag>());
    }

    @Override
    public RECT getRect(Set<BoundedTag> added) {
        RECT ret;
        Cache<CharacterTag, RECT> cache = this.swf == null ? null : this.swf.getRectCache();
        RECT rECT = ret = cache == null ? null : cache.get(this);
        if (ret != null) {
            return ret;
        }
        ret = new RECT(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE);
        HashMap<Integer, Integer> depthMap = new HashMap<Integer, Integer>();
        boolean foundSomething = false;
        for (Tag t : this.getTags()) {
            MATRIX m = null;
            int characterId = -1;
            if (t instanceof PlaceObjectTypeTag) {
                PlaceObjectTypeTag pot = (PlaceObjectTypeTag)t;
                m = pot.getMatrix();
                int charId = pot.getCharacterId();
                if (charId > -1) {
                    depthMap.put(pot.getDepth(), charId);
                    characterId = charId;
                } else {
                    Integer chi = (Integer)depthMap.get(pot.getDepth());
                    if (chi != null) {
                        characterId = chi;
                    }
                }
            }
            if (characterId == -1) continue;
            HashSet<Integer> need = new HashSet<Integer>();
            need.add(characterId);
            RECT r = this.getCharacterBounds(need, added);
            if (m != null) {
                AffineTransform trans = SWF.matrixToTransform(m);
                Point topleft = new Point();
                trans.transform(new Point(r.Xmin, r.Ymin), topleft);
                Point topright = new Point();
                trans.transform(new Point(r.Xmax, r.Ymin), topright);
                Point bottomright = new Point();
                trans.transform(new Point(r.Xmax, r.Ymax), bottomright);
                Point bottomleft = new Point();
                trans.transform(new Point(r.Xmin, r.Ymax), bottomleft);
                r.Xmin = Math.min(Math.min(Math.min(topleft.x, topright.x), bottomleft.x), bottomright.x);
                r.Ymin = Math.min(Math.min(Math.min(topleft.y, topright.y), bottomleft.y), bottomright.y);
                r.Xmax = Math.max(Math.max(Math.max(topleft.x, topright.x), bottomleft.x), bottomright.x);
                r.Ymax = Math.max(Math.max(Math.max(topleft.y, topright.y), bottomleft.y), bottomright.y);
            }
            ret.Xmin = Math.min(r.Xmin, ret.Xmin);
            ret.Ymin = Math.min(r.Ymin, ret.Ymin);
            ret.Xmax = Math.max(r.Xmax, ret.Xmax);
            ret.Ymax = Math.max(r.Ymax, ret.Ymax);
            foundSomething = true;
        }
        if (!foundSomething) {
            ret = new RECT();
        }
        if (cache != null) {
            cache.put(this, ret);
        }
        return ret;
    }

    @Override
    public void setModified(boolean value) {
        if (!value) {
            for (Tag subTag : this.getTags()) {
                subTag.setModified(false);
            }
        }
        super.setModified(value);
    }

    @Override
    public ReadOnlyTagList getTags() {
        if (this.readOnlyTags == null) {
            this.readOnlyTags = new ReadOnlyTagList(this.subTags);
        }
        return this.readOnlyTags;
    }

    @Override
    public void removeTag(int index) {
        this.setModified(true);
        this.subTags.remove(index);
    }

    @Override
    public void removeTag(Tag tag) {
        this.setModified(true);
        this.subTags.remove(tag);
    }

    @Override
    public void addTag(Tag tag) {
        this.setModified(true);
        this.subTags.add(tag);
    }

    @Override
    public void addTag(int index, Tag tag) {
        this.setModified(true);
        this.subTags.add(index, tag);
    }

    @Override
    public void createOriginalData() {
        super.createOriginalData();
        for (Tag subTag : this.getTags()) {
            subTag.createOriginalData();
        }
    }

    @Override
    public void getNeededCharacters(Set<Integer> needed) {
        for (Tag t : this.getTags()) {
            if (!(t instanceof CharacterIdTag)) continue;
            needed.add(((CharacterIdTag)((Object)t)).getCharacterId());
        }
    }

    @Override
    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = this.getTimeline().replaceCharacter(oldCharacterId, newCharacterId);
        if (modified) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public boolean removeCharacter(int characterId) {
        boolean modified = this.getTimeline().removeCharacter(characterId);
        if (modified) {
            this.setModified(true);
        }
        return modified;
    }

    @Override
    public int getUsedParameters() {
        return 7;
    }

    @Override
    public Shape getOutline(int frame, int time, int ratio, RenderContext renderContext, Matrix transformation, boolean stroked) {
        return this.getTimeline().getOutline(frame, time, renderContext, transformation, stroked);
    }

    @Override
    public void toImage(int frame, int time, int ratio, RenderContext renderContext, SerializableImage image, SerializableImage fullImage, boolean isClip, Matrix transformation, Matrix strokeTransformation, Matrix absoluteTransformation, Matrix fullTransformation, ColorTransform colorTransform, double unzoom, boolean sameImage, ExportRectangle viewRect, boolean scaleStrokes, int drawMode) {
        this.getTimeline().toImage(frame, time, renderContext, image, fullImage, isClip, transformation, strokeTransformation, absoluteTransformation, colorTransform, unzoom, sameImage, viewRect, fullTransformation, scaleStrokes, drawMode);
    }

    @Override
    public void toSVG(SVGExporter exporter, int ratio, ColorTransform colorTransform, int level) throws IOException {
        this.getTimeline().toSVG(0, 0, null, 0, exporter, colorTransform, level + 1);
    }

    @Override
    public void toHtmlCanvas(StringBuilder result, double unitDivisor) {
        this.getTimeline().toHtmlCanvas(result, unitDivisor, null);
    }

    @Override
    public int getNumFrames() {
        return this.getTimeline().getFrameCount();
    }

    @Override
    public boolean isSingleFrame() {
        if (!this.isSingleFrameInitialized) {
            this.initialiteIsSingleFrame();
        }
        return this.isSingleFrame;
    }

    private synchronized void initialiteIsSingleFrame() {
        if (!this.isSingleFrameInitialized) {
            if (this.getTimeline().getRealFrameCount() > 1) {
                this.isSingleFrameInitialized = true;
                return;
            }
            this.isSingleFrame = this.getTimeline().isSingleFrame();
            this.isSingleFrameInitialized = true;
        }
    }

    @Override
    public boolean isModified() {
        if (super.isModified()) {
            return true;
        }
        for (Tag t : this.getTags()) {
            if (!t.isModified()) continue;
            return true;
        }
        return false;
    }

    public void clearReadOnlyListCache() {
        this.readOnlyTags = null;
    }

    @Override
    public void replaceTag(int index, Tag newTag) {
        this.removeTag(index);
        this.addTag(index, newTag);
    }

    @Override
    public RECT getRectWithStrokes() {
        return this.getRect();
    }
}

