/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSpecialType;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.base.AloneTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.ALPHABITMAPDATA;
import com.jpexs.decompiler.flash.types.ALPHACOLORMAPDATA;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.EnumValue;
import com.jpexs.decompiler.flash.types.annotations.EnumValues;
import com.jpexs.decompiler.flash.types.annotations.HideInRawEdit;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.SerializableImage;
import java.awt.Dimension;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

@SWFVersion(from=3)
public class DefineBitsLossless2Tag
extends ImageTag
implements AloneTag {
    public static final int ID = 36;
    public static final String NAME = "DefineBitsLossless2";
    @SWFType(value=BasicType.UI8)
    @EnumValues(value={@EnumValue(value=3, text="8-bit colormapped"), @EnumValue(value=5, text="32-bit ARGB")})
    public int bitmapFormat;
    @SWFType(value=BasicType.UI16)
    public int bitmapWidth;
    @SWFType(value=BasicType.UI16)
    public int bitmapHeight;
    @SWFType(value=BasicType.UI8)
    @Conditional(value={"bitmapFormat"}, options={3})
    public int bitmapColorTableSize;
    public ByteArrayRange zlibBitmapData;
    public static final int FORMAT_8BIT_COLORMAPPED = 3;
    public static final int FORMAT_32BIT_ARGB = 5;
    @HideInRawEdit
    private ALPHACOLORMAPDATA colorMapData;
    @HideInRawEdit
    private ALPHABITMAPDATA bitmapData;
    @Internal
    private boolean decompressed = false;

    public DefineBitsLossless2Tag(SWF swf) {
        this(swf, null, swf.getNextCharacterId());
    }

    public DefineBitsLossless2Tag(SWF swf, ByteArrayRange data, int characterID) {
        super(swf, 36, NAME, data);
        this.characterID = characterID;
        this.bitmapFormat = 5;
        this.bitmapWidth = 1;
        this.bitmapHeight = 1;
        this.zlibBitmapData = new ByteArrayRange(this.createEmptyImage());
        this.forceWriteAsLong = true;
    }

    public DefineBitsLossless2Tag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 36, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.characterID = sis.readUI16("characterID");
        this.bitmapFormat = sis.readUI8("bitmapFormat");
        this.bitmapWidth = sis.readUI16("bitmapWidth");
        this.bitmapHeight = sis.readUI16("bitmapHeight");
        if (this.bitmapFormat == 3) {
            this.bitmapColorTableSize = sis.readUI8("bitmapColorTableSize");
        }
        this.zlibBitmapData = sis.readByteRangeEx(sis.available(), "zlibBitmapData", DumpInfoSpecialType.ZLIB_DATA, null);
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterID);
        sos.writeUI8(this.bitmapFormat);
        sos.writeUI16(this.bitmapWidth);
        sos.writeUI16(this.bitmapHeight);
        if (this.bitmapFormat == 3) {
            sos.writeUI8(this.bitmapColorTableSize);
        }
        sos.write(this.zlibBitmapData);
    }

    private byte[] createEmptyImage() {
        try {
            ALPHABITMAPDATA bitmapData = new ALPHABITMAPDATA();
            bitmapData.bitmapPixelData = new int[]{-16777216};
            ByteArrayOutputStream bitmapDataOS = new ByteArrayOutputStream();
            SWFOutputStream sos = new SWFOutputStream(bitmapDataOS, this.getVersion());
            sos.writeALPHABITMAPDATA(bitmapData, 5, 1, 1);
            ByteArrayOutputStream zlibOS = new ByteArrayOutputStream();
            SWFOutputStream sos2 = new SWFOutputStream(zlibOS, this.getVersion());
            sos2.writeBytesZlib(bitmapDataOS.toByteArray());
            return zlibOS.toByteArray();
        }
        catch (IOException ex) {
            Logger.getLogger(DefineBitsLossless2Tag.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public void setImage(byte[] data) throws IOException {
        SerializableImage image = new SerializableImage(ImageHelper.read(data));
        ALPHABITMAPDATA bitmapData = new ALPHABITMAPDATA();
        int width = image.getWidth();
        int height = image.getHeight();
        bitmapData.bitmapPixelData = new int[width * height];
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int pos = 0; pos < pixels.length; ++pos) {
            int argb = pixels[pos];
            int a = argb >> 24 & 0xFF;
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb & 0xFF;
            r = r * a / 255;
            g = g * a / 255;
            b = b * a / 255;
            bitmapData.bitmapPixelData[pos] = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
        int format = 5;
        ByteArrayOutputStream bitmapDataOS = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(bitmapDataOS, this.getVersion());
        sos.writeALPHABITMAPDATA(bitmapData, format, width, height);
        ByteArrayOutputStream zlibOS = new ByteArrayOutputStream();
        SWFOutputStream sos2 = new SWFOutputStream(zlibOS, this.getVersion());
        sos2.writeBytesZlib(bitmapDataOS.toByteArray());
        this.zlibBitmapData = new ByteArrayRange(zlibOS.toByteArray());
        this.bitmapFormat = format;
        this.bitmapWidth = width;
        this.bitmapHeight = height;
        this.decompressed = false;
        this.clearCache();
        this.setModified(true);
    }

    public ALPHACOLORMAPDATA getColorMapData() {
        if (!this.decompressed) {
            this.uncompressData();
        }
        return this.colorMapData;
    }

    public ALPHABITMAPDATA getBitmapData() {
        if (!this.decompressed) {
            this.uncompressData();
        }
        return this.bitmapData;
    }

    private void uncompressData() {
        try {
            byte[] uncompressedData = SWFInputStream.uncompressByteArray(this.zlibBitmapData.getArray(), this.zlibBitmapData.getPos(), this.zlibBitmapData.getLength());
            SWFInputStream sis = new SWFInputStream(this.swf, uncompressedData);
            if (this.bitmapFormat == 3) {
                this.colorMapData = sis.readALPHACOLORMAPDATA(this.bitmapColorTableSize, this.bitmapWidth, this.bitmapHeight, "colorMapData");
            } else if (this.bitmapFormat == 5) {
                this.bitmapData = sis.readALPHABITMAPDATA(this.bitmapFormat, this.bitmapWidth, this.bitmapHeight, "bitmapData");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.decompressed = true;
    }

    @Override
    public ImageFormat getImageFormat() {
        return ImageFormat.PNG;
    }

    @Override
    public ImageFormat getOriginalImageFormat() {
        return ImageFormat.PNG;
    }

    @Override
    public InputStream getOriginalImageData() {
        return null;
    }

    @Override
    protected SerializableImage getImage() {
        SerializableImage bi = new SerializableImage(this.bitmapWidth, this.bitmapHeight, SerializableImage.TYPE_INT_ARGB_PRE);
        int[] pixels = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
        ALPHACOLORMAPDATA colorMapData = null;
        ALPHABITMAPDATA bitmapData = null;
        if (this.bitmapFormat == 3) {
            colorMapData = this.getColorMapData();
        }
        if (this.bitmapFormat == 5) {
            bitmapData = this.getBitmapData();
        }
        int pos32aligned = 0;
        int pos = 0;
        for (int y = 0; y < this.bitmapHeight; ++y) {
            for (int x = 0; x < this.bitmapWidth; ++x) {
                int colorTableIndex;
                int c = 0;
                if (this.bitmapFormat == 3 && (colorTableIndex = colorMapData.colorMapPixelData[pos32aligned] & 0xFF) < colorMapData.colorTableRGB.length) {
                    c = colorMapData.colorTableRGB[colorTableIndex];
                }
                if (this.bitmapFormat == 5) {
                    c = bitmapData.bitmapPixelData[pos];
                }
                pixels[pos] = c;
                ++pos32aligned;
                ++pos;
            }
            while (pos32aligned % 4 != 0) {
                ++pos32aligned;
            }
        }
        return bi;
    }

    @Override
    public Dimension getImageDimension() {
        return new Dimension(this.bitmapWidth, this.bitmapHeight);
    }
}

