/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.base.AloneTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.JpegFixer;
import com.jpexs.helpers.SerializableImage;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

@SWFVersion(from=2)
public class DefineBitsJPEG2Tag
extends ImageTag
implements AloneTag {
    public static final int ID = 21;
    public static final String NAME = "DefineBitsJPEG2";
    @SWFType(value=BasicType.UI8)
    public ByteArrayRange imageData;

    public DefineBitsJPEG2Tag(SWF swf) {
        super(swf, 21, NAME, null);
        this.characterID = swf.getNextCharacterId();
        this.imageData = new ByteArrayRange(this.createEmptyImage());
        this.forceWriteAsLong = true;
    }

    public DefineBitsJPEG2Tag(SWF swf, ByteArrayRange data, int characterID, byte[] imageData) throws IOException {
        super(swf, 21, NAME, data);
        this.characterID = characterID;
        this.imageData = new ByteArrayRange(imageData);
    }

    public DefineBitsJPEG2Tag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 21, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.characterID = sis.readUI16("characterID");
        this.imageData = sis.readByteRangeEx(sis.available(), "imageData");
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterID);
        sos.write(this.imageData);
    }

    private byte[] createEmptyImage() {
        BufferedImage img = new BufferedImage(1, 1, 3);
        ByteArrayOutputStream bitmapDataOS = new ByteArrayOutputStream();
        ImageHelper.write(img, ImageFormat.JPEG, bitmapDataOS);
        return bitmapDataOS.toByteArray();
    }

    @Override
    public void setImage(byte[] data) {
        this.imageData = new ByteArrayRange(data);
        this.clearCache();
        this.setModified(true);
    }

    @Override
    public ImageFormat getImageFormat() {
        return this.getOriginalImageFormat();
    }

    @Override
    public ImageFormat getOriginalImageFormat() {
        return ImageTag.getImageFormat(this.imageData);
    }

    @Override
    public InputStream getOriginalImageData() {
        int errorLength = DefineBitsJPEG2Tag.hasErrorHeader(this.imageData) ? 4 : 0;
        JpegFixer jpegFixer = new JpegFixer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            jpegFixer.fixJpeg(new ByteArrayInputStream(this.imageData.getArray(), this.imageData.getPos() + errorLength, this.imageData.getLength() - errorLength), baos);
        }
        catch (IOException ex) {
            Logger.getLogger(DefineBitsJPEG2Tag.class.getName()).log(Level.SEVERE, null, ex);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    @Override
    protected SerializableImage getImage() {
        try {
            BufferedImage image = ImageHelper.read(this.getOriginalImageData());
            if (image == null) {
                Logger.getLogger(DefineBitsJPEG2Tag.class.getName()).log(Level.SEVERE, "Failed to load image");
                return null;
            }
            SerializableImage img = new SerializableImage(image);
            return img;
        }
        catch (IOException ex) {
            Logger.getLogger(DefineBitsJPEG2Tag.class.getName()).log(Level.SEVERE, "Failed to get image", ex);
            return null;
        }
    }

    @Override
    public Dimension getImageDimension() {
        if (this.cachedImage != null) {
            return new Dimension(this.cachedImage.getWidth(), this.cachedImage.getHeight());
        }
        try {
            return ImageHelper.getDimesion(this.getOriginalImageData());
        }
        catch (IOException ex) {
            Logger.getLogger(DefineBitsJPEG2Tag.class.getName()).log(Level.SEVERE, "Failed to get image dimension", ex);
            return null;
        }
    }
}

