/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.search;

import com.jpexs.decompiler.flash.AppResources;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ClassPath;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.search.ScriptNotFoundException;
import com.jpexs.decompiler.flash.search.ScriptSearchResult;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ABCSearchResult
implements Serializable,
ScriptSearchResult {
    public static String STR_INSTANCE_INITIALIZER = AppResources.translate("trait.instanceinitializer");
    public static String STR_CLASS_INITIALIZER = AppResources.translate("trait.classinitializer");
    public static String STR_SCRIPT_INITIALIZER = AppResources.translate("trait.scriptinitializer");
    private ScriptPack scriptPack;
    private final boolean pcode;
    private final int classIndex;
    private final int traitId;
    private static final int SERIAL_VERSION_MAJOR = 1;
    private static final int SERIAL_VERSION_MINOR = 0;

    public ABCSearchResult(SWF swf, InputStream is) throws IOException, ScriptNotFoundException {
        List traitIndices;
        ClassPath cp;
        ObjectInputStream ois = new ObjectInputStream(is);
        int versionMajor = ois.read();
        ois.read();
        if (versionMajor != 1) {
            throw new IOException("Unknown search result version: " + versionMajor);
        }
        try {
            cp = (ClassPath)ois.readObject();
            traitIndices = (List)ois.readObject();
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(ABCSearchResult.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException();
        }
        this.pcode = ois.readBoolean();
        this.classIndex = ois.readInt();
        this.traitId = ois.readInt();
        boolean packFound = false;
        for (ScriptPack pack : swf.getAS3Packs()) {
            if (!cp.equals(pack.getClassPath()) || !traitIndices.equals(pack.traitIndices)) continue;
            this.scriptPack = pack;
            packFound = true;
            break;
        }
        if (!packFound) {
            throw new ScriptNotFoundException();
        }
    }

    public void save(OutputStream os) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.write(1);
        oos.write(0);
        oos.writeObject(this.scriptPack.getClassPath());
        oos.writeObject(this.scriptPack.traitIndices);
        oos.writeBoolean(this.pcode);
        oos.writeInt(this.classIndex);
        oos.writeInt(this.traitId);
        oos.flush();
        oos.close();
    }

    public ABCSearchResult(ScriptPack scriptPack) {
        this.scriptPack = scriptPack;
        this.pcode = false;
        this.classIndex = 0;
        this.traitId = -4;
    }

    public ABCSearchResult(ScriptPack scriptPack, int classIndex, int traitId) {
        this.scriptPack = scriptPack;
        this.pcode = true;
        this.classIndex = classIndex;
        this.traitId = traitId;
    }

    public ScriptPack getScriptPack() {
        return this.scriptPack;
    }

    public boolean isPcode() {
        return this.pcode;
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public int getTraitId() {
        return this.traitId;
    }

    private String getTraitName() {
        boolean isStatic;
        if (this.traitId == -3) {
            return STR_SCRIPT_INITIALIZER;
        }
        if (this.classIndex == -1) {
            return null;
        }
        if (this.traitId == -2) {
            return STR_CLASS_INITIALIZER;
        }
        if (this.traitId == -1) {
            return STR_INSTANCE_INITIALIZER;
        }
        ABC abc = this.scriptPack.abc;
        int staticTraitCount = abc.class_info.get((int)this.classIndex).static_traits.traits.size();
        boolean bl = isStatic = this.traitId < staticTraitCount;
        if (isStatic) {
            return abc.class_info.get((int)this.classIndex).static_traits.traits.get(this.traitId).getName(abc).getName(abc.constants, null, false, true);
        }
        int index = this.traitId - staticTraitCount;
        return abc.instance_info.get((int)this.classIndex).instance_traits.traits.get(index).getName(abc).getName(abc.constants, null, false, true);
    }

    public String toString() {
        String result = this.scriptPack.getClassPath().toString();
        if (this.pcode) {
            result = result + "/";
            result = result + this.getTraitName();
        }
        return result;
    }

    @Override
    public SWF getSWF() {
        return this.scriptPack.getSwf();
    }
}

