/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.abc.avm2.parser.AVM2ParseException;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.ActionScript3Parser;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.importers.As3ScriptReplaceException;
import com.jpexs.decompiler.flash.importers.As3ScriptReplaceExceptionItem;
import com.jpexs.decompiler.flash.importers.As3ScriptReplacerInterface;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.graph.CompilationException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class FFDecAs3ScriptReplacer
implements As3ScriptReplacerInterface {
    @Override
    public void replaceScript(ScriptPack pack, String text) throws As3ScriptReplaceException, IOException, InterruptedException {
        ABC abc = pack.abc;
        SWF swf = pack.abc.getSwf();
        String scriptName = pack.getPathScriptName() + ".as";
        int oldIndex = pack.scriptIndex;
        int newIndex = abc.script_info.size();
        try {
            ScriptInfo si = abc.script_info.get(oldIndex);
            if (pack.isSimple) {
                si.delete(abc, true);
            } else {
                for (int t : pack.traitIndices) {
                    si.traits.traits.get(t).delete(abc, true);
                }
            }
            int newClassIndex = abc.instance_info.size();
            for (int t : pack.traitIndices) {
                if (!(si.traits.traits.get(t) instanceof TraitClass)) continue;
                TraitClass tc = (TraitClass)si.traits.traits.get(t);
                newClassIndex = tc.class_info + 1;
            }
            ArrayList<ABC> otherAbcs = new ArrayList<ABC>(pack.allABCs);
            otherAbcs.remove(abc);
            abc.script_info.get(oldIndex).delete(abc, true);
            ActionScript3Parser.compile(text, abc, otherAbcs, scriptName, newClassIndex, oldIndex);
            if (pack.isSimple) {
                abc.script_info.set(oldIndex, abc.script_info.get(newIndex));
                abc.script_info.remove(newIndex);
            }
            abc.script_info.get(oldIndex).setModified(true);
            abc.pack();
            ((Tag)((Object)abc.parentTag)).setModified(true);
        }
        catch (AVM2ParseException ex) {
            abc.script_info.get(oldIndex).delete(abc, false);
            throw new As3ScriptReplaceException(new As3ScriptReplaceExceptionItem(null, ex.text, (int)ex.line));
        }
        catch (CompilationException ex) {
            abc.script_info.get(oldIndex).delete(abc, false);
            throw new As3ScriptReplaceException(new As3ScriptReplaceExceptionItem(null, ex.text, ex.line));
        }
    }

    @Override
    public boolean isAvailable() {
        File swc = Configuration.getPlayerSWC();
        return swc != null && swc.exists();
    }

    @Override
    public void initReplacement(ScriptPack pack) {
    }

    @Override
    public void deinitReplacement(ScriptPack pack) {
    }
}

