/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers;

import com.jpexs.decompiler.flash.abc.ScriptPack;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.exporters.settings.ScriptExportSettings;
import com.jpexs.decompiler.flash.importers.As3ScriptReplaceException;
import com.jpexs.decompiler.flash.importers.As3ScriptReplaceExceptionItem;
import com.jpexs.decompiler.flash.importers.As3ScriptReplacerInterface;
import com.jpexs.decompiler.flash.importers.ScriptImporterProgressListener;
import com.jpexs.helpers.Helper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AS3ScriptImporter {
    private static final Logger logger = Logger.getLogger(AS3ScriptImporter.class.getName());

    public int importScripts(As3ScriptReplacerInterface scriptReplacer, String scriptsFolder, List<ScriptPack> packs) throws InterruptedException {
        return this.importScripts(scriptReplacer, scriptsFolder, packs, null);
    }

    public int importScripts(As3ScriptReplacerInterface scriptReplacer, String scriptsFolder, List<ScriptPack> packs, ScriptImporterProgressListener listener) throws InterruptedException {
        if (!scriptsFolder.endsWith(File.separator)) {
            scriptsFolder = scriptsFolder + File.separator;
        }
        int importCount = 0;
        for (ScriptPack pack : packs) {
            if (Thread.currentThread().isInterrupted()) {
                return importCount;
            }
            try {
                File file = pack.getExportFile(scriptsFolder, new ScriptExportSettings(ScriptExportMode.AS, false, false));
                if (!file.exists()) continue;
                pack.getSwf().informListeners("importing_as", file.getAbsolutePath());
                String fileName = file.getAbsolutePath();
                String txt = Helper.readTextFile(fileName);
                try {
                    pack.abc.replaceScriptPack(scriptReplacer, pack, txt);
                }
                catch (As3ScriptReplaceException asre) {
                    for (As3ScriptReplaceExceptionItem item : asre.getExceptionItems()) {
                        logger.log(Level.SEVERE, "%error% on line %line%, column %col%, file: %file%".replace("%error%", item.getMessage()).replace("%line%", Long.toString(item.getLine())).replace("%file%", fileName).replace("%col%", "" + item.getCol()));
                    }
                }
                catch (InterruptedException ex) {
                    return importCount;
                }
                ++importCount;
                if (listener == null) continue;
                listener.scriptImported();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        return importCount;
    }
}

