/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.script;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.AVM2Deobfuscation;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.instructions.alchemy.AlchemyTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.construction.NewFunctionIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.FindPropertyIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.FindPropertyStrictIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.other.GetLexIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.AsTypeIns;
import com.jpexs.decompiler.flash.abc.avm2.instructions.types.CoerceIns;
import com.jpexs.decompiler.flash.abc.avm2.model.InitVectorAVM2Item;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.NamespaceSet;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.script.Dependency;
import com.jpexs.decompiler.flash.exporters.script.DependencyType;
import com.jpexs.decompiler.flash.tags.ABCContainerTag;
import com.jpexs.decompiler.graph.DottedChain;
import java.util.List;

public class DependencyParser {
    public static void parseDependenciesFromNS(String ignoredCustom, ABC abc, List<Dependency> dependencies, List<String> uses, int namespace_index, DottedChain ignorePackage, String name, DependencyType dependencyType) {
        Namespace ns = abc.constants.getNamespace(namespace_index);
        if (name.isEmpty()) {
            name = "*";
        }
        DottedChain newimport = ns.getName(abc.constants);
        if (DependencyParser.parseUsagesFromNS(ignoredCustom, abc, dependencies, uses, namespace_index, ignorePackage, name)) {
            return;
        }
        if (ns.kind != 22 && ns.kind != 23) {
            return;
        }
        Dependency dep = new Dependency(newimport = newimport.addWithSuffix(name), dependencyType);
        if (!dependencies.contains(dep)) {
            DottedChain pkg = newimport.getWithoutLast();
            if (pkg.equals(InitVectorAVM2Item.VECTOR_PACKAGE)) {
                return;
            }
            if (!pkg.equals(ignorePackage)) {
                dependencies.add(dep);
            }
        }
    }

    public static void parseDependenciesFromMultiname(String ignoredCustom, ABC abc, List<Dependency> dependencies, List<String> uses, Multiname m, DottedChain ignorePackage, List<DottedChain> fullyQualifiedNames, DependencyType dependencyType) {
        if (m != null) {
            if (m.kind == 29) {
                if (m.qname_index != 0) {
                    DependencyParser.parseDependenciesFromMultiname(ignoredCustom, abc, dependencies, uses, abc.constants.getMultiname(m.qname_index), ignorePackage, fullyQualifiedNames, dependencyType);
                }
                int[] nArray = m.params;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer i2 = nArray[i];
                    if (i2 == 0) continue;
                    DependencyParser.parseDependenciesFromMultiname(ignoredCustom, abc, dependencies, uses, abc.constants.getMultiname(i2), ignorePackage, fullyQualifiedNames, dependencyType);
                }
                return;
            }
            Namespace ns = m.getNamespace(abc.constants);
            String name = m.getName(abc.constants, fullyQualifiedNames, true, true);
            NamespaceSet nss = m.getNamespaceSet(abc.constants);
            if (ns != null) {
                DependencyParser.parseDependenciesFromNS(ignoredCustom, abc, dependencies, uses, m.namespace_index, ignorePackage, name, dependencyType);
            }
            if (nss != null) {
                for (int n : nss.namespaces) {
                    DependencyParser.parseDependenciesFromNS(ignoredCustom, abc, dependencies, uses, n, ignorePackage, nss.namespaces.length > 1 ? "" : name, dependencyType);
                }
            }
        }
    }

    public static void parseDependenciesFromMethodInfo(Trait trait, int scriptIndex, int classIndex, boolean isStatic, String ignoredCustom, ABC abc, int method_index, List<Dependency> dependencies, List<String> uses, DottedChain ignorePackage, List<DottedChain> fullyQualifiedNames, List<Integer> visitedMethods) throws InterruptedException {
        if (method_index < 0 || method_index >= abc.method_info.size()) {
            return;
        }
        visitedMethods.add(method_index);
        if (abc.method_info.get((int)method_index).ret_type != 0) {
            DependencyParser.parseDependenciesFromMultiname(ignoredCustom, abc, dependencies, uses, abc.constants.getMultiname(abc.method_info.get((int)method_index).ret_type), ignorePackage, fullyQualifiedNames, DependencyType.SIGNATURE);
        }
        for (int t : abc.method_info.get((int)method_index).param_types) {
            if (t == 0) continue;
            DependencyParser.parseDependenciesFromMultiname(ignoredCustom, abc, dependencies, uses, abc.constants.getMultiname(t), ignorePackage, fullyQualifiedNames, DependencyType.SIGNATURE);
        }
        MethodBody body = abc.findBody(method_index);
        if (body != null) {
            body = body.convertMethodBodyCanUseLast(Configuration.autoDeobfuscate.get(), "", isStatic, scriptIndex, classIndex, abc, trait);
            body.traits.getDependencies(scriptIndex, classIndex, isStatic, ignoredCustom, abc, dependencies, uses, ignorePackage, fullyQualifiedNames);
            for (ABCException ex : body.exceptions) {
                DependencyParser.parseDependenciesFromMultiname(ignoredCustom, abc, dependencies, uses, abc.constants.getMultiname(ex.type_index), ignorePackage, fullyQualifiedNames, DependencyType.EXPRESSION);
            }
            for (AVM2Instruction ins : body.getCode().code) {
                DottedChain nimport;
                Dependency depExp;
                if (ins.definition instanceof AlchemyTypeIns && !dependencies.contains(depExp = new Dependency(nimport = AlchemyTypeIns.ALCHEMY_PACKAGE.addWithSuffix(ins.definition.instructionName), DependencyType.EXPRESSION))) {
                    dependencies.add(depExp);
                }
                if (ins.definition instanceof NewFunctionIns && ins.operands[0] != method_index && !visitedMethods.contains(ins.operands[0])) {
                    DependencyParser.parseDependenciesFromMethodInfo(trait, scriptIndex, classIndex, isStatic, ignoredCustom, abc, ins.operands[0], dependencies, uses, ignorePackage, fullyQualifiedNames, visitedMethods);
                }
                if (ins.definition instanceof FindPropertyStrictIns || ins.definition instanceof FindPropertyIns || ins.definition instanceof GetLexIns || ins.definition instanceof CoerceIns || ins.definition instanceof AsTypeIns) {
                    int m = ins.operands[0];
                    if (m == 0 || m >= abc.constants.getMultinameCount()) continue;
                    DependencyParser.parseDependenciesFromMultiname(ignoredCustom, abc, dependencies, uses, abc.constants.getMultiname(m), ignorePackage, fullyQualifiedNames, DependencyType.EXPRESSION);
                    continue;
                }
                for (int k = 0; k < ins.definition.operands.length; ++k) {
                    int multinameIndex;
                    if (ins.definition.operands[k] != 257 || (multinameIndex = ins.operands[k]) >= abc.constants.getMultinameCount()) continue;
                    DependencyParser.parseUsagesFromMultiname(ignoredCustom, abc, dependencies, uses, abc.constants.getMultiname(multinameIndex), ignorePackage, fullyQualifiedNames, DependencyType.EXPRESSION);
                }
            }
        }
    }

    public static void parseUsagesFromMultiname(String ignoredCustom, ABC abc, List<Dependency> dependencies, List<String> uses, Multiname m, DottedChain ignorePackage, List<DottedChain> fullyQualifiedNames, DependencyType dependencyType) {
        if (m != null) {
            if (m.kind == 29) {
                if (m.qname_index != 0) {
                    DependencyParser.parseUsagesFromMultiname(ignoredCustom, abc, dependencies, uses, abc.constants.getMultiname(m.qname_index), ignorePackage, fullyQualifiedNames, dependencyType);
                }
                int[] nArray = m.params;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer i2 = nArray[i];
                    if (i2 == 0) continue;
                    DependencyParser.parseUsagesFromMultiname(ignoredCustom, abc, dependencies, uses, abc.constants.getMultiname(i2), ignorePackage, fullyQualifiedNames, dependencyType);
                }
                return;
            }
            Namespace ns = m.getNamespace(abc.constants);
            String name = m.getName(abc.constants, fullyQualifiedNames, false, true);
            NamespaceSet nss = m.getNamespaceSet(abc.constants);
            if (ns != null) {
                DependencyParser.parseUsagesFromNS(ignoredCustom, abc, dependencies, uses, m.namespace_index, ignorePackage, name);
            }
            if (nss != null) {
                if (nss.namespaces.length == 1) {
                    DependencyParser.parseUsagesFromNS(ignoredCustom, abc, dependencies, uses, nss.namespaces[0], ignorePackage, name);
                } else {
                    for (int n : nss.namespaces) {
                        DependencyParser.parseUsagesFromNS(ignoredCustom, abc, dependencies, uses, n, ignorePackage, "");
                    }
                }
            }
        }
    }

    private static boolean parseUsagesFromNS(String ignoredCustom, ABC abc, List<Dependency> dependencies, List<String> uses, int namespace_index, DottedChain ignorePackage, String name) {
        Namespace ns = abc.constants.getNamespace(namespace_index);
        if (ns.kind == 8) {
            String nsVal = ns.getName(abc.constants).toRawString();
            for (ABCContainerTag abcTag : abc.getAbcTags()) {
                DottedChain nsimport = abcTag.getABC().nsValueToName(nsVal);
                if (nsimport.equals(AVM2Deobfuscation.BUILTIN)) {
                    return true;
                }
                if (nsimport.isEmpty()) continue;
                Dependency depNs = new Dependency(nsimport, DependencyType.NAMESPACE);
                if (!nsimport.getWithoutLast().equals(ignorePackage) && !dependencies.contains(depNs)) {
                    dependencies.add(depNs);
                }
                if (ignoredCustom != null && nsVal.equals(ignoredCustom)) {
                    return true;
                }
                if (!uses.contains(nsimport.getLast())) {
                    uses.add(nsimport.getLast());
                }
                return true;
            }
        }
        return false;
    }
}

