/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters;

import com.jpexs.decompiler.flash.AbortRetryIgnoreHandler;
import com.jpexs.decompiler.flash.EventListener;
import com.jpexs.decompiler.flash.ReadOnlyTagList;
import com.jpexs.decompiler.flash.RetryTask;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.action.parser.ActionParseException;
import com.jpexs.decompiler.flash.exporters.PreviewExporter;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.exporters.modes.MorphShapeExportMode;
import com.jpexs.decompiler.flash.exporters.morphshape.CanvasMorphShapeExporter;
import com.jpexs.decompiler.flash.exporters.settings.MorphShapeExportSettings;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MorphShapeExporter {
    public List<File> exportMorphShapes(AbortRetryIgnoreHandler handler, String outdir, ReadOnlyTagList tags, MorphShapeExportSettings settings, EventListener evl) throws IOException, InterruptedException {
        ArrayList<File> ret = new ArrayList<File>();
        if (tags.isEmpty()) {
            return ret;
        }
        File foutdir = new File(outdir);
        Path.createDirectorySafe(foutdir);
        int count = 0;
        for (Object t : tags) {
            if (!(t instanceof MorphShapeTag)) continue;
            ++count;
        }
        if (count == 0) {
            return ret;
        }
        int currentIndex = 1;
        for (Tag t : tags) {
            if (!(t instanceof MorphShapeTag)) continue;
            if (evl != null) {
                evl.handleExportingEvent("morphshape", currentIndex, count, t.getName());
            }
            int characterID = 0;
            if (t instanceof CharacterTag) {
                characterID = ((CharacterTag)t).getCharacterId();
            }
            File file = new File(outdir + File.separator + characterID + settings.getFileExtension());
            new RetryTask(() -> MorphShapeExporter.lambda$exportMorphShapes$0(t, settings, file), handler).run();
            ret.add(file);
            if (evl != null) {
                evl.handleExportedEvent("morphshape", currentIndex, count, t.getName());
            }
            ++currentIndex;
        }
        if (settings.mode == MorphShapeExportMode.CANVAS) {
            File fcanvas = new File(foutdir + File.separator + "canvas.js");
            Helper.saveStream(SWF.class.getClassLoader().getResourceAsStream("com/jpexs/helpers/resource/canvas.js"), fcanvas);
            ret.add(fcanvas);
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void lambda$exportMorphShapes$0(Tag t, MorphShapeExportSettings settings, File file) throws IOException, InterruptedException {
        mst = (MorphShapeTag)t;
        switch (1.$SwitchMap$com$jpexs$decompiler$flash$exporters$modes$MorphShapeExportMode[settings.mode.ordinal()]) {
            case 1: {
                fos = new BufferedOutputStream(new FileOutputStream(file));
                var5_7 = null;
                rect = new ExportRectangle(mst.getRect());
                rect.xMax *= settings.zoom;
                rect.yMax *= settings.zoom;
                rect.xMin *= settings.zoom;
                rect.yMin *= settings.zoom;
                exporter = new SVGExporter(rect, settings.zoom);
                mst.toSVG(exporter, -2, new CXFORMWITHALPHA(), 0);
                fos.write(Utf8Helper.getBytes(exporter.getSVG()));
                if (fos == null) break;
                if (var5_7 == null) ** GOTO lbl23
                try {
                    fos.close();
                }
                catch (Throwable rect) {
                    var5_7.addSuppressed(rect);
                }
                break;
lbl23:
                // 1 sources

                fos.close();
                break;
                catch (Throwable rect) {
                    try {
                        var5_7 = rect;
                        throw rect;
                    }
                    catch (Throwable var8_21) {
                        if (fos != null) {
                            if (var5_7 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var9_23) {
                                    var5_7.addSuppressed(var9_23);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var8_21;
                    }
                }
            }
            case 2: {
                fos = new BufferedOutputStream(new FileOutputStream(file));
                var5_8 = null;
                deltaX = -Math.min(mst.getStartBounds().Xmin, mst.getEndBounds().Xmin);
                deltaY = -Math.min(mst.getStartBounds().Ymin, mst.getEndBounds().Ymin);
                cse = new CanvasMorphShapeExporter(mst.getSwf(), mst.getShapeAtRatio(0), mst.getShapeAtRatio(65535), new CXFORMWITHALPHA(), 20.0, deltaX, deltaY);
                cse.export();
                needed = new HashSet<Integer>();
                ct = mst;
                needed.add(ct.getCharacterId());
                ct.getNeededCharactersDeep(needed);
                baos = new ByteArrayOutputStream();
                SWF.libraryToHtmlCanvas(ct.getSwf(), needed, baos);
                fos.write(Utf8Helper.getBytes(cse.getHtml(new String(baos.toByteArray(), Utf8Helper.charset), SWF.getTypePrefix(mst) + mst.getCharacterId(), mst.getRect())));
                if (fos == null) break;
                if (var5_8 == null) ** GOTO lbl64
                try {
                    fos.close();
                }
                catch (Throwable deltaX) {
                    var5_8.addSuppressed(deltaX);
                }
                break;
lbl64:
                // 1 sources

                fos.close();
                break;
                catch (Throwable deltaX) {
                    try {
                        var5_8 = deltaX;
                        throw deltaX;
                    }
                    catch (Throwable var12_27) {
                        if (fos != null) {
                            if (var5_8 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var13_28) {
                                    var5_8.addSuppressed(var13_28);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var12_27;
                    }
                }
            }
            case 3: {
                fos = new BufferedOutputStream(new FileOutputStream(file));
                var5_9 = null;
                try {
                    new PreviewExporter().exportSwf(fos, mst, null, 0, false);
                }
                catch (ActionParseException ex) {
                    Logger.getLogger(MorphShapeExporter.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (fos == null) break;
                if (var5_9 == null) ** GOTO lbl99
                try {
                    fos.close();
                }
                catch (Throwable var6_17) {
                    var5_9.addSuppressed(var6_17);
                }
                break;
lbl99:
                // 1 sources

                fos.close();
                break;
                catch (Throwable var6_18) {
                    try {
                        var5_9 = var6_18;
                        throw var6_18;
                    }
                    catch (Throwable var14_29) {
                        if (fos != null) {
                            if (var5_9 != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable var15_30) {
                                    var5_9.addSuppressed(var15_30);
                                }
                            } else {
                                fos.close();
                            }
                        }
                        throw var14_29;
                    }
                }
            }
        }
    }
}

