/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.configuration;

import com.jpexs.decompiler.flash.configuration.ConfigurationInternal;
import com.jpexs.decompiler.flash.configuration.ConfigurationItemChangeListener;
import com.jpexs.decompiler.flash.configuration.ConfigurationName;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfigurationItem<T> {
    private final String name;
    protected boolean hasValue;
    private T value;
    private T defaultValue;
    private boolean modified;
    private List<ConfigurationItemChangeListener<T>> listeners;

    public ConfigurationItem(String name) {
        this.name = name;
    }

    public ConfigurationItem(String name, T defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    public ConfigurationItem(String name, T defaultValue, T value) {
        this.name = name;
        this.hasValue = true;
        this.defaultValue = defaultValue;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public T get() {
        if (!this.hasValue) {
            return this.defaultValue;
        }
        return this.value;
    }

    public T get(T defaultValue) {
        if (!this.hasValue) {
            return defaultValue;
        }
        return this.value;
    }

    public void set(T value) {
        this.hasValue = true;
        this.modified = true;
        this.value = value;
        this.fireConfigurationItemChanged(value);
    }

    public void unset() {
        this.hasValue = false;
        this.modified = true;
        this.value = null;
        this.fireConfigurationItemChanged(this.defaultValue);
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public boolean isModified() {
        return this.modified;
    }

    public static ConfigurationItem<?> getItem(Field field) {
        try {
            field.setAccessible(true);
            ConfigurationItem item = (ConfigurationItem)field.get(null);
            return item;
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            Logger.getLogger(ConfigurationItem.class.getName()).log(Level.SEVERE, null, ex);
            throw new Error(ex);
        }
    }

    public static Class<?> getConfigurationFieldType(Field field) {
        Type type = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
        if (type instanceof Class) {
            return (Class)type;
        }
        return (Class)((ParameterizedType)type).getRawType();
    }

    public static String getName(Field field) {
        ConfigurationName annotation = field.getAnnotation(ConfigurationName.class);
        String name = annotation == null ? field.getName() : annotation.value();
        return name;
    }

    public static boolean isInternal(Field field) {
        ConfigurationInternal cint = field.getAnnotation(ConfigurationInternal.class);
        return cint != null;
    }

    public String toString() {
        return this.name;
    }

    private void fireConfigurationItemChanged(T newValue) {
        if (this.listeners != null) {
            for (ConfigurationItemChangeListener<T> listener : this.listeners) {
                listener.configurationItemChanged(newValue);
            }
        }
    }

    public void addListener(ConfigurationItemChangeListener<T> l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ConfigurationItemChangeListener<T>>();
        }
        this.listeners.add(l);
    }

    public void removeListener(ConfigurationItemChangeListener<T> l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }
}

