/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.swf5;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionScriptFunction;
import com.jpexs.decompiler.flash.action.LocalDataArea;
import com.jpexs.decompiler.flash.action.model.CallFunctionActionItem;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SecondPassData;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@SWFVersion(from=5)
public class ActionCallFunction
extends Action {
    public ActionCallFunction() {
        super(61, 0);
    }

    @Override
    public String toString() {
        return "CallFunction";
    }

    @Override
    public boolean execute(LocalDataArea lda) {
        String functionName = lda.popAsString();
        int numArgs = (int)lda.popAsNumber().doubleValue();
        ArrayList<Object> args = new ArrayList<Object>();
        for (int i = 0; i < numArgs; ++i) {
            args.add(lda.pop());
        }
        for (ActionScriptFunction f : lda.functions) {
            if (!functionName.equals(f.getFunctionName())) continue;
            lda.push(lda.stage.callFunction(f.getFunctionOffset(), f.getFunctionLength(), args, f.getFuncRegNames(), Undefined.INSTANCE));
            return true;
        }
        return true;
    }

    @Override
    public void translate(SecondPassData secondPassData, boolean insideDoInitAction, GraphSourceItem lineStartAction, TranslateStack stack, List<GraphTargetItem> output, HashMap<Integer, String> regNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, int staticOperation, String path) {
        GraphTargetItem functionName = stack.pop();
        long numArgs = this.popLong(stack);
        ArrayList<GraphTargetItem> args = new ArrayList<GraphTargetItem>();
        for (long l = 0L; l < numArgs; ++l) {
            args.add(stack.pop());
        }
        CallFunctionActionItem cft = new CallFunctionActionItem((GraphSourceItem)this, lineStartAction, functionName, args);
        cft.calculatedFunction = functions.get(functionName.toStringNoQuotes(LocalData.empty));
        stack.push(cft);
    }

    @Override
    public int getStackPopCount(BaseLocalData localData, TranslateStack stack) {
        int result = 2;
        if (stack.size() >= 2) {
            result = (int)((long)result + stack.peek(2).getAsLong());
        }
        return result;
    }

    @Override
    public int getStackPushCount(BaseLocalData localData, TranslateStack stack) {
        return 1;
    }
}

