/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model.clauses;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.GetVariableActionItem;
import com.jpexs.decompiler.flash.action.model.SetTypeActionItem;
import com.jpexs.decompiler.flash.action.model.StoreRegisterActionItem;
import com.jpexs.decompiler.flash.action.model.clauses.LoopActionItem;
import com.jpexs.decompiler.flash.action.parser.script.ActionSourceGenerator;
import com.jpexs.decompiler.flash.action.parser.script.VariableActionItem;
import com.jpexs.decompiler.flash.action.swf4.ActionIf;
import com.jpexs.decompiler.flash.action.swf4.ActionJump;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.action.swf5.ActionEquals2;
import com.jpexs.decompiler.flash.action.swf5.ActionStoreRegister;
import com.jpexs.decompiler.flash.action.swf6.ActionEnumerate2;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.LoopWithType;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.Loop;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ForInActionItem
extends LoopActionItem
implements Block {
    public GraphTargetItem variableName;
    public GraphTargetItem enumVariable;
    public List<GraphTargetItem> commands;
    private boolean labelUsed;

    @Override
    public List<List<GraphTargetItem>> getSubs() {
        ArrayList<List<GraphTargetItem>> ret = new ArrayList<List<GraphTargetItem>>();
        if (this.commands != null) {
            ret.add(this.commands);
        }
        return ret;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.variableName);
        visitor.visit(this.enumVariable);
        visitor.visitAll(this.commands);
    }

    @Override
    public void visitNoBlock(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.variableName);
        visitor.visit(this.enumVariable);
    }

    public ForInActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, Loop loop, GraphTargetItem variableName, GraphTargetItem enumVariable, List<GraphTargetItem> commands) {
        super(instruction, lineStartIns, loop);
        this.variableName = variableName;
        this.enumVariable = enumVariable;
        this.commands = commands;
    }

    @Override
    public boolean needsSemicolon() {
        return false;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (writer instanceof NulWriter) {
            ((NulWriter)writer).startLoop(this.loop.id, LoopWithType.LOOP_TYPE_LOOP);
        }
        if (this.labelUsed) {
            writer.append("loop").append(this.loop.id).append(":").newLine();
        }
        writer.append("for");
        if (writer.getFormatting().spaceBeforeParenthesesForParentheses) {
            writer.append(" ");
        }
        writer.append("(");
        if (this.variableName instanceof SetTypeActionItem) {
            GraphTargetItem vn = ((SetTypeActionItem)((Object)this.variableName)).getObject();
            if (this.variableName instanceof StoreRegisterActionItem && ((StoreRegisterActionItem)this.variableName).define) {
                writer.append("var ");
            }
            if (vn instanceof GetVariableActionItem) {
                ((GetVariableActionItem)vn).printObfuscatedName = true;
            }
            this.stripQuotes(vn, localData, writer);
        }
        writer.append(" in ");
        this.enumVariable.toString(writer, localData);
        writer.append(")").startBlock();
        for (GraphTargetItem ti : this.commands) {
            ti.toStringSemicoloned(writer, localData).newLine();
        }
        writer.endBlock();
        if (writer instanceof NulWriter) {
            LoopWithType loopOjb = ((NulWriter)writer).endLoop(this.loop.id);
            this.labelUsed = loopOjb.used;
        }
        return writer;
    }

    @Override
    public List<ContinueItem> getContinues() {
        ArrayList<ContinueItem> ret = new ArrayList<ContinueItem>();
        for (GraphTargetItem ti : this.commands) {
            if (ti instanceof ContinueItem) {
                ret.add((ContinueItem)ti);
            }
            if (!(ti instanceof Block)) continue;
            ret.addAll(((Block)((Object)ti)).getContinues());
        }
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ActionSourceGenerator asGenerator = (ActionSourceGenerator)generator;
        HashMap<String, Integer> registerVars = asGenerator.getRegisterVars(localData);
        ret.addAll(this.enumVariable.toSource(localData, generator));
        ret.add(new ActionEnumerate2());
        ArrayList<Action> loopExpr = new ArrayList<Action>();
        int exprReg = asGenerator.getTempRegister(localData);
        loopExpr.add(new ActionStoreRegister(exprReg));
        loopExpr.add(new ActionPush(Null.INSTANCE));
        loopExpr.add(new ActionEquals2());
        ActionIf forInEndIf = new ActionIf(0);
        loopExpr.add(forInEndIf);
        ArrayList<Action> loopBody = new ArrayList<Action>();
        VariableActionItem vaact = (VariableActionItem)this.variableName;
        ActionItem setVar = vaact.getBoxedValue();
        setVar.value = new DirectValueActionItem(new RegisterNumber(exprReg));
        loopBody.addAll(asGenerator.toActionList(((GraphTargetItem)setVar).toSourceIgnoreReturnValue(localData, generator)));
        int oldForIn = asGenerator.getForInLevel(localData);
        asGenerator.setForInLevel(localData, oldForIn + 1);
        loopBody.addAll(asGenerator.toActionList(asGenerator.generate(localData, this.commands)));
        asGenerator.setForInLevel(localData, oldForIn);
        ActionJump forinJmpBack = new ActionJump(0);
        loopBody.add(forinJmpBack);
        int bodyLen = Action.actionsToBytes(loopBody, false, 10).length;
        int exprLen = Action.actionsToBytes(loopExpr, false, 10).length;
        forinJmpBack.setJumpOffset(-bodyLen - exprLen);
        forInEndIf.setJumpOffset(bodyLen);
        ret.addAll(loopExpr);
        ret.addAll(loopBody);
        asGenerator.releaseTempRegister(localData, exprReg);
        return ret;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }
}

