/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf5.ActionInitObject;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.TernarOpItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class InitObjectActionItem
extends ActionItem {
    public List<GraphTargetItem> names;
    public List<GraphTargetItem> values;

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visitAll(this.names);
        visitor.visitAll(this.values);
    }

    public InitObjectActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, List<GraphTargetItem> names, List<GraphTargetItem> values) {
        super(instruction, lineStartIns, 0);
        this.values = values;
        this.names = names;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("{");
        for (int i = this.values.size() - 1; i >= 0; --i) {
            if (i < this.values.size() - 1) {
                writer.append(",");
            }
            writer.append(IdentifiersDeobfuscation.printIdentifier(false, this.names.get(i).toStringNoQuotes(localData), new String[0]));
            writer.append(":");
            if (this.values.get(i) instanceof TernarOpItem) {
                writer.append("(");
                this.values.get(i).toString(writer, localData);
                writer.append(")");
                continue;
            }
            this.values.get(i).toString(writer, localData);
        }
        return writer.append("}");
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        for (GraphTargetItem name : this.names) {
            ret.addAll(name.getNeededSources());
        }
        for (GraphTargetItem value : this.values) {
            ret.addAll(value.getNeededSources());
        }
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        for (int i = this.values.size() - 1; i >= 0; --i) {
            ret.addAll(this.names.get(i).toSource(localData, generator));
            ret.addAll(this.values.get(i).toSource(localData, generator));
        }
        ret.add(new ActionPush(this.values.size()));
        ret.add(new ActionInitObject());
        return ret;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + Objects.hashCode(this.names);
        hash = 61 * hash + Objects.hashCode(this.values);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InitObjectActionItem other = (InitObjectActionItem)obj;
        if (!Objects.equals(this.names, other.names)) {
            return false;
        }
        return Objects.equals(this.values, other.values);
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InitObjectActionItem other = (InitObjectActionItem)obj;
        if (!GraphTargetItem.objectsValueEquals(this.names, other.names)) {
            return false;
        }
        return GraphTargetItem.objectsValueEquals(this.values, other.values);
    }

    @Override
    public boolean hasSideEffect() {
        for (GraphTargetItem n : this.names) {
            if (!n.hasSideEffect()) continue;
            return true;
        }
        for (GraphTargetItem v : this.values) {
            if (!v.hasSideEffect()) continue;
            return true;
        }
        return false;
    }
}

