/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.ConstantPool;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf4.ConstantIndex;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SimpleValue;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class DirectValueActionItem
extends ActionItem
implements SimpleValue {
    public Object value;
    public final List<String> constants;
    public GraphTargetItem computedRegValue;
    public final int pos;

    public DirectValueActionItem(Object o) {
        this(null, null, 0, o, new ArrayList<String>());
    }

    public DirectValueActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, int instructionPos, Object value, List<String> constants) {
        super(instruction, lineStartIns, 0);
        this.constants = constants;
        this.value = value;
        this.pos = instructionPos;
    }

    @Override
    protected int getPos() {
        return this.pos;
    }

    @Override
    public boolean isVariableComputed() {
        return this.computedRegValue != null;
    }

    @Override
    public Object getResult() {
        if (this.computedRegValue != null) {
            return this.computedRegValue.getResult();
        }
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        if (this.value instanceof Float) {
            return (double)((Float)this.value).floatValue();
        }
        if (this.value instanceof Long || this.value instanceof Integer || this.value instanceof Short || this.value instanceof Byte) {
            return ((Number)this.value).doubleValue();
        }
        if (this.value instanceof Boolean) {
            return this.value;
        }
        if (this.value instanceof String) {
            return this.value;
        }
        if (this.value instanceof ConstantIndex) {
            return this.constants.get(((ConstantIndex)this.value).index);
        }
        if (this.value instanceof RegisterNumber) {
            return Undefined.INSTANCE;
        }
        return this.value;
    }

    @Override
    public boolean isSimpleValue() {
        return !(this.value instanceof RegisterNumber);
    }

    @Override
    public String toStringNoQuotes(LocalData localData) {
        if (this.value instanceof Double && Double.compare((Double)this.value, 0.0) == 0) {
            return "0";
        }
        if (this.value instanceof Float && Float.compare(((Float)this.value).floatValue(), 0.0f) == 0) {
            return "0";
        }
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.value instanceof ConstantIndex) {
            return this.constants.get(((ConstantIndex)this.value).index);
        }
        if (this.value instanceof RegisterNumber) {
            return IdentifiersDeobfuscation.printIdentifier(false, ((RegisterNumber)this.value).translate(), new String[0]);
        }
        return this.value.toString();
    }

    @Override
    public GraphTextWriter appendToNoQuotes(GraphTextWriter writer, LocalData localData) {
        if (this.value instanceof Double && Double.compare((Double)this.value, 0.0) == 0) {
            return writer.append("0");
        }
        if (this.value instanceof Float && Float.compare(((Float)this.value).floatValue(), 0.0f) == 0) {
            return writer.append("0");
        }
        if (this.value instanceof String) {
            return writer.append((String)this.value);
        }
        if (this.value instanceof ConstantIndex) {
            return writer.append(this.constants.get(((ConstantIndex)this.value).index));
        }
        if (this.value instanceof RegisterNumber) {
            return writer.append(IdentifiersDeobfuscation.printIdentifier(false, ((RegisterNumber)this.value).translate(), new String[0]));
        }
        return writer.append(this.value.toString());
    }

    public String toStringNoH(ConstantPool constants) {
        if (this.value instanceof ConstantIndex) {
            return this.constants.get(((ConstantIndex)this.value).index);
        }
        return EcmaScript.toString(this.value);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) {
        if (this.value instanceof Double && Double.compare((Double)this.value, 0.0) == 0) {
            return writer.append("0");
        }
        if (this.value instanceof Float && Float.compare(((Float)this.value).floatValue(), 0.0f) == 0) {
            return writer.append("0");
        }
        if (this.value instanceof String) {
            return writer.append("\"").append(Helper.escapeActionScriptString((String)this.value)).append("\"");
        }
        if (this.value instanceof ConstantIndex) {
            return writer.append("\"").append(Helper.escapeActionScriptString(this.constants.get(((ConstantIndex)this.value).index))).append("\"");
        }
        if (this.value instanceof RegisterNumber) {
            HighlightData srcData = this.getSrcData();
            srcData.localName = ((RegisterNumber)this.value).translate();
            srcData.regIndex = ((RegisterNumber)this.value).number;
            return writer.appendWithData(IdentifiersDeobfuscation.printIdentifier(false, ((RegisterNumber)this.value).translate(), new String[0]), srcData);
        }
        return writer.append(EcmaScript.toString(this.value));
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        if (this.computedRegValue != null) {
            if (dependencies.contains(this.computedRegValue)) {
                return false;
            }
            dependencies.add(this.computedRegValue);
        }
        return this.value instanceof Double || this.value instanceof Float || this.value instanceof Boolean || this.value instanceof Long || this.value == Null.INSTANCE || this.computedRegValue != null && this.computedRegValue.isCompileTime(dependencies) || this.value instanceof String || this.value instanceof ConstantIndex;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.value);
        hash = 71 * hash + Objects.hashCode(this.constants);
        hash = 71 * hash + this.pos;
        return hash;
    }

    @Override
    public boolean valueEquals(GraphTargetItem obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectValueActionItem)) {
            return false;
        }
        DirectValueActionItem other = (DirectValueActionItem)obj;
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        return Objects.equals(this.constants, other.constants);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirectValueActionItem other = (DirectValueActionItem)obj;
        if (!Objects.equals(this.value, other.value)) {
            return false;
        }
        if (!Objects.equals(this.constants, other.constants)) {
            return false;
        }
        return other.pos == this.pos;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return DirectValueActionItem.toSourceMerge(localData, generator, new ActionPush(this.value));
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public boolean isString() {
        return this.value instanceof String || this.value instanceof ConstantIndex;
    }

    public String getAsString() {
        if (!this.isString()) {
            return null;
        }
        return (String)this.getResult();
    }

    @Override
    public String toString() {
        return "" + this.getResult();
    }
}

