/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action;

import com.jpexs.decompiler.flash.DisassemblyListener;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionDefineFunctionPushRegistersCleaner;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.deobfuscation.ActionDeobfuscator;
import com.jpexs.decompiler.flash.action.model.ConstantPool;
import com.jpexs.decompiler.flash.action.special.ActionDeobfuscateJump;
import com.jpexs.decompiler.flash.action.special.ActionEnd;
import com.jpexs.decompiler.flash.action.special.ActionStore;
import com.jpexs.decompiler.flash.action.special.ActionUnknown;
import com.jpexs.decompiler.flash.action.swf4.ActionIf;
import com.jpexs.decompiler.flash.action.swf4.ActionJump;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf5.ActionConstantPool;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.helpers.SWFDecompilerPlugin;
import com.jpexs.decompiler.graph.GraphSourceItemContainer;
import com.jpexs.helpers.CancellableWorker;
import com.jpexs.helpers.stat.Statistics;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActionListReader {
    private static final Logger logger = Logger.getLogger(ActionListReader.class.getName());

    public static ActionList readActionListTimeout(final List<DisassemblyListener> listeners, final SWFInputStream sis, final int version, final int ip, final int endIp, final String path, final int deobfuscationMode) throws IOException, InterruptedException, TimeoutException {
        try {
            ActionList actions = CancellableWorker.call(new Callable<ActionList>(){

                @Override
                public ActionList call() throws IOException, InterruptedException {
                    return ActionListReader.readActionList(listeners, sis, version, ip, endIp, path, deobfuscationMode);
                }
            }, Configuration.decompilationTimeoutSingleMethod.get().intValue(), TimeUnit.SECONDS);
            return actions;
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof InterruptedException) {
                throw (InterruptedException)cause;
            }
            if (cause instanceof InterruptedException) {
                throw (IOException)cause;
            }
            logger.log(Level.SEVERE, null, ex);
            return new ActionList();
        }
    }

    public static ActionList readActionList(List<DisassemblyListener> listeners, SWFInputStream sis, int version, int ip, int endIp, String path, int deobfuscationMode) throws IOException, InterruptedException {
        ActionList actions;
        TreeMap<Long, Action> actionMap = new TreeMap<Long, Action>();
        HashMap<Long, Long> nextOffsets = new HashMap<Long, Long>();
        Action entryAction = ActionListReader.readActionListAtPos(listeners, null, sis, actionMap, nextOffsets, ip, 0L, endIp, path, false, new ArrayList<Long>());
        if (actionMap.isEmpty()) {
            return new ActionList();
        }
        ArrayList addresses = new ArrayList(actionMap.keySet());
        Action lastAction = (Action)actionMap.get(addresses.get(addresses.size() - 1));
        if (!(lastAction instanceof ActionEnd)) {
            ActionEnd aEnd = new ActionEnd();
            aEnd.setAddress((Long)nextOffsets.get(lastAction.getAddress()));
            long endAddress = aEnd.getAddress();
            actionMap.put(aEnd.getAddress(), aEnd);
            nextOffsets.put(endAddress, endAddress + 1L);
        }
        if (entryAction != (actions = ActionListReader.fixActionList(new ActionList(actionMap.values()), nextOffsets)).get(0)) {
            ActionDeobfuscateJump jump = new ActionDeobfuscateJump(0);
            actions.addAction(0, jump);
            jump.setJumpOffset((int)(entryAction.getAddress() - (long)jump.getTotalActionLength()));
        }
        if (SWFDecompilerPlugin.fireActionListParsed(actions, sis.getSwf())) {
            actions = ActionListReader.fixActionList(actions, null);
        }
        if (deobfuscationMode == 1) {
            try (Statistics s = new Statistics("ActionDeobfuscator");){
                new ActionDeobfuscator().actionListParsed(actions, sis.getSwf());
            }
            catch (InterruptedException | ThreadDeath ex) {
                throw ex;
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "Deobfuscation failed in: " + path, ex);
            }
        }
        try {
            new ActionDefineFunctionPushRegistersCleaner().actionListParsed(actions, sis.getSwf());
        }
        catch (InterruptedException | ThreadDeath ex) {
            throw ex;
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, "Cleaning push registers in ActionDefineFunction failed: " + path, ex);
        }
        return actions;
    }

    public static ActionList fixActionList(ActionList actions, Map<Long, Long> nextOffsets) {
        HashMap<Action, List<Action>> containerLastActions = new HashMap<Action, List<Action>>();
        ActionListReader.getContainerLastActions(actions, containerLastActions);
        ActionList ret = new ActionList();
        ret.fileData = actions.fileData;
        if (nextOffsets != null) {
            int index = 0;
            while (index != -1 && index < actions.size()) {
                Action action = (Action)actions.get(index);
                ret.add(action);
                if (++index >= actions.size()) continue;
                long nextAddress = nextOffsets.get(action.getAddress());
                if (((Action)actions.get(index)).getAddress() == nextAddress || action.isExit() || action instanceof ActionJump) continue;
                ActionDeobfuscateJump jump = new ActionDeobfuscateJump(0);
                jump.setAddress(action.getAddress());
                int size = jump.getTotalActionLength();
                jump.setJumpOffset((int)(nextAddress - action.getAddress() - (long)size));
                ret.add(jump);
            }
        } else {
            ret.addAll(actions);
        }
        HashMap<Action, Action> jumps = new HashMap<Action, Action>();
        ActionListReader.getJumps(ret, jumps);
        ActionListReader.updateActionLengths(ret);
        ActionListReader.updateAddresses(ret, 0L);
        long endAddress = ((Action)ret.get(ret.size() - 1)).getAddress();
        ActionListReader.updateJumps(ret, jumps, containerLastActions, endAddress);
        ActionListReader.updateActionStores(ret, jumps);
        ActionListReader.updateContainerSizes(ret, containerLastActions);
        return ret;
    }

    public static List<Action> getOriginalActions(SWFInputStream sis, int startIp, int endIp) throws IOException, InterruptedException {
        TreeMap<Long, Action> actionMap = new TreeMap<Long, Action>();
        HashMap<Long, Long> nextOffsets = new HashMap<Long, Long>();
        ActionListReader.readActionListAtPos(new ArrayList<DisassemblyListener>(), null, sis, actionMap, nextOffsets, startIp, startIp, endIp + 1, "", false, new ArrayList<Long>());
        return new ArrayList<Action>(actionMap.values());
    }

    private static long getNearAddress(ActionList actions, long address, boolean next) {
        int min = 0;
        int max = actions.size() - 1;
        while (max >= min) {
            int mid = (min + max) / 2;
            long midValue = ((Action)actions.get(mid)).getAddress();
            if (midValue == address) {
                return address;
            }
            if (midValue < address) {
                min = mid + 1;
                continue;
            }
            max = mid - 1;
        }
        return next ? (min < actions.size() ? ((Action)actions.get(min)).getAddress() : -1L) : (max >= 0 ? ((Action)actions.get(max)).getAddress() : -1L);
    }

    private static Map<Long, Action> actionListToMap(List<Action> actions) {
        HashMap<Long, Action> map = new HashMap<Long, Action>(actions.size());
        for (Action a : actions) {
            long address = a.getAddress();
            if (map.containsKey(address)) continue;
            map.put(a.getAddress(), a);
        }
        return map;
    }

    private static void getJumps(List<Action> actions, Map<Action, Action> jumps) {
        Map<Long, Action> actionMap = ActionListReader.actionListToMap(actions);
        for (Action a : actions) {
            long target = -1L;
            if (a instanceof ActionIf) {
                target = ((ActionIf)a).getTargetAddress();
            } else if (a instanceof ActionJump) {
                target = ((ActionJump)a).getTargetAddress();
            } else if (a instanceof ActionStore) {
                long address;
                ActionStore aStore = (ActionStore)((Object)a);
                int storeSize = aStore.getStoreSize();
                Action targetAction = a;
                for (int i = 0; i <= storeSize && (targetAction = actionMap.get(address = targetAction.getAddress() + (long)targetAction.getTotalActionLength())) != null; ++i) {
                }
                jumps.put(a, targetAction);
            }
            if (target < 0L) continue;
            Action targetAction = actionMap.get(target);
            jumps.put(a, targetAction);
        }
    }

    public static List<Action> getContainerLastActions(ActionList actions, Action action) {
        GraphSourceItemContainer container = (GraphSourceItemContainer)((Object)action);
        List<Long> sizes = container.getContainerSizes();
        long endAddress = action.getAddress() + container.getHeaderSize();
        ArrayList<Action> lasts = new ArrayList<Action>(sizes.size());
        for (long size : sizes) {
            long lastActionAddress = ActionListReader.getNearAddress(actions, (endAddress += size) - 1L, false);
            Action lastAction = null;
            if (lastActionAddress != -1L) {
                lastAction = actions.getByAddress(lastActionAddress);
            }
            lasts.add(lastAction);
        }
        return lasts;
    }

    private static void getContainerLastActions(ActionList actions, Map<Action, List<Action>> lastActions) {
        for (Action a : actions) {
            if (!(a instanceof GraphSourceItemContainer)) continue;
            lastActions.put(a, ActionListReader.getContainerLastActions(actions, a));
        }
    }

    private static long updateAddresses(List<Action> actions, long address) {
        for (int i = 0; i < actions.size(); ++i) {
            Action a = actions.get(i);
            a.setAddress(address);
            int length = a.getTotalActionLength();
            if (i != actions.size() - 1 && a instanceof ActionEnd) {
                length = new ActionDeobfuscateJump(0).getTotalActionLength();
            }
            address += (long)length;
        }
        return address;
    }

    private static void updateActionLengths(List<Action> actions) {
        for (int i = 0; i < actions.size(); ++i) {
            actions.get(i).updateLength();
        }
    }

    private static void updateActionStores(List<Action> actions, Map<Action, Action> jumps) {
        Map<Long, Action> actionMap = ActionListReader.actionListToMap(actions);
        for (int i = 0; i < actions.size(); ++i) {
            long address;
            Action a = actions.get(i);
            if (!(a instanceof ActionStore)) continue;
            ActionStore aStore = (ActionStore)((Object)a);
            Action nextActionAfterStore = jumps.get(a);
            Action a1 = a;
            ArrayList<Action> store = new ArrayList<Action>();
            while ((a1 = actionMap.get(address = a1.getAddress() + (long)a1.getTotalActionLength())) != null && a1 != nextActionAfterStore) {
                store.add(a1);
            }
            aStore.setStore(store);
        }
    }

    private static void updateContainerSizes(List<Action> actions, Map<Action, List<Action>> containerLastActions) {
        for (int i = 0; i < actions.size(); ++i) {
            Action a = actions.get(i);
            if (!(a instanceof GraphSourceItemContainer)) continue;
            GraphSourceItemContainer container = (GraphSourceItemContainer)((Object)a);
            List<Action> lastActions = containerLastActions.get(a);
            long startAddress = a.getAddress() + container.getHeaderSize();
            for (int j = 0; j < lastActions.size(); ++j) {
                Action lastAction = lastActions.get(j);
                int length = (int)(lastAction.getAddress() + (long)lastAction.getTotalActionLength() - startAddress);
                container.setContainerSize(j, length);
                startAddress += (long)length;
            }
        }
    }

    private static void replaceJumpTargets(Map<Action, Action> jumps, Action oldTarget, Action newTarget) {
        for (Action a : jumps.keySet()) {
            if (jumps.get(a) != oldTarget) continue;
            jumps.put(a, newTarget);
        }
    }

    private static void replaceContainerLastActions(Map<Action, List<Action>> containerLastActions, Action oldTarget, Action newTarget) {
        for (Action a : containerLastActions.keySet()) {
            List<Action> targets = containerLastActions.get(a);
            for (int i = 0; i < targets.size(); ++i) {
                if (targets.get(i) != oldTarget) continue;
                targets.set(i, newTarget);
            }
        }
    }

    private static void updateJumps(List<Action> actions, Map<Action, Action> jumps, Map<Action, List<Action>> containerLastActions, long endAddress) {
        if (actions.isEmpty()) {
            return;
        }
        for (int i = 0; i < actions.size(); ++i) {
            long offset;
            Action target;
            ActionJump aJump;
            Action a = actions.get(i);
            if (i != actions.size() - 1 && a instanceof ActionEnd) {
                aJump = new ActionDeobfuscateJump(0);
                aJump.setJumpOffset((int)(endAddress - a.getAddress() - (long)aJump.getTotalActionLength()));
                aJump.setAddress(a.getAddress());
                ActionListReader.replaceJumpTargets(jumps, a, aJump);
                ActionListReader.replaceContainerLastActions(containerLastActions, a, aJump);
                a = aJump;
                actions.set(i, a);
                continue;
            }
            if (a instanceof ActionIf) {
                ActionIf aIf = (ActionIf)a;
                target = jumps.get(a);
                offset = target != null ? target.getAddress() - a.getAddress() - (long)a.getTotalActionLength() : endAddress - a.getAddress() - (long)a.getTotalActionLength();
                aIf.setJumpOffset((int)offset);
                continue;
            }
            if (!(a instanceof ActionJump)) continue;
            aJump = (ActionJump)a;
            target = jumps.get(a);
            offset = target != null ? target.getAddress() - a.getAddress() - (long)a.getTotalActionLength() : endAddress - a.getAddress() - (long)a.getTotalActionLength();
            aJump.setJumpOffset((int)offset);
        }
    }

    public static boolean removeAction(ActionList actions, int index, boolean removeWhenLast) {
        if (index < 0 || actions.size() <= index) {
            return false;
        }
        long startIp = ((Action)actions.get(0)).getAddress();
        Action lastAction = (Action)actions.get(actions.size() - 1);
        long endAddress = lastAction.getAddress() + (long)lastAction.getTotalActionLength();
        HashMap<Action, List<Action>> containerLastActions = new HashMap<Action, List<Action>>();
        ActionListReader.getContainerLastActions(actions, containerLastActions);
        HashMap<Action, Action> jumps = new HashMap<Action, Action>();
        ActionListReader.getJumps(actions, jumps);
        Action prevAction = index > 0 ? (Action)actions.get(index - 1) : null;
        Action nextAction = index + 1 < actions.size() ? (Action)actions.get(index + 1) : null;
        Action actionToRemove = (Action)actions.get(index);
        for (Action a : containerLastActions.keySet()) {
            List lastActions = (List)containerLastActions.get(a);
            for (int i = 0; i < lastActions.size(); ++i) {
                if (lastActions.get(i) != actionToRemove) continue;
                if (!removeWhenLast) {
                    return false;
                }
                lastActions.set(i, prevAction);
            }
        }
        for (Action a : jumps.keySet()) {
            Action targetAction = (Action)jumps.get(a);
            if (targetAction != actionToRemove) continue;
            jumps.put(a, nextAction);
        }
        if (containerLastActions.containsKey(actionToRemove)) {
            containerLastActions.remove(actionToRemove);
        }
        if (jumps.containsKey(actionToRemove)) {
            jumps.remove(actionToRemove);
        }
        actions.remove(index);
        ActionListReader.updateActionLengths(actions);
        ActionListReader.updateAddresses(actions, startIp);
        ActionListReader.updateJumps(actions, jumps, containerLastActions, endAddress);
        ActionListReader.updateActionStores(actions, jumps);
        ActionListReader.updateContainerSizes(actions, containerLastActions);
        return true;
    }

    public static boolean removeActions(ActionList actions, List<Action> actionsToRemove, boolean removeWhenLast) {
        long startIp = ((Action)actions.get(0)).getAddress();
        Action lastAction = (Action)actions.get(actions.size() - 1);
        long endAddress = lastAction.getAddress() + (long)lastAction.getTotalActionLength();
        HashMap<Action, List<Action>> containerLastActions = new HashMap<Action, List<Action>>();
        ActionListReader.getContainerLastActions(actions, containerLastActions);
        HashMap<Action, Action> jumps = new HashMap<Action, Action>();
        ActionListReader.getJumps(actions, jumps);
        for (Action actionToRemove : actionsToRemove) {
            int index = actions.getIndexByAction(actionToRemove);
            Action prevAction = index > 0 ? (Action)actions.get(index - 1) : null;
            Action nextAction = index + 1 < actions.size() ? (Action)actions.get(index + 1) : null;
            for (Action a : containerLastActions.keySet()) {
                List lastActions = (List)containerLastActions.get(a);
                for (int i = 0; i < lastActions.size(); ++i) {
                    if (lastActions.get(i) != actionToRemove) continue;
                    if (!removeWhenLast) {
                        return false;
                    }
                    lastActions.set(i, prevAction);
                }
            }
            for (Action a : jumps.keySet()) {
                Action targetAction = (Action)jumps.get(a);
                if (targetAction != actionToRemove) continue;
                jumps.put(a, nextAction);
            }
            if (containerLastActions.containsKey(actionToRemove)) {
                containerLastActions.remove(actionToRemove);
            }
            if (jumps.containsKey(actionToRemove)) {
                jumps.remove(actionToRemove);
            }
            actions.remove(index);
        }
        ActionListReader.updateActionLengths(actions);
        ActionListReader.updateAddresses(actions, startIp);
        ActionListReader.updateJumps(actions, jumps, containerLastActions, endAddress);
        ActionListReader.updateActionStores(actions, jumps);
        ActionListReader.updateContainerSizes(actions, containerLastActions);
        return true;
    }

    public static boolean addAction(ActionList actions, int index, Action action, boolean addToContainer, boolean replaceJump) {
        if (index < 0 || actions.size() < index) {
            return false;
        }
        long startIp = ((Action)actions.get(0)).getAddress();
        Action lastAction = (Action)actions.get(actions.size() - 1);
        if (!(lastAction instanceof ActionEnd)) {
            ActionEnd aEnd = new ActionEnd();
            aEnd.setAddress(lastAction.getAddress() + (long)lastAction.getTotalActionLength());
            actions.add(aEnd);
            lastAction = aEnd;
        }
        long endAddress = lastAction.getAddress();
        HashMap<Action, List<Action>> containerLastActions = new HashMap<Action, List<Action>>();
        ActionListReader.getContainerLastActions(actions, containerLastActions);
        HashMap<Action, Action> jumps = new HashMap<Action, Action>();
        ArrayList<Action> tempActions = new ArrayList<Action>(actions);
        tempActions.add(action);
        ActionListReader.getJumps(tempActions, jumps);
        Action prevAction = (Action)actions.get(index);
        if (addToContainer) {
            for (Action a : containerLastActions.keySet()) {
                List lastActions = (List)containerLastActions.get(a);
                for (int i = 0; i < lastActions.size(); ++i) {
                    if (lastActions.get(i) != prevAction) continue;
                    lastActions.set(i, action);
                }
            }
        }
        if (replaceJump) {
            for (Action a : jumps.keySet()) {
                Action targetAction = (Action)jumps.get(a);
                if (targetAction != prevAction) continue;
                jumps.put(a, action);
            }
        }
        actions.add(index, action);
        ActionListReader.updateActionLengths(actions);
        ActionListReader.updateAddresses(actions, startIp);
        ActionListReader.updateJumps(actions, jumps, containerLastActions, endAddress);
        ActionListReader.updateActionStores(actions, jumps);
        ActionListReader.updateContainerSizes(actions, containerLastActions);
        return true;
    }

    public static boolean addActions(ActionList actions, int index, List<Action> newActions) {
        if (index < 0 || actions.size() < index) {
            return false;
        }
        long startIp = ((Action)actions.get(0)).getAddress();
        Action lastAction = (Action)actions.get(actions.size() - 1);
        if (!(lastAction instanceof ActionEnd)) {
            ActionEnd aEnd = new ActionEnd();
            aEnd.setAddress(lastAction.getAddress() + (long)lastAction.getTotalActionLength());
            actions.add(aEnd);
            lastAction = aEnd;
        }
        long endAddress = lastAction.getAddress();
        HashMap<Action, List<Action>> containerLastActions = new HashMap<Action, List<Action>>();
        ActionListReader.getContainerLastActions(actions, containerLastActions);
        HashMap<Action, Action> jumps = new HashMap<Action, Action>();
        ArrayList<Action> tempActions = new ArrayList<Action>(actions);
        tempActions.addAll(newActions);
        ActionListReader.getJumps(tempActions, jumps);
        actions.addAll(index, newActions);
        ActionListReader.updateActionLengths(actions);
        ActionListReader.updateAddresses(actions, startIp);
        ActionListReader.updateJumps(actions, jumps, containerLastActions, endAddress);
        ActionListReader.updateActionStores(actions, jumps);
        ActionListReader.updateContainerSizes(actions, containerLastActions);
        return true;
    }

    private static Action readActionListAtPos(List<DisassemblyListener> listeners, ConstantPool cpool, SWFInputStream sis, Map<Long, Action> actions, Map<Long, Long> nextOffsets, long ip, long startIp, long endIp, String path, boolean indeterminate, List<Long> visitedContainers) throws IOException {
        Action entryAction = null;
        if (visitedContainers.contains(ip)) {
            return null;
        }
        visitedContainers.add(ip);
        LinkedList<Long> jumpQueue = new LinkedList<Long>();
        jumpQueue.add(ip);
        block0: while (!jumpQueue.isEmpty()) {
            ip = (Long)jumpQueue.remove();
            if (ip < startIp) continue;
            while (endIp == -1L || endIp > ip) {
                long nIp;
                Action existingAction;
                sis.seek((int)ip);
                Action a = sis.readAction();
                if (a == null) continue block0;
                a.fileOffset = ip;
                int actionLengthWithHeader = a.getTotalActionLength();
                if (a instanceof ActionUnknown && a.getActionCode() >= 128) {
                    ActionDeobfuscateJump aJump = new ActionDeobfuscateJump(0);
                    int jumpLength = aJump.getTotalActionLength();
                    aJump.setAddress(a.getAddress());
                    aJump.setJumpOffset(actionLengthWithHeader - jumpLength);
                    a = aJump;
                    actionLengthWithHeader = a.getTotalActionLength();
                }
                if (entryAction == null) {
                    entryAction = a;
                }
                if ((existingAction = actions.get(ip)) != null) continue block0;
                actions.put(ip, a);
                nextOffsets.put(ip, ip + (long)actionLengthWithHeader);
                long pos = sis.getPos();
                long length = pos + (long)sis.available();
                for (int i = 0; i < listeners.size(); ++i) {
                    listeners.get(i).progressReading(pos, length);
                }
                a.setAddress(ip);
                if (a instanceof ActionPush && cpool != null) {
                    ((ActionPush)a).constantPool = cpool.constants;
                } else if (a instanceof ActionConstantPool) {
                    cpool = new ConstantPool(((ActionConstantPool)a).constantPool);
                } else if (a instanceof ActionIf) {
                    ActionIf aIf = (ActionIf)a;
                    nIp = ip + (long)actionLengthWithHeader + (long)aIf.getJumpOffset();
                    if (nIp >= 0L) {
                        jumpQueue.add(nIp);
                    }
                } else {
                    if (a instanceof ActionJump) {
                        ActionJump aJump = (ActionJump)a;
                        nIp = ip + (long)actionLengthWithHeader + (long)aJump.getJumpOffset();
                        if (nIp < 0L) continue block0;
                        jumpQueue.add(nIp);
                        continue block0;
                    }
                    if (a instanceof GraphSourceItemContainer) {
                        GraphSourceItemContainer cnt = (GraphSourceItemContainer)((Object)a);
                        String cntName = cnt.getName();
                        String newPath = path + (cntName == null ? "" : "/" + cntName);
                        for (long size : cnt.getContainerSizes()) {
                            if (size == 0L) continue;
                            long ip2 = ip + (long)actionLengthWithHeader;
                            long endIp2 = ip + (long)actionLengthWithHeader + size;
                            ActionListReader.readActionListAtPos(listeners, cpool, sis, actions, nextOffsets, ip2, startIp, endIp2, newPath, indeterminate, visitedContainers);
                            actionLengthWithHeader = (int)((long)actionLengthWithHeader + size);
                        }
                    }
                }
                ip += (long)actionLengthWithHeader;
                if (!a.isExit()) continue;
                continue block0;
            }
        }
        return entryAction;
    }

    public static boolean fixConstantPools(List<DisassemblyListener> listeners, ActionList actions) {
        Action lastAction = (Action)actions.get(actions.size() - 1);
        int endIp = (int)lastAction.getAddress();
        ArrayList<Action> actionMap = new ArrayList<Action>(endIp);
        for (int i = 0; i <= endIp; ++i) {
            actionMap.add(null);
        }
        for (Action a : actions) {
            actionMap.set((int)a.getAddress(), a);
        }
        try {
            int startIp = (int)((Action)actions.get(0)).getAddress();
            return ActionListReader.fixConstantPools(listeners, new ConstantPool(), actionMap, new TreeMap<Integer, Action>(), startIp, startIp, endIp, null, true, new ArrayList<Integer>());
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private static boolean fixConstantPools(List<DisassemblyListener> listeners, ConstantPool cpool, List<Action> actions, Map<Integer, Action> actionMap, int ip, int startIp, int endIp, String path, boolean indeterminate, List<Integer> visitedContainers) throws IOException {
        if (visitedContainers.contains(ip)) {
            return false;
        }
        visitedContainers.add(ip);
        LinkedList<Integer> jumpQueue = new LinkedList<Integer>();
        jumpQueue.add(ip);
        boolean ret = false;
        block0: while (!jumpQueue.isEmpty()) {
            Action a;
            ip = (Integer)jumpQueue.remove();
            if (ip < startIp) continue;
            while ((endIp == -1 || endIp > ip) && (a = actions.get(ip)) != null) {
                int actionLengthWithHeader;
                block15: {
                    int nIp;
                    block14: {
                        actionLengthWithHeader = a.getTotalActionLength();
                        Action existingAction = actionMap.get(ip);
                        if (existingAction != null) continue block0;
                        actionMap.put(ip, a);
                        if (listeners != null) {
                            for (int i = 0; i < listeners.size(); ++i) {
                                listeners.get(i).progressReading(ip, actions.size());
                            }
                        }
                        if (a.getAddress() != (long)ip) {
                            a.setAddress(ip);
                            ret = true;
                        }
                        if (!(a instanceof ActionPush) || cpool == null) break block14;
                        ActionPush push = (ActionPush)a;
                        if (push.constantPool == cpool.constants) break block15;
                        List<String> list = push.constantPool = cpool.constants.isEmpty() ? null : cpool.constants;
                        if (push.constantPool == null) break block15;
                        ret = true;
                        break block15;
                    }
                    if (a instanceof ActionConstantPool) {
                        cpool = new ConstantPool(((ActionConstantPool)a).constantPool);
                    } else if (a instanceof ActionIf) {
                        ActionIf aIf = (ActionIf)a;
                        nIp = ip + actionLengthWithHeader + aIf.getJumpOffset();
                        if (nIp >= 0) {
                            jumpQueue.add(nIp);
                        }
                    } else {
                        if (a instanceof ActionJump) {
                            ActionJump aJump = (ActionJump)a;
                            nIp = ip + actionLengthWithHeader + aJump.getJumpOffset();
                            if (nIp < 0) continue block0;
                            jumpQueue.add(nIp);
                            continue block0;
                        }
                        if (a instanceof GraphSourceItemContainer) {
                            GraphSourceItemContainer cnt = (GraphSourceItemContainer)((Object)a);
                            String cntName = cnt.getName();
                            String newPath = path + (cntName == null ? "" : "/" + cntName);
                            for (long size : cnt.getContainerSizes()) {
                                if (size == 0L) continue;
                                int ip2 = ip + actionLengthWithHeader;
                                int endIp2 = ip + actionLengthWithHeader + (int)size;
                                ret |= ActionListReader.fixConstantPools(listeners, cpool, actions, actionMap, ip2, startIp, endIp2, newPath, indeterminate, visitedContainers);
                                actionLengthWithHeader = (int)((long)actionLengthWithHeader + size);
                            }
                        }
                    }
                }
                ip += actionLengthWithHeader;
                if (!a.isExit()) continue;
                continue block0;
            }
        }
        return ret;
    }
}

