/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action;

import com.jpexs.decompiler.flash.BaseLocalData;
import com.jpexs.decompiler.flash.FinalProcessLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.ActionGraphSource;
import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.action.ActionLocalData;
import com.jpexs.decompiler.flash.action.ActionScript2ClassDetector;
import com.jpexs.decompiler.flash.action.ActionSecondPassData;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.EnumerateActionItem;
import com.jpexs.decompiler.flash.action.model.FunctionActionItem;
import com.jpexs.decompiler.flash.action.model.GetPropertyActionItem;
import com.jpexs.decompiler.flash.action.model.SetTarget2ActionItem;
import com.jpexs.decompiler.flash.action.model.SetTargetActionItem;
import com.jpexs.decompiler.flash.action.model.SetTypeActionItem;
import com.jpexs.decompiler.flash.action.model.StoreRegisterActionItem;
import com.jpexs.decompiler.flash.action.model.TemporaryRegister;
import com.jpexs.decompiler.flash.action.model.clauses.ForInActionItem;
import com.jpexs.decompiler.flash.action.model.clauses.TellTargetActionItem;
import com.jpexs.decompiler.flash.action.model.operations.NeqActionItem;
import com.jpexs.decompiler.flash.action.model.operations.StrictEqActionItem;
import com.jpexs.decompiler.flash.action.model.operations.StrictNeqActionItem;
import com.jpexs.decompiler.flash.action.swf4.ActionEquals;
import com.jpexs.decompiler.flash.action.swf4.ActionIf;
import com.jpexs.decompiler.flash.action.swf4.ActionJump;
import com.jpexs.decompiler.flash.action.swf4.ActionNot;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.action.swf5.ActionDefineFunction;
import com.jpexs.decompiler.flash.action.swf5.ActionEquals2;
import com.jpexs.decompiler.flash.action.swf6.ActionStrictEquals;
import com.jpexs.decompiler.flash.action.swf7.ActionDefineFunction2;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.graph.AbstractGraphTargetVisitor;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.Graph;
import com.jpexs.decompiler.graph.GraphException;
import com.jpexs.decompiler.graph.GraphPart;
import com.jpexs.decompiler.graph.GraphSource;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemContainer;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.Loop;
import com.jpexs.decompiler.graph.SecondPassData;
import com.jpexs.decompiler.graph.StopPartKind;
import com.jpexs.decompiler.graph.ThrowState;
import com.jpexs.decompiler.graph.TranslateStack;
import com.jpexs.decompiler.graph.model.BinaryOpItem;
import com.jpexs.decompiler.graph.model.BreakItem;
import com.jpexs.decompiler.graph.model.GotoItem;
import com.jpexs.decompiler.graph.model.IfItem;
import com.jpexs.decompiler.graph.model.PopItem;
import com.jpexs.decompiler.graph.model.PushItem;
import com.jpexs.decompiler.graph.model.ScriptEndItem;
import com.jpexs.decompiler.graph.model.SwitchItem;
import com.jpexs.decompiler.graph.model.WhileItem;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ActionGraph
extends Graph {
    private boolean insideDoInitAction;
    private boolean insideFunction;

    public ActionGraph(String path, boolean insideDoInitAction, boolean insideFunction, List<Action> code, HashMap<Integer, String> registerNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, int version) {
        super(new ActionGraphSource(path, insideDoInitAction, code, version, registerNames, variables, functions), new ArrayList<GraphException>());
        this.insideDoInitAction = insideDoInitAction;
        this.insideFunction = insideFunction;
    }

    @Override
    public LinkedHashMap<String, Graph> getSubGraphs() {
        LinkedHashMap<String, Graph> subgraphs = new LinkedHashMap<String, Graph>();
        List<Action> alist = ((ActionGraphSource)this.code).getActions();
        int ip = 0;
        for (Action action : alist) {
            if (action instanceof GraphSourceItemContainer && (action instanceof ActionDefineFunction || action instanceof ActionDefineFunction2)) {
                GraphSourceItemContainer cnt = (GraphSourceItemContainer)((Object)action);
                String functionName = action instanceof ActionDefineFunction ? ((ActionDefineFunction)action).functionName : ((ActionDefineFunction2)action).functionName;
                long endAddr = action.getAddress() + cnt.getHeaderSize();
                ArrayList<ActionList> outs = new ArrayList<ActionList>();
                for (long size : cnt.getContainerSizes()) {
                    if (size == 0L) {
                        outs.add(new ActionList());
                        continue;
                    }
                    outs.add(new ActionList((Collection<Action>)alist.subList(Action.adr2ip(alist, endAddr), Action.adr2ip(alist, endAddr + size))));
                    endAddr += size;
                }
                for (ActionList al : outs) {
                    subgraphs.put("loc" + Helper.formatAddress(this.code.pos2adr(ip)) + ": function " + functionName, new ActionGraph("", false, false, al, new HashMap<Integer, String>(), new HashMap<String, GraphTargetItem>(), new HashMap<String, GraphTargetItem>(), 10));
                }
            }
            ++ip;
        }
        return subgraphs;
    }

    public boolean isInsideDoInitAction() {
        return this.insideDoInitAction;
    }

    @Override
    protected void afterPopupateAllParts(Set<GraphPart> allParts) {
    }

    public static List<GraphTargetItem> translateViaGraph(SecondPassData secondPassData, boolean insideDoInitAction, boolean insideFunction, HashMap<Integer, String> registerNames, HashMap<String, GraphTargetItem> variables, HashMap<String, GraphTargetItem> functions, List<Action> code, int version, int staticOperation, String path) throws InterruptedException {
        ActionGraph g = new ActionGraph(path, insideDoInitAction, insideFunction, code, registerNames, variables, functions, version);
        ActionLocalData localData = new ActionLocalData(secondPassData, insideDoInitAction, registerNames);
        g.init(localData);
        return g.translate(localData, staticOperation, path);
    }

    @Override
    public void finalProcessStack(TranslateStack stack, List<GraphTargetItem> output, String path) {
        if (stack.size() > 0) {
            for (int i = stack.size() - 1; i >= 0; --i) {
                FunctionActionItem f;
                if (!(stack.get(i) instanceof FunctionActionItem) || output.contains(f = (FunctionActionItem)stack.remove(i))) continue;
                output.add(0, f);
            }
        }
    }

    @Override
    protected boolean canBeBreakCandidate(BaseLocalData localData, GraphPart part, List<ThrowState> throwStates) {
        if (part.refs.size() <= 1) {
            return true;
        }
        boolean isSwitch = true;
        for (GraphPart r : part.refs) {
            if (this.code.get(r.end) instanceof ActionIf) {
                if (r.start < r.end - 1 && this.code.get(r.end - 1) instanceof ActionStrictEquals) continue;
                isSwitch = false;
                continue;
            }
            isSwitch = false;
        }
        return !isSwitch;
    }

    @Override
    protected void finalProcess(List<GraphTargetItem> list, int level, FinalProcessLocalData localData, String path) throws InterruptedException {
        GraphTargetItem it;
        int t;
        GraphTargetItem target;
        int targetEnd;
        int targetStart;
        boolean again;
        if (level == 0) {
            ArrayList<GraphTargetItem> removed = new ArrayList<GraphTargetItem>();
            for (int i = list.size() - 1; i >= 0; --i) {
                if (list.get(i) instanceof ScriptEndItem) continue;
                if (!(list.get(i) instanceof FunctionActionItem)) break;
                removed.add(0, list.remove(i));
            }
            list.addAll(0, removed);
        }
        GraphTargetItem targetStartItem = null;
        do {
            int i;
            again = false;
            targetStart = -1;
            targetEnd = -1;
            targetStartItem = null;
            target = null;
            for (t = 0; t < list.size(); ++t) {
                ActionItem st;
                it = list.get(t);
                if (it instanceof PushItem) {
                    PushItem pi = (PushItem)it;
                    if (pi.value instanceof GetPropertyActionItem) {
                        GetPropertyActionItem gp = (GetPropertyActionItem)pi.value;
                        if (gp.propertyIndex == 11) {
                            list.remove(t);
                            --t;
                            continue;
                        }
                    }
                }
                if (it instanceof SetTargetActionItem) {
                    st = (SetTargetActionItem)it;
                    if (st.target.isEmpty()) {
                        if (targetStart > -1) {
                            targetEnd = t;
                            break;
                        }
                    } else {
                        target = new DirectValueActionItem(null, null, 0, st.target, new ArrayList<String>());
                        targetStart = t;
                        targetStartItem = it;
                    }
                }
                if (!(it instanceof SetTarget2ActionItem)) continue;
                st = (SetTarget2ActionItem)it;
                if (((SetTarget2ActionItem)st).target instanceof PopItem) {
                    list.remove(t);
                    --t;
                    continue;
                }
                if (((SetTarget2ActionItem)st).target instanceof DirectValueActionItem && ((SetTarget2ActionItem)st).target.getResult().equals("")) {
                    if (targetStart <= -1) continue;
                    targetEnd = t;
                    break;
                }
                targetStart = t;
                target = ((SetTarget2ActionItem)st).target;
                targetStartItem = it;
            }
            if (targetStart > -1 && targetEnd == -1) {
                targetEnd = list.size();
                if (list.get(list.size() - 1) instanceof ScriptEndItem) {
                    --targetEnd;
                }
            }
            if (targetStart <= -1 || targetEnd <= -1 || targetStartItem == null) continue;
            ArrayList<GraphTargetItem> newlist = new ArrayList<GraphTargetItem>();
            for (int i2 = 0; i2 < targetStart; ++i2) {
                newlist.add(list.get(i2));
            }
            ArrayList<GraphTargetItem> tellist = new ArrayList<GraphTargetItem>();
            for (i = targetStart + 1; i < targetEnd; ++i) {
                tellist.add(list.get(i));
            }
            newlist.add(new TellTargetActionItem(targetStartItem.getSrc(), targetStartItem.getLineStartItem(), target, tellist));
            for (i = targetEnd + 1; i < list.size(); ++i) {
                newlist.add(list.get(i));
            }
            list.clear();
            list.addAll(newlist);
            again = true;
        } while (again);
        targetStart = -1;
        targetEnd = -1;
        target = null;
        for (t = 0; t < list.size(); ++t) {
            int i;
            it = list.get(t);
            if (it instanceof SetTargetActionItem) {
                SetTargetActionItem st = (SetTargetActionItem)it;
                if (st.target.isEmpty()) {
                    if (targetStart > -1) {
                        targetEnd = t;
                    } else {
                        targetStart = t;
                        targetStartItem = st;
                        target = new DirectValueActionItem(null, null, 0, st.target, new ArrayList<String>());
                    }
                }
            }
            if (it instanceof SetTarget2ActionItem) {
                SetTarget2ActionItem st = (SetTarget2ActionItem)it;
                if (st.target instanceof DirectValueActionItem && st.target.getResult().equals("")) {
                    if (targetStart > -1) {
                        targetEnd = t;
                    } else {
                        targetStart = t;
                        targetStartItem = st;
                        target = st.target;
                    }
                }
            }
            if (targetStart <= -1 || targetEnd <= -1) continue;
            ArrayList<GraphTargetItem> newlist = new ArrayList<GraphTargetItem>();
            for (int i3 = 0; i3 < targetStart; ++i3) {
                newlist.add(list.get(i3));
            }
            ArrayList<GraphTargetItem> tellist = new ArrayList<GraphTargetItem>();
            for (i = targetStart + 1; i < targetEnd; ++i) {
                tellist.add(list.get(i));
            }
            newlist.add(new TellTargetActionItem(targetStartItem.getSrc(), targetStartItem.getLineStartItem(), target, tellist));
            for (i = targetEnd + 1; i < list.size(); ++i) {
                newlist.add(list.get(i));
            }
            list.clear();
            list.addAll(newlist);
            targetStart = -1;
            targetEnd = -1;
            target = null;
            t = 0;
        }
        for (t = 1; t < list.size(); ++t) {
            GraphTargetItem en;
            it = list.get(t);
            List<GraphTargetItem> checkedBody = null;
            GraphTargetItem checkedCondition = null;
            Loop checkedLoop = null;
            if (it instanceof WhileItem) {
                WhileItem wi = (WhileItem)it;
                checkedBody = wi.commands;
                checkedCondition = wi.expression.get(wi.expression.size() - 1);
                checkedLoop = wi.loop;
            } else if (it instanceof IfItem) {
                IfItem ifi = (IfItem)it;
                if (ifi.onFalse.isEmpty()) {
                    checkedBody = ifi.onTrue;
                    checkedCondition = ifi.expression;
                    checkedLoop = null;
                }
            }
            if (checkedBody == null || checkedBody.isEmpty() || !(checkedBody.get(0) instanceof SetTypeActionItem)) continue;
            SetTypeActionItem sti = (SetTypeActionItem)((Object)checkedBody.get(0));
            if (!(checkedCondition instanceof NeqActionItem)) continue;
            NeqActionItem ne = (NeqActionItem)checkedCondition;
            if (!(ne.rightSide instanceof DirectValueActionItem)) continue;
            DirectValueActionItem dv = (DirectValueActionItem)ne.rightSide;
            if (dv.value != Null.INSTANCE || !((en = list.get(t - 1)) instanceof EnumerateActionItem)) continue;
            EnumerateActionItem eti = (EnumerateActionItem)en;
            list.remove(t);
            checkedBody.remove(0);
            if (checkedLoop == null) {
                checkedLoop = new Loop(localData.loops.size(), null, null);
                checkedBody.add(new BreakItem(null, null, checkedLoop.id));
            }
            sti.setValue(new DirectValueActionItem(Null.INSTANCE));
            list.add(t, new ForInActionItem(null, null, checkedLoop, (GraphTargetItem)((Object)sti), eti.object, checkedBody));
            list.remove(t - 1);
            --t;
        }
        super.finalProcess(list, level, localData, path);
    }

    @Override
    public List<GraphTargetItem> translate(BaseLocalData localData, int staticOperation, String path) throws InterruptedException {
        List<GraphTargetItem> ret = super.translate(localData, staticOperation, path);
        if (this.insideDoInitAction && !this.insideFunction) {
            ActionScript2ClassDetector detector = new ActionScript2ClassDetector();
            detector.checkClass(ret, ((ActionGraphSource)this.code).getVariables(), path);
        }
        this.makeDefineRegistersUp(ret);
        return ret;
    }

    private void makeDefineRegistersUp(final List<GraphTargetItem> list) {
        for (int i = 0; i < list.size(); ++i) {
            final int fi = i;
            final GraphTargetItem ti = list.get(i);
            if (ti instanceof TemporaryRegister) continue;
            final HashSet visitedItems = new HashSet();
            ti.visitNoBlock(new AbstractGraphTargetVisitor(){

                @Override
                public void visit(GraphTargetItem item) {
                    if (item != null && !visitedItems.contains(item)) {
                        visitedItems.add(item);
                        if (item instanceof TemporaryRegister) {
                            return;
                        }
                        if (ti instanceof ForInActionItem && item == ((ForInActionItem)ti).variableName) {
                            return;
                        }
                        if (item instanceof StoreRegisterActionItem) {
                            StoreRegisterActionItem sr = (StoreRegisterActionItem)item;
                            if (sr.define) {
                                list.add(fi, new StoreRegisterActionItem(null, null, sr.register, new DirectValueActionItem(Null.INSTANCE), true));
                                sr.define = false;
                            }
                        }
                        item.visitNoBlock(this);
                    }
                }
            });
            if (!(ti instanceof Block)) continue;
            Block b = (Block)((Object)ti);
            for (List<GraphTargetItem> items : b.getSubs()) {
                this.makeDefineRegistersUp(items);
            }
        }
    }

    private GraphPart findPart(int ip, Set<GraphPart> allParts) {
        for (GraphPart p : allParts) {
            if (!p.containsIP(ip)) continue;
            return p;
        }
        return null;
    }

    @Override
    protected List<GraphTargetItem> check(List<GraphTargetItem> currentRet, List<GotoItem> foundGotos, Map<GraphPart, List<GraphTargetItem>> partCodes, Map<GraphPart, Integer> partCodePos, Set<GraphPart> visited, GraphSource code, BaseLocalData localData, Set<GraphPart> allParts, TranslateStack stack, GraphPart parent, GraphPart part, List<GraphPart> stopPart, List<StopPartKind> stopPartKind, List<Loop> loops, List<ThrowState> throwStates, List<GraphTargetItem> output, Loop currentLoop, int staticOperation, String path) throws InterruptedException {
        if (!output.isEmpty() && output.get(output.size() - 1) instanceof StoreRegisterActionItem) {
            StoreRegisterActionItem str = (StoreRegisterActionItem)output.get(output.size() - 1);
            if (str.value instanceof EnumerateActionItem) {
                output.remove(output.size() - 1);
            }
        }
        ArrayList<GraphTargetItem> ret = null;
        if (part.nextParts.size() == 2 && !stack.isEmpty() && stack.peek() instanceof StrictEqActionItem) {
            GraphSourceItem switchStartItem = code.get(part.start);
            GraphTargetItem switchedObject = null;
            if (!output.isEmpty() && output.get(output.size() - 1) instanceof StoreRegisterActionItem) {
                switchedObject = ((StoreRegisterActionItem)output.get((int)(output.size() - 1))).value;
            }
            if (switchedObject == null) {
                // empty if block
            }
            ArrayList<GraphTargetItem> caseValuesMap = new ArrayList<GraphTargetItem>();
            StrictEqActionItem set = (StrictEqActionItem)stack.pop();
            caseValuesMap.add(set.rightSide);
            switchedObject = set.leftSide instanceof StoreRegisterActionItem ? ((StoreRegisterActionItem)set.leftSide).value : set.leftSide;
            if (switchedObject == null) {
                stack.push(set);
                return ret;
            }
            ArrayList<GraphPart> caseBodyParts = new ArrayList<GraphPart>();
            caseBodyParts.add(part.nextParts.get(0));
            Object top = null;
            ActionSecondPassData secondPassData = (ActionSecondPassData)localData.secondPassData;
            boolean secondSwitchFound = false;
            if (secondPassData != null) {
                for (int si = 0; si < secondPassData.switchParts.size(); ++si) {
                    if (!secondPassData.switchParts.get(si).get(0).equals(part)) continue;
                    part = this.findPart(secondPassData.switchParts.get((int)si).get((int)(secondPassData.switchParts.get((int)si).size() - 1)).start, allParts);
                    caseBodyParts.clear();
                    for (GraphPart p : secondPassData.switchOnFalseParts.get(si)) {
                        caseBodyParts.add(this.findPart(p.start, allParts));
                    }
                    caseValuesMap.clear();
                    caseValuesMap.addAll((Collection<GraphTargetItem>)secondPassData.switchCaseExpressions.get(si));
                    secondSwitchFound = true;
                }
            }
            boolean cnt = true;
            if (!secondSwitchFound && cnt) {
                stack.push(set);
            } else {
                GraphPart defaultPart = part = part.nextParts.get(1);
                if (code.size() > defaultPart.start && code.get(defaultPart.start) instanceof ActionJump && defaultPart.refs.size() == 1 && !this.partIsLoopContBrePre(defaultPart, loops, throwStates)) {
                    defaultPart = defaultPart.nextParts.get(0);
                }
                Reference<Object> nextRef = new Reference<Object>(null);
                Reference<Object> tiRef = new Reference<Object>(null);
                SwitchItem sw = this.handleSwitch(switchedObject, switchStartItem, foundGotos, partCodes, partCodePos, visited, allParts, stack, stopPart, stopPartKind, loops, throwStates, localData, staticOperation, path, caseValuesMap, defaultPart, caseBodyParts, nextRef, tiRef);
                ret = new ArrayList<GraphTargetItem>();
                ret.addAll(output);
                ret.add(sw);
                if (nextRef.getVal() != null) {
                    if (tiRef.getVal() != null) {
                        ret.add(tiRef.getVal());
                    } else {
                        ret.addAll(this.printGraph(foundGotos, partCodes, partCodePos, visited, localData, stack, allParts, null, nextRef.getVal(), stopPart, stopPartKind, loops, throwStates, staticOperation, path));
                    }
                }
            }
        }
        return ret;
    }

    @Override
    protected int checkIp(int ip) {
        int oldIp = ip;
        GraphSourceItem action = this.code.get(ip);
        if (action instanceof ActionPush && ((ActionPush)action).values.size() == 1 && ((ActionPush)action).values.get(0) == Null.INSTANCE && ip + 3 <= this.code.size() && (this.code.get(ip + 1) instanceof ActionEquals || this.code.get(ip + 1) instanceof ActionEquals2) && this.code.get(ip + 2) instanceof ActionNot && this.code.get(ip + 3) instanceof ActionIf) {
            ActionIf aif = (ActionIf)this.code.get(ip + 3);
            if (this.code.adr2pos(this.code.pos2adr(ip + 3) + 5L + (long)aif.getJumpOffset()) == ip) {
                ip += 4;
            }
        }
        if (oldIp != ip) {
            if (ip == this.code.size()) {
                return ip;
            }
            return this.checkIp(ip);
        }
        return ip;
    }

    @Override
    public SecondPassData prepareSecondPass(List<GraphTargetItem> list) {
        ActionSecondPassData spd = new ActionSecondPassData();
        HashSet<GraphPart> processedIfs = new HashSet<GraphPart>();
        this.checkSecondPassSwitches(processedIfs, list, spd.switchParts, spd.switchOnFalseParts, spd.switchCaseExpressions);
        if (spd.switchParts.isEmpty()) {
            return null;
        }
        return spd;
    }

    private void checkSecondPassSwitches(Set<GraphPart> processedIfs, List<GraphTargetItem> list, List<List<GraphPart>> allSwitchParts, List<List<GraphPart>> allSwitchOnFalseParts, List<List<GraphTargetItem>> allSwitchExpressions) {
        for (GraphTargetItem item : list) {
            if (item instanceof IfItem) {
                IfItem ii = (IfItem)item;
                boolean isNeq = true;
                if (!processedIfs.contains(ii.decisionPart) && (ii.expression instanceof StrictNeqActionItem || ii.expression instanceof StrictEqActionItem)) {
                    isNeq = ii.expression instanceof StrictNeqActionItem;
                    ArrayList<GraphPart> switchParts = new ArrayList<GraphPart>();
                    ArrayList<GraphTargetItem> switchExpressions = new ArrayList<GraphTargetItem>();
                    ArrayList<GraphPart> switchOnFalseParts = new ArrayList<GraphPart>();
                    BinaryOpItem sneq = (BinaryOpItem)ii.expression;
                    int regId = -1;
                    GraphTargetItem svar = null;
                    if (sneq.leftSide instanceof StoreRegisterActionItem) {
                        StoreRegisterActionItem sr = (StoreRegisterActionItem)sneq.leftSide;
                        regId = sr.register.number;
                    } else {
                        svar = sneq.leftSide;
                    }
                    switchParts.add(ii.decisionPart);
                    switchExpressions.add(sneq.rightSide);
                    switchOnFalseParts.add(ii.onTruePart);
                    IfItem ii2 = ii;
                    IfItem lastOkayIi = ii;
                    while (isNeq && !ii2.onTrue.isEmpty() && ii2.onTrue.get(0) instanceof IfItem || !isNeq && !ii2.onFalse.isEmpty() && ii2.onFalse.get(0) instanceof IfItem) {
                        ii2 = (IfItem)(isNeq ? ii2.onTrue.get(0) : ii2.onFalse.get(0));
                        if (!(ii2.expression instanceof StrictNeqActionItem) && !(ii2.expression instanceof StrictEqActionItem)) break;
                        isNeq = ii2.expression instanceof StrictNeqActionItem;
                        sneq = (BinaryOpItem)ii2.expression;
                        if (sneq.leftSide instanceof DirectValueActionItem) {
                            DirectValueActionItem dv = (DirectValueActionItem)sneq.leftSide;
                            if (!(dv.value instanceof RegisterNumber)) break;
                            RegisterNumber rn = (RegisterNumber)dv.value;
                            if (rn.number != regId) break;
                            processedIfs.add(ii.decisionPart);
                            processedIfs.add(ii2.decisionPart);
                            switchParts.add(ii2.decisionPart);
                            switchOnFalseParts.add(ii2.onTruePart);
                            switchExpressions.add(sneq.rightSide);
                            lastOkayIi = ii2;
                            continue;
                        }
                        if (svar == null || !sneq.leftSide.valueEquals(svar)) break;
                        processedIfs.add(ii.decisionPart);
                        processedIfs.add(ii2.decisionPart);
                        switchParts.add(ii2.decisionPart);
                        switchOnFalseParts.add(ii2.onTruePart);
                        switchExpressions.add(sneq.rightSide);
                        lastOkayIi = ii2;
                    }
                    if (switchParts.size() > 1) {
                        allSwitchParts.add(switchParts);
                        allSwitchOnFalseParts.add(switchOnFalseParts);
                        allSwitchExpressions.add(switchExpressions);
                    }
                }
            }
            if (!(item instanceof Block)) continue;
            for (List<GraphTargetItem> sub : ((Block)((Object)item)).getSubs()) {
                this.checkSecondPassSwitches(processedIfs, sub, allSwitchParts, allSwitchOnFalseParts, allSwitchExpressions);
            }
        }
    }
}

