/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.usages;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.abc.usages.InsideClassMultinameUsageInterface;
import com.jpexs.decompiler.flash.abc.usages.MultinameUsage;
import java.util.Objects;

public abstract class TraitMultinameUsage
extends MultinameUsage
implements InsideClassMultinameUsageInterface {
    protected final int traitIndex;
    public static final int TRAITS_TYPE_CLASS = 1;
    public static final int TRAITS_TYPE_INSTANCE = 2;
    public static final int TRAITS_TYPE_SCRIPT = 3;
    protected final int traitsType;
    protected final int classIndex;
    protected final int scriptIndex;
    protected final Traits traits;
    protected final int parentTraitIndex;

    public TraitMultinameUsage(ABC abc, int multinameIndex, int scriptIndex, int classIndex, int traitIndex, int traitsType, Traits traits, int parentTraitIndex) {
        super(abc, multinameIndex, scriptIndex);
        this.scriptIndex = scriptIndex;
        this.classIndex = classIndex;
        this.traitIndex = traitIndex;
        this.traitsType = traitsType;
        this.traits = traits;
        this.parentTraitIndex = parentTraitIndex;
    }

    public String toString() {
        return "class " + this.abc.constants.getMultiname(this.abc.instance_info.get((int)this.classIndex).name_index).getNameWithNamespace(this.abc.constants, true).toPrintableString(true);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 23 * hash + this.traitIndex;
        hash = 23 * hash + this.traitsType;
        hash = 23 * hash + this.classIndex;
        hash = 23 * hash + this.scriptIndex;
        hash = 23 * hash + Objects.hashCode(this.traits);
        hash = 23 * hash + this.parentTraitIndex;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        TraitMultinameUsage other = (TraitMultinameUsage)obj;
        if (this.traitIndex != other.traitIndex) {
            return false;
        }
        if (this.traitsType != other.traitsType) {
            return false;
        }
        if (this.classIndex != other.classIndex) {
            return false;
        }
        if (this.scriptIndex != other.scriptIndex) {
            return false;
        }
        if (this.parentTraitIndex != other.parentTraitIndex) {
            return false;
        }
        return Objects.equals(this.traits, other.traits);
    }

    @Override
    public boolean collides(MultinameUsage other) {
        return false;
    }

    @Override
    public int getClassIndex() {
        return this.classIndex;
    }

    public int getTraitIndex() {
        return this.traitIndex;
    }

    public int getTraitsType() {
        return this.traitsType;
    }

    public int getScriptIndex() {
        return this.scriptIndex;
    }

    public Traits getTraits() {
        return this.traits;
    }

    public int getParentTraitIndex() {
        return this.parentTraitIndex;
    }
}

